#include "modeline.h"

int GetMemory (const char *input)
{
  int pos = 0;        /* position in string */
  int inmem = -1;     /* memory amount read from config */
  int outmem = -1;    /* memory amount transfered to bytes */
  char test [30];     /* processing string */
  char type;          /* type indicator */
  
  /* check if we already did this */
  if (ml.flags.gotmem) return ml.Memory;
  
  strcpy (test, input);
  
  /* check how the memory was given */
  pos = strcspn (test, "M");
  if (pos == strlen (test)) pos = strcspn (test, "k");
  if (pos == strlen (test)) pos = strcspn (test, "b");
  type = test [pos];
  test [pos] = '\0';
  
  /* translate memory from text to integer */
  inmem = strtol (test, NULL, 10);
  
  /* change memory into bytes */
  if (type == 'b') outmem = inmem;
  else if (type == 'k') outmem = (inmem * 1024);
  else if (type == 'M') outmem = (inmem * 1048576);
  
  ml.flags.gotmem = 1;
  
  /* if there's less than 256kb of memory, we die */
  if ((outmem / (256 * 1024)) < 1)
    Die ("Memory less than 256kb (%i bytes)
Either you have a really bad video adaptor, or something went wrong.
Check you config\n", outmem);
  else return outmem;
  
  return -1;
}

int ReadFile (const char *File)
{
  char readstr [80];        /* store the read text from the configfile here */
  char variable [80];       /* store the variable name here */
  char value [80];          /* store the variable value here */
  uid_t me;                 /* user id */
  struct passwd *my_passwd; /* user info structure */
  char UseFile [5] [30];    /* config filenames */
  FILE *fp = NULL;          /* filedescriptor */
  int i;                    /* file atempt counter */
  int pos;                  /* string position pointer */
  
  strcpy (UseFile [0], ml.File);
  
  readstr [0] = '\0';
  variable [0] = '\0';
  value [0] = '\0';
  
#ifdef HAVE_PWD_H
  me = getuid ();
  my_passwd = getpwuid (me);
  if (!my_passwd) Die ("Couldn't find out about user %d.\n", (int) me);
  
  sprintf (UseFile [1], "%s/.mode.conf", my_passwd->pw_dir);
#else
  UseFile [1] [0] = 0;
#endif
  
  strcpy (UseFile [2], "/etc/mode.conf");
  strcpy (UseFile [3], "/usr/etc/mode.conf");
  strcpy (UseFile [4], "/usr/local/etc/mode.conf");
  
  if (ml.flags.verbose) printf ("Searching for following configfile(s):");
  
  /* try to open a config file */
  for (i = 0; i < 5; i++)
  {
    if (!UseFile [i] [0]) continue;
    
    if (ml.flags.verbose) printf ("\n   (%i) %s", i + 1, UseFile [i]);
    fp = fopen (UseFile [i], "r");
    if (fp)
    {
      if (ml.flags.verbose) printf (" (found)\n");
      break;
    }
    
  }
  
  if (!fp) return 1;
  
  fgets (readstr, 80, fp);
  while (!feof (fp))
  {
    pos = strspn (readstr, "#");
    strcpy (readstr, &readstr [pos]);
    sscanf (readstr, "%[^= ] = %[^\n]\n", variable, value);

    /* check what the variable is, and copy the value acordingly */
    if (!strcmp (variable, "HorFrontPorch"))
      ml.h.fp = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "HorSyncWidth"))
      ml.h.sw = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "HorSyncWidthMax"))
      ml.h.sw_max = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "HorSyncWidthMin"))
      ml.h.sw_min = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "HorBackPorch"))
      ml.h.bp = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "VertFrontPorch"))
      ml.v.fp = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "VertSyncWidth"))
      ml.v.sw = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "VertSyncWidthMax"))
      ml.v.sw_max = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "VertSyncWidthMin"))
      ml.v.sw_min = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "VertBackPorch"))
      ml.v.bp = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "MaxDotClock"))
      ml.max_dot = strtol (value, NULL, 10);
    
    else if (!strcmp (variable, "VideoMemory"))
      ml.Memory = GetMemory (value);
    
    fgets (readstr, 80, fp);
  }
  
  fclose (fp);
  return 0;
}
