<?

class C_AFFIX {
    var $lang;
    var $flag;
    var $sub;
    var $add;
    var $regexp;
}

class C_NORM_FORM {
    var $word;
    var $lang;
    var $flag;
}

// ---------------------------------------------------
// load_affix()
// ---------------------------------------------------
function load_affix() {
   global $DEBUG;   

   global $ispellmode;
   
   global $affix_file;
   global $affix_array;
   global $normalized_array;

   $affix_array=array();
   $normalized_array=array();

   $i=0;
   if ($ispellmode=='db') {
      $query="SELECT flag,lang,mask,find,repl
                FROM affix
               WHERE type='s'";

      if($DEBUG) echo "load_affix(): ",$query,"<BR><HR>";

      if (!($res=db_query($query))) print_error_local('Query error: '.$query."\n<BR>".db_error());
 
      while ($row=db_fetchrow($res)) {
         $affix_array[$i] = new C_AFFIX;
         $affix_array[$i]->flag=trim($row[0]);
	 $affix_array[$i]->lang=trim($row[1]);
	 $affix_array[$i]->regexp=trim($row[2]);
	 $affix_array[$i]->add=trim($row[3]);
	 $affix_array[$i]->sub=trim($row[4]);
	 $i++;
      }
      db_freeresult($res);
   } elseif ($ispellmode=='text') {
      reset($affix_file);

      while (list($lang,$file)=each($affix_file)) {
         $fd=fopen($file,"r");
         if (! $fd) {
            print ("Load affix error: cannot open file $file");
            exit_local(1);
         }

         $suffixes=0;
         while (! feof($fd)) {
            $str=strtolower(trim(fgets($fd,1024)));

            if (preg_match("/^#|^[\s\t\n\r]*$/",$str)) continue;

            if (ereg("^suffixes",$str)) {
               $suffixes=1;
               continue;
            }

            if ($suffixes != 1) continue;

            if (preg_match("/^flag[\s\t]+\*{0,1}(.):/i",$str,$param)) {
               $flag=trim($param[1]);
               continue;
            }

            if (preg_match("/^[\s\t]*([^>#]+)>[\s\t]+-([^\,\s\t]+),([^\s\t]+)/",$str,$param)) {
               $regexp=trim($param[1]);
               $add_str=trim($param[2]);
               $sub_str=trim($param[3]);
	       
	       if ($sub_str == '-') $sub_str='';

               $regexp=str_replace(" ","",$regexp);
               $add_str=str_replace(" ","",$add_str);
               $sub_str=str_replace(" ","",$sub_str);

	       $affix_array[$i] = new C_AFFIX;
	       
               $affix_array[$i]->flag=$flag;
	       $affix_array[$i]->lang=$lang;
	       $affix_array[$i]->regexp=$regexp;
	       $affix_array[$i]->add=$add_str;
	       $affix_array[$i]->sub=$sub_str;
	       $i++;
            } elseif (preg_match("/^[\s\t]*([^>#]+)>[\s\t]+([^\s\t\#]+)/",$str,$param)) {
               $regexp=trim($param[1]);
               $add_str='';
               $sub_str=trim($param[2]);

               $regexp=str_replace(" ","",$regexp);
               $sub_str=str_replace(" ","",$sub_str);

	       $affix_array[$i] = new C_AFFIX;
	       
               $affix_array[$i]->flag=$flag;
	       $affix_array[$i]->lang=$lang;
	       $affix_array[$i]->regexp=$regexp;
	       $affix_array[$i]->add=$add_str;
	       $affix_array[$i]->sub=$sub_str;
	       $i++;
            }
         }
         fclose($fd);
      }
   }
}

// ---------------------------------------------------
// normalize_word($word)
// ---------------------------------------------------
function normalize_word($word) {
   global $DEBUG;

   global $affix_array;
   global $normalized_array;

   global $final_word;
   
   $j=0;
   
   for($i=0; $i<count($affix_array); $i++) {
      $sub=$affix_array[$i]->sub;
      if (strlen($word)<strlen($sub)) continue;
      
      if ($sub != '') {
         if (strcmp($sub,substr($word,strlen($word)-strlen($sub),strlen($sub)))!=0) continue;
         $temp_word=eregi_replace("$sub$",$affix_array[$i]->add,$word);
      } else {
         $temp_word=$word.$affix_array[$i]->add; 
      }   

      if (eregi($affix_array[$i]->regexp,$temp_word)) {
         if ($DEBUG) echo "<font color=#a00000>Possible norm form</font> \"$temp_word\" for \"$word\":".
	                  " <font color=#a00000>-</font> ".$affix_array[$i]->sub.
			  " <font color=#a00000>+</font> ".$affix_array[$i]->add.
			  " <font color=#a00000>exp</font> ".$affix_array[$i]->regexp.
	                  " <font color=#a00000>fl</font> ".$affix_array[$i]->flag.
			  " <font color=#a00000>lng</font> ".$affix_array[$i]->lang.
			  "<br><hr>\n";

	 $normalized_array["$word"][$j]=new C_NORM_FORM;
         $normalized_array["$word"][$j]->word=$temp_word;
         $normalized_array["$word"][$j]->flag=$affix_array[$i]->flag;
         $normalized_array["$word"][$j]->lang=$affix_array[$i]->lang;
	 $j++;
      }
   }

   $final_word["$word"][0]=$word;
}

// ---------------------------------------------------
// check_words()
// ---------------------------------------------------
function check_words() {
   global $DEBUG;

   global $ispellmode;
   global $spell_file;
   global $grep;

   global $final_word;
   global $normalized_array;

   reset ($normalized_array);
   while (list($word,$value)=each($normalized_array)) {
      for ($j=0; $j<count($value); $j++) {
         $norm_word=$normalized_array[$word][$j]->word;
         $norm_lang=$normalized_array[$word][$j]->lang;
         $norm_flag=$normalized_array[$word][$j]->flag;
	 
         if ($ispellmode=='db') {
            $query="SELECT flag
                      FROM spell
                     WHERE word='$norm_word'
                       AND lang='$norm_lang'";
      
            if($DEBUG) echo "check_words(): ",$query,"<BR><HR>";
      
            if (!($res=db_query($query))) print_error_local('Query error: '.$query."\n<BR>".db_error());
      
            while ($row=db_fetchrow($res)) {
               $flag=trim($row[0]);
               if ($flag == '') continue;
               if (ereg($norm_flag,$flag)) {
	           $final_word[$word][]=$norm_word;
		   if ($DEBUG) echo "check_words(): ","<font color=#0000d0>Norm form found:</font> \"$norm_word\" for \"$word\"<br><hr>\n";
	       }
            }
            db_freeresult($res);
         } elseif ($ispellmode=='text') {
            reset ($spell_file);
            while (list($lang,$lang_file)=each($spell_file)) {
               if ($lang != $norm_lang) continue;
               for ($i=0;$i<count($lang_file);$i++) {
                  $file=$lang_file[$i];
                  $pipe="$grep -i \"^$norm_word/\" $file";
                  if ($DEBUG) echo "check_words(): ",$pipe."<br><hr>";
   
                  $fd=popen($pipe,"r");
   
                  if (! $fd) {
                     print "Cannot pipe to $grep<br>\n";
                     exit_local(1);
                  }
   
                  while (! feof($fd)) {
                     $str=trim(strtolower(fgets($fd,1024)));
                     if ($str=='') continue;
                     $str_array=explode("/",$str);
		    
                     if (($str_array[0]==$norm_word)&&
                         (ereg($norm_flag,$str_array[1])))  {
                            $final_word[$word][]=$norm_word;
                            if ($DEBUG) echo "check_words(): ","<font color=#0000d0>Norm form found:</font> \"$norm_word\" for \"$word\"<br><hr>\n";
                     }
                  } // while
   
                  pclose($fd);
               } // for
            }
         } // if
      } // for
   } // while
}

?>

