      SUBROUTINE M_SFIT(IDELIM,IERR)
C
C     Sets up parameters used for fitting
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mntyq.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER MFIT
      PARAMETER (MFIT = 6)
      CHARACTER*10 FITNAM(MFIT)
C
      INTEGER IDELIM,IERR
C
      INTEGER KCMD,LCMD,NVAL,NNUM,ICMTYQ,IVLTYQ,IOERR,I,NCHAR,NCHR
     + ,ISTR,NPTR
      INTEGER ISTRNQ,ISTTYQ
      REAL RVAL,VALTYQ
      CHARACTER*10 TCOMM
      CHARACTER*80 TXT1
C
      DATA FITNAM/'DEFAULT','INTEGRATE','CONVOLUTE', 'AREA',
     + 'COMMANDS', ' '/
C
      IERR = 0
C
      IF(COMND1.EQ.'SHOW') THEN
        WRITE(TXTMES,'(
     +   1X,A,1X,L1,'','',2X,A,1X,I4)',IOSTAT=IOERR)
     +   'Integrate function across a bin:',QFINTG
     +   ,'Number of intervals:',NFINTG
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(
     +   1X,A,1X,L1,'','',2X,A,1X,1PG11.4)',IOSTAT=IOERR)
     +   'Convolute function with a Gaussian:',QFCONV
     +   ,'Width of Gaussian:',RFCONV(1)
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(
     +   1X,A,1X,I3,'','',2X,A,1X,F5.1)',IOSTAT=IOERR)
     +   'Number of intervals',NINT(RFCONV(2))
     +   ,'Number of sigma',RFCONV(3)
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(
     +   1X,A,1X,L1)',IOSTAT=IOERR)
     +   'Calc. AREA with frag., dipion, ARGUS bkg functions:',QFAREA
        CALL MN_MES(LUNTTO,'I',TXTMES)
        TXTMES = ' The following commands will be executed if' //
     +   ' you do a quick fit'
        CALL MN_MES(LUNTTO,'I',TXTMES)
        DO I=1,NFSTKD
          TXTMES = '   ' // TFSTK(I)
          CALL MN_MES(LUNTTO,'I',TXTMES)
        ENDDO
        TXTMES = ' '
        CALL MN_MES(LUNTTO,'E',TXTMES)
        GOTO 9000
      ENDIF
C     
 1000 CONTINUE
      CALL WAITYQ('Give option or ?: ')
      KCMD = ICMTYQ(.TRUE.,IDELIM,FITNAM)
      IF(KCMD.GT.0) COMND3 = FITNAM(KCMD)
      IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
        CALL QUOTYQ('SET FIT')
        IDELIM = 0
        CALL MN_HLP(IDELIM,IERR)
        GOTO 1000
      ELSEIF(KCMD.LT.0) THEN
        GOTO 9000
      ELSEIF(KCMD.EQ.0) THEN
        CALL MN_DCK(IDELIM,KCMD,MFIT,FITNAM,IERR)
        IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
        GOTO 9000
C       
C     Set all fitting parameters to default values
C       
      ELSEIF(COMND3.EQ.'DEFAULT') THEN
        CALL M_FDFL
C       
C     Integrate over a bin or not
C       
      ELSEIF(COMND3.EQ.'INTEGRATE') THEN
        CALL WAITYQ('On or Off: ')
        LCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
        IF(LCMD.LT.0) THEN
          GOTO 9000
        ELSEIF(LCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,LCMD,MLOG,LOGNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          GOTO 9000
        ELSEIF(MOD(LCMD,2).EQ.1) THEN
          CALL WAITYQ(
     +     'Give number of intervals in each bin: ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          IF(NVAL.LE.0) THEN
            GOTO 9000
          ELSEIF(MOD(NVAL,2).NE.0) THEN
            NVAL = MAX0(2,(NVAL / 2) * 2)
            WRITE(TXTMES
     +       ,'('' The number of intervals must be even.''
     +       ,'' It will be set to'',I4)',IOSTAT=IOERR) NVAL
            CALL MN_MES(LUNTTO,'ME',TXTMES)
          ELSEIF(NVAL.GT.MFINTG) THEN
            WRITE(TXTMES
     +       ,'('' Maximum number of intervals is'',I4)'
     +       ,IOSTAT=IOERR) MFINTG
            CALL MN_MES(LUNTTO,'ME',TXTMES)
            NVAL = MFINTG
          ENDIF
          IF(.NOT.QFINTG) QMNCHGE = .TRUE.
          QFINTG = .TRUE.
          NFINTG = NVAL
        ELSE
          IF(QFINTG) QMNCHGE = .TRUE.
          QFINTG = .FALSE.
        ENDIF
C       
C     Convolute function with a Gaussian
C       
      ELSEIF(COMND3.EQ.'CONVOLUTE') THEN
        CALL WAITYQ('On or Off: ')
        LCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
        IF(LCMD.LT.0) THEN
          GOTO 9000
        ELSEIF(LCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,LCMD,MLOG,LOGNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          GOTO 9000
        ELSEIF(MOD(LCMD,2).EQ.1) THEN
          CALL WAITYQ(
     +     'Give width of Gaussian,' //
     +     ' # of intervals and # of sigma: ')
          NNUM = 0
 1300     CONTINUE
          RVAL = VALTYQ(.TRUE.,IDELIM)
          IF(RVAL.LE.0.0) THEN
            GOTO 9000
          ENDIF
          NNUM = NNUM + 1
          IF(NNUM.EQ.2) THEN
            NVAL = NINT(RVAL)
            IF(MOD(NVAL,2).NE.0) THEN
              NVAL = MAX0(2,(NVAL / 2) * 2)
              WRITE(TXTMES
     +         ,'('' The number of intervals must be even.''
     +         ,'' It will be set to'',I4)',IOSTAT=IOERR) NVAL
              CALL MN_MES(LUNTTO,'ME',TXTMES)
            ENDIF
            IF(NVAL.GT.MFCONV) THEN
              WRITE(TXTMES
     +         ,'('' Too many intervals. Number of intervals set to''
     +         ,I4)') MFCONV
              CALL MN_MES(LUNTTO,'ME',TXTMES)
              NVAL = MFCONV
            ENDIF
            RVAL = FLOAT(NVAL)
          ENDIF
          RFCONV(NNUM) = RVAL
          IF(NNUM.LT.3 .AND. IDELIM.EQ.0) GOTO 1300
          IF(NNUM.GT.0) THEN
            IF(.NOT.QFCONV) QMNCHGE = .TRUE.
            QFCONV = .TRUE.
          ENDIF
        ELSE
          IF(QFCONV) QMNCHGE = .TRUE.
          QFCONV = .FALSE.
        ENDIF
C       
C     Calculate the AREA of fragmentation or dipion functions
C       
      ELSEIF(COMND3.EQ.'AREA') THEN
        CALL WAITYQ('On or Off: ')
        LCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
        IF(LCMD.LT.0) THEN
          GOTO 9000
        ELSEIF(LCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,LCMD,MLOG,LOGNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          GOTO 9000
        ELSEIF(MOD(LCMD,2).EQ.1) THEN
          QFAREA = .TRUE.
        ELSE
          QFAREA = .FALSE.
        ENDIF
C       
C     Define a set of commands to be executed when doing quick fits
C       
      ELSEIF(COMND3.EQ.'COMMANDS') THEN
        CALL WAITYQ('Give command (END to finish): ')
        NPTR = 0
 5000   CONTINUE
        ISTR = ISTRNQ(.TRUE.,TXT1,NCHAR)
        TCOMM = ' '
        IF(NCHAR.LE.0) THEN
          NCHAR = 1
          TXT1 = ' '
        ELSE
          CALL QUOTYQ(TXT1(1:NCHAR))
          NCHR = ISTTYQ(.TRUE.,IDELIM,TCOMM)
        ENDIF
        CALL ZERTYQ('.FALSE.')
        IF(TCOMM(1:3).EQ.'END') THEN
          NFSTKD = NPTR
          NFSTKU = 0
        ELSE
          NPTR = NPTR + 1
          IF(NPTR.GT.MFSTK) THEN
            NPTR = NPTR - 1
            CALL MN_ERR('M_DEFI'
     +       ,'Buffer for storing fit commands is full')
          ELSE
            TFSTK(NPTR) = TXT1(1:NCHAR)
            GOTO 5000
          ENDIF
        ENDIF
      ENDIF
C     
 9000 CONTINUE
      END
