      SUBROUTINE M_TGET(ICMD,COMAND,ISET,IVAR,NELEM,NPNTn,IDELIM,n1,n2
     + ,QPASS)
C
C------------------------------------------------------------------------------
C     Get the character string that is wanted.
C     It can be a histogram title, an Ntuple variable name,
C     the value of an Ntuple variable or a character array element
C     For a variable the event (point) number and the element number must
C     also be returned.
C     Checks on whether the name really belongs to a character variable or
C     whether the point or element number is OK are done later.
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mnprs.inc"
#include "mninf.inc"
#include "mnlun.inc"
*
      integer icmd,iset,ivar,nelem,npntn,idelim,n1,n2
      character*(*) comand
      logical qpass
*
      logical qmnhex,qexist
      character*80 txt1
      integer ida,idb,nh,nloop,npt,nmult,i,k,jelem(9),leng
     + ,nbin,ich,nblo,ioerr,ierr
      integer lnblnk
*
      integer  icmtyp,ichtyp,lchtyp,inttyp,iv2typ,nchscn
      real     vl2typ
      external icmtyp,ichtyp,lchtyp,inttyp,iv2typ,vl2typ,nchscn
C
      QPASS = .FALSE.
      ICMD = 0
      COMAND = ' '
C
      ICMD = ICMTYP(.TRUE.,IDELIM,CHANAM)
      IF(IDELIM.GT.0 .or. icmd.le.0) return
C
C     Check for left parenthesis
C
      ICH = LCHTYP()
      IF(ICH.NE.ICHAR('(')) THEN
          CALL M_EMSG('M_TGET','Missing "(" after variable')
          RETURN
      ENDIF
*
*     Get plot number
*
      IDA = IV2TYP(.TRUE.,IDELIM)
*
      IF(IDA.EQ.0 .AND. NCHSCN().EQ.0) THEN
        IDELIM = 0
        CALL RESTYP
        RETURN
      ENDIF
*
      IF(IDELIM.GT.0) THEN
        CALL M_EMSG('M_TGET','Something wrong with plot number')
        RETURN
      ENDIF
*
      if(icmd.ne.1) then
        IDB = NDIDB
C       
C       SEE IF & IS NEXT CHARACTER
C       
        ICH = LCHTYP()
        IF(ICH.EQ.ICHAR('&')) THEN
          IDB = IV2TYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) THEN
            CALL M_EMSG('M_TGET','Something wrong with plot number')
            RETURN
          ENDIF
        ENDIF
C       
        NH = 0
        QEXIST = QMNHEX(IDA,IDB,NH)
        ISET = NH
C       
        IF(.NOT.QEXIST) THEN
          WRITE(TXTERR,10000) IDA,IDB
10000     FORMAT('Plot ',I7,I4,' does not exist ***')
          CALL M_EMSG('M_TGET',TXTERR)
          RETURN
        ENDIF
      else
        if(ida.ge.0 .and. ida.le.mcreg) then
          iset = ida
        else
          write(txterr,'('' Character array element'',I6
     +     ,'' does not exist'')') ida
          call m_emsg('M_TGET',txterr)
          return
        endif
      endif
C
C     Check for right parenthesis for title or character array
C     Then look for a square bracket that signals a range
C
      ich = lchtyp()
      if(icmd.eq.1) then
        if(ich.ne.ichar(')')) then
          CALL M_EMSG('M_TGET','Missing ")" after array element')
          return
        else
          goto 4000
        endif
      elseif(icmd.eq.2) then
        if(ich.ne.ichar(')')) then
          CALL M_EMSG('M_TGET','Missing ")" after plot number')
          return
        else
          goto 4000
        endif
      endif
C
C     GET ALL THE RELEVANT HISTOGRAM INFORMATION
C
      CALL MN_HGT(IDA,IDB,NH)
C
C     If this is an Ntuple get the variable name or number
C
      IF(NDIM.LT.-1) THEN
        CALL M_VGET(1,NH,IVAR,TXT1,jELEM,IDELIM,IERR)
        IF(IERR.NE.0) THEN
          CALL M_EMSG('M_TGET'
     +     ,'Something wrong with the variable name')
          IVAR = 0
          RETURN
        ENDIF
      else
        call m_emsg('M_TGET'
     +   ,'Can only access Ntuple variable names/character variables')
        ivar = 0
        return
      ENDIF
*
*     Ntuple variable value
*
      if(icmd.eq.4) then
C       
C       Check that last character was not a )
C       
        ICH = LCHTYP()
        IF(ICH.EQ.ICHAR(')')) THEN
          CALL M_EMSG('M_TGET','Point number not given')
          RETURN
        ENDIF
C       
C       If we want the value of a variable get the point number and element
C       The element number is optional
C       
        npntn = IV2TYP(.TRUE.,IDELIM)
C       
C       Check for right parenthesis
C       
        ICH = LCHTYP()
        IF(ICH.eq.ICHAR(')')) THEN
          nelem = 1
        else
          nelem = IV2TYP(.TRUE.,IDELIM)
        endif
      endif
*
*     Check for parentheses
*
      ICH = LCHTYP()
      if(ICH.NE.ICHAR(')')) THEN
        CALL M_EMSG('M_TGET','Missing ")" after variable/point/element')
        return
      endif
C
C     Check for left and right square bracket
C
 4000 continue
      ICH = ICHTYP(.TRUE.)
      IF(ICH.NE.ICHAR('[')) THEN
        n1 = 0
        n2 = 0
        qpass = .true.
        return
      else
        n1 = iv2typ(.true.,idelim)
        n2 = iv2typ(.true.,idelim)
        ICH = LCHTYP()
        IF(ICH.NE.ICHAR(']')) THEN
          call m_emsg('M_TGET','Missing "]" after character range')
          return
        endif
      ENDIF
C
      QPASS = .TRUE.
C
      END
