      SUBROUTINE MN_FTI(IERR)
C
C     Subroutine that initializes everything for fitting
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mninf.inc"
#include "mncwn.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mntyq.inc"
#include "mnluj.inc"
#include "mnusr.inc"
#include "mnlun.inc"
C
      DOUBLE PRECISION WPAR(4)
      CHARACTER*20 TCMD
      REAL AFLO(MDIMMX),AFHI(MDIMMX),RVAL(MDIMMX)
      LOGICAL QERRL,QERRH,QERRX,QERRY
C
      LOGICAL QPIPI
      LOGICAL QMNHEX
      CHARACTER*80 TEXT
      CHARACTER*10 NAME
      LOGICAL QASK,QFNTPL,QSFILE
      INTEGER IDLSTA(MFITMX),IDLSTB(MFITMX)
      integer ioerr,lend
      integer  lnblnk
      external lnblnk
C
      LOGICAL QCHLG
      LOGICAL QDEBUG
      logical qfbinsv
C
      DATA NFLAST/0/
      DATA IDLSTA/MFITMX*0/,IDLSTB/MFITMX*0/
      DATA QCHLG/.FALSE./,QDEBUG/.FALSE./
C
C     Loop over the histograms to fit and check for stupid mistakes
C     Particularly check for limits being wrong
C     Remove any exclusions
C
      XXLO = 1.0E30
      XXHI = -1.0E30
      YYLO = 1.0E30
      YYHI = -1.0E30
*
      qfbinsv = qfbinw
C
C     Copy data into arrays to fit
C
      NDFIT = 0
      NFPTE = 0
      DO 2000 NF=1,NHFIT
          IDA = IDFITA(NF)
          IDB = IDFITB(NF)
          IF(IDA.EQ.0) THEN
              WRITE(TXTERR,'(''Wrong histogram number''
     1         ,I7,I4)',iostat=ioerr) IDA,IDB
              CALL MN_ERR('MN_FTI',TXTERR)
              IERR = 1
              GOTO 9000
          ENDIF
C
          CALL MN_HGT(IDA,IDB,NHD)
          IF(NHD.LE.0) THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     1         ,'' does not exist'')',iostat=ioerr) IDA,IDB
              CALL MN_ERR('MN_FTI',TXTERR)
              IERR = 1
              GOTO 9000
          ENDIF
          NPTRHD = NPTRH
          NPTRDD = NPTRD
C
          IF(NPNT.LE.0) THEN
            WRITE(TXTERR,'(''No entries in histogram'',I7,I4)'
     +       ,iostat=ioerr)
     1       IDA,IDB
            CALL MN_ERR('MN_FTI',TXTERR)
            IERR = 2
            GOTO 9000
          ENDIF
C
C         See if we are trying to fit an Ntuple
C
          QFNTPL = NDIM.LT.-1 .AND. INTPMN(2).NE.0
          IF(NDIM.GT.2) THEN
              WRITE(TXTERR,'(''I can only fit 1 or 2-dimensional''
     1         ,'' histograms.'')')
              CALL M_EMSG('MN_FTI',TXTERR)
              WRITE(TXTERR,'(''Histogram'',I7,I4
     2           ,'' has'',I3,'' dimensions'')',iostat=ioerrr)
     +         IDA,IDB,NDIM
              CALL MN_ERR('MN_FTI',TXTERR)
              IERR = 3
              GOTO 9000
          ELSEIF(NDIM.LT.-1 .AND. .NOT.QFNTPL) THEN
              CALL M_EMSG('MN_FTI','You are trying to fit an Ntuple' //
     +         ' but have not assigned the variables')
              CALL MN_ERR('MN_FTI'
     +         ,'to axes. Use the SET NTUPLE command')
              IERR = 3
              GOTO 9000
          ELSE IF(NDIM.EQ.-2) THEN
              CALL MN_ERR('MN_FTI',' I can only fit 2-dimensional' //
     +         ' histograms, not scatter plots')
              IERR = 3
              GOTO 9000
          ENDIF
C
C         Decide on the dimension of the plot to fit
C
          IF(QFNTPL) THEN
              NDIMF = -2
              IF(INTPMN(3).EQ.0) NDIMF = -1
          ELSE
              NDIMF = -IABS(NDIM)
          ENDIF
C
          IF(QFNTPL) THEN
              QERRL = INTPMN(IABS(NDIMF)+1+3).GT.0
              QERRH = INTPMN(IABS(NDIMF)+1+6).GT.0
              NOFF  = IABS(NDIMF) + 1
              NOFFL = NOFF + 3
              NOFFH = NOFF + 6
          ELSE
              CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
          ENDIF
C
          IF(.NOT.QERRL) THEN
            WRITE(TXTERR,'(''Plot'',I7,I4
     1       ,'' has no errors defined so I cannot fit it'')'
     +       ,iostat=ioerr)
     3       IDA,IDB
            CALL M_EMSG('MN_FTI',TXTERR)
            IF(QFNTPL) THEN
              CALL MN_ERR('MN_FTI'
     +         ,'Use the SET NTUPLE command to set them')
            ELSE
              CALL MN_ERR('MN_FTI'
     +         ,'Use the HIST ERROR command to set them')
            ENDIF
            IERR = 4
            GOTO 9000
          ENDIF
C
C         Copy the histogram to the fit area
C         First get some space
C
          NWPPTF = 2 * (IABS(NDIM)+1)
          IF(QERRH) NWPPTF = 3 * (IABS(NDIM)+1)
          NWRD = NWPPTF * NPNT
          NBPPT = 32
          CALL MN_FNW(IDA,IDB,NDIMF,NWRD,NHF,NPTRHF,NPTRDF,NWHF
     +     ,NBPPT,NTMODE)
          IF(NHF.LE.0) GOTO 9000
C
C         Check that the number of header words agrees with the expected number
C         Otherwise complain to the author
C
          IF(NDIM.EQ.NDIMF .AND. (NPTRDD-NPTRHD).GT.NWHF) THEN
              CALL M_EMSG('MN_FTI'
     +         ,'Inconsistency in number of header words making' //
     +         ' histogram to fit')
              CALL MN_ERR('MN_FTI','Complain to the author!!!')
              GOTO 9000
          ENDIF
C
          IF(NDIM.EQ.NDIMF) THEN
              NWTOT  = NINT(RDAT(NPTRHD))
              NWHEAD = NINT(RDAT(NPTRHD+1))
              NWDAT  = NINT(RDAT(NPTRHD+2))
C
C             Copy header and data separately to allow for header expansion
C             Zero any words of header not copied
C
              CALL UCOPY_r(RDAT(NPTRHD),RFIT(NPTRHF),NWHEAD)
              CALL UCOPY_r(RDAT(NPTRDD),RFIT(NPTRDF),NWDAT)
              IF(NWHEAD.LT.NWHF) THEN
                  CALL VZERO_r(RDAT(NPTRHD+NWHEAD+1),NWHF-NWHEAD)
                  NWTOT = NWHF + NWDAT
                  RDAT(NPTRHD)   = NWTOT
                  RDAT(NPTRHD+1) = NWHF
              ENDIF
          ELSEIF(QFNTPL) THEN
              NWDAT = NWPPTF*NPNT
              NWTOT = NWHF + NWDAT
              DXL = 0.0
              DYL = 0.0
              DXH = 0.0
              DYH = 0.0
              EDLO  = 1.0E+31
              EDHI  = -1.0E+31
              EDENT = 0.0
              nvcwn = 0
              CALL M_NTPPNT(IDA,IDB,0,IERR,RVAL)
              IF(IERR.NE.0) GOTO 9000
              DO 1100 II=1,NPNT
                  CALL M_NTPPNT(IDA,IDB,II,IERR,RVAL)
                  IF(IERR.NE.0) GOTO 9000
C
                  NPTRF = NPTRDF + NWPPTF*(II-1) - 1
                  XX = RVAL(INTPMN(1))
                  IF(INTPMN(2).GT.0) YY = RVAL(INTPMN(2))
                  EE   = RVAL(INTPMN(NOFF))
C
                  IF(INTPMN(4).GT.0) DXXL = RVAL(INTPMN(4))
                  IF(INTPMN(5).GT.0) DYYL = RVAL(INTPMN(5))
                  DEEL = RVAL(INTPMN(NOFFL))
C
                  IF(QERRH) THEN
                      IF(INTPMN(7).GT.0) DXXH = RVAL(INTPMN(7))
                      IF(INTPMN(8).GT.0) DYYH = RVAL(INTPMN(8))
                      DEEH = RVAL(INTPMN(NOFFH))
                  ELSE
                      DXXH = DXXL
                      DYYH = DYYL
                      DEEH = DEEL
                  ENDIF
C
                  NN = 1
                  RFIT(NPTRF + NN) = XX
                  IF(IABS(NDIMF).GE.2) THEN
                      NN = NN + 1
                      RFIT(NPTRF + NN) = YY
                  ENDIF
                  NN = NN + 1
                  RFIT(NPTRF + NN) = EE
C
                  NN = NN + 1
                  RFIT(NPTRF + NN) = DXXL
                  IF(IABS(NDIMF).GE.2) THEN
                      NN = NN + 1
                      RFIT(NPTRF + NN) = 0.5*DYYL
                  ENDIF
                  NN = NN + 1
                  RFIT(NPTRF + NN) = DEEL
C
                  IF(QERRH) THEN
                      NN = NN + 1
                      RFIT(NPTRF + NN) = DXXH
                      IF(IABS(NDIM).GE.2) THEN
                          NN = NN + 1
                          RFIT(NPTRF + NN) = DYYH
                      ENDIF
                      NN = NN + 1
                      RFIT(NPTRF + NN) = DEEH
                  ENDIF
C
                  EDLO  = AMIN1(EDLO,EE-DEEL)
                  EDHI  = AMAX1(EDHI,EE+DEEH)
                  EDENT = EDENT + EE
1100          CONTINUE
          ELSE
              NWDAT = NWPPTF*NPNT
              NWTOT = NWHF + NWDAT
              DX = (ADHI(1) - ADLO(1)) / FLOAT(IDBIN(1))
              IF(IABS(NDIM).GE.2)
     1         DY = (ADHI(2) - ADLO(2)) / FLOAT(IDBIN(2))
              NBX = 0
              NBY = 1
              DO 1200 II=1,NPNT
                  NPTR = NPTRDD + NWPPT*(II-1) - 1
                  NPTRF = NPTRDF + NWPPTF*(II-1) - 1
                  NBX = NBX + 1
                  IF(NBX.GT.IDBIN(1)) THEN
                      NBX = 1
                      NBY = NBY + 1
                  ENDIF
                  XX = ADLO(1) + FLOAT(NBX-1)*DX + 0.5*DX
                  IF(IABS(NDIM).GE.2)
     1             YY = ADLO(2) + FLOAT(NBY-1)*DY + 0.5*DY
                  EE   = AMNE(II,NHD,NERR)
                  DEEL = AMNDEN(II,NHD,NERR)
                  IF(QENULL .AND. EE.EQ.0.0 .AND. DEEL.EQ.0.0)
     1             DEEL = 1.0
                  IF(QERRH) DEEH = AMNDEP(II,NHD,NERR)
                  NN = 1
                  RFIT(NPTRF + NN) = XX
                  IF(IABS(NDIM).GE.2) THEN
                      NN = NN + 1
                      RFIT(NPTRF + NN) = YY
                  ENDIF
                  NN = NN + 1
                  RFIT(NPTRF + NN) = EE
                  NN = NN + 1
                  RFIT(NPTRF + NN) = 0.5*DX
                  IF(IABS(NDIM).GE.2) THEN
                      NN = NN + 1
                      RFIT(NPTRF + NN) = 0.5*DY
                  ENDIF
                  NN = NN + 1
                  RFIT(NPTRF + NN) = DEEL
                  IF(QERRH) THEN
                      NN = NN + 1
                      RFIT(NPTRF + NN) = 0.5*DX
                      IF(IABS(NDIM).GE.2) THEN
                          NN = NN + 1
                          RFIT(NPTRF + NN) = 0.5*DY
                      ENDIF
                      NN = NN + 1
                      RFIT(NPTRF + NN) = DEEH
                  ENDIF
 1200         CONTINUE
          ENDIF
C
C         Check that the limits are ok and whether any x errors are defined
C
          CALL VFILL(AFLO(1),IABS(NDIMF),1.0E+30)
          CALL VFILL(AFHI(1),IABS(NDIMF),-1.0E+30)
C
          QERRX = .FALSE.
          QERRY = .FALSE.
          DO 1300 II=1,NPNT
              NPTR = NPTRDF + FLOAT(II-1)*NWPPTF -1
              DO 1290 ND=1,IABS(NDIMF)
                  XX   = RFIT(NPTR + ND)
                  DXXL = RFIT(NPTR + IABS(NDIMF) + 1 + ND)
                  DXXH = DXXL
                  IF(QERRH) DXXH = RFIT(NPTR + 2*(IABS(NDIMF) + 1) + ND)
                  AFLO(ND) = AMIN1(AFLO(ND),XX - DXXL)
                  AFHI(ND) = AMAX1(AFHI(ND),XX + DXXH)
                  IF(ND.EQ.1 .AND. .NOT.QERRX) THEN
                      QERRX = DXXL.GT.0.0
                  ELSEIF(ND.EQ.2 .AND. .NOT.QERRY) THEN
                      QERRY = DXXL.GT.0.0
                  ENDIF
1290          CONTINUE
1300      CONTINUE
C
          IF((IABS(NDIMF).EQ.1 .AND. .NOT.QERRX) .OR.
     +       (IABS(NDIMF).EQ.2 .AND.
     +        (.NOT.QERRX .OR. .NOT.QERRY))) THEN
              WRITE(TXTMES,'('' Plot'',I7,I4
     +         ,'' does not have a bin width'')',IOSTAT=IOERR) IDA,IDB
              CALL MN_MES(LUNTTO,'M',TXTMES)
              WRITE(TXTMES,'('' The bin width will not be used in'',
     +         '' calculating function values'')')
              CALL MN_MES(LUNTTO,'E',TXTMES)
              QFBINW = .FALSE.
          ENDIF
C
C         Do not do the limit checking if we are fitting an Ntuple
C
          IF(.NOT.QFNTPL) THEN
            DO 1320 ND=1,IABS(NDIMF)
              IF((AFLO(ND).EQ.0.0 .AND. ADLO(ND).NE.0.0) .OR.
     2         (ADLO(ND).EQ.0.0 .AND. AFLO(ND).NE.0.0) .OR.
     2         (AFHI(ND).EQ.0.0 .AND. ADHI(ND).NE.0.0) .OR.
     2         (ADHI(ND).EQ.0.0 .AND. AFHI(ND).NE.0.0) .OR.
     3         (AFLO(ND).NE.0.0 .AND.
     3         ABS(ADLO(ND)-AFLO(ND)).GT.1.0E-05*ABS(AFLO(ND)))
     3         .OR.
     3         (AFHI(ND).NE.0.0 .AND.
     3         ABS(ADHI(ND)-AFHI(ND)).GT.1.0E-05*ABS(AFHI(ND))))
     +         THEN
                lend = lnblnk(tdnam(nd,nhd))
                WRITE(TXTMES,'('' WARNING. The limits''
     1           ,'' stored for plot'',I7,I4,2X,A,'' axis'')'
     +           ,iostat=ioerr)
     +           IDA,IDB,TDNAM(ND,NHD)(:lend)
                CALL MN_MES(LUNTTO,'M',TXTMES)
                CALL MN_MES(LUNTTO,'M'
     +           ,' do not agree with those I calculate.')
                CALL MN_MES(LUNTTO,'M'
     +           ,' The calculated ones will be used for fitting')
                WRITE(TXTMES,'('' Stored limits:''
     +           ,T20,2G11.4)',iostat=ioerr) ADLO(ND),ADHI(ND)
                CALL MN_MES(LUNTTO,'M',TXTMES)
                WRITE(TXTMES,'('' Calculated limits:''
     +           ,T20,2G11.4)',iostat=ioerr) AFLO(ND),AFHI(ND)
                CALL MN_MES(LUNTTO,'ME',TXTMES)
              ENDIF
 1320       CONTINUE
          ENDIF
C
C         UPDATE THE HEADER
C
          CALL MN_HDU(RFIT(NPTRHF),NWTOT,NWHF,NWDAT,IDA,IDB
     +     ,NDIMF,NWPPTF,NPNT,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     +     ,EDENT,EDLO,EDHI,IDBIN,AFLO,AFHI,NBPPT,ACONT)
C
          NDFIT = NDFIT + 1
          NFPTE = NFPTE + NWTOT
C
C         NOW FILL THE OTHER ARRAYS NEEDED FOR THE FIT HISTOGRAMS
C
          IFPTRH(NHF) = NPTRHF
          IFPTRD(NHF) = NPTRDF
          IFNDIM(NHF) = NDIMF
          IFWPPT(NHF) = NWPPTF
          IFPFIT(NHF) = NPNT
          TFTIT(NHF)  = TDTIT(NHD)
          TFFIL(NHF)  = TDFIL(NHD)
          DO 1350 NN=1,IABS(NDIM)
              TFNAM(NN,NHF) = TDNAM(NN,NHD)
1350     CONTINUE
C
C         KEEP TRACK OF THE LIMITS AND THE NUMBER OF POINTS
C
          XXLO = AMIN1(XXLO,AFLO(1))
          XXHI = AMAX1(XXHI,AFHI(1))
          YYLO = AMIN1(YYLO,AFLO(2))
          YYHI = AMAX1(YYHI,AFHI(2))
C
C         FIND OUT IF WE FIT THIS HISTOGRAM LAST TIME
C         AND IF WE WANT TO KEEP EXCLUSIONS
C
          KH = 0
          DO 1400 KK=1,NFLAST
              IF(IDLSTA(KK).EQ.IDA .AND. IDLSTB(KK).EQ.IDB) THEN
                  KH = KK
                  IXEXCL(NF) = IXEXCL(KH)
                  IYEXCL(NF) = IYEXCL(KH)
                  IXINCL(NF) = IXINCL(KH)
                  IYINCL(NF) = IYINCL(KH)
                  CALL UCOPY_r(XLEXCL(1,KH),XLEXCL(1,NF),IXEXCL(KH))
                  CALL UCOPY_r(XHEXCL(1,KH),XHEXCL(1,NF),IXEXCL(KH))
                  CALL UCOPY_r(YLEXCL(1,KH),YLEXCL(1,NF),IYEXCL(KH))
                  CALL UCOPY_r(YHEXCL(1,KH),YHEXCL(1,NF),IYEXCL(KH))
                  CALL UCOPY_r(XLINCL(1,KH),XLINCL(1,NF),IXINCL(KH))
                  CALL UCOPY_r(XHINCL(1,KH),XHINCL(1,NF),IXINCL(KH))
                  CALL UCOPY_r(YLINCL(1,KH),YLINCL(1,NF),IYINCL(KH))
                  CALL UCOPY_r(YHINCL(1,KH),YHINCL(1,NF),IYINCL(KH))
                  GOTO 1410
              ENDIF
 1400     CONTINUE
          IXEXCL(NF) = 0
          IYEXCL(NF) = 0
          IXINCL(NF) = 0
          IYINCL(NF) = 0
 1410     CONTINUE
          IF(IXEXCL(NF).GT.0 .OR. IYEXCL(NF).GT.0 .OR.
     +       IXINCL(NF).GT.0 .OR. IYINCL(NF).GT.0) THEN
 1500         CONTINUE
              IF(QRFILE) THEN
                  JCMD = 1
              ELSE
                  CALL M_EXCL(0,NF,LUNTTO,IDELIM)
                  CALL WAITYQ('Remove them [*Y/N]? ')
                  JCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
                  IF(IDELIM.GT.0 .OR. JCMD.EQ.0 .OR. JCMD.GT.2) THEN
                      GOTO 1500
                  ENDIF
              ENDIF
              IF(MOD(JCMD,2).EQ.0 .AND. JCMD.GT.0) THEN
              ELSE
                  CALL M_EXCL(-3,NF,LUNTTO,IDELIM)
              ENDIF
          ENDIF
 2000 CONTINUE
C
      QASK = .FALSE.
      IF(.NOT.QSORTH .OR.
     +   XXLO.LT.XMINNM .OR. XXHI.GT.XMAXNM) THEN
          IF(QSORTH .AND.
     +       (XXLO.LT.XMINNM .OR. XXHI.GT.XMAXNM)) THEN
              CALL M_EMSG('MN_FTI'
     +         ,'Set orthogonality limits are inside the plot limits')
              CALL M_EMSG('MN_FTI'
     +         ,'They will be reset to the plot limits')
          ENDIF
          QASK = .TRUE.
          XMINNM = XXLO
          XMAXNM = XXHI
          YMINNM = YYLO
          YMAXNM = YYHI
      ENDIF
C
C     SET UPPER AND LOWER PLOT LIMITS TO DEFAULT
C
      CALL VZERO_r(ALIMS(1,1),2*3)
C
C     If doing fit type 2, i.e. likelihood using Monte Carlo statistics
C     or parameters are fractions
C     then set overall normalization on
C
      IF(NFITTP.EQ.2 .OR. NPARTP.EQ.1) THEN
          IF(.NOT.QSNORM) THEN
              TXTMES = ' Turning on overall normalization'
              CALL MN_MES(LUNTTO,'M',TXTMES)
              TXTMES = ' Use the SET NORM ON|OFF command to reset it' //
     +         ' for the next fit'
              CALL MN_MES(LUNTTO,'ME',TXTMES)
          ENDIF
          QSNORM = .TRUE.
      ENDIF
C
C     LOOP OVER FUNCTIONS AND SET UP PARAMETERS OK
C
      QPIPI = .FALSE.
      NFUSEM = 0
      DO 3000 NF=1,NFUN_MN
          NFUN = INUMF(NF)
          IF(IUSEF(NF).EQ.0) GOTO 3000
          NFUSEL = NF
          NFUSEM = NFUSEM + 1
          IF(TUSEF(NF)(1: 9).EQ.'Chebyshev' .OR.
     +       TUSEF(NF)(1: 8).EQ.'Legendre'  .OR.
     +       TUSEF(NF)(2:10).EQ.'Chebyshev' .OR.
     +       TUSEF(NF)(2: 9).EQ.'Legendre') QCHLG = .TRUE.
          IF(.NOT.QSORTH .AND.
     +       IDLSTA(1).NE.0 .AND. .NOT.QASK .AND. QCHLG .AND.
     +       (TUSEF(NF)(1: 9).EQ.'Chebyshev' .OR.
     +        TUSEF(NF)(1: 8).EQ.'Legendre'  .OR.
     +        TUSEF(NF)(2:10).EQ.'Chebyshev' .OR.
     +        TUSEF(NF)(2: 9).EQ.'Legendre')) THEN
 2100         CONTINUE
              QASK = .TRUE.
              QCHLG = .TRUE.
              CALL WAITYQ(' Calculate new orthogonality limits' //
     +         ' for Chebyshevs and Legendres [*Y/N]? ')
              JCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
              IF(IDELIM.GT.0) THEN
                  IF(QRFILE) THEN
                      CALL RESTYQ
                      JCMD = 1
                  ELSE
                      GOTO 2100
                  ENDIF
              ENDIF
              IF(MOD(JCMD,2).EQ.0 .AND. JCMD.GT.0) THEN
              ELSE
                  XMINNM = XXLO
                  XMAXNM = XXHI
                  YMINNM = YYLO
                  YMAXNM = YYHI
              ENDIF
          ENDIF
C
          IF(NFUN.EQ.LFPIPI) THEN
              QPIPI = .TRUE.
          ENDIF
C
C         IF THE FUNCTION IS A HISTOGRAM CHECK THAT THE HISTOGRAM
C         EXISTS AND CALCULATE THE SPLINE IF NECESSARY
C
          IF(NFUN.EQ.LFHFUN .OR. NFUN.EQ.LFHSMO) THEN
              IDA  = NINT(XFXPAR(1,NF))
              IDB  = NINT(XFXPAR(2,NF))
              IF(.NOT.QMNHEX(IDA,IDB,NH)) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     1              ,'' does not exist'')') IDA,IDB
                  CALL MN_ERR('MN_FTI',TXTERR)
                  GOTO 9000
              ENDIF
C
              IF(NFUN.EQ.LFHSMO) THEN
                  CALL M_FHSMO(NF,IERR)
                  IF(IERR.NE.0) GOTO 9000
              ENDIF
          ENDIF
C
C         If doing fit type 2, i.e. likelihood using Monte Carlo statistics
C         check that all functions are histograms
C
          IF(NFITTP.EQ.2) THEN
              IF(NFUN.NE.LFHFUN .AND. NFUN.NE.LFHSMO) THEN
                  WRITE(TXTERR,'(''Function'',I3
     +             ,'' is not a histogram'')') NF
                  CALL MN_ERR('MN_FTI',TXTERR)
                  GOTO 9000
              ENDIF
          ENDIF
C
C         If parameter types are 1, then change the names to fractions
C
          IF(NPARTP.EQ.1) THEN
              NTEXT = 4
              WRITE(TEXT,'(''FRC'',I1.1)') NFUSEM
              TPARF(1,NF) = TEXT(1:NTEXT)
          ENDIF
C
C         IF WE ARE FITTING MORE THAN 1 HISTOGRAM CHANGES THE NAMES
C
          IF(NHFIT.GT.1) THEN
              IPARF(NF) = IPARF(NF) + NHFIT - 1
              NPAR = IPARF(NF)
              DO 2200 II=NPAR,NHFIT+1,-1
                  TPARF(II,NF)   = TPARF(II-NHFIT+1,NF)
                  FPAR(II,NF)    = FPAR(II-NHFIT+1,NF)
                  DFPAR(II,NF)   = DFPAR(II-NHFIT+1,NF)
                  DPFPAR(II,NF)  = DPFPAR(II-NHFIT+1,NF)
                  DNFPAR(II,NF)  = DNFPAR(II-NHFIT+1,NF)
                  FPARLO(II,NF)  = FPARLO(II-NHFIT+1,NF)
                  FPARHI(II,NF)  = FPARHI(II-NHFIT+1,NF)
2200          CONTINUE
C
C             Using ratio of AREAs
C
              IF(QRATIO) THEN
                  DO 2300 NH=2,NHFIT
                      TEXT = TPARF(1,NF)(1:4)
                      IF(TEXT(1:4).EQ.'NORM') THEN
                          NTEXT = 9
                          TEXT = 'NRM /NORM'
                          WRITE(TEXT(4:4),'(I1.1)',IOSTAT=IOERR) NH-1
                      ELSE
                          NTEXT = 8
                          TEXT = 'AR /AREA'
                          WRITE(TEXT(3:3),'(I1.1)',IOSTAT=IOERR) NH-1
                      ENDIF
                      TPARF(NH,NF)  = TEXT(1:NTEXT)
                      FPAR(NH,NF)   = 0.5
                      DFPAR(NH,NF)  = 0.1
                      DPFPAR(NH,NF) = 0.0
                      DNFPAR(NH,NF) = 0.0
                      FPARLO(NH,NF) = 0.0
                      FPARHI(NH,NF) = 1.0
2300              CONTINUE
C
C             Using individual areas
C
              ELSE
                  DO 2400 NH=1,NHFIT
                      TEXT = TPARF(1,NF)(1:4)
                      IF(TEXT(1:4).EQ.'NORM') THEN
                          NTEXT = 5
                          TEXT = 'NORM'
                          WRITE(TEXT(5:5),'(I1.1)',IOSTAT=IOERR) NH
                      ELSE
                          NTEXT = 5
                          TEXT = 'AREA'
                          WRITE(TEXT(5:5),'(I1.1)',IOSTAT=IOERR) NH
                      ENDIF
                      TPARF(NH,NF)  = TEXT(1:NTEXT)
                      FPAR(NH,NF)   = FPAR(1,NF)
                      DFPAR(NH,NF)  = DFPAR(1,NF)
                      DPFPAR(NH,NF) = DPFPAR(1,NF)
                      DNFPAR(NH,NF) = DNFPAR(1,NF)
                      FPARLO(NH,NF) = FPARLO(1,NF)
                      FPARHI(NH,NF) = FPARHI(1,NF)
2400              CONTINUE
              ENDIF
C
C             Now decide if any parameters have to be fixed
C
              IF(QRATIO .AND. NHFIT.EQ.2) THEN
                  IF(IASSF(NF,1).EQ.0) THEN
                      FPAR(2,NF)   = 0.0
                      DFPAR(2,NF)  = 0.0
                      FPARLO(2,NF) = 0.0
                      FPARHI(2,NF) = 0.0
                  ELSEIF(IASSF(NF,2).EQ.0) THEN
                      FPAR(2,NF)   = 1.0
                      DFPAR(2,NF)  = 0.0
                      FPARLO(2,NF) = 0.0
                      FPARHI(2,NF) = 0.0
                  ENDIF
              ELSEIF(.NOT.QRATIO) THEN
                  DO 2500 NH=1,NHFIT
                      IF(IASSF(NF,NH).EQ.0) THEN
                          FPAR(NH,NF)   = 0.0
                          DFPAR(NH,NF)  = 0.0
                          FPARLO(NH,NF) = 0.0
                          FPARHI(NH,NF) = 0.0
                      ENDIF
 2500             CONTINUE
              ENDIF
          ENDIF
3000  CONTINUE
C
C     IF WE WANT TO DO A PIPI FIT FIND THE RELEVANT PARENT AND
C     DAUGHTER RESONANCES
C
      IF(QPIPI) THEN
          DO 5200 NH=1,NHFIT
              IDA = IDFITA(NH)
              IDB = IDFITB(NH)
              LENT = LNBLNK(TFTIT(NH))
              WRITE(TXTMES,'('' Histogram'',I7,I4,'':'',1X,A)'
     1         ,IOSTAT=IOERR) IDA,IDB,TFTIT(NH)(1:LENT)
              CALL MN_MES(LUNTTO,'ME',TXTMES)
              NFUN0  = 0
              DO 5100 NF=1,NFUN_MN
                  IF(IUSEF(NF).EQ.0) GOTO 5100
                  IF(INUMF(NF).NE.LFPIPI) GOTO 5100
                  if(nfun0.eq.0) then
                      call m_adpi(1,nf,nh,idelim,ierr)
                      if(ierr.ne.0) goto 9000
                      nfun0 = nf
                  else
                      xfxpar(2,nf) = xfxpar(2,nfun0)
                      xfxpar(3,nf) = xfxpar(3,nfun0)
                      xfxpar(4,nf) = xfxpar(4,nfun0)
                  endif
5100          CONTINUE
5200      CONTINUE
      ENDIF
C
C     Initialize MINIUT
C
      CALL MN_MES(LUNTTO,'M',' ')
      WRITE(TXTMES,'(1X,78(''=''))')
      CALL MN_MES(LUNTTO,'M',TXTMES)
      CALL MNINIT(LUNTTI,LUNTTO,LUNLPT)
      WRITE(TXTMES,'(1X,78(''=''))')
      CALL MN_MES(LUNTTO,'M',TXTMES)
      CALL MN_MES(LUNTTO,'M',' ')
      CALL MN_MES(LUNTTO,'ME',' ')
C
      TCMD = 'SET PRINTOUT'
C      LENT = LNBLNK(TCMD)
      WPAR(1) = 0.0D0
      CALL MNEXCM(FCN,TCMD,WPAR(1),1,IERFLG,FUTIL)
      WRITE(TXTMES,'(''Fitting Histogram(s):'',5(I7,I4,'';''))'
     + ,IOSTAT=IOERR) (IDFITA(II),IDFITB(II),II=1,NHFIT)
      LENT = MIN0(50,LNBLNK(TXTMES))
      CALL MNSETI(TXTMES(1:LENT))
C
C
      NPART = 0
C
      IF(QSNORM) THEN
          NPART = NPART + 1
          NAME  = 'NORM00'
          F00   = 1.0
          DF00  = 0.1
          DPF00 = 0.0
          DNF00 = 0.0
          F00LO = 0.0
          F00HI = 0.0
          ISF00 = NPART
          JMINFX(NPART) = 0
          JMINPX(NPART) = 1
          WPAR(1) = DBLE(F00)
          WPAR(2) = DBLE(DF00)
          WPAR(3) = DBLE(F00LO)
          WPAR(4) = DBLE(F00HI)
          CALL MNPARM(NPART,NAME,WPAR(1),WPAR(2),WPAR(3),WPAR(4),IERFLG)
      ENDIF
C
      NFUSEM = 0
      DO 4200 NF=1,NFUN_MN
          IF(IUSEF(NF).EQ.0) GOTO 4200
          NFUSEM = NFUSEM + 1
          NPARF = IPARF(NF)
          LENT = LNBLNK(TUSEF(NF))
          DO 4150 II=1,NPARF
              NPART = NPART + 1
              NAME = TPARF(II,NF)
              XXVAL = FPAR(II,NF)
              XXERR = DFPAR(II,NF)
              XXLO  = FPARLO(II,NF)
              XXHI  = FPARHI(II,NF)
              IF(XXERR.LT.0.0) XXERR = 0.01
              IF(XXERR.EQ.0.0 .AND. II.GT.NHFIT .AND.
     +           TUSEF(NF)(LENT-7:LENT).NE.' - QUICK') XXERR = 0.01
C
C             Fix the last normalization if parameter type is 2
C             Also set limits on the fractions
C
              IF(NPARTP.EQ.1) THEN
                  XXVAL = AMAX1(0.1,AMIN1(0.9,XXVAL))
                  XXLO = 0.0
                  XXHI = 1.0
                  IF(NF.EQ.NFUSEL) THEN
                      XXERR = 0.0
                  ENDIF
              ENDIF
C
C             Cross-references between MINUIT and Mn_Fit parameters
C
              JMINFX(NPART) = NF
              JMINPX(NPART) = II
              ISFPAR(II,NF) = NPART
              IF(XXERR.LE.0.0) ISFPAR(II,NF) = -NPART
C
              WPAR(1) = DBLE(XXVAL)
              WPAR(2) = DBLE(XXERR)
              WPAR(3) = DBLE(XXLO)
              WPAR(4) = DBLE(XXHI)
              CALL MNPARM(NPART,NAME,WPAR(1),WPAR(2),WPAR(3),WPAR(4)
     +         ,IERFLG)
4150      CONTINUE
4200  CONTINUE
C
C     Store the number of parameters and zero the number of constraints
C     plus the cross-reference table
C
      NPAR_MN = NPART
      NCNSTR  = 0
      CALL VZERO_i(JCNSTX(1),MINMAX)
C
C     If there are commands in the stack then turn on stack reading
C     Do this by defining a new command called QUICK_FIT_
C
      IF(NFSTKU.GT.0) THEN
          JDELIM = -1
          CALL QUOTYQ('QUICK_FIT_')
          COMND2 = 'UNDEFINE'
          QSFILE = QRFILE
          QRFILE = .TRUE.
          CALL M_DEFI(JDELIM,COMND2)
          QRFILE = QSFILE
          COMND2 = 'FDEFINE_'
          CALL M_DEFI(JDELIM,COMND2)
      ENDIF
C
C
      IF(QDEBUG) THEN
          DO 4800 I=1,NHFIT
              IDA = IDFITA(I)
              IDB = IDFITB(I)
              CALL MN_FGT(IDA,IDB,NH)
              WRITE(TXTMES,12000) IDA,IDB,NPNT
12000         FORMAT(' Fitting Histogram',I7,I4
     1         ,'  Number of points to fit',I6)
              CALL MN_MES(LUNTTO,'ME',TXTMES)
C
              DO 4700 JJ=1,NPNT
                  NPTR = NPTRD + NWPPT*(JJ-1) - 1
                  WRITE(LUNTTO,12010) JJ,(RFIT(NPTR+KK),KK=1,NWPPT)
12010             FORMAT(1X,I4,1PG14.6,' +/-',1PG14.6
     1             ,2X,1PG14.6,' +/-',1PG14.6)
 4700         CONTINUE
 4800     CONTINUE
      ENDIF
C
      WPAR(1) = 1.0D0
      TCMD = 'CALL FCN'
      CALL MNEXCM(FCN,TCMD,WPAR(1),1,IERFLG,FUTIL)
C
C     If there are commands in the stack then turn on stack reading
C
      IF(NFSTKU.GT.0) THEN
          CALL QUOTYQ('QUICK_FIT_')
      ENDIF
C
      CALL MIN_CMD
C
C     Put the results as the next start values
C     and reset MINUIT
C
      CALL MN_FUP(0)
C
C     Flag that I have exited MINUIT, so next DISPLAY allows for a change
C     in the number of functions etc.
C
      QMNCHGE = .TRUE.
C
C     Clear all the MINUIT parameters
C
      TCMD = 'CLEAR'
      CALL MNEXCM(FCN,TCMD,0.0D0,0,IERFLG,FUTIL)
C
      NFLAST = NHFIT
      DO 8100 I=1,NHFIT
          IDLSTA(I) = IDFITA(I)
          IDLSTB(I) = IDFITB(I)
8100  CONTINUE
*
*     Reset the use of the bin width in function calculation??
*
      QFBINW = qfbinsv
C
 9000 CONTINUE
      RETURN
      END
