//------------------------------------------------------------------------
// Get the header information for a histogram
//
// $Id: m_root_hdr.cxx,v 1.2 2005/06/06 09:29:17 brock Exp $
//------------------------------------------------------------------------

#include "TDirectory.h"
#include "TKey.h"
#include "TDatime.h"
#include "TH1.h"
#include <string>
#include <iostream>

using namespace std;

extern "C" {
    int m_root_hdr_(Int_t &leni, char *tidi,
		    Int_t &lent, char *title,
		    Int_t &ndim, Int_t &nwppt,
		    Int_t &nbinx, Float_t &xlo, Float_t &xhi,
		    Int_t &nbiny, Float_t &ylo, Float_t &yhi,
		    Int_t &nbinz, Float_t &zlo, Float_t &zhi,
		    Int_t &nhdate, Int_t &nhtime) {
	
	char* tid;
	tid = tidi;
	tid[leni] = 0;
	//gDirectory->ls();
	TH1 *h; 
	gDirectory->GetObject(tid,h);
	if ( h == 0 ) {
	    cout << "m_root_hdr: Could not find histogram " << tid << endl;
	    return 1;
	}
	//gDirectory->GetListOfKeys()->Print();
	TDatime datime = gDirectory->GetModificationDate();
	nhdate = datime.GetDate();
	nhtime = datime.GetTime();
	//datime.Print();
	//cout << "Directory modification date/time is " 
	//     << datime.GetDate() << "/" << datime.GetTime() << endl;
	
	//TIter next(gDirectory->GetListOfKeys());
	//TKey *key;
	//while ( (key=(TKey*)next()) ) {
	//    printf("Key %s is a %s with date/time %d/%d\n",
	//	   key->GetName(),key->GetClassName(),
	//	   key->GetDatime().GetDate(),key->GetDatime().GetTime());
	//}
	TKey *hkey = gDirectory->GetKey(tid);
	//cout << "Key name  is " << hkey->GetName() << endl;
	//cout << "Key class is " << hkey->GetClassName() << endl;
	//cout << "Key date  is " << hkey->GetDatime().GetDate() << endl;
	//cout << "Key time  is " << hkey->GetDatime().GetTime() << endl;
	nhdate = hkey->GetDatime().GetDate();
	nhtime = hkey->GetDatime().GetTime();
	//cout << "Key for " << tid << " is " << hkey->Print();
	//TDatime *hdatime = hkey->GetDatime();
	//TDatime datimeh = gDirectory->GetKey(tid)->GetModificationDate();
	//datimeh.Print();
	//cout << "Modification date/time is " 
	//     << datimeh.GetDate() << "/" << datimeh.GetTime() << endl;

	const char *classname;
	classname = h->ClassName();
	cout << "m_root_hdr: " << tid << " is a " << classname << endl;

	/* In case of variable bin width set ndim = -1 and nwppt = -4 */

	// Get the information about the histograms
	if ( strcmp(classname,"TH1C") == 0 ||
	     strcmp(classname,"TH1D") == 0 || 
	     strcmp(classname,"TH1F") == 0 || 
	     strcmp(classname,"TH1I") == 0 || 
	     strcmp(classname,"TH1S") == 0 ||
	     strcmp(classname,"TProfile") == 0 ) {
	    const TArrayD *xbins = h->GetXaxis()->GetXbins();
	    //cout << "Number of bin values: " << xbins->fN << endl;
	    if ( xbins->fN != 0 ) {
		ndim  = -1;
		nwppt = 4;
	    } else {
		ndim  = 1;
		nwppt = 2;
	    }
	    nbinx = h->GetNbinsX();
	    xlo   = h->GetXaxis()->GetBinLowEdge(1);
	    xhi   = h->GetXaxis()->GetBinLowEdge(nbinx+1);
	    nbiny = 0;
	    ylo = yhi = 0.0;
	} else if ( strcmp(classname,"TH2C") == 0 ||
		    strcmp(classname,"TH2D") == 0 || 
		    strcmp(classname,"TH2F") == 0 || 
		    strcmp(classname,"TH2I") == 0 || 
		    strcmp(classname,"TH2S") == 0 ||
		    strcmp(classname,"TProfile2D") == 0 ) {
	    const TArrayD *xbins = h->GetXaxis()->GetXbins();
	    cout << "Number of x bin values: " << xbins->fN << endl;
	    const TArrayD *ybins = h->GetYaxis()->GetXbins();
	    cout << "Number of y bin values: " << ybins->fN << endl;
	    if ( xbins->fN != 0 || ybins->fN != 0 ) {
		ndim  = -2;
		nwppt = 6;
	    } else {
		ndim  = 2;
		nwppt = 2;
	    }
	    nbinx = h->GetNbinsX();
	    xlo   = h->GetXaxis()->GetBinLowEdge(1);
	    xhi   = h->GetXaxis()->GetBinLowEdge(nbinx+1);
	    nbiny = h->GetNbinsY();
	    ylo   = h->GetYaxis()->GetBinLowEdge(1);
	    yhi   = h->GetYaxis()->GetBinLowEdge(nbiny+1);
	} else if ( strcmp(classname,"TH3C") == 0 ||
		    strcmp(classname,"TH3D") == 0 || 
		    strcmp(classname,"TH3F") == 0 || 
		    strcmp(classname,"TH3I") == 0 || 
		    strcmp(classname,"TH3S") == 0 ) {
	    ndim  = 3;
	    const TArrayD *xbins = h->GetXaxis()->GetXbins();
	    cout << "Number of x bin values: " << xbins->fN << endl;
	    const TArrayD *ybins = h->GetYaxis()->GetXbins();
	    cout << "Number of y bin values: " << ybins->fN << endl;
	    const TArrayD *zbins = h->GetZaxis()->GetXbins();
	    cout << "Number of z bin values: " << zbins->fN << endl;
	    if ( xbins->fN != 0 || ybins->fN != 0 || zbins->fN != 0 ) {
		cout << "m_root_hdr: "
		     << "Cannot handle variable bin width 3-D histograms"
		     << endl;
		return 1;
	    }
	    nwppt = 2;
	    nbinx = h->GetNbinsX();
	    xlo   = h->GetXaxis()->GetBinLowEdge(1);
	    xhi   = h->GetXaxis()->GetBinLowEdge(nbinx+1);
	    nbiny = h->GetNbinsY();
	    ylo   = h->GetYaxis()->GetBinLowEdge(1);
	    yhi   = h->GetYaxis()->GetBinLowEdge(nbiny+1);
	    nbinz = h->GetNbinsZ();
	    zlo   = h->GetZaxis()->GetBinLowEdge(1);
	    zhi   = h->GetZaxis()->GetBinLowEdge(nbinz+1);
	} else {
	    cout << "m_root_hdr: "
		 << tid << " is not a 1-D, 2-D, 3-D or Profile histogram: "
		 << classname << endl;
	    return 1;
	}

	const char* nam = h->GetName();
	const char* tit = h->GetTitle();
	//cout << "Histogram name/title: " << nam << "/" << tit << endl;
	Int_t len = strlen(tit);
	strcpy(title,tit);
	lent = len;

	return 0;
    }
}
