      SUBROUTINE M_NTPSCN(IDELIM)
C
C-----------------------------------------------------------------------
C
C     Scans an Ntuple, invoking a COMIS function for every entry
C     in the Ntuple.
C
C     Called by MN_NTP
C
C-----------------------------------------------------------------------
C
      implicit none
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mntpl.inc"
#include "mncwn.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      CHARACTER*80 TFILI,TFILE,TFUNC,TXT1
      CHARACTER*40 TARG
      INTEGER IDA,IDB,idh,NH,nh2,I,KCMD,IDELIM,IERR
      integer nnid,ioerr,nchri,ind1,ind2,nevt1,nevt2,nadr,id1,ndhis0
      real arg
      REAL XVAL,CSRJCL
      LOGICAL QEXIST,qcwntp,hntnew,accessf
      integer isltyq,icmtyq
      real valtyq
      external isltyq,icmtyq,valtyq,hntnew
C
      CALL WAITYQ('Give the Ntuple identifier: ')
      CALL MN_HNO(IDA,IDB,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 9000
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Ntuple'',I7,I4,'' does not exist'')'
     +     ,IOSTAT=IOERR) IDA,IDB
          CALL MN_ERR('M_NTPSCN',TXTERR)
          GOTO 9000
      ENDIF
C
C     Check that it really is an Ntuple
C
      IF(NDIM.GT.-2) THEN
          WRITE(TXTERR,'(''Plot'',I7,I4,'' is not an Ntuple'')'
     +     ,IOSTAT=IOERR) IDA,IDB
          CALL MN_ERR('M_NTPSCN',TXTERR)
          GOTO 9000
      ENDIF
*
*     Find out if it is a CWN
*
      qcwntp = .false.
      if(ndim.lt.0 .and. nwdat.le.0) then
          if(qafetch) then
              nh2 = nh
          else
              nh2 = -nh
          endif
          call m_intp(ida,idb,nh2,ierr)
          if(ierr.ne.0) goto 9000
          idh = ida
          qcwntp = hntnew(idh)
      endif
C
C     Fill the commons with the Ntuple information
C
      ID    = IDA
      NVAR  = IABS(NDIM)
      TITLE = TDTIT(NH)
      CALL UCOPY_r(ADLO,RLIM(1),NVAR)
      CALL UCOPY_r(ADHI,RLIM(NVAR+1),NVAR)
      CALL TCOPY(TDNAM(1,NH),TAGS,NVAR)
C
      CALL WAITYQ('Give COMIS filename: ')
      NCHRI = ISLTYQ(.TRUE.,IDELIM,TFILI)
      IF(NCHRI.LE.0) GOTO 9000
C
C     See if a calling argument was given
C
      IND1 = INDEX(TFILI(1:NCHRI),'(')
      IND2 = INDEX(TFILI(1:NCHRI),')')
      IF(IND1.GT.1 .AND. IND2.GT.IND1+1) THEN
          TARG = TFILI(IND1+1:IND2-1)
          NCHRI = IND1 - 1
      ELSE
          TARG = ' '
      ENDIF
C
C     See if the file exists and if not write a skeleton
C
      tfile = tfili(:nchri)
      call m_pfil(0,tfile,ierr)
      if(ierr.ne.0) goto 9000
#if ( defined(UNIX) )
      qexist = accessf(tfile,0)
#endif
#if ( defined(VMS) )
      INQUIRE(FILE=tfile,EXIST=QEXIST)
#endif

      IF(.NOT.QEXIST) THEN
          CALL M_SKEL(1,LUNTMP,NH,IERR,TFILE)
      ENDIF
C
C     See if the COMIS function should be edited
C
      CALL WAITYQ('Edit the COMIS function file [Y/N]: ')
      KCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
C
C     See if the number of events to scan is given
C
      CALL M_NEVT(IDELIM,NEVT1,NEVT2,IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Edit the COMIS function if requested
C
      IF(MOD(KCMD,2).EQ.1) THEN
          CALL QUOTYQ(TFILE)
          TXT1 = 'EDIT'
          CALL MN_SPW(TXT1,IDELIM)
      ENDIF
C
C     Compile the COMIS function
C
      CALL M_FCMS(0,TFILE,TFILI,TFUNC,NADR,IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Evaluate any argument
C
      ARG = 0.0
      IF(TARG.NE.' ') THEN
          CALL QUOTYQ(TARG)
          ARG = VALTYQ(.TRUE.,IDELIM)
          CALL ZERTYQ('.FALSE.')
          IF(IDELIM.GT.0) THEN
              TXTERR = 'Error in calling argument: ' // TARG
              CALL MN_ERR('M_NTPSCN',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
C
C     Initialize the reading of the Ntuple
C     but do not read it in again
C
      nvcwn = 0
      CALL M_NTPPNT(IDA,IDB,-1,IERR,RVAL)
      IF(IERR.NE.0) GOTO 9000
C
C     Loop over the Ntuple
C
      DO 3000 I=NEVT1,NEVT2
          CALL M_NTPPNT(IDA,IDB,I,IERR,RVAL)
          IF(IERR.NE.0) GOTO 9000
C
          IDNEVT = I
cicb          CALL CSJCAL(NADR,1,ARG)
          XVAL = CSRJCL(NADR,1,ARG)
3000  CONTINUE
C
C     Now make all the histograms in the current HBOOK directory in memory
C     into Mn_Fit histograms
C
      CALL M_SDIR(3,IERR)
      IF(IERR.NE.0) GOTO 9000
      NDHIS0 = NDHIS
      CALL M_HBMN(0,0,NDIDB,4)
      NNID = 1
      ID1  = 0
      CALL MN_HNG('M_NTPSCN',NNID,NDHIS0,1,ID1,ID1,IDB,IDB)
      CALL M_SDIR(0,IERR)
      IF(IERR.NE.0) GOTO 9000
C
9000  CONTINUE
      END
