C
      SUBROUTINE M_FILG(IDA,IDB,ADAT,AERN,AERP,WEIGHT,QERRI)
C
C     Filling routine for MNBOOK
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mntmp.inc"
#include "mnlun.inc"
C
      REAL ADAT(*),AERN(*),AERP(*)
C
      INTEGER IERR
      LOGICAL QINS,QERRI,QERRL,QERRH
C
      DATA IERR/0/
C
      NERR = 0
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) GOTO 9000
C
      CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
C
      NWTOT = NINT(RDAT(NPTRH))
      NWH   = NINT(RDAT(NPTRH+1))
      NWDAT = NINT(RDAT(NPTRH+2))
C
C     GET THE NUMBER OF UNDERFLOWS AND OVERFLOWS
C
      CALL MN_UOF(RDAT(NPTRH),ACONT)
C
C     FOR BINNED HISTOGRAMS INCREMENT THE BIN CONTENTS
C
      IF(NDIM.GT.0) THEN
C
C         SORT OUT WHICH BIN I AM IN AND THE POINTER TO IT
C
          NDEL  = 0
          NUOF  = 0
          NBTOT = 1
          QINS  = .TRUE.
          DO 1000 ND=1,NDIM
              FBIN = (ADAT(ND)-ADLO(ND)) / (ADHI(ND)-ADLO(ND))
CICB              IF(FBIN.LT.0.0 .OR. FBIN.GT.1.0) GOTO 9000
              IF(FBIN.GE.0.0) THEN
                  NBIN = IFIX(FBIN*FLOAT(IDBIN(ND))) + 1
              ELSE
                  NBIN = IFIX(FBIN*FLOAT(IDBIN(ND)))
              ENDIF
              NBIN = MIN0(MAX0(NBIN,0),IDBIN(ND)+1)
              IF(NBIN.LE.0) THEN
                  NUOF = 1
                  QINS = .FALSE.
              ELSE IF(NBIN.GT.IDBIN(ND)) THEN
                  NUOF = 3
                  QINS = .FALSE.
              ELSE
                  NUOF = 2
              ENDIF
C
              IF(QINS) THEN
                  IF(ND.EQ.1) THEN
                      NDEL = NBIN - 1
                  ELSE
                      NBTOT = NBTOT * IDBIN(ND-1)
                      NDEL = NDEL + NBTOT*(NBIN-1)
                  ENDIF
              ENDIF
C
              IF(NDIM.LE.3) THEN
                  IF(ND.EQ.1) THEN
                      NDUOF = NUOF - 1
                  ELSE
                      NDUOF = NDUOF + (3**(ND-1))*(NUOF-1)
                  ENDIF
              ENDIF
 1000     CONTINUE
C
          IF(QINS) THEN
              NPT = NDEL + 1
              EE  = AMNE(NPT,NH,NERR)
              EE  = EE + WEIGHT
              CALL UMNE(NPT,NH,NPTRD,NDIM,NWPPT,NBPPT,EE,NERR)
              DEE = 0.0
              IF(QERRL) THEN
                  DEE = AMNDEN(NPT,NH,NERR)
                  DEE = SQRT(DEE*DEE + WEIGHT*WEIGHT)
                  CALL UMNDE(NPT,NH,NPTRD,NDIM,NWPPT,NBPPT,DEE,NERR)
              ENDIF
          ENDIF
C
          IF(NDIM.LE.3) ACONT(NDUOF+1) = ACONT(NDUOF+1) + WEIGHT
          EDHI  = AMAX1(EDHI,EE+DEE)
          EDENT = EDENT + WEIGHT
C
C     UNBINNED HISTOGRAMS
C     FILL UP THE BUFFER AND IF NECESSARY WRITE IT OUT
C     OR JUST ADD THE EXTRA DATA POINT
C
      ELSEIF(NDIM.LT.0) THEN
C          IF(NWDAT.EQ.0 .AND.QMNOPN) THEN
C              NN = 0
C              DO 3000 NNN=1,NUBIN
C                  IF(IDA.EQ.IDTA(NNN) .AND. IDB.EQ.IDTB(NNN)) THEN
C                      NN = NNN
C                      NPTRT = IPTR(NN)
C                      GOTO 3001
C                  ENDIF
C3000          CONTINUE
C              GOTO 9000
C3001          CONTINUE
CC
C              CALL UCOPY_r(ADAT,RTMP(NPTRT+1,NN),IABS(NDIM))
C              NPTRT = NPTRT + IABS(NDIM)
C              IF(QERRL) THEN
C                  IF(QERRI) CALL UCOPY_r(AERN,RTMP(NPTRT+1,NN),IABS(NDIM))
C                  NPTRT = NPTRT + IABS(NDIM)
C              ENDIF
C              IF(QERRH) THEN
C                  IF(QERRI) CALL UCOPY_r(AERP,RTMP(NPTRT+1,NN),IABS(NDIM))
C                  NPTRT = NPTRT + IABS(NDIM)
C              ENDIF
C
C              IF(NPTRT.GT.MNBLOK) THEN
C                  NWD = MNBLOK
C                  WRITE(LUNMNU) IDA,IDB,NWD,(RTMP(II,NN),II=1,NWD)
C                  NPTRT = NPTRT - MNBLOK
C                  IDWR(NN)  = IDWR(NN) + 1
C                  CALL UCOPY_r(RTMP(MNBLOK+1,NN),RTMP(1,NN),NPTRT)
C              ENDIF
C              IPTR(NN)  = NPTRT
C
C          ELSE IF(NWDAT.GT.0) THEN
              IF(NWPPT*NPNT.LT.NWDAT) THEN
                  NWCOP = IABS(NDIM)
                  IF(NDIM.EQ.-1) NWCOP = NWCOP + 1
                  NPTR = NPTRD + NWPPT*NPNT
                  CALL UCOPY_r(ADAT,RDAT(NPTR),NWCOP)
                  IF(QERRL) THEN
                      NPTR = NPTR + NWCOP
                      IF(QERRI) CALL UCOPY_r(AERN,RDAT(NPTR),NWCOP)
                  ENDIF
                  IF(QERRH) THEN
                      NPTR = NPTR + NWCOP
                      IF(QERRI) CALL UCOPY_r(AERP,RDAT(NPTR),NWCOP)
                  ENDIF
              ELSE
                  IERR = IERR + 1
                  IF(IERR.LE.10 .OR. MOD(IERR,100).EQ.1) THEN
                      WRITE(TXTERR,'(''No more room to store data''
     1                 ,'' for plot'',I7,I4)') IDA,IDB
                      CALL M_EMSG('M_FILG',TXTERR)
                  ENDIF
                  GOTO 9000
              ENDIF
C          ENDIF
C
C         UPDATE THE POINTERS AND NUMBER OF ENTRIES
C
          DO 3100 ND=1,IABS(NDIM)
              IF(QERRH) THEN
                  ADLO(ND) = AMIN1(ADLO(ND),ADAT(ND)-AERN(ND))
                  ADHI(ND) = AMAX1(ADHI(ND),ADAT(ND)+AERP(ND))
              ELSEIF(QERRL) THEN
                  ADLO(ND) = AMIN1(ADLO(ND),ADAT(ND)-AERN(ND))
                  ADHI(ND) = AMAX1(ADHI(ND),ADAT(ND)+AERN(ND))
              ELSE
                  ADLO(ND) = AMIN1(ADLO(ND),ADAT(ND))
                  ADHI(ND) = AMAX1(ADHI(ND),ADAT(ND))
              ENDIF
3100      CONTINUE
          NPNT = NPNT + 1
          EDENT = FLOAT(NPNT)
          IF(NDIM.EQ.-1) THEN
              IF(QERRH) THEN
                  EDLO = AMIN1(EDLO,ADAT(2)-AERN(2))
                  EDHI = AMAX1(EDHI,ADAT(2)+AERP(2))
              ELSEIF(QERRL) THEN
                  EDLO = AMIN1(EDLO,ADAT(2)-AERN(2))
                  EDHI = AMAX1(EDHI,ADAT(2)+AERN(2))
              ELSE
                  EDLO = AMIN1(EDLO,ADAT(2))
                  EDHI = AMAX1(EDHI,ADAT(2))
              ENDIF
              acont(2) = edent
          elseif(ndim.eq.-2) then
              acont(5) = edent
          ENDIF
      ENDIF
C
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWDAT,IDA,IDB,NDIM,NWPPT,NPNT
     1 ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
C
 9000 CONTINUE
      RETURN
      END
