      SUBROUTINE MIN_CMD
C
C     Routine for interpreting MINUIT commands and passing them to MINUIT
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mncmd.inc"
#include "mntyq.inc"
#include "mnlun.inc"
C
      PARAMETER (MMIN=52)
      CHARACTER*10 MINNAM(MMIN)
C
      CHARACTER*20 TCMD
      CHARACTER*80 TXT1,TXT2
C
      DOUBLE PRECISION RNUMB(20),PVAL(MINMAX)
      DOUBLE PRECISION G,F
      DOUBLE PRECISION FMIN,FEDM,ERRDEF,VAL,ERROR,BND1,BND2
      DOUBLE PRECISION EPSI_0,EPSI
      DOUBLE PRECISION WWK,WW1,WW2,WW3,WW4
      CHARACTER*10 TPNAME
      INTEGER NSTK,NPRLEV
C
      DATA MINNAM/'HELP', 'EXIT', 'MINUIT',
     2 'MODIFY',    'MINOS',     'MAX_CALLS', 'PRECISION',
     3 'FCN_DRAW',  'FCN_PLOT',  'PROB_PLOT', 'CHI_PLOT',  'INFO',
     3 'FORCE_ISW', 'STANDARD',  'UNIT',      'STRATEGY',
     + 'CONTOUR',   'MNCONTOUR', 'SCAN',
     4 'SEEK',      'IMPROVE',   'MINIMIZE',  'SIMPLEX',   'MIGRAD',
     5 'PUNCH',     'SAVE',      'PRINTOUT',
     + 'FIX',       'FLOAT',     'RELEASE',   'RESTORE',
     7 'GRADIENT',  'NO_GRADIEN','CALL_FCN',  'MATOUT',
     8 'HESSE',     'COVARIANCE',
     9 'ERROR_DEF', 'PAGE',
     A 'FIT_INFO',  'DUMP',       'DISPLAY',
     1 'EXCLUDE',   'NO_EXCLUDE', 'INCLUDE',  'NO_INCLUDE',
     2 'ITERATIONS','NO_ITERATI',
     3 'BACK_SUB',  'CONSTRAIN',  'UNCONSTRAI',
     Z ' '/
      DATA NPRLEV/0/
C
      NFCNMX_0= 2000
      EPSI_0  = 0.1
      NSTK    = 0
C
C     MAIN LOOP FOR COMMANDS
C
1000  CONTINUE
C
      CALL WAITYQ('MINUIT> ')
      ICMD = ICMTYQ(.TRUE.,IDELIM,MINNAM)
      IF(ICMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 1000
      ENDIF
      COMND1 = ' '
      IF(ICMD.GT.0) COMND1 = MINNAM(ICMD)
      CALL MN_DCK(IDELIM,ICMD,MMIN,MINNAM,IERR)
      IF(ICMD.LT.0 .OR. (IERR.NE.0 .AND. IERR.NE.2)) THEN
          GOTO 1000
      ENDIF
C
      IF(IERR.EQ.2) THEN
          CALL RESTYQ
C
C         UPDATE THE VALUES OF THE FUNCTION PARAMETERS
C
          CALL MN_FUP(1)
C
C         SEE IF THE COMMAND IS A STANDARD MN_FIT COMMAND
C
          CALL RESTYQ
          NCFLG = -1
          CALL MN_CMD(NCFLG,NCERR)
C
C         SEE IF THE COMMAND IS AN INTERNALLY DEFINED COMMAND
C
          IF(NOPR.GT.0 .AND. NCERR.EQ.2) THEN
              CALL RESTYQ
              CALL MN_CIN(NCERR)
          ENDIF
C
C         ERROR IN COMMAND
C
          IF(NCERR.EQ.2) CALL MN_UNK('MIN_CMD')
          GOTO 1000
      ENDIF
C
C     EXECUTE THE COMMAND
C
      NFCNMX = NFCNMX_0
      EPSI   = EPSI_0
C
C     HELP COMMAND
C
      IF(COMND1.EQ.'HELP') THEN
          CALL MN_HLP(IDELIM,IERR)
          GOTO 1000
C
C     EXIT
C
      ELSEIF(COMND1.EQ.'EXIT') THEN
          RETURN
C
C     Get the MINUIT command
C
      ELSEIF(COMND1.EQ.'MINUIT') THEN
          CALL WAITYQ(
     +     'Give the MINUIT command and parameters: ')
          NCHAR2 = ISTTYP(.TRUE.,IDELIM,COMND2)
          IF(NCHAR2.LE.0 .OR. IDELIM.GT.0) THEN
              CALL ZERTYQ('.TRUE.')
              GOTO 1000
          ENDIF
          IF(COMND2(1:3).EQ.'SET' .OR. COMND2(1:3).EQ.'SHO') THEN
              CALL WAITYQ('SET or SHOW what: ')
              NCHAR3 = ISTTYP(.TRUE.,IDELIM,COMND3)
              IF(NCHAR3.LE.0 .OR. IDELIM.GT.0) THEN
                  CALL ZERTYQ('.TRUE.')
                  GOTO 1000
              ENDIF
              COMND2 = COMND2(1:NCHAR2) // ' ' // COMND3(1:NCHAR3)
          ENDIF
C
C     Extra MINUIT commands, that don't really use MINUIT
C
      ELSEIF(
     + COMND1.EQ.'EXCLUDE'    .OR. COMND1.EQ.'NO_EXCLUDE' .OR.
     + COMND1.EQ.'INCLUDE'    .OR. COMND1.EQ.'NO_INCLUDE' .OR.
     + COMND1.EQ.'ITERATIONS' .OR. COMND1.EQ.'NO_ITERATI' .OR.
     + COMND1.EQ.'BACK_SUB'   .OR.
     + COMND1.EQ.'CONSTRAIN'  .OR. COMND1.EQ.'UNCONSTRAI') THEN
         CALL MN_FUP(1)
         CALL MIN_CM2(IDELIM,FCN,FUTIL)
         GOTO 1000
      ENDIF
C
C     Get all the numbers out for the MINUIT command.
C
      NNUM = 0
      CALL VZERO_r(RNUMB,2*20)
      IF(COMND1.EQ.'MINUIT'    .OR. COMND1.EQ.'MINOS'     .OR.
     +   COMND1.EQ.'CONTOUR'   .OR. COMND1.EQ.'MNCONTOUR' .OR.
     +   COMND1.EQ.'SEEK'      .OR. COMND1.EQ.'STRATEGY'  .OR.
     +   COMND1.EQ.'PRINTOUT'  .OR.
     +   COMND1.EQ.'FIX'       .OR. COMND1.EQ.'FLOAT'     .OR.
     +   COMND1.EQ.'RELEASE'   .OR. COMND1.EQ.'RESTORE'   .OR.
     +   COMND1.EQ.'CALL_FCN'  .OR. COMND1.EQ.'ERROR_DEF') THEN
1600      CONTINUE
          IF(NNUM.LE.20 .AND. IDELIM.EQ.0) THEN
              RVAL = VALTYQ(.TRUE.,IDELIM)
              CALL MN_RCK(RVAL,IDELIM,IERR)
              IF(IERR.NE.0) GOTO 1600
              NNUM = NNUM + 1
              RNUMB(NNUM)  = RVAL
              GOTO 1600
          ENDIF
      ENDIF
C
C     Execute a MINUIT command
C
      IF(COMND1.EQ.'MINUIT') THEN
          LENC = LENOCC(COMND2)
          TCMD = COMND2(1:LENC)
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     MODIFY COMMAND
C
      ELSEIF(COMND1.EQ.'MODIFY') THEN
          CALL MNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
          CALL WAITYQ('Give parameter number: ')
          NUMQ = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NUMQ,IDELIM,NERR)
          IF(NERR.GT.0) THEN
              CALL ZERTYQ('.FALSE')
              GOTO 1000
          ENDIF
          IF(NUMQ.LE.0 .OR. NUMQ.GT.NPARX) THEN
              WRITE(TXTERR,'(''Error in parameter number'',I4)')
     1         NUMQ
              CALL MN_ERR('MIN_CMD',TXTERR)
              GOTO 1000
          ENDIF
          L = NUMQ
          CALL MNPOUT(NUMQ,TPNAME,VAL,ERROR,BND1,BND2,IVARBL)
          NNUM = 0
          CALL WAITYQ('Give new values: ')
2210      CONTINUE
          RVAL = VALTYQ(.TRUE.,IDELIM)
          IF(IDELIM.EQ.ICHAR('=')) THEN
              NNUM = NNUM + 1
              IF(NNUM.EQ.1) RNUMB(NNUM) = VAL
              IF(NNUM.EQ.2) RNUMB(NNUM) = ERROR
              IF(NNUM.EQ.3) RNUMB(NNUM) = BND1
              IF(NNUM.EQ.4) RNUMB(NNUM) = BND2
          ELSE
              CALL MN_RCK(RVAL,IDELIM,NERR)
              IF(NERR.EQ.0) THEN
                  NNUM = NNUM + 1
                  RNUMB(NNUM) = RVAL
              ELSEIF(NERR.NE.2) THEN
                  CALL ZERTYQ('.FALSE.')
                  GOTO 1000
              ENDIF
          ENDIF
          IF(IDELIM.GE.0) GOTO 2210
C
          DO 2250 K=1,4
              IF(K.GT.NNUM) THEN
                  IF(K.EQ.1) WWK=VAL
                  IF(K.EQ.2) WWK=ERROR
                  IF(K.EQ.3) WWK=BND1
                  IF(K.EQ.4) WWK=BND2
              ELSE
                  WWK=RNUMB(K)
              ENDIF
              IF(K.EQ.1) WW1=WWK
              IF(K.EQ.2) WW2=WWK
              IF(K.EQ.3) WW3=WWK
              IF(K.EQ.4) WW4=WWK
2250      CONTINUE
          CALL MNPARM(L,TPNAME,WW1,WW2,WW3,WW4,IERFLG)
          IF(IERFLG.NE.0) CALL MN_ERR('MIN_CMD'
     +     ,'Error modifying parameter')
          GOTO 1000
C
C     CHANGE THE NUMBER OF CALLS
C
      ELSEIF(COMND1.EQ.'MAX_CALLS') THEN
          TXT1 = 'Give number of calls (<CR> ='
          WRITE(TXT1(29:),'(I6)',IOSTAT=IOERR) NFCNMX_0
          LENT = LENOCC(TXT1)
          TXT2 = TXT1(1:LENT) // '):'
          LENT = LENT + 2
          CALL WAITYQ(TXT2(1:LENT))
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          IF(NVAL.GT.0) NFCNMX_0 = NVAL
          GOTO 1000
C
C     CHANGE THE PRECISION
C
      ELSEIF(COMND1.EQ.'PRECISION') THEN
          TXT1 = 'Give precision (<CR> ='
          WRITE(TXT1(23:),'(F10.5)',IOSTAT=IOERR) EPSI_0
          LENT = LENOCC(TXT1)
          TXT2 = TXT1(1:LENT) // '):'
          LENT = LENT + 2
          CALL WAITYQ(TXT2(1:LENT))
          RVAL = VALTYQ(.TRUE.,IDELIM)
          IF(RVAL.GT.0.0) EPSI_0 = DBLE(RVAL)
C
C     FCN_DRAW COMMAND
C
      ELSEIF(COMND1.EQ.'FCN_DRAW') THEN
          CALL MN_FUP(1)
          CALL MIN_DRAW(FCN,NNUM,RNUMB,FUTIL)
C
C     FCN_PLOT, PROB_PLOT and CHI_PLOT COMMANDS
C
      ELSEIF(COMND1.EQ.'FCN_PLOT' .OR. COMND1.EQ.'PROB_PLOT' .OR.
     +       COMND1.EQ.'CHI_PLOT') THEN
          CALL MN_FUP(1)
          IF(COMND1.EQ.'FCN_PLOT') THEN
              NMODE = 1
          elseif(comnd1.eq.'PROB_PLOT') then
              NMODE = 2
          elseif(comnd1.eq.'CHI_PLOT') then
              NMODE = 3
          ENDIF
          CALL MIN_PLOT(FCN,NMODE,FUTIL)
C
C     INFO COMMAND
C
      ELSEIF(COMND1.EQ.'INFO') THEN
          TCMD = 'SHOW PARAMETER'
          CALL MNEXCM(FCN,TCMD,RNUMB,0,IERFLG,FUTIL)
C
C     FORCE ISW TO SOME VALUE
C
      ELSEIF(COMND1.EQ.'FORCE_ISW') THEN
          CALL M_EMSG('MIN_CMD','Command not valid in CERN MINUIT')
C
C     CALL STANDARD ROUTINE
C
      ELSEIF(COMND1.EQ.'STANDARD') THEN
          TCMD = 'STANDARD'
          CALL MNEXCM(FCN,TCMD,RNUMB,0,IERFLG,FUTIL)
C
C     CHANGE THE INPUT UNIT
C
      ELSEIF(COMND1.EQ.'UNIT') THEN
          CALL M_EMSG('MIN_CMD','Command not valid in CERN MINUIT')
C
C     Standard CONTOUR command
C
      ELSE IF(COMND1.EQ.'CONTOUR') THEN
          TCMD = 'CONTOUR'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     MINOS type contour. Make a plot from it
C
      ELSE IF(COMND1.EQ.'MNCONTOUR') THEN
          CALL MIN_CONT(FCN,NNUM,RNUMB,FUTIL)
C
C     STRATEGY command
C
      ELSE IF(COMND1.EQ.'STRATEGY') THEN
          TCMD = 'SET STRATEGY'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     SCAN command
C
      ELSE IF(COMND1.EQ.'SCAN') THEN
          TCMD = 'SCAN'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     SEEK command
C
      ELSE IF(COMND1.EQ.'SEEK') THEN
          TCMD = 'SEEK'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     SIMPLEX COMMAND
C
      ELSE IF(COMND1.EQ.'SIMPLEX') THEN
          TCMD = 'SIMPLEX'
          RNUMB(1) = DBLE(NFCNMX)
          RNUMB(2) = EPSI
          NNUM = 2
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     MIGRAD COMMAND
C
      ELSE IF(COMND1.EQ.'MIGRAD') THEN
          TCMD = 'MIGRAD'
          RNUMB(1) = DBLE(NFCNMX)
          RNUMB(2) = EPSI
          NNUM = 2
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     MINIMIZE command
C
      ELSE IF(COMND1.EQ.'MINIMIZE') THEN
          TCMD = 'MINIMIZE'
          RNUMB(1) = DBLE(NFCNMX)
          RNUMB(2) = EPSI
          NNUM = 2
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     IMPROVE command
C
      ELSE IF(COMND1.EQ.'IMPROVE') THEN
          TCMD = 'IMPROVE'
          RNUMB(1) = NFCNMX
          NNUM = 1
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     MINOS command
C
      ELSE IF(COMND1.EQ.'MINOS') THEN
          TCMD = 'MINOS'
          DO 4000 I=NNUM,1,-1
              RNUMB(I+1) = RNUMB(I)
4000      CONTINUE
          RNUMB(1) = NFCNMX
          NNUM = NNUM + 1
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     PUNCH COMMAND
C
      ELSE IF(COMND1.EQ.'PUNCH' .OR. COMND1.EQ.'SAVE') THEN
          TCMD = 'SAVE'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     PRINTOUT COMMAND
C
      ELSE IF(COMND1.EQ.'PRINTOUT') THEN
          NPRLEV = NINT(RNUMB(1))
          TCMD = 'SET PRINTOUT'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     FIX COMMAND
C
      ELSE IF(COMND1.EQ.'FIX') THEN
          TCMD = 'FIX'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     FLOAT COMMAND
C
      ELSE IF(COMND1.EQ.'FLOAT' .OR. COMND1.EQ.'RELEASE') THEN
C
C         Check that the parameter being floated is not constrained
C
          DO 4500 I=1,NNUM
              NP = NINT(RNUMB(I))
              IF(JCNSTX(NP).NE.0) THEN
                  WRITE(TXTERR,'(''WARNING: Parameter'',I3
     +             ,'' is constrained. You should not float it'')'
     +             ,IOSTAT=IOERR) NP
                  CALL M_EMSG('MIN_CMD',TXTERR)
              ENDIF
4500      CONTINUE
C
          TCMD = 'RELEASE'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     RESTORE COMMAND
C
      ELSE IF(COMND1.EQ.'RESTORE') THEN
          TCMD = 'RESTORE'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     GRADIENT COMMAND
C
      ELSE IF(COMND1.EQ.'GRADIENT') THEN
          TCMD = 'SET GRADIENT'
          RNUMB(1) = 1.0
          NNUM = 1
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     TURN OFF GRADIENT COMMAND
C
      ELSE IF(COMND1.EQ.'NO_GRADIEN') THEN
          TCMD = 'SET NOGRADIENT'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     CALL FCN WITH SOME FLAG
C
      ELSE IF(COMND1.EQ.'CALL_FCN') THEN
          IF(NNUM.GT.0) THEN
              TCMD = 'CALL FCN'
              CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
          ENDIF
C
C     CALCULATE THE COVARIANCE MATRIX
C
      ELSE IF(COMND1.EQ.'HESSE') THEN
          TCMD = 'HESSE'
          RNUMB(1) = DBLE(NFCNMX)
          NNUM = 1
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
          IF(NPRLEV.GE.0) THEN
              NNUM = 0
              TCMD = 'SHOW COVARIANCE'
              CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
          ENDIF
C
C     CALCULATE OR OUTPUT THE COVARIANCE MATRIX
C
      ELSE IF(COMND1.EQ.'MATOUT') THEN
          TCMD = 'SHOW COVARIANCE'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     COVARIANCE COMMAND
C
      ELSE IF(COMND1.EQ.'COVARIANCE') THEN
          TCMD = 'SHOW COVARIANCE'
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     CHANGE THE ERROR DEFINITION
C
      ELSE IF(COMND1.EQ.'ERROR_DEF') THEN
          TCMD = 'SET ERRORDEF'
          IF(RNUMB(1).LE.0.) RNUMB(1) = 1.0D0
          NNUM = 1
          CALL MNEXCM(FCN,TCMD,RNUMB,NNUM,IERFLG,FUTIL)
C
C     START A NEW PAGE
C
      ELSE IF(COMND1.EQ.'PAGE') THEN
          WRITE(LUNDMP,'(''1'')')
C
C     FIT_INFO COMMAND
C
      ELSE IF(COMND1.EQ.'FIT_INFO' .OR. COMND1.EQ.'DUMP' .OR.
     +        COMND1.EQ.'DISPLAY') THEN
          CALL MNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
          DO 7000 I=1,NPARX
              CALL MNPOUT(I,TPNAME,PVAL(I),ERROR,BND1,BND2,IVARBL)
7000      CONTINUE
          IF(COMND1.EQ.'FIT_INFO') THEN
              IFLAG = 11
          ELSEIF(COMND1.EQ.'DUMP') THEN
              IFLAG = 12
          ELSEIF(COMND1.EQ.'DISPLAY') THEN
              IFLAG = 13
          ENDIF
C
          CALL FCN(NPARX,G,F,PVAL,IFLAG,FUTIL)
C
C     Invalid Command
C
      ELSE
          LENC = MAX0(1,LENOCC(COMND1))
          TXTERR = 'Command ' // COMND1(1:LENC) // ' not valid here'
          CALL MN_ERR('MIN_CMD',TXTERR)
      ENDIF
      GOTO 1000
C
      END
