void mn_call(void)
{
  void m_start_();
  int what_loop(void);
  void m_stop_();

  m_start_ ();

  ku_trap( 1, -1);         /* Install signal handler */

  while( 1 ) {
    if( what_loop() == 1 )
      break;
    else {
      /* this branch is for VMS exceptions only */
      reset_break();
    }
  }

  m_stop_ ();

  kc_break.jump_set = 0;
  ku_trap( 0, -1 );             /* remove signal handler */
  ku_shut();                    /* clean up the mess */

}


int what_loop()
{
  void m_run_();

#ifdef vms

  /*
   * The signal handler calls LIB$SIG_TO_RET which lets what_loop return
   * the error number ( 1 == SS$_NORMAL )
   */
  VAXC$ESTABLISH( signal_handler );

#endif

  /* catch exceptions saving signal mask */
  if( sigsetjmp( kc_break.stack, 1 ) != 0 ) { /* saving signal mask */
    /* longjmp happened */
    reset_break();
  }
  kc_break.jump_set = 1;

  m_run_ ();

  kc_break.intr_count = 0;    /* reset the ^C counter */

  return 1;
}
