/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit http://www.gnu.org/copyleft/gpl.html

   Written by Moritz Bunkus <moritz@bunkus.org>.
   Changes by Robert Millan <rmh@aybabtu.com>.
   Changes by Daniel Løvbrøtte Olsen <daniel@dodsorf.as>
*/

#include "common/common_pch.h"

#include "common/extern_data.h"

#ifdef SYS_UNIX
std::vector<std::string> const sub_charsets = {
  "1026",
  "1046",
  "1047",
  "10646-1:1993",
  "10646-1:1993UCS4",
  "437",
  "500",
  "500V1",
  "850",
  "851",
  "852",
  "855",
  "856",
  "857",
  "860",
  "861",
  "862",
  "863",
  "864",
  "865",
  "866",
  "869",
  "874",
  "8859_1",
  "8859_2",
  "8859_3",
  "8859_4",
  "8859_5",
  "8859_6",
  "8859_7",
  "8859_8",
  "8859_9",
  "904",
  "ANSI_X3.110",
  "ANSI_X3.110-1983",
  "ANSI_X3.4",
  "ANSI_X3.4-1968",
  "ANSI_X3.4-1986",
  "ARABIC",
  "ARABIC7",
  "ARMSCII-8",
  "ASCII",
  "ASMO-708",
  "ASMO_449",
  "BALTIC",
  "BIG-5",
  "BIG-FIVE",
  "BIG5",
  "BIG5-HKSCS",
  "BIG5HKSCS",
  "BIGFIVE",
  "BS_4730",
  "CA",
  "CN",
  "CN-BIG5",
  "CN-GB",
  "CP-AR",
  "CP-GR",
  "CP-HU",
  "CP037",
  "CP038",
  "CP10007",
  "CP1004",
  "CP1026",
  "CP1046",
  "CP1047",
  "CP1070",
  "CP1079",
  "CP1081",
  "CP1084",
  "CP1089",
  "CP1124",
  "CP1125",
  "CP1129",
  "CP1132",
  "CP1133",
  "CP1160",
  "CP1161",
  "CP1162",
  "CP1163",
  "CP1164",
  "CP1250",
  "CP1251",
  "CP1252",
  "CP1253",
  "CP1254",
  "CP1255",
  "CP1256",
  "CP1257",
  "CP1258",
  "CP1361",
  "CP273",
  "CP274",
  "CP275",
  "CP278",
  "CP280",
  "CP281",
  "CP282",
  "CP284",
  "CP285",
  "CP290",
  "CP297",
  "CP367",
  "CP420",
  "CP423",
  "CP424",
  "CP437",
  "CP500",
  "CP737",
  "CP775",
  "CP813",
  "CP819",
  "CP850",
  "CP851",
  "CP852",
  "CP855",
  "CP856",
  "CP857",
  "CP860",
  "CP861",
  "CP862",
  "CP863",
  "CP864",
  "CP865",
  "CP866",
  "CP868",
  "CP869",
  "CP870",
  "CP871",
  "CP874",
  "CP875",
  "CP880",
  "CP891",
  "CP903",
  "CP904",
  "CP905",
  "CP912",
  "CP915",
  "CP916",
  "CP918",
  "CP920",
  "CP922",
  "CP930",
  "CP932",
  "CP933",
  "CP935",
  "CP936",
  "CP937",
  "CP939",
  "CP949",
  "CP950",
  "CPIBM861",
  "CSA7-1",
  "CSA7-2",
  "CSASCII",
  "CSA_T500",
  "CSA_T500-1983",
  "CSA_Z243.4-1985-1",
  "CSA_Z243.4-1985-2",
  "CSA_Z243.419851",
  "CSA_Z243.419852",
  "CSDECMCS",
  "CSEBCDICATDE",
  "CSEBCDICATDEA",
  "CSEBCDICCAFR",
  "CSEBCDICDKNO",
  "CSEBCDICDKNOA",
  "CSEBCDICES",
  "CSEBCDICESA",
  "CSEBCDICESS",
  "CSEBCDICFISE",
  "CSEBCDICFISEA",
  "CSEBCDICFR",
  "CSEBCDICIT",
  "CSEBCDICPT",
  "CSEBCDICUK",
  "CSEBCDICUS",
  "CSEUCKR",
  "CSEUCPKDFMTJAPANESE",
  "CSGB2312",
  "CSHPROMAN8",
  "CSIBM037",
  "CSIBM038",
  "CSIBM1026",
  "CSIBM1124",
  "CSIBM1129",
  "CSIBM1132",
  "CSIBM1133",
  "CSIBM1160",
  "CSIBM1161",
  "CSIBM11621162",
  "CSIBM1163",
  "CSIBM1164",
  "CSIBM273",
  "CSIBM274",
  "CSIBM275",
  "CSIBM277",
  "CSIBM278",
  "CSIBM280",
  "CSIBM281",
  "CSIBM284",
  "CSIBM285",
  "CSIBM290",
  "CSIBM297",
  "CSIBM420",
  "CSIBM423",
  "CSIBM424",
  "CSIBM500",
  "CSIBM851",
  "CSIBM855",
  "CSIBM856",
  "CSIBM857",
  "CSIBM860",
  "CSIBM863",
  "CSIBM864",
  "CSIBM865",
  "CSIBM866",
  "CSIBM868",
  "CSIBM869",
  "CSIBM870",
  "CSIBM871",
  "CSIBM880",
  "CSIBM891",
  "CSIBM903",
  "CSIBM904",
  "CSIBM905",
  "CSIBM918",
  "CSIBM922",
  "CSIBM930",
  "CSIBM932",
  "CSIBM933",
  "CSIBM935",
  "CSIBM937",
  "CSIBM939",
  "CSIBM943",
  "CSISO10367BOX",
  "CSISO103T618BIT",
  "CSISO10SWEDISH",
  "CSISO111ECMACYRILLIC",
  "CSISO11SWEDISHFORNAMES",
  "CSISO121CANADIAN1",
  "CSISO122CANADIAN2",
  "CSISO139CSN369103",
  "CSISO141JUSIB1002",
  "CSISO143IECP271",
  "CSISO14JISC6220RO",
  "CSISO150",
  "CSISO150GREEKCCITT",
  "CSISO151CUBA",
  "CSISO153GOST1976874",
  "CSISO15ITALIAN",
  "CSISO16PORTUGESE",
  "CSISO17SPANISH",
  "CSISO18GREEK7OLD",
  "CSISO19LATINGREEK",
  "CSISO2022CN",
  "CSISO2022JP",
  "CSISO2022JP2",
  "CSISO2022KR",
  "CSISO2033",
  "CSISO21GERMAN",
  "CSISO25FRENCH",
  "CSISO27LATINGREEK1",
  "CSISO49INIS",
  "CSISO4UNITEDKINGDOM",
  "CSISO50INIS8",
  "CSISO51INISCYRILLIC",
  "CSISO5427CYRILLIC",
  "CSISO5427CYRILLIC1981",
  "CSISO5428GREEK",
  "CSISO58GB1988",
  "CSISO60DANISHNORWEGIAN",
  "CSISO60NORWEGIAN1",
  "CSISO61NORWEGIAN2",
  "CSISO646DANISH",
  "CSISO69FRENCH",
  "CSISO84PORTUGUESE2",
  "CSISO85SPANISH2",
  "CSISO86HUNGARIAN",
  "CSISO88GREEK7",
  "CSISO89ASMO449",
  "CSISO90",
  "CSISO92JISC62991984B",
  "CSISO99NAPLPS",
  "CSISOLATIN1",
  "CSISOLATIN2",
  "CSISOLATIN3",
  "CSISOLATIN4",
  "CSISOLATIN5",
  "CSISOLATIN6",
  "CSISOLATINARABIC",
  "CSISOLATINCYRILLIC",
  "CSISOLATINGREEK",
  "CSISOLATINHEBREW",
  "CSKOI8R",
  "CSKSC5636",
  "CSMACINTOSH",
  "CSNATSDANO",
  "CSNATSSEFI",
  "CSN_369103",
  "CSPC775BALTIC",
  "CSPC850MULTILINGUAL",
  "CSPC862LATINHEBREW",
  "CSPC8CODEPAGE437",
  "CSPCP852",
  "CSSHIFTJIS",
  "CSUCS4",
  "CSUNICODE",
  "CUBA",
  "CWI",
  "CWI-2",
  "CYRILLIC",
  "DE",
  "DEC",
  "DEC-MCS",
  "DECMCS",
  "DIN_66003",
  "DK",
  "DS2089",
  "DS_2089",
  "E13B",
  "EBCDIC-AT-DE",
  "EBCDIC-AT-DE-A",
  "EBCDIC-BE",
  "EBCDIC-BR",
  "EBCDIC-CA-FR",
  "EBCDIC-CP-AR1",
  "EBCDIC-CP-AR2",
  "EBCDIC-CP-BE",
  "EBCDIC-CP-CA",
  "EBCDIC-CP-CH",
  "EBCDIC-CP-DK",
  "EBCDIC-CP-ES",
  "EBCDIC-CP-FI",
  "EBCDIC-CP-FR",
  "EBCDIC-CP-GB",
  "EBCDIC-CP-GR",
  "EBCDIC-CP-HE",
  "EBCDIC-CP-IS",
  "EBCDIC-CP-IT",
  "EBCDIC-CP-NL",
  "EBCDIC-CP-NO",
  "EBCDIC-CP-ROECE",
  "EBCDIC-CP-SE",
  "EBCDIC-CP-TR",
  "EBCDIC-CP-US",
  "EBCDIC-CP-WT",
  "EBCDIC-CP-YU",
  "EBCDIC-CYRILLIC",
  "EBCDIC-DK-NO",
  "EBCDIC-DK-NO-A",
  "EBCDIC-ES",
  "EBCDIC-ES-A",
  "EBCDIC-ES-S",
  "EBCDIC-FI-SE",
  "EBCDIC-FI-SE-A",
  "EBCDIC-FR",
  "EBCDIC-GREEK",
  "EBCDIC-INT",
  "EBCDIC-INT1",
  "EBCDIC-IS-FRISS",
  "EBCDIC-IT",
  "EBCDIC-JP-E",
  "EBCDIC-JP-KANA",
  "EBCDIC-PT",
  "EBCDIC-UK",
  "EBCDIC-US",
  "EBCDICATDE",
  "EBCDICATDEA",
  "EBCDICCAFR",
  "EBCDICDKNO",
  "EBCDICDKNOA",
  "EBCDICES",
  "EBCDICESA",
  "EBCDICESS",
  "EBCDICFISE",
  "EBCDICFISEA",
  "EBCDICFR",
  "EBCDICISFRISS",
  "EBCDICIT",
  "EBCDICPT",
  "EBCDICUK",
  "EBCDICUS",
  "ECMA-114",
  "ECMA-118",
  "ECMA-128",
  "ECMA-CYRILLIC",
  "ECMACYRILLIC",
  "ELOT_928",
  "ES",
  "ES2",
  "EUC-CN",
  "EUC-JISX0213",
  "EUC-JP",
  "EUC-KR",
  "EUC-TW",
  "EUCCN",
  "EUCJP",
  "EUCKR",
  "EUCTW",
  "FI",
  "FR",
  "GB",
  "GB13000",
  "GB18030",
  "GB2312",
  "GBK",
  "GB_1988-80",
  "GB_198880",
  "GEORGIAN-ACADEMY",
  "GEORGIAN-PS",
  "GOST_19768",
  "GOST_19768-74",
  "GOST_1976874",
  "GREEK",
  "GREEK-CCITT",
  "GREEK7",
  "GREEK7-OLD",
  "GREEK7OLD",
  "GREEK8",
  "GREEKCCITT",
  "HEBREW",
  "HP-ROMAN8",
  "HPROMAN8",
  "HU",
  "IBM-1046",
  "IBM-1124",
  "IBM-1129",
  "IBM-1132",
  "IBM-1133",
  "IBM-1160",
  "IBM-1161",
  "IBM-1162",
  "IBM-1163",
  "IBM-1164",
  "IBM-856",
  "IBM-922",
  "IBM-930",
  "IBM-932",
  "IBM-933",
  "IBM-935",
  "IBM-937",
  "IBM-939",
  "IBM-943",
  "IBM037",
  "IBM038",
  "IBM1004",
  "IBM1026",
  "IBM1046",
  "IBM1047",
  "IBM1089",
  "IBM1124",
  "IBM1129",
  "IBM1132",
  "IBM1133",
  "IBM1160",
  "IBM1161",
  "IBM1162",
  "IBM1163",
  "IBM1164",
  "IBM256",
  "IBM273",
  "IBM274",
  "IBM275",
  "IBM277",
  "IBM278",
  "IBM280",
  "IBM281",
  "IBM284",
  "IBM285",
  "IBM290",
  "IBM297",
  "IBM367",
  "IBM420",
  "IBM423",
  "IBM424",
  "IBM437",
  "IBM500",
  "IBM775",
  "IBM813",
  "IBM819",
  "IBM848",
  "IBM850",
  "IBM851",
  "IBM852",
  "IBM855",
  "IBM856",
  "IBM857",
  "IBM860",
  "IBM861",
  "IBM862",
  "IBM863",
  "IBM864",
  "IBM865",
  "IBM866",
  "IBM868",
  "IBM869",
  "IBM870",
  "IBM871",
  "IBM874",
  "IBM875",
  "IBM880",
  "IBM891",
  "IBM903",
  "IBM904",
  "IBM905",
  "IBM912",
  "IBM915",
  "IBM916",
  "IBM918",
  "IBM920",
  "IBM922",
  "IBM930",
  "IBM932",
  "IBM933",
  "IBM935",
  "IBM937",
  "IBM939",
  "IBM943",
  "IEC_P27-1",
  "IEC_P271",
  "INIS",
  "INIS-8",
  "INIS-CYRILLIC",
  "INIS8",
  "INISCYRILLIC",
  "ISIRI-3342",
  "ISIRI3342",
  "ISO-10646",
  "ISO-10646UCS2",
  "ISO-10646UCS4",
  "ISO-10646UTF-8",
  "ISO-10646UTF8",
  "ISO-2022-CN",
  "ISO-2022-CN-EXT",
  "ISO-2022-JP",
  "ISO-2022-JP-2",
  "ISO-2022-JP-3",
  "ISO-2022-KR",
  "ISO-8859-1",
  "ISO-8859-10",
  "ISO-8859-11",
  "ISO-8859-13",
  "ISO-8859-14",
  "ISO-8859-15",
  "ISO-8859-16",
  "ISO-8859-2",
  "ISO-8859-3",
  "ISO-8859-4",
  "ISO-8859-5",
  "ISO-8859-6",
  "ISO-8859-7",
  "ISO-8859-8",
  "ISO-8859-9",
  "ISO-CELTIC",
  "ISO-IR-10",
  "ISO-IR-100",
  "ISO-IR-101",
  "ISO-IR-103",
  "ISO-IR-109",
  "ISO-IR-11",
  "ISO-IR-110",
  "ISO-IR-111",
  "ISO-IR-121",
  "ISO-IR-122",
  "ISO-IR-126",
  "ISO-IR-127",
  "ISO-IR-138",
  "ISO-IR-139",
  "ISO-IR-14",
  "ISO-IR-141",
  "ISO-IR-143",
  "ISO-IR-144",
  "ISO-IR-148",
  "ISO-IR-15",
  "ISO-IR-150",
  "ISO-IR-151",
  "ISO-IR-153",
  "ISO-IR-155",
  "ISO-IR-156",
  "ISO-IR-157",
  "ISO-IR-16",
  "ISO-IR-166",
  "ISO-IR-17",
  "ISO-IR-179",
  "ISO-IR-18",
  "ISO-IR-19",
  "ISO-IR-193",
  "ISO-IR-197",
  "ISO-IR-199",
  "ISO-IR-203",
  "ISO-IR-209",
  "ISO-IR-21",
  "ISO-IR-226",
  "ISO-IR-25",
  "ISO-IR-27",
  "ISO-IR-37",
  "ISO-IR-4",
  "ISO-IR-49",
  "ISO-IR-50",
  "ISO-IR-51",
  "ISO-IR-54",
  "ISO-IR-55",
  "ISO-IR-57",
  "ISO-IR-6",
  "ISO-IR-60",
  "ISO-IR-61",
  "ISO-IR-69",
  "ISO-IR-8-1",
  "ISO-IR-84",
  "ISO-IR-85",
  "ISO-IR-86",
  "ISO-IR-88",
  "ISO-IR-89",
  "ISO-IR-9-1",
  "ISO-IR-90",
  "ISO-IR-92",
  "ISO-IR-98",
  "ISO-IR-99",
  "ISO2022CN",
  "ISO2022CNEXT",
  "ISO2022JP",
  "ISO2022JP2",
  "ISO2022KR",
  "ISO646-CA",
  "ISO646-CA2",
  "ISO646-CN",
  "ISO646-CU",
  "ISO646-DE",
  "ISO646-DK",
  "ISO646-ES",
  "ISO646-ES2",
  "ISO646-FI",
  "ISO646-FR",
  "ISO646-FR1",
  "ISO646-GB",
  "ISO646-HU",
  "ISO646-IT",
  "ISO646-JP",
  "ISO646-JP-OCR-B",
  "ISO646-KR",
  "ISO646-NO",
  "ISO646-NO2",
  "ISO646-PT",
  "ISO646-PT2",
  "ISO646-SE",
  "ISO646-SE2",
  "ISO646-US",
  "ISO646-YU",
  "ISO6937",
  "ISO8859-1",
  "ISO8859-10",
  "ISO8859-11",
  "ISO8859-13",
  "ISO8859-14",
  "ISO8859-15",
  "ISO8859-16",
  "ISO8859-2",
  "ISO8859-3",
  "ISO8859-4",
  "ISO8859-5",
  "ISO8859-6",
  "ISO8859-7",
  "ISO8859-8",
  "ISO8859-9",
  "ISO88591",
  "ISO885910",
  "ISO885911",
  "ISO885913",
  "ISO885914",
  "ISO885915",
  "ISO885916",
  "ISO88592",
  "ISO88593",
  "ISO88594",
  "ISO88595",
  "ISO88596",
  "ISO88597",
  "ISO88598",
  "ISO88599",
  "ISO_10367-BOX",
  "ISO_10367BOX",
  "ISO_2033",
  "ISO_2033-1983",
  "ISO_5427",
  "ISO_5427-EXT",
  "ISO_5427:1981",
  "ISO_5427EXT",
  "ISO_5428",
  "ISO_5428:1980",
  "ISO_646.IRV:1991",
  "ISO_6937",
  "ISO_6937-2",
  "ISO_6937-2:1983",
  "ISO_69372",
  "ISO_6937:1992",
  "ISO_8859-1",
  "ISO_8859-10",
  "ISO_8859-10:1992",
  "ISO_8859-14",
  "ISO_8859-14:1998",
  "ISO_8859-15:1998",
  "ISO_8859-1:1987",
  "ISO_8859-2",
  "ISO_8859-2:1987",
  "ISO_8859-3",
  "ISO_8859-3:1988",
  "ISO_8859-4",
  "ISO_8859-4:1988",
  "ISO_8859-5",
  "ISO_8859-5:1988",
  "ISO_8859-6",
  "ISO_8859-6:1987",
  "ISO_8859-7",
  "ISO_8859-7:1987",
  "ISO_8859-8",
  "ISO_8859-8:1988",
  "ISO_8859-9",
  "ISO_8859-9:1989",
  "ISO_9036",
  "IT",
  "JIS_C6220-1969-RO",
  "JIS_C62201969RO",
  "JIS_C6229-1984-B",
  "JIS_C62291984B",
  "JOHAB",
  "JP",
  "JP-OCR-B",
  "JS",
  "JUS_I.B1.002",
  "KOI-7",
  "KOI-8",
  "KOI8",
  "KOI8-R",
  "KOI8-T",
  "KOI8-U",
  "KOI8R",
  "KOI8U",
  "KSC5636",
  "L1",
  "L10",
  "L2",
  "L3",
  "L4",
  "L5",
  "L6",
  "L7",
  "L8",
  "LATIN-GREEK",
  "LATIN-GREEK-1",
  "LATIN1",
  "LATIN10",
  "LATIN2",
  "LATIN3",
  "LATIN4",
  "LATIN5",
  "LATIN6",
  "LATIN7",
  "LATIN8",
  "LATINGREEK",
  "LATINGREEK1",
  "MAC",
  "MAC-CYRILLIC",
  "MAC-IS",
  "MAC-SAMI",
  "MAC-UK",
  "MACCYRILLIC",
  "MACINTOSH",
  "MACIS",
  "MACUK",
  "MACUKRAINIAN",
  "MS-ANSI",
  "MS-ARAB",
  "MS-CYRL",
  "MS-EE",
  "MS-GREEK",
  "MS-HEBR",
  "MS-MAC-CYRILLIC",
  "MS-TURK",
  "MSCP1361",
  "MSCP949",
  "MSMACCYRILLIC",
  "MSZ_7795.3",
  "MS_KANJI",
  "NAPLPS",
  "NATS-DANO",
  "NATS-SEFI",
  "NATSDANO",
  "NATSSEFI",
  "NC_NC00-10",
  "NC_NC00-10:81",
  "NC_NC0010",
  "NF_Z_62-010",
  "NF_Z_62-010_(1973)",
  "NF_Z_62-010_1973",
  "NF_Z_62010",
  "NF_Z_62010_1973",
  "NO",
  "NO2",
  "NS_4551-1",
  "NS_4551-2",
  "NS_45511",
  "NS_45512",
  "OS2LATIN1",
  "OSF00010001",
  "OSF00010002",
  "OSF00010003",
  "OSF00010004",
  "OSF00010005",
  "OSF00010006",
  "OSF00010007",
  "OSF00010008",
  "OSF00010009",
  "OSF0001000A",
  "OSF00010020",
  "OSF00010100",
  "OSF00010101",
  "OSF00010102",
  "OSF00010104",
  "OSF00010105",
  "OSF00010106",
  "OSF00030010",
  "OSF0004000A",
  "OSF0005000A",
  "OSF05010001",
  "OSF10010001",
  "OSF10020025",
  "OSF10020111",
  "OSF10020115",
  "OSF10020116",
  "OSF10020118",
  "OSF1002011C",
  "OSF1002011D",
  "OSF10020122",
  "OSF10020129",
  "OSF100201A4",
  "OSF100201A8",
  "OSF100201B5",
  "OSF100201F4",
  "OSF10020352",
  "OSF10020354",
  "OSF10020357",
  "OSF10020359",
  "OSF1002035D",
  "OSF1002035E",
  "OSF1002035F",
  "OSF10020360",
  "OSF10020364",
  "OSF10020365",
  "OSF10020366",
  "OSF10020367",
  "OSF1002036B",
  "OSF10020370",
  "OSF1002037B",
  "OSF10020387",
  "OSF10020388",
  "OSF10020396",
  "OSF100203B5",
  "OSF10020402",
  "OSF10020417",
  "PT",
  "PT2",
  "R8",
  "ROMAN8",
  "RUSCII",
  "SE",
  "SE2",
  "SEN_850200_B",
  "SEN_850200_C",
  "SHIFT-JIS",
  "SHIFT_JIS",
  "SHIFT_JISX0213",
  "SJIS",
  "SS636127",
  "ST_SEV_358-88",
  "T.61",
  "T.61-8BIT",
  "T.618BIT",
  "TCVN",
  "TCVN-5712",
  "TCVN5712-1",
  "TCVN5712-1:1993",
  "TIS-620",
  "TIS620",
  "TIS620-0",
  "TIS620.2529-1",
  "TIS620.2533-0",
  "TS-5881",
  "TSCII",
  "UCS-2",
  "UCS-2BE",
  "UCS-2LE",
  "UCS-4",
  "UCS-4BE",
  "UCS-4LE",
  "UCS2",
  "UCS4",
  "UHC",
  "UJIS",
  "UK",
  "UNICODE",
  "UNICODEBIG",
  "UNICODELITTLE",
  "US",
  "US-ASCII",
  "UTF-16",
  "UTF-16BE",
  "UTF-16LE",
  "UTF-32",
  "UTF-32BE",
  "UTF-32LE",
  "UTF-7",
  "UTF-8",
  "UTF16",
  "UTF16BE",
  "UTF16LE",
  "UTF32",
  "UTF32BE",
  "UTF32LE",
  "UTF7",
  "UTF8",
  "VISCII",
  "WCHAR_T",
  "WIN-SAMI-2",
  "WINBALTRIM",
  "WINDOWS-1250",
  "WINDOWS-1251",
  "WINDOWS-1252",
  "WINDOWS-1253",
  "WINDOWS-1254",
  "WINDOWS-1255",
  "WINDOWS-1256",
  "WINDOWS-1257",
  "WINDOWS-1258",
  "WINSAMI2",
  "WS2",
  "YU",
};
#elif defined(SYS_APPLE)
std::vector<std::string> const sub_charsets = {
  "437",
  "850",
  "852",
  "855",
  "857",
  "860",
  "861",
  "862",
  "863",
  "865",
  "866",
  "869",
  "ANSI_X3.4-1968",
  "ANSI_X3.4-1986",
  "ARABIC",
  "ARMSCII-8",
  "ASCII",
  "ASMO-708",
  "BIG-5",
  "BIG-FIVE",
  "BIG5",
  "BIG5-HKSCS",
  "BIG5HKSCS",
  "BIGFIVE",
  "C99",
  "CHINESE",
  "CN",
  "CN-BIG5",
  "CN-GB",
  "CN-GB-ISOIR165",
  "CP-GR",
  "CP-IS",
  "CP1046",
  "CP1124",
  "CP1125",
  "CP1129",
  "CP1133",
  "CP1161",
  "CP1162",
  "CP1163",
  "CP1250",
  "CP1251",
  "CP1252",
  "CP1253",
  "CP1254",
  "CP1255",
  "CP1256",
  "CP1257",
  "CP1258",
  "CP1361",
  "CP367",
  "CP437",
  "CP737",
  "CP775",
  "CP819",
  "CP850",
  "CP852",
  "CP853",
  "CP855",
  "CP856",
  "CP857",
  "CP858",
  "CP860",
  "CP861",
  "CP862",
  "CP863",
  "CP864",
  "CP865",
  "CP866",
  "CP869",
  "CP874",
  "CP922",
  "CP932",
  "CP936",
  "CP943",
  "CP949",
  "CP950",
  "CSASCII",
  "CSBIG5",
  "CSEUCKR",
  "CSEUCPKDFMTJAPANESE",
  "CSEUCTW",
  "CSGB2312",
  "CSHALFWIDTHKATAKANA",
  "CSHPROMAN8",
  "CSIBM1161",
  "CSIBM1162",
  "CSIBM1163",
  "CSIBM855",
  "CSIBM857",
  "CSIBM860",
  "CSIBM861",
  "CSIBM863",
  "CSIBM864",
  "CSIBM865",
  "CSIBM866",
  "CSIBM869",
  "CSISO14JISC6220RO",
  "CSISO159JISX02121990",
  "CSISO2022CN",
  "CSISO2022JP",
  "CSISO2022JP2",
  "CSISO2022KR",
  "CSISO57GB1988",
  "CSISO58GB231280",
  "CSISO87JISX0208",
  "CSISOLATIN1",
  "CSISOLATIN2",
  "CSISOLATIN3",
  "CSISOLATIN4",
  "CSISOLATIN5",
  "CSISOLATIN6",
  "CSISOLATINARABIC",
  "CSISOLATINCYRILLIC",
  "CSISOLATINGREEK",
  "CSISOLATINHEBREW",
  "CSKOI8R",
  "CSKSC56011987",
  "CSMACINTOSH",
  "CSPC775BALTIC",
  "CSPC850MULTILINGUAL",
  "CSPC862LATINHEBREW",
  "CSPC8CODEPAGE437",
  "CSPCP852",
  "CSSHIFTJIS",
  "CSUCS4",
  "CSUNICODE",
  "CSUNICODE11",
  "CSUNICODE11UTF7",
  "CSVISCII",
  "CYRILLIC",
  "DEC-HANYU",
  "DEC-KANJI",
  "ECMA-114",
  "ECMA-118",
  "ELOT_928",
  "EUC-CN",
  "EUC-JISX0213",
  "EUC-JP",
  "EUC-KR",
  "EUC-TW",
  "EUCCN",
  "EUCJP",
  "EUCKR",
  "EUCTW",
  "EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE",
  "GB18030",
  "GB2312",
  "GBK",
  "GB_1988-80",
  "GB_2312-80",
  "GEORGIAN-ACADEMY",
  "GEORGIAN-PS",
  "GREEK",
  "GREEK8",
  "HEBREW",
  "HP-ROMAN8",
  "HZ",
  "HZ-GB-2312",
  "IBM-1161",
  "IBM-1162",
  "IBM-1163",
  "IBM-CP1133",
  "IBM1161",
  "IBM1162",
  "IBM1163",
  "IBM367",
  "IBM437",
  "IBM775",
  "IBM819",
  "IBM850",
  "IBM852",
  "IBM855",
  "IBM857",
  "IBM860",
  "IBM861",
  "IBM862",
  "IBM863",
  "IBM864",
  "IBM865",
  "IBM866",
  "IBM869",
  "ISO-10646-UCS-2",
  "ISO-10646-UCS-4",
  "ISO-2022-CN",
  "ISO-2022-CN-EXT",
  "ISO-2022-JP",
  "ISO-2022-JP-1",
  "ISO-2022-JP-2",
  "ISO-2022-JP-3",
  "ISO-2022-KR",
  "ISO-8859-1",
  "ISO-8859-10",
  "ISO-8859-13",
  "ISO-8859-14",
  "ISO-8859-15",
  "ISO-8859-16",
  "ISO-8859-2",
  "ISO-8859-3",
  "ISO-8859-4",
  "ISO-8859-5",
  "ISO-8859-6",
  "ISO-8859-7",
  "ISO-8859-8",
  "ISO-8859-9",
  "ISO-CELTIC",
  "ISO-IR-100",
  "ISO-IR-101",
  "ISO-IR-109",
  "ISO-IR-110",
  "ISO-IR-126",
  "ISO-IR-127",
  "ISO-IR-138",
  "ISO-IR-14",
  "ISO-IR-144",
  "ISO-IR-148",
  "ISO-IR-149",
  "ISO-IR-157",
  "ISO-IR-159",
  "ISO-IR-165",
  "ISO-IR-166",
  "ISO-IR-179",
  "ISO-IR-199",
  "ISO-IR-203",
  "ISO-IR-226",
  "ISO-IR-230",
  "ISO-IR-57",
  "ISO-IR-58",
  "ISO-IR-6",
  "ISO-IR-87",
  "ISO646-CN",
  "ISO646-JP",
  "ISO646-US",
  "ISO8859-1",
  "ISO8859-10",
  "ISO8859-13",
  "ISO8859-14",
  "ISO8859-15",
  "ISO8859-16",
  "ISO8859-2",
  "ISO8859-3",
  "ISO8859-4",
  "ISO8859-5",
  "ISO8859-6",
  "ISO8859-7",
  "ISO8859-8",
  "ISO8859-9",
  "ISO_646.IRV:1991",
  "ISO_8859-1",
  "ISO_8859-10",
  "ISO_8859-10:1992",
  "ISO_8859-13",
  "ISO_8859-14",
  "ISO_8859-14:1998",
  "ISO_8859-15",
  "ISO_8859-15:1998",
  "ISO_8859-16",
  "ISO_8859-16:2000",
  "ISO_8859-1:1987",
  "ISO_8859-2",
  "ISO_8859-2:1987",
  "ISO_8859-3",
  "ISO_8859-3:1988",
  "ISO_8859-4",
  "ISO_8859-4:1988",
  "ISO_8859-5",
  "ISO_8859-5:1988",
  "ISO_8859-6",
  "ISO_8859-6:1987",
  "ISO_8859-7",
  "ISO_8859-7:1987",
  "ISO_8859-8",
  "ISO_8859-8:1988",
  "ISO_8859-9",
  "ISO_8859-9:1989",
  "JAVA",
  "JIS0208",
  "JISX0201-1976",
  "JIS_C6220-1969-RO",
  "JIS_C6226-1983",
  "JIS_X0201",
  "JIS_X0208",
  "JIS_X0208-1983",
  "JIS_X0208-1990",
  "JIS_X0212",
  "JIS_X0212-1990",
  "JIS_X0212.1990-0",
  "JOHAB",
  "JP",
  "KOI8-R",
  "KOI8-RU",
  "KOI8-T",
  "KOI8-U",
  "KOREAN",
  "KSC_5601",
  "KS_C_5601-1987",
  "KS_C_5601-1989",
  "L1",
  "L2",
  "L3",
  "L4",
  "L5",
  "L6",
  "L7",
  "L8",
  "LATIN1",
  "LATIN2",
  "LATIN3",
  "LATIN4",
  "LATIN5",
  "LATIN6",
  "LATIN7",
  "LATIN8",
  "MAC",
  "MACARABIC",
  "MACCENTRALEUROPE",
  "MACCROATIAN",
  "MACCYRILLIC",
  "MACGREEK",
  "MACHEBREW",
  "MACICELAND",
  "MACINTOSH",
  "MACROMAN",
  "MACROMANIA",
  "MACTHAI",
  "MACTURKISH",
  "MACUKRAINE",
  "MS-ANSI",
  "MS-ARAB",
  "MS-CYRL",
  "MS-EE",
  "MS-GREEK",
  "MS-HEBR",
  "MS-TURK",
  "MS_KANJI",
  "MULELAO-1",
  "NEXTSTEP",
  "R8",
  "RISCOS-LATIN1",
  "ROMAN8",
  "SHIFT-JIS",
  "SHIFT_JIS",
  "SHIFT_JISX0213",
  "SJIS",
  "TCVN",
  "TCVN-5712",
  "TCVN5712-1",
  "TCVN5712-1:1993",
  "TDS565",
  "TIS-620",
  "TIS620",
  "TIS620-0",
  "TIS620.2529-1",
  "TIS620.2533-0",
  "TIS620.2533-1",
  "UCS-2",
  "UCS-2-INTERNAL",
  "UCS-2-SWAPPED",
  "UCS-2BE",
  "UCS-2LE",
  "UCS-4",
  "UCS-4-INTERNAL",
  "UCS-4-SWAPPED",
  "UCS-4BE",
  "UCS-4LE",
  "UHC",
  "UNICODE-1-1",
  "UNICODE-1-1-UTF-7",
  "UNICODEBIG",
  "UNICODELITTLE",
  "US",
  "US-ASCII",
  "UTF-16",
  "UTF-16BE",
  "UTF-16LE",
  "UTF-32",
  "UTF-32BE",
  "UTF-32LE",
  "UTF-7",
  "UTF-8",
  "UTF-8-MAC",
  "UTF8",
  "UTF8-MAC",
  "VISCII",
  "VISCII1.1-1",
  "WINBALTRIM",
  "WINDOWS-1250",
  "WINDOWS-1251",
  "WINDOWS-1252",
  "WINDOWS-1253",
  "WINDOWS-1254",
  "WINDOWS-1255",
  "WINDOWS-1256",
  "WINDOWS-1257",
  "WINDOWS-1258",
  "WINDOWS-874",
  "X0201",
  "X0208",
  "X0212",
};
#else
std::vector<std::string> const sub_charsets = {
  "437",
  "850",
  "852",
  "855",
  "857",
  "860",
  "861",
  "862",
  "863",
  "865",
  "866",
  "869",
  "ANSI_X3.4-1968",
  "ANSI_X3.4-1986",
  "ARABIC",
  "ARMSCII-8",
  "ASCII",
  "ASMO-708",
  "BIG-5",
  "BIG-FIVE",
  "BIG5",
  "BIG5-HKSCS",
  "BIG5HKSCS",
  "BIGFIVE",
  "C99",
  "CHINESE",
  "CN",
  "CN-BIG5",
  "CN-GB",
  "CN-GB-ISOIR165",
  "CP-GR",
  "CP-IS",
  "CP1125",
  "CP1133",
  "CP1250",
  "CP1251",
  "CP1252",
  "CP1253",
  "CP1254",
  "CP1255",
  "CP1256",
  "CP1257",
  "CP1258",
  "CP1361",
  "CP367",
  "CP437",
  "CP737",
  "CP775",
  "CP819",
  "CP850",
  "CP852",
  "CP853",
  "CP855",
  "CP857",
  "CP858",
  "CP860",
  "CP861",
  "CP862",
  "CP863",
  "CP864",
  "CP865",
  "CP866",
  "CP869",
  "CP874",
  "CP932",
  "CP936",
  "CP949",
  "CP950",
  "CSASCII",
  "CSBIG5",
  "CSEUCKR",
  "CSEUCPKDFMTJAPANESE",
  "CSEUCTW",
  "CSGB2312",
  "CSHALFWIDTHKATAKANA",
  "CSHPROMAN8",
  "CSIBM855",
  "CSIBM857",
  "CSIBM860",
  "CSIBM861",
  "CSIBM863",
  "CSIBM864",
  "CSIBM865",
  "CSIBM866",
  "CSIBM869",
  "CSISO14JISC6220RO",
  "CSISO159JISX02121990",
  "CSISO2022CN",
  "CSISO2022JP",
  "CSISO2022JP2",
  "CSISO2022KR",
  "CSISO57GB1988",
  "CSISO58GB231280",
  "CSISO87JISX0208",
  "CSISOLATIN1",
  "CSISOLATIN2",
  "CSISOLATIN3",
  "CSISOLATIN4",
  "CSISOLATIN5",
  "CSISOLATIN6",
  "CSISOLATINARABIC",
  "CSISOLATINCYRILLIC",
  "CSISOLATINGREEK",
  "CSISOLATINHEBREW",
  "CSKOI8R",
  "CSKSC56011987",
  "CSMACINTOSH",
  "CSPC775BALTIC",
  "CSPC850MULTILINGUAL",
  "CSPC862LATINHEBREW",
  "CSPC8CODEPAGE437",
  "CSPCP852",
  "CSSHIFTJIS",
  "CSUCS4",
  "CSUNICODE",
  "CSUNICODE11",
  "CSUNICODE11UTF7",
  "CSVISCII",
  "CYRILLIC",
  "ECMA-114",
  "ECMA-118",
  "ELOT_928",
  "EUC-CN",
  "EUC-JP",
  "EUC-KR",
  "EUC-TW",
  "EUCCN",
  "EUCJP",
  "EUCKR",
  "EUCTW",
  "EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE",
  "GB18030",
  "GB2312",
  "GBK",
  "GB_1988-80",
  "GB_2312-80",
  "GEORGIAN-ACADEMY",
  "GEORGIAN-PS",
  "GREEK",
  "GREEK8",
  "HEBREW",
  "HP-ROMAN8",
  "HZ",
  "HZ-GB-2312",
  "IBM-CP1133",
  "IBM367",
  "IBM437",
  "IBM775",
  "IBM819",
  "IBM850",
  "IBM852",
  "IBM855",
  "IBM857",
  "IBM860",
  "IBM861",
  "IBM862",
  "IBM863",
  "IBM864",
  "IBM865",
  "IBM866",
  "IBM869",
  "ISO-10646-UCS-2",
  "ISO-10646-UCS-4",
  "ISO-2022-CN",
  "ISO-2022-CN-EXT",
  "ISO-2022-JP",
  "ISO-2022-JP-1",
  "ISO-2022-JP-2",
  "ISO-2022-KR",
  "ISO-8859-1",
  "ISO-8859-10",
  "ISO-8859-13",
  "ISO-8859-14",
  "ISO-8859-15",
  "ISO-8859-16",
  "ISO-8859-2",
  "ISO-8859-3",
  "ISO-8859-4",
  "ISO-8859-5",
  "ISO-8859-6",
  "ISO-8859-7",
  "ISO-8859-8",
  "ISO-8859-9",
  "ISO-CELTIC",
  "ISO-IR-100",
  "ISO-IR-101",
  "ISO-IR-109",
  "ISO-IR-110",
  "ISO-IR-126",
  "ISO-IR-127",
  "ISO-IR-138",
  "ISO-IR-14",
  "ISO-IR-144",
  "ISO-IR-148",
  "ISO-IR-149",
  "ISO-IR-157",
  "ISO-IR-159",
  "ISO-IR-165",
  "ISO-IR-166",
  "ISO-IR-179",
  "ISO-IR-199",
  "ISO-IR-203",
  "ISO-IR-226",
  "ISO-IR-57",
  "ISO-IR-58",
  "ISO-IR-6",
  "ISO-IR-87",
  "ISO646-CN",
  "ISO646-JP",
  "ISO646-US",
  "ISO_646.IRV:1991",
  "ISO_8859-1",
  "ISO_8859-10",
  "ISO_8859-10:1992",
  "ISO_8859-13",
  "ISO_8859-14",
  "ISO_8859-14:1998",
  "ISO_8859-15",
  "ISO_8859-15:1998",
  "ISO_8859-16",
  "ISO_8859-16:2000",
  "ISO_8859-1:1987",
  "ISO_8859-2",
  "ISO_8859-2:1987",
  "ISO_8859-3",
  "ISO_8859-3:1988",
  "ISO_8859-4",
  "ISO_8859-4:1988",
  "ISO_8859-5",
  "ISO_8859-5:1988",
  "ISO_8859-6",
  "ISO_8859-6:1987",
  "ISO_8859-7",
  "ISO_8859-7:1987",
  "ISO_8859-8",
  "ISO_8859-8:1988",
  "ISO_8859-9",
  "ISO_8859-9:1989",
  "JAVA",
  "JIS0208",
  "JISX0201-1976",
  "JIS_C6220-1969-RO",
  "JIS_C6226-1983",
  "JIS_X0201",
  "JIS_X0208",
  "JIS_X0208-1983",
  "JIS_X0208-1990",
  "JIS_X0212",
  "JIS_X0212-1990",
  "JIS_X0212.1990-0",
  "JOHAB",
  "JP",
  "KOI8-R",
  "KOI8-RU",
  "KOI8-T",
  "KOI8-U",
  "KOREAN",
  "KSC_5601",
  "KS_C_5601-1987",
  "KS_C_5601-1989",
  "L1",
  "L2",
  "L3",
  "L4",
  "L5",
  "L6",
  "L7",
  "L8",
  "LATIN1",
  "LATIN2",
  "LATIN3",
  "LATIN4",
  "LATIN5",
  "LATIN6",
  "LATIN7",
  "LATIN8",
  "MAC",
  "MACARABIC",
  "MACCENTRALEUROPE",
  "MACCROATIAN",
  "MACCYRILLIC",
  "MACGREEK",
  "MACHEBREW",
  "MACICELAND",
  "MACINTOSH",
  "MACROMAN",
  "MACROMANIA",
  "MACTHAI",
  "MACTURKISH",
  "MACUKRAINE",
  "MS-ANSI",
  "MS-ARAB",
  "MS-CYRL",
  "MS-EE",
  "MS-GREEK",
  "MS-HEBR",
  "MS-TURK",
  "MS_KANJI",
  "MULELAO-1",
  "NEXTSTEP",
  "R8",
  "ROMAN8",
  "SHIFT-JIS",
  "SHIFT_JIS",
  "SJIS",
  "TCVN",
  "TCVN-5712",
  "TCVN5712-1",
  "TCVN5712-1:1993",
  "TIS-620",
  "TIS620",
  "TIS620-0",
  "TIS620.2529-1",
  "TIS620.2533-0",
  "TIS620.2533-1",
  "UCS-2",
  "UCS-2-INTERNAL",
  "UCS-2-SWAPPED",
  "UCS-2BE",
  "UCS-2LE",
  "UCS-4",
  "UCS-4-INTERNAL",
  "UCS-4-SWAPPED",
  "UCS-4BE",
  "UCS-4LE",
  "UHC",
  "UNICODE-1-1",
  "UNICODE-1-1-UTF-7",
  "UNICODEBIG",
  "UNICODELITTLE",
  "US",
  "US-ASCII",
  "UTF-16",
  "UTF-16BE",
  "UTF-16LE",
  "UTF-32",
  "UTF-32BE",
  "UTF-32LE",
  "UTF-7",
  "UTF-8",
  "VISCII",
  "VISCII1.1-1",
  "WINBALTRIM",
  "WINDOWS-1250",
  "WINDOWS-1251",
  "WINDOWS-1252",
  "WINDOWS-1253",
  "WINDOWS-1254",
  "WINDOWS-1255",
  "WINDOWS-1256",
  "WINDOWS-1257",
  "WINDOWS-1258",
  "WINDOWS-874",
  "X0201",
  "X0208",
  "X0212",
};
#endif

std::vector<std::string> const g_popular_character_sets{
  "ISO-8859-15",
  "MS-ANSI",
  "US-ASCII",
  "UTF-8",
  "WINDOWS-1250",
  "WINDOWS-1252",
};

std::vector<cctld_t> const g_cctlds = {
  { "ac", "Ascension Island"                             },
  { "ad", "Andorra"                                      },
  { "ae", "United Arab Emirates"                         },
  { "af", "Afghanistan"                                  },
  { "ag", "Antigua and Barbuda"                          },
  { "ai", "Anguilla"                                     },
  { "al", "Albania"                                      },
  { "am", "Armenia"                                      },
  { "an", "Netherlands Antilles"                         },
  { "ao", "Angola"                                       },
  { "aq", "Antarctica"                                   },
  { "ar", "Argentina"                                    },
  { "as", "American Samoa"                               },
  { "at", "Austria"                                      },
  { "au", "Australia"                                    },
  { "aw", "Aruba"                                        },
  { "ax", "Åland Islands"                                },
  { "az", "Azerbaijan"                                   },
  { "ba", "Bosnia and Herzegovina"                       },
  { "bb", "Barbados"                                     },
  { "bd", "Bangladesh"                                   },
  { "be", "Belgium"                                      },
  { "bf", "Burkina Faso"                                 },
  { "bg", "Bulgaria"                                     },
  { "bh", "Bahrain"                                      },
  { "bi", "Burundi"                                      },
  { "bj", "Benin"                                        },
  { "bm", "Bermuda"                                      },
  { "bn", "Brunei"                                       },
  { "bo", "Bolivia"                                      },
  { "bq", "Bonaire"                                      },
  { "br", "Brazil"                                       },
  { "bs", "Bahamas"                                      },
  { "bt", "Bhutan"                                       },
  { "bv", "Bouvet Island"                                },
  { "bw", "Botswana"                                     },
  { "by", "Belarus"                                      },
  { "bz", "Belize"                                       },
  { "ca", "Canada"                                       },
  { "cc", "Cocos Islands"                                },
  { "cd", "Congo, Democratic Republic of the Congo"      },
  { "cf", "Central African Republic"                     },
  { "cg", "Congo, Republic of the Congo"                 },
  { "ch", "Switzerland"                                  },
  { "ci", "Côte d'Ivoire"                                },
  { "ck", "Cook Islands"                                 },
  { "cl", "Chile"                                        },
  { "cm", "Cameroon"                                     },
  { "cn", "China, People's Republic of China"            },
  { "co", "Colombia"                                     },
  { "cr", "Costa Rica"                                   },
  { "cu", "Cuba"                                         },
  { "cv", "Cape Verde"                                   },
  { "cw", "Curaçao"                                      },
  { "cx", "Christmas Island"                             },
  { "cy", "Cyprus"                                       },
  { "cz", "Czech Republic"                               },
  { "de", "Germany"                                      },
  { "dj", "Djibouti"                                     },
  { "dk", "Denmark"                                      },
  { "dm", "Dominica"                                     },
  { "do", "Dominican Republic"                           },
  { "dz", "Algeria Dzayer"                               },
  { "ec", "Ecuador"                                      },
  { "ee", "Estonia"                                      },
  { "eg", "Egypt"                                        },
  { "eh", "Western Sahara"                               },
  { "er", "Eritrea"                                      },
  { "es", "Spain"                                        },
  { "et", "Ethiopia"                                     },
  { "eu", "European Union"                               },
  { "fi", "Finland"                                      },
  { "fj", "Fiji"                                         },
  { "fk", "Falkland Islands"                             },
  { "fm", "Micronesia, Federated States of Micronesia"   },
  { "fo", "Faroe Islands"                                },
  { "fr", "France"                                       },
  { "ga", "Gabon"                                        },
  { "gd", "Grenada"                                      },
  { "ge", "Georgia"                                      },
  { "gf", "French Guiana"                                },
  { "gg", "Guernsey"                                     },
  { "gh", "Ghana"                                        },
  { "gi", "Gibraltar"                                    },
  { "gl", "Greenland"                                    },
  { "gm", "Gambia"                                       },
  { "gn", "Guinea"                                       },
  { "gp", "Guadeloupe"                                   },
  { "gq", "Equatorial Guinea"                            },
  { "gr", "Greece"                                       },
  { "gs", "South Georgia and the South Sandwich Islands" },
  { "gt", "Guatemala"                                    },
  { "gu", "Guam"                                         },
  { "gw", "Guinea-Bissau"                                },
  { "gy", "Guyana"                                       },
  { "hk", "Hong Kong"                                    },
  { "hm", "Heard Island and McDonald Islands"            },
  { "hn", "Honduras"                                     },
  { "hr", "Croatia"                                      },
  { "ht", "Haiti"                                        },
  { "hu", "Hungary"                                      },
  { "id", "Indonesia"                                    },
  { "ie", "Ireland"                                      },
  { "il", "Israel"                                       },
  { "im", "Isle of Man"                                  },
  { "in", "India"                                        },
  { "io", "British Indian Ocean Territory"               },
  { "iq", "Iraq"                                         },
  { "ir", "Iran"                                         },
  { "is", "Iceland"                                      },
  { "it", "Italy"                                        },
  { "je", "Jersey"                                       },
  { "jm", "Jamaica"                                      },
  { "jo", "Jordan"                                       },
  { "jp", "Japan"                                        },
  { "ke", "Kenya"                                        },
  { "kg", "Kyrgyzstan"                                   },
  { "kh", "Cambodia"                                     },
  { "ki", "Kiribati"                                     },
  { "km", "Comoros"                                      },
  { "kn", "Saint Kitts and Nevis"                        },
  { "kp", "Korea, Democratic People's Republic of Korea" },
  { "kr", "Korea, Republic of Korea"                     },
  { "kw", "Kuwait"                                       },
  { "ky", "Cayman Islands"                               },
  { "kz", "Kazakhstan"                                   },
  { "la", "Laos"                                         },
  { "lb", "Lebanon"                                      },
  { "lc", "Saint Lucia"                                  },
  { "li", "Liechtenstein"                                },
  { "lk", "Sri Lanka"                                    },
  { "lr", "Liberia Partial[21]"                          },
  { "ls", "Lesotho"                                      },
  { "lt", "Lithuania"                                    },
  { "lu", "Luxembourg"                                   },
  { "lv", "Latvia"                                       },
  { "ly", "Libya"                                        },
  { "ma", "Morocco"                                      },
  { "mc", "Monaco"                                       },
  { "md", "Moldova"                                      },
  { "me", "Montenegro"                                   },
  { "mg", "Madagascar"                                   },
  { "mh", "Marshall Islands"                             },
  { "mk", "Macedonia"                                    },
  { "ml", "Mali"                                         },
  { "mm", "Myanmar"                                      },
  { "mn", "Mongolia"                                     },
  { "mo", "Macau"                                        },
  { "mp", "Northern Mariana Islands"                     },
  { "mq", "Martinique"                                   },
  { "mr", "Mauritania"                                   },
  { "ms", "Montserrat"                                   },
  { "mt", "Malta"                                        },
  { "mu", "Mauritius"                                    },
  { "mv", "Maldives"                                     },
  { "mw", "Malawi"                                       },
  { "mx", "Mexico"                                       },
  { "my", "Malaysia"                                     },
  { "mz", "Mozambique"                                   },
  { "na", "Namibia"                                      },
  { "nc", "New Caledonia"                                },
  { "ne", "Niger"                                        },
  { "nf", "Norfolk Island"                               },
  { "ng", "Nigeria"                                      },
  { "ni", "Nicaragua"                                    },
  { "nl", "Netherlands"                                  },
  { "no", "Norway"                                       },
  { "np", "Nepal"                                        },
  { "nr", "Nauru"                                        },
  { "nu", "Niue"                                         },
  { "nz", "New Zealand"                                  },
  { "om", "Oman"                                         },
  { "pa", "Panama"                                       },
  { "pe", "Peru"                                         },
  { "pf", "French Polynesia"                             },
  { "pg", "Papua New Guinea"                             },
  { "ph", "Philippines"                                  },
  { "pk", "Pakistan"                                     },
  { "pl", "Poland"                                       },
  { "pm", "Saint-Pierre and Miquelon"                    },
  { "pn", "Pitcairn Islands"                             },
  { "pr", "Puerto Rico"                                  },
  { "ps", "Palestine"                                    },
  { "pt", "Portugal"                                     },
  { "pw", "Palau"                                        },
  { "py", "Paraguay"                                     },
  { "qa", "Qatar"                                        },
  { "re", "Réunion"                                      },
  { "ro", "Romania"                                      },
  { "rs", "Serbia"                                       },
  { "ru", "Russia"                                       },
  { "rw", "Rwanda"                                       },
  { "sa", "Saudi Arabia"                                 },
  { "sb", "Solomon Islands"                              },
  { "sc", "Seychelles"                                   },
  { "sd", "Sudan"                                        },
  { "se", "Sweden"                                       },
  { "sg", "Singapore"                                    },
  { "sh", "Saint Helena"                                 },
  { "si", "Slovenia"                                     },
  { "sj", "Svalbard and Jan Mayen Islands"               },
  { "sk", "Slovakia"                                     },
  { "sl", "Sierra Leone"                                 },
  { "sm", "San Marino"                                   },
  { "sn", "Senegal"                                      },
  { "so", "Somalia"                                      },
  { "sr", "Suriname"                                     },
  { "ss", "South Sudan"                                  },
  { "st", "São Tomé and Príncipe"                        },
  { "su", "Soviet Union"                                 },
  { "sv", "El Salvador"                                  },
  { "sx", "Sint Maarten"                                 },
  { "sy", "Syria"                                        },
  { "sz", "Swaziland"                                    },
  { "tc", "Turks and Caicos Islands"                     },
  { "td", "Chad"                                         },
  { "tf", "French Southern and Antarctic Lands"          },
  { "tg", "Togo"                                         },
  { "th", "Thailand"                                     },
  { "tj", "Tajikistan"                                   },
  { "tk", "Tokelau"                                      },
  { "tl", "East Timor"                                   },
  { "tm", "Turkmenistan"                                 },
  { "tn", "Tunisia"                                      },
  { "to", "Tonga"                                        },
  { "tr", "Turkey"                                       },
  { "tt", "Trinidad and Tobago"                          },
  { "tv", "Tuvalu"                                       },
  { "tw", "Taiwan"                                       },
  { "tz", "Tanzania"                                     },
  { "ua", "Ukraine"                                      },
  { "ug", "Uganda"                                       },
  { "uk", "United Kingdom"                               },
  { "us", "United States of America"                     },
  { "uy", "Uruguay 2"                                    },
  { "uz", "Uzbekistan"                                   },
  { "va", "Vatican City"                                 },
  { "vc", "Saint Vincent and the Grenadines"             },
  { "ve", "Venezuela"                                    },
  { "vg", "British Virgin Islands"                       },
  { "vi", "United States Virgin Islands"                 },
  { "vn", "Vietnam"                                      },
  { "vu", "Vanuatu"                                      },
  { "wf", "Wallis and Futuna"                            },
  { "ws", "Samoa"                                        },
  { "ye", "Yemen"                                        },
  { "yt", "Mayotte"                                      },
  { "za", "South Africa"                                 },
  { "zm", "Zambia"                                       },
  { "zw", "Zimbabwe"                                     },
};

std::vector<std::string> const g_popular_country_codes{ "cn", "de", "es", "fi", "fr", "it", "jp", "nl", "no", "pt", "ru", "se", "uk", "us" };

static std::map<std::string, std::string> const s_deprecated_cctlds{
  { "gb", "uk" },
  { "tp", "tl" },
};

boost::optional<std::string>
map_to_cctld(std::string const &s) {
  auto deprecated = brng::find_if(s_deprecated_cctlds, [&s](std::pair<std::string, std::string> const &entry) { return entry.first == s; });
  if (deprecated != s_deprecated_cctlds.end())
    return deprecated->second;

  auto current = brng::find_if(g_cctlds, [&s](cctld_t const &entry) { return entry.code == s; });
  if (current != g_cctlds.end())
    return s;

  return boost::none;
}
