string filename;

array inds=({});
array funs=({});
array typs=({});

int ah_level=0;
string ah_string="";

string parse_syntax(string s)
{
   string res="",t,u;
   while (sscanf(s,"%sstruct %[a-z_0-9A-Z]%s",t,u,s)==3)
      res+=t+"<a href=reference.html#struct_"+u+">struct "+u+"</a>";
   return replace(res+s,
		  ({"mird_key_t","mird_size_t","MIRD_RES"}),
		  ({"<a href=reference.html#mird_key_t>mird_key_t</a>",
		    "<a href=reference.html#mird_size_t>mird_size_t</a>",
		    "<a href=reference.html#MIRD_RES>MIRD_RES</a>",
		  }));
}

string tag_func(object o,mapping args,string data)
{
   funs+=({({args->name,args->desc})});
   inds+=({args->name});

   return 
      "<a name=\""+args->name+"\"><h3>"+args->name+" - "+args->desc+
      "</h3>"+
      "<pre>"+parse_syntax(args->syntax)+"</pre>"+
      data+
      "</a>";
//       "<hr noshade>";
}

string tag_mird_type(object o,mapping args,string data)
{
   typs+=({({args->name,args->desc})});
   inds+=({args->name});

   return 
      "<a name=\""+replace(args->name," ","_")+"\"><h3>"+
      args->name+" - "+args->desc+
      "</h3>"+
      data+
      "</a>";
//       "<hr noshade>";
}

string tag_ref(object o,mapping args,string data)
{
   if (!args->to) args->to=data;
   return "<tt><a href=\"reference.html#"+
      replace(args->to," ","_")+"\">"+data+"</a></tt>";
}

string tag_err(object o,mapping args,string data)
{
   if (!args->ref) args->ref=data;
   return "<tt><a href=\"reference.html#"+args->ref+"\">"+data+"</a></tt>";
}

string tag_error(object o,mapping args,string data)
{
   inds+=({args->name});

   return 
      "<a name="+args->name+">"+
      "<b><tt>"+args->name+"</tt></b> - <i>"+data+"</i></a><br>";
}

string tag_ah(object o,mapping args,string data)
{
   int i;
   string name=replace(`-(data,@("-.,?;!\n\t"/"")," "*8)," ","_");
   sscanf(o->tag()[0],"ah%d",i);
   while (i>ah_level) ah_string+="<ul>\n",ah_level++;
   while (i<ah_level) ah_string+="</ul>\n",ah_level--;
   ah_string+="<li><a href="+filename+"#"+name+">"+data+"</a>\n";
   return "<a name="+name+"><h"+i+">"+data+"</h"+i+">";
}

int main(int ac,array am)
{
   if (ac<2) error("USAGE: mkhtml <file>\n");
   
   filename=am[1];
   if (filename[strlen(filename)-3..]==".in")
      filename=filename[..strlen(filename)-4];
   string s=Stdio.read_bytes(filename+".in");
   if (!s) error("failed to read %O\n",filename+".in");
   
   object p=Parser.HTML();
   p->add_container("func",tag_func);
   p->add_container("mird_type",tag_mird_type);
   p->add_container("ref",tag_ref);
   p->add_container("err",tag_err);
   p->add_container("error",tag_error);

   p->add_container("ah2",tag_ah);
   p->add_container("ah3",tag_ah);
   s=p->finish(s)->read();

   p=Parser.HTML();
   p->add_tag(
      "functions",
      map(funs,
	  lambda(array a)
	  {
	     return "<li><a href=\"reference.html#"+a[0]+"\"><tt>"+
		a[0]+"</tt> - "+a[1]+"</a>\n";
	  })*"");
   p->add_tag(
      "datatypes",
      map(typs,
	  lambda(array a)
	  {
	     return "<li><a href=\"reference.html#"+
		replace(a[0]," ","_")+"\"><tt>"+
		a[0]+"</tt> - "+a[1]+"</a>\n";
	  })*"");
   sort(map(inds,lower_case),inds);
   p->add_tag(
      "index",
      "<ul>"+
      map(inds,
	  lambda(string s)
	  {
	     return "<li><a href=\"reference.html#"+
		replace(s," ","_")+"\"><tt>"+
		s+"</tt></a>\n";
	  })*""+"<ul>");
   ah_string+="</ul>"*ah_level;

   p->add_tag("contents",ah_string);
      
   s=p->finish(s)->read();

   write(s);
   return 0;
}
