/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 1997-2000 by the German Cancer Research Center (Deutsches
 *   Krebsforschungszentrum, DKFZ Heidelberg) and Bastien Chevreux
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */


#ifndef lint
static char vcid[] = "$Id$";
#endif /* lint */


#include <mira/multitag.H>
#include <mira/read.H>
#include <mira/contig.H>

StringContainer<uint8> multitag_t::MT_sc_mttagsource("multitags tagsource");
StringContainer<uint16> multitag_t::MT_sc_mtidentifier("multitags identifier");
StringContainer<uint32> multitag_t::MT_sc_mtcomment("multitags comment");


// multitag_t::newIdentifier() and newComment() below will need initialised
//  static entries in the multitag class. Therefore, make sure we initialised
//   that before using newIdentifier() or newComment()

const multitag_t::mte_src_t multitag_t::MT_tagsrcentry_idEmpty=multitag_t::newSource("");
const multitag_t::mte_src_t multitag_t::MT_tagsrcentry_idMIRA=multitag_t::newSource("MIRA");
const multitag_t::mte_src_t multitag_t::MT_tagsrcentry_idGenBank=multitag_t::newSource("GenBank");
const multitag_t::mte_src_t multitag_t::MT_tagsrcentry_idGFF3=multitag_t::newSource("GFF3");


// simplest way to avoid the static initialisation fiasco:
//  define class variables which use this here.

const multitag_t::mte_id_t Contig::CON_tagentry_idEmpty=multitag_t::newIdentifier("");
const multitag_t::mte_id_t Contig::CON_tagentry_idALUS=multitag_t::newIdentifier("ALUS");
const multitag_t::mte_id_t Contig::CON_tagentry_idREPT=multitag_t::newIdentifier("REPT");
const multitag_t::mte_id_t Contig::CON_tagentry_idSRMc=multitag_t::newIdentifier("SRMc");
const multitag_t::mte_id_t Contig::CON_tagentry_idWRMc=multitag_t::newIdentifier("WRMc");
const multitag_t::mte_id_t Contig::CON_tagentry_idSAOc=multitag_t::newIdentifier("SAOc");
const multitag_t::mte_id_t Contig::CON_tagentry_idSROc=multitag_t::newIdentifier("SROc");
const multitag_t::mte_id_t Contig::CON_tagentry_idSIOc=multitag_t::newIdentifier("SIOc");
const multitag_t::mte_id_t Contig::CON_tagentry_idFpAS=multitag_t::newIdentifier("FpAS");
const multitag_t::mte_id_t Contig::CON_tagentry_idPSHP=multitag_t::newIdentifier("PSHP");
const multitag_t::mte_id_t Contig::CON_tagentry_idED_D=multitag_t::newIdentifier("ED_D");
const multitag_t::mte_id_t Contig::CON_tagentry_idED_C=multitag_t::newIdentifier("ED_C");
const multitag_t::mte_id_t Contig::CON_tagentry_idED_I=multitag_t::newIdentifier("ED_I");

const multitag_t::mte_id_t Contig::CON_tagentry_idESDN=multitag_t::newIdentifier("ESDN");

const multitag_t::mte_id_t Contig::CON_tagentry_idSTMS=multitag_t::newIdentifier("STMS");
const multitag_t::mte_id_t Contig::CON_tagentry_idSTMU=multitag_t::newIdentifier("STMU");
const multitag_t::mte_id_t Contig::CON_tagentry_idUNSc=multitag_t::newIdentifier("UNSc");   // UNSure, contig

const multitag_t::mte_id_t Contig::CON_tagentry_idIUPc=multitag_t::newIdentifier("IUPc");   // IUPAC in consensus

const multitag_t::mte_id_t Contig::CON_tagentry_idMCVc=multitag_t::newIdentifier("MCVc");   // missing coverage in consensus
const multitag_t::mte_id_t Contig::CON_tagentry_idDGPc=multitag_t::newIdentifier("DGPc");   // Dubious Gap Position

const multitag_t::mte_co_t Contig::CON_tagentry_coEmpty=multitag_t::newComment("");



const multitag_t::mte_id_t Read::REA_tagentry_idEmpty=multitag_t::newIdentifier("");

const multitag_t::mte_id_t Read::REA_tagentry_idMINF=multitag_t::newIdentifier("MINF");

const multitag_t::mte_id_t Read::REA_tagentry_idSRMr=multitag_t::newIdentifier("SRMr");
const multitag_t::mte_id_t Read::REA_tagentry_idCRMr=multitag_t::newIdentifier("CRMr");
const multitag_t::mte_id_t Read::REA_tagentry_idWRMr=multitag_t::newIdentifier("WRMr");
const multitag_t::mte_id_t Read::REA_tagentry_idSAOr=multitag_t::newIdentifier("SAOr"); //  SNP intrA Organism in Read
const multitag_t::mte_id_t Read::REA_tagentry_idSROr=multitag_t::newIdentifier("SROr"); //  SNP inteR Organism in Read
const multitag_t::mte_id_t Read::REA_tagentry_idSIOr=multitag_t::newIdentifier("SIOr"); //  SNP Intra- and inter Organism in Read
const multitag_t::mte_id_t Read::REA_tagentry_idED_D=multitag_t::newIdentifier("ED_D");
const multitag_t::mte_id_t Read::REA_tagentry_idED_C=multitag_t::newIdentifier("ED_C");
const multitag_t::mte_id_t Read::REA_tagentry_idED_I=multitag_t::newIdentifier("ED_I");

const multitag_t::mte_id_t Read::REA_tagentry_idESDN=multitag_t::newIdentifier("ESDN");

const multitag_t::mte_id_t Read::REA_tagentry_idPSHP=multitag_t::newIdentifier("PSHP");
const multitag_t::mte_id_t Read::REA_tagentry_idUNSr=multitag_t::newIdentifier("UNSr");
const multitag_t::mte_id_t Read::REA_tagentry_idMNRr=multitag_t::newIdentifier("MNRr");      // Masked Nasty Repeat
const multitag_t::mte_id_t Read::REA_tagentry_idCJSP=multitag_t::newIdentifier("CJSP"); // Contig Join Spoiler
const multitag_t::mte_id_t Read::REA_tagentry_idHAF0=multitag_t::newIdentifier("HAF0");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF1=multitag_t::newIdentifier("HAF1");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF2=multitag_t::newIdentifier("HAF2");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF3=multitag_t::newIdentifier("HAF3");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF4=multitag_t::newIdentifier("HAF4");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF5=multitag_t::newIdentifier("HAF5");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF6=multitag_t::newIdentifier("HAF6");
const multitag_t::mte_id_t Read::REA_tagentry_idHAF7=multitag_t::newIdentifier("HAF7");

const multitag_t::mte_id_t Read::REA_tagentry_idMFSM=multitag_t::newIdentifier("MFSM");  // MIRA Force Short-Read Merge


const multitag_t::mte_id_t Read::REA_tagentry_idALUS=multitag_t::newIdentifier("ALUS");
const multitag_t::mte_id_t Read::REA_tagentry_idREPT=multitag_t::newIdentifier("REPT");
const multitag_t::mte_id_t Read::REA_tagentry_idSVEC=multitag_t::newIdentifier("SVEC");

const multitag_t::mte_id_t Read::REA_tagentry_idFsrc=multitag_t::newIdentifier("Fsrc");
const multitag_t::mte_id_t Read::REA_tagentry_idFgen=multitag_t::newIdentifier("Fgen");
const multitag_t::mte_id_t Read::REA_tagentry_idFCDS=multitag_t::newIdentifier("FCDS");
const multitag_t::mte_id_t Read::REA_tagentry_idFexn=multitag_t::newIdentifier("Fexn");
const multitag_t::mte_id_t Read::REA_tagentry_idFint=multitag_t::newIdentifier("Fint");
const multitag_t::mte_id_t Read::REA_tagentry_idFpAS=multitag_t::newIdentifier("FpAS");

const multitag_t::mte_id_t Read::REA_tagentry_idFmRN=multitag_t::newIdentifier("FmRN");
const multitag_t::mte_id_t Read::REA_tagentry_idFm_R=multitag_t::newIdentifier("Fm-R");
const multitag_t::mte_id_t Read::REA_tagentry_idFpRN=multitag_t::newIdentifier("FpRN");
const multitag_t::mte_id_t Read::REA_tagentry_idFrRN=multitag_t::newIdentifier("FrRN");
const multitag_t::mte_id_t Read::REA_tagentry_idFscR=multitag_t::newIdentifier("FscR");
const multitag_t::mte_id_t Read::REA_tagentry_idFsnR=multitag_t::newIdentifier("FsnR");
const multitag_t::mte_id_t Read::REA_tagentry_idFtRN=multitag_t::newIdentifier("FtRN");



const multitag_t::mte_co_t Read::REA_tagentry_coEmpty=multitag_t::newComment("");
const multitag_t::mte_co_t Read::REA_tagentry_coUnknown=multitag_t::newComment("UNKNOWN??? Please contact author.");
const multitag_t::mte_co_t Read::REA_tagentry_coSRMr=multitag_t::newComment("Strong Repeat Marker base found by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coCRMr=multitag_t::newComment("Carbon-copy Repeat Marker base found by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coWRMr=multitag_t::newComment("Weak Repeat Marker base found by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coSAOr=multitag_t::newComment("SNP intrA Organism found by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coSROr=multitag_t::newComment("SNP inteR Organism found by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coSIOr=multitag_t::newComment("SNP Intra- and inter Organism found by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coFpAS=multitag_t::newComment("Poly-A signal set by MIRA");
const multitag_t::mte_co_t Read::REA_tagentry_coPSHP=multitag_t::newComment("Pyrosequencing Suspicious HomoPolymer (found by MIRA)");
const multitag_t::mte_co_t Read::REA_tagentry_coUNSr=multitag_t::newComment("Unsure, read");
