/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */


// 	$Id$	


#ifndef _mira_structs_h_
#define _mira_structs_h_

#include <string>

//#include "stdinc/stlincludes.H"
#include "stdinc/types.H"
#include "enums.H"

using namespace std;


// ----------------- For parametrisation

struct special_parameters
{
  uint32 sp_est_startstep;

  bool mi_stop_on_nfs;
  bool mi_extended_log;

  uint32 mi_as_largecontigsize;
  uint32 mi_as_largecontigsize4stats;

  uint32 mi_stop_readnamelength;
};

struct assembly_parameters
{
//  uint32 as_pattern_length;     // Length of the pattern to use for matching
//  uint32 as_num_end_errors;      // # of errors allowed when matching ends
//  uint32 as_num_middle_errors;   // # of errors allowed when matching middle parts
//  uint32 as_num_middle_runs;     // # of middle part runs to make. at this time only exactly 1 supported

  uint32 as_numthreads;

  uint64 as_amm_maxprocesssize;
  uint64 as_amm_keeppercentfree;

  uint32 as_cleanup_tmpfiles;  // clean up the temporary files after assembly?

  uint32 as_minimum_readlength;      // min. length of reads to be used in assembly
  uint32 as_minimum_readspercontig;      // min. reads per contig

  //uint32 as_infile_which;          // loadjob
  //uint32 as_infile_backbone_which; // loadjob for backbone
  string as_infile_which;          // SANGER file type
  string as_infile_backbone_which; // backbone file type


  uint32 as_backbone_raillength;   // raillength for backbone
  uint32 as_backbone_railoverlap;   // railoverlap for backbone
  uint32 as_backbone_outlen;       // "rail"length for backbone in output
  int32 as_startbackboneusage_inpass; // in which pass to use backbones first
  base_quality_t  as_backbone_basequals;     // quality for backbone

  bool   as_automemmanagement;

  bool   as_loadbackbone;
  bool   as_backbone_alsobuildnewcontigs;


  bool   as_load_sequencedata;
  bool   as_filecheck_only;
  bool   as_enforce_qualsinreads;
  bool   as_wants_qualityfile;
  bool   as_loadSOLEXA_solexa_scores_in_qual_files;
  bool   as_loadstraindata;
  bool   as_assigndefaultstrain;
  bool   as_mergexmltraceinfo;

  bool   as_keepcontigsinmem;
  bool   as_savesimplesingletsinproject;
  bool   as_savetaggedsingletsinproject;

  bool   as_output_html;
  bool   as_output_txt;
  bool   as_output_caf;
  bool   as_output_maf;
  bool   as_output_tcs;
  bool   as_output_ace;
  bool   as_output_gff3;
  bool   as_output_wiggle;
  bool   as_output_fasta;
  bool   as_output_gap4da;
  bool   as_output_tmp_html;
  bool   as_output_tmp_tcs;
  bool   as_output_tmp_txt;
  bool   as_output_tmp_caf;
  bool   as_output_tmp_maf;
  bool   as_output_tmp_ace;
  bool   as_output_tmp_fasta;
  bool   as_output_tmp_gap4da;
  bool   as_output_exttmp_alsosinglets;
  bool   as_output_exttmp_html;
  bool   as_output_exttmp_caf;
  bool   as_output_exttmp_ace;
  bool   as_output_exttmp_fasta;
  bool   as_output_exttmp_gap4da;
  
  bool   as_output_removerollovertmps;
  bool   as_output_removetmpdir;

  bool   as_clip_lowercase;

  bool   as_clip_skimchimeradetection;
  bool   as_clip_skimjunkdetection;

  bool   as_clip_knownadaptorsright;

  bool   as_clip_proposeendclips;
  bool   as_clip_pec_sxaggcxg;
  uint32 as_clip_pec_basesperhash;

  bool   as_clip_badsolexaends;

  bool   as_clip_possible_vectors;
  bool   as_clip_quality;
  bool   as_clip_badstretchquality;
  bool   as_clip_maskedbases;
  bool   as_clip_mergessahavectorscreen;

  bool   as_put_asswithmira_tags;

  base_quality_t as_basedefaultqual;
  base_quality_t as_clip_quality_minqual;
  base_quality_t as_clip_badstretchquality_minqual;
  base_quality_t as_fastq_qualoffset;

  base_quality_t as_clip_quality_minthreshold;
  uint32         as_clip_quality_numminthreshold;

  int32  as_clip_quality_winlen;
  int32  as_clip_badstretchquality_winlen;

  int32  as_clip_vector_maxlenallowed;
  int32  as_clip_maskedbase_gapsize;
  int32  as_clip_maskedbase_maxfrontgap;
  int32  as_clip_maskedbase_maxendgap;
  int32  as_clip_ssahamerge_gapsize;
  int32  as_clip_ssahamerge_maxfrontgap;
  int32  as_clip_ssahamerge_maxendgap;
  int32  as_clip_ssahamerge_strictfrontclip;
  int32  as_clip_ssahamerge_strictendclip;
  int32  as_clip_minslrequired;
  int32  as_clip_minqlsetto;
  int32  as_clip_minsrrequired;
  int32  as_clip_minqrsetto;
  bool   as_clip_ensureminimumleftclipoff;
  bool   as_clip_ensureminimumrightclipoff;

  bool    as_clip_polyat;
  bool    as_clip_polyat_keeppolysignal;
  uint32  as_clip_polyat_len;
  uint32  as_clip_polyat_maxerrors;
  uint32  as_clip_polyat_maxgap;

  bool    as_clip_3ppolybase;
  uint32  as_clip_3ppolybase_len;
  uint32  as_clip_3ppolybase_maxerrors;
  uint32  as_clip_3ppolybase_maxgap;



  uint32 as_external_qual;
  uint32 as_external_qual_override;
  bool   as_discard_read_on_eq_error;

  uint32  as_numpasses;
  uint32  as_maxcontigsperpass;
  uint32  as_numrmbbreakloops;

  bool    as_use_read_extension;
  uint32  as_readextension_window_len;
  uint32  as_readextension_window_maxerrors;
  uint32  as_readextension_firstpassnum;
  uint32  as_readextension_lastpassnum;

  bool   as_mark_repeats;
  bool   as_mark_repeats_onlyinresult;
  bool   as_skimeachpass;

  bool   as_spoilerdetection;
  int32  as_spdetect_lastpassonly;

  bool   as_keep_long_repeats_separated;
  bool   as_automatic_repeat_detection;
  double as_ard_multicopythreshold;
  int32  as_ard_multicopyminlen;
  int32  as_ard_multicopygrace;
  bool   as_uniform_read_distribution;
  int32  as_urd_startinpass;
  double as_urd_cutoffmultiplier;

  char   as_readnaming_scheme;

  bool   as_dateoutput;

  bool as_backbone_strainname_forceforall;

  bool as_buntify_reads;

  string as_projectname_in;
  string as_projectname_out;
  string as_tmpf_unused_ids;
  string as_tmpf_ads;
  string as_tmpf_adsextend;
  string as_tmpf_scfreadfail;
  string as_tmpf_scfreadfatallywrong;
  string as_tmpf_vectorclip;
  string as_tmpf_spoiler;
  string as_tmpf_posmatch;
  string as_tmpf_poolinfo;
  string as_tmpf_normalisedskim;
  string as_tmpf_clippings;

  string as_backbone_strainname;
  string as_default_strainname;
  string as_backbone_rail_fromstrain;

  string as_infile_backbone_MAF;
  string as_infile_backbone_CAF;
  string as_infile_backbone_GBF;
  string as_infile_backbone_GFF3;
  string as_infile_backbone_FASTA;
  string as_infile_backbone_FASTAQUAL;

  string as_infile_FOFNEXP;
  string as_infile_FASTA;
  string as_infile_FASTAQUAL;
  string as_infile_FASTQ;
  string as_infile_CAF;
  string as_infile_MAF;
  string as_infile_FOFNPHD;
  string as_infile_PHD;

  string as_infile_chkptMAF;

//  string as_infile_454GS20FASTA;
//  string as_infile_454GS20FASTAQUAL;
//  string as_infile_454GS20CONSSHREDFASTA;
//  string as_infile_454GS20CONSSHREDFASTAQUAL;
//  string as_infile_454GS20CONSFASTA;
//  string as_infile_454GS20CONSFASTAQUAL;
//  string as_infile_SOLEXAFASTA;
//  string as_infile_SOLEXAFASTAQUAL;
//  string as_infile_SOLIDFASTA;
//  string as_infile_SOLIDFASTAQUAL;
  string as_infile_straindata;
  string as_infile_xmltraceinfo;
  string as_infile_ssahavectorscreen;
  string as_infile_smaltvectorscreen;

  string as_outfile_FASTA;
  string as_outfile_FASTAQUAL;
  string as_outfile_FASTAPADDED;
  string as_outfile_FASTAPADDEDQUAL;
  string as_outfile_CAF;
  string as_outfile_MAF;
  string as_outfile_TCS;
  string as_outfile_ACE;
  string as_outfile_WIGGLE;
  string as_outfile_HTML;
  string as_outfile_TXT;
  string as_outdir_GAP4DA;
  string as_outfile_callparams;

  string as_outfile_stats_reads_invalid;
  string as_outfile_stats_reads_tooshort;
  string as_outfile_stats_contigstats;
  string as_outfile_stats_info;
  string as_outfile_stats_debrislist;
  string as_outfile_stats_crlist;
  string as_outfile_stats_readtags;
  string as_outfile_stats_contigtags;
  string as_outfile_stats_snpanalysis;
  string as_outfile_stats_snpenvironment;
  string as_outfile_stats_featureanalysis;
  string as_outfile_stats_featuresummary;
  string as_outfile_stats_featuresequences;
  //string as_tmp_skimmarknastyrepeats;
  string as_outfile_stats_readrepeats;
};

struct directory_parameters
{
  string dir_exp;
  string dir_scf;
  string dir_fasta;

  string dir_cwd;
  string dir_top;
  string dir_tmp;
  string dir_tmp_redirectedto;
  string dir_results;
  string dir_info;
  string dir_checkpoint;

  string dir_tmp_symlink;
};

struct skim_parameters
{
  uint32 sk_numthreads;
  uint32 sk_basesperhash;
  uint32 sk_hashsavestepping;
  int32  sk_percentrequired;
  uint32 sk_maxhitsperread;
  double sk_maxmegahubratio;

  double sk_freqest_minnormal;
  double sk_freqest_maxnormal;
  double sk_freqest_repeat;
  double sk_freqest_heavyrepeat;
  double sk_freqest_crazyrepeat;
  uint32 sk_nastyrepeatratio;
  uint32 sk_repeatlevel_in_infofile;
  bool   sk_masknastyrepeats;
  bool   sk_alsoskimrevcomp;

  bool   sk_swcheckonbackbones;

  //uint32 sk_maxhashesinmem;
  uint32 sk_maxhashesinmem;
  uint32 sk_memcaphitreduction;
};


struct align_parameters
{
  uint32 al_max_cutoff;	        /* failsafe. if too many solutions exist,
				   stop calculations here */

  // The following values will all need to be reached if a solution 
  //  has to be regarded as valid.
  int32 al_min_score;	        /* Minimum score for two aligned sequences
				   to be accepted as valid solution */
  int32 al_min_relscore;	/* Percentage minimum of the score of two
				   alignments to have to be recognised as
				   valid solution */
  int32 al_min_overlap;     // minimum overlap of two alignments in bases

  int32  al_kmin;           // minimum number of errors in banded Smith-Waterman
  int32  al_kmax;           // maximum ...
  int32  al_kpercent;       /* k errors deduced by the length of expected overlap in %
			       10% and 150 ovelap -> k= 15 */

  
  bool   ads_enforce_clean_ends; /* when true, ads will tolerate no ACGT/ACGT
				    mismatch within distance of ends of
				    overlap */
  int32  ads_clean_end_distance; // distance for above


  bool   ads_extra_gap_penalty;   // in ADS, use extra penalty function for long gaps? 
  uint32 ads_gp_level;  // gap penalty level;
  uint32 ads_max_gppercent;  // Max. gap penalty in percent
  vector<uint32> ads_gp_function;  // gap penalty level;

  uint32 al_solexahack_maxerrors; /* hack (not used at the moment by align object
				     but by assembly: maximum errors an alignment
				     of Solexa sequences may have */

//  bool   ads_extra_mismatch_penalty;
//  uint32 ads_emp_windowlen;
//  uint32 ads_emp_maxmismatches;
};

struct dynamic_parameters
{
  int32 dyn_score_multiplier;   /* by which factor the score differs from a normal 
				   +1/-1/-2 matrix */
				   

  int32 dyn_score_match;		// Scores for a match
  int32 dyn_score_mismatch;      //   "  a mismatch
  int32 dyn_score_halfmatch;	 // Scores for a half match (e.g. M-A or M-V)
  int32 dyn_score_halfmismatch;  //   "  a half mismatch (e.g. M-D)
  int32 dyn_score_nmatch;        //   "  a match with N
  int32 dyn_score_npenaltymatch; //   "  a match with N (light penalty)
  int32 dyn_score_gap;           //   "  gap penalty
  int32 dyn_score_oldgap;        //   "  gap penalty
  int32 dyn_score_oldgapmatch;   //   "  gap penalty, but base "below" gap match
  int32 dyn_score_ltermgap;      //   "  left terminal gap penalties
  int32 dyn_score_rtermgap;      //   "  right terminal gap penalties
  int32 dyn_score_termgap;      //   "  (min from lterm and rterm)
};


struct pathfinder_parameters
{
  bool paf_use_genomic_algorithms;

  bool paf_use_template_information;
  bool paf_use_emergency_blacklist;
  bool paf_use_emergency_search_stop;
  bool paf_use_max_contig_buildtime;

  bool   paf_use_quick_rule;
  int8   paf_quickrule_minsim1;
  int8   paf_quickrule_minsim2;
  int32  paf_quickrule_minlen1;
  int32  paf_quickrule_minlen2;

  uint32 paf_bbquickoverlap_minlen;

  uint32 paf_minreadstocachebuildstart;

  int32 paf_max_contig_buildtime;
  int32 paf_ess_depth;

  long int paf_max_startcache_filltime;

  int16 paf_skipwholecontigscan;
  
  clock_t paf_maxcontigclockticks;
  clock_t paf_nextread_maxcttoess;
};

struct contig_parameters
{
  string con_nameprefix;
  int32 con_reject_on_drop_in_relscore;
  int32 con_danger_analyse_mode;        // analysejob
  int32 con_danger_max_error_rate;      /* reject when more than x% bases
					   from danger zones in read to add
					   don't match
					   the actual consensus */
  bool  con_danger_analyse_Ns;          // true when N also have to be analysed
//  int32 con_rmb_numzone_trigger;       /* how many rmb zones are needed to
//					   be sure that it's really a rmb */
//  int32 con_min_groupqual_srmbwrmb_change;
  base_quality_t con_minrmbneighbourqual;
  base_quality_t con_mingroupqualforrmbtagging;
  int32 con_minreadspergroup;
  int32 con_use_template_information;
  int32 con_endreadmarkexclusionarea;
  bool  con_emea_setzero_on_clipping_pec;
  int32 con_insertsize_minimum;
  int32 con_insertsize_maximum;
  int32 con_template_build_direction;

  int32 con_output_html_cpl;            // characters per line for HTML
  int32 con_output_text_cpl;            // characters per line for TEXT
  char  con_output_html_gapfill;            // endgap fill-character for TEXT
  char  con_output_text_gapfill;            // endgap fill-character for TEXT

  uint32 con_gap_override_ratio;

  bool  con_assume_snp_insteadof_rmb;
  bool  con_disregard_spurious_rmb_mismatches;
  bool  con_also_mark_gap_bases;
  bool  con_also_mark_gap_bases_needbothstrands;
  bool  con_also_mark_gap_bases_evenmc;   // even multicolumn
  bool  con_shorttagcomments;

  bool  con_force_nonIUPACconsensus_perseqtype;
  bool  con_force_nonIUPACconsensus_amongseqtypes;

  bool  con_mergeshortreads;
  int32 con_msr_keependsunmapped;
};

struct edit_parameters
{
  bool ed_automatic_contic_editing;
  bool ed_strict_editing_mode;

  uint32 ed_confirmation_threshold;
};


#endif



