/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2009 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 *
 */


// 	$Id$	



#ifndef _maf_parse_h
#define _maf_parse_h


#include <string>

#include "stdinc/stlincludes.H"

#include "mira/read.H"
#include "mira/readpool.H"
#include "mira/contig.H"



class MAFParse
{
  // Variables
private:
  vector<MIRAParameters> *   MAF_miraparams;   // parameters for the contigs

  // Result Variables
  ReadPool*         MAF_readpool;         // where to store the reads
  list<Contig>*     MAF_contiglist;      // 
  void (*MAF_callbackfunc)(list<Contig> &, ReadPool &);


  vector<uint32> MAF_lrperseqtype;  // longest read per seqtype

  bool  MAF_simulateloading;
  bool  MAF_recalcconsensus;

  int32 MAF_vmajor;
  int32 MAF_vminor;

  string MAF_read_name;
  string MAF_read_scf_file;
  string MAF_read_template;
  string MAF_read_base_caller;
  string MAF_read_sequencing_vector;

  string MAF_read_strain;
  string MAF_read_machinetype;

  vector<char>  MAF_read_sequence;
  vector<base_quality_t> MAF_read_qualities;
  vector<int32> MAF_read_align_origin;
  vector<tag_t> MAF_read_taglist;

  int32 MAF_read_len;

  int32 MAF_read_insert_size_min;
  int32 MAF_read_insert_size_max;
  int32 MAF_read_ql;
  int32 MAF_read_qr;
  int32 MAF_read_cl;
  int32 MAF_read_cr;
  int32 MAF_read_sl;
  int32 MAF_read_sr;

  char  MAF_read_strand_given;
  int8  MAF_read_seqtype;

  bool  MAF_read_isbackbone;
  bool  MAF_read_israil;
  bool  MAF_read_isCER;



  list<Contig::contig_init_read_t> MAF_contig_assembledfrom;
  vector<char>  MAF_contig_sequence;
  vector<base_quality_t> MAF_contig_qualities;
  vector<tag_t> MAF_contig_taglist;

  string MAF_contig_name;

  int32  MAF_contig_numreads;
  int32  MAF_contig_len;      // read in from LC
  int32  MAF_contig_rawlen; // deduced from AT lines



  bool   MAF_isinread;
  bool   MAF_isincontig;

  int32  MAF_readpoolid;

private:
  void deescapeString(string & s);

  size_t countReadsBeforeLoad(const string & fileName, size_t & maxlinelen); 


  void cleanupHeaderData();
  void cleanupReadData();
  void cleanupContigData();

  void checkParseIsInRead(string & acttoken);
  void checkParseIsNotInRead(string & acttoken);
  void checkParseIsInContig(string & acttoken);

  void parseLineFV(ifstream & mafin, string & acttoken, string & actline);
  void parseLineAQ(ifstream & mafin, string & acttoken, string & actline);
  void parseLineRS(ifstream & mafin, string & acttoken, string & actline);
  void parseLineRQ(ifstream & mafin, string & acttoken, string & actline);
  void parseLineCS(ifstream & mafin, string & acttoken, string & actline);
  void parseLineCQ(ifstream & mafin, string & acttoken, string & actline);
  void parseLineRD(ifstream & mafin, string & acttoken, string & actline);
  void parseLineLR(ifstream & mafin, string & acttoken, string & actline);
  void parseLineSV(ifstream & mafin, string & acttoken, string & actline);
  void parseLineTN(ifstream & mafin, string & acttoken, string & actline);
  void parseLineDI(ifstream & mafin, string & acttoken, string & actline);
  void parseLineTF(ifstream & mafin, string & acttoken, string & actline);
  void parseLineTT(ifstream & mafin, string & acttoken, string & actline);
  void parseLineSF(ifstream & mafin, string & acttoken, string & actline);
  void parseLineBC(ifstream & mafin, string & acttoken, string & actline);
  void parseLineSL(ifstream & mafin, string & acttoken, string & actline);
  void parseLineSR(ifstream & mafin, string & acttoken, string & actline);
  void parseLineQL(ifstream & mafin, string & acttoken, string & actline);
  void parseLineQR(ifstream & mafin, string & acttoken, string & actline);
  void parseLineCL(ifstream & mafin, string & acttoken, string & actline);
  void parseLineCR(ifstream & mafin, string & acttoken, string & actline);
  void parseLineAO(ifstream & mafin, string & acttoken, string & actline);
  void parseLineRT(ifstream & mafin, string & acttoken, string & actline);
  void parseLineST(ifstream & mafin, string & acttoken, string & actline);
  void parseLineSN(ifstream & mafin, string & acttoken, string & actline);
  void parseLineMT(ifstream & mafin, string & acttoken, string & actline);
  void parseLineIB(ifstream & mafin, string & acttoken, string & actline);
  void parseLineIC(ifstream & mafin, string & acttoken, string & actline);
  void parseLineIR(ifstream & mafin, string & acttoken, string & actline);
  void parseLineAT(ifstream & mafin, string & acttoken, string & actline);
  void parseLineER(ifstream & mafin, string & acttoken, string & actline);
  void parseLineCO(ifstream & mafin, string & acttoken, string & actline);
  void parseLineNR(ifstream & mafin, string & acttoken, string & actline);
  void parseLineLC(ifstream & mafin, string & acttoken, string & actline);
  void parseLineCT(ifstream & mafin, string & acttoken, string & actline);
  void parseLineEC(ifstream & mafin, string & acttoken, string & actline);

  void parseTagData(ifstream & mafin, string & acttoken, tag_t & tag);

  void checkReadData();
  void addReadToReadPool();

public:
  MAFParse(ReadPool &aPool, 
      list<Contig>  &theContigs, 
      vector<MIRAParameters> * mp);
  ~MAFParse();

  size_t load(const string & fileName,
	      const uint8 seqtype,
	      const uint8 loadaction,
	      vector<uint32> & lrperseqtype,
	      bool recalcconsensus = true,
	      void (*callback)(list<Contig> &, ReadPool &) = NULL, // callback after each contig loaded
	      bool isVerbose = false);

  friend ostream &operator<<(ostream &ostr, MAFParse const &i);

};





#endif
