/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#ifndef _NTDSBMSG_
#define _NTDSBMSG_

#define FACILITY_SYSTEM 0x0
#define FACILITY_NTDSB 0x800
#define FACILITY_BACKUP 0x7FF

#define STATUS_SEVERITY_WARNING 0x2
#define STATUS_SEVERITY_SUCCESS 0x0
#define STATUS_SEVERITY_INFORMATIONAL 0x1
#define STATUS_SEVERITY_ERROR 0x3

#define hrNone ((HRESULT)0x00000000L)
#define hrNyi ((HRESULT)0xC0000001L)
#define hrInvalidParam ((HRESULT)0xC7FF0001L)
#define hrError ((HRESULT)0xC7FF0002L)
#define hrInvalidHandle ((HRESULT)0xC7FF0003L)
#define hrRestoreInProgress ((HRESULT)0xC7FF0004L)
#define hrAlreadyOpen ((HRESULT)0xC7FF0005L)
#define hrInvalidRecips ((HRESULT)0xC7FF0006L)
#define hrCouldNotConnect ((HRESULT)0xC7FF0007L)
#define hrRestoreMapExists ((HRESULT)0xC7FF0008L)
#define hrIncrementalBackupDisabled ((HRESULT)0xC7FF0009L)
#define hrLogFileNotFound ((HRESULT)0xC7FF000AL)
#define hrCircularLogging ((HRESULT)0xC7FF000BL)
#define hrNoFullRestore ((HRESULT)0xC7FF000CL)
#define hrCommunicationError ((HRESULT)0xC7FF000DL)
#define hrFullBackupNotTaken ((HRESULT)0xC7FF000EL)
#define hrMissingExpiryToken ((HRESULT)0xC7FF000FL)
#define hrUnknownExpiryTokenFormat ((HRESULT)0xC7FF0010L)
#define hrContentsExpired ((HRESULT)0xC7FF0011L)
#define hrAlreadyListening ((HRESULT)RPC_S_ALREADY_LISTENING)
#define hrFileClose ((HRESULT)0xC8000066L)
#define hrOutOfThreads ((HRESULT)0xC8000067L)
#define hrTooManyIO ((HRESULT)0xC8000069L)
#define hrBFNotSynchronous ((HRESULT)0x880000C8L)
#define hrBFPageNotFound ((HRESULT)0x880000C9L)
#define hrBFInUse ((HRESULT)0xC80000CAL)
#define hrPMRecDeleted ((HRESULT)0xC800012EL)
#define hrRemainingVersions ((HRESULT)0x88000141L)
#define hrFLDKeyTooBig ((HRESULT)0x88000190L)
#define hrFLDTooManySegments ((HRESULT)0xC8000191L)
#define hrFLDNullKey ((HRESULT)0x88000192L)
#define hrLogFileCorrupt ((HRESULT)0xC80001F5L)
#define hrNoBackupDirectory ((HRESULT)0xC80001F7L)
#define hrBackupDirectoryNotEmpty ((HRESULT)0xC80001F8L)
#define hrBackupInProgress ((HRESULT)0xC80001F9L)
#define hrMissingPreviousLogFile ((HRESULT)0xC80001FDL)
#define hrLogWriteFail ((HRESULT)0xC80001FEL)
#define hrBadLogVersion ((HRESULT)0xC8000202L)
#define hrInvalidLogSequence ((HRESULT)0xC8000203L)
#define hrLoggingDisabled ((HRESULT)0xC8000204L)
#define hrLogBufferTooSmall ((HRESULT)0xC8000205L)
#define hrLogSequenceEnd ((HRESULT)0xC8000207L)
#define hrNoBackup ((HRESULT)0xC8000208L)
#define hrInvalidBackupSequence ((HRESULT)0xC8000209L)
#define hrBackupNotAllowedYet ((HRESULT)0xC800020BL)
#define hrDeleteBackupFileFail ((HRESULT)0xC800020CL)
#define hrMakeBackupDirectoryFail ((HRESULT)0xC800020DL)
#define hrInvalidBackup ((HRESULT)0xC800020EL)
#define hrRecoveredWithErrors ((HRESULT)0xC800020FL)
#define hrMissingLogFile ((HRESULT)0xC8000210L)
#define hrLogDiskFull ((HRESULT)0xC8000211L)
#define hrBadLogSignature ((HRESULT)0xC8000212L)
#define hrBadDbSignature ((HRESULT)0xC8000213L)
#define hrBadCheckpointSignature ((HRESULT)0xC8000214L)
#define hrCheckpointCorrupt ((HRESULT)0xC8000215L)
#define hrDatabaseInconsistent ((HRESULT)0xC8000226L)
#define hrConsistentTimeMismatch ((HRESULT)0xC8000227L)
#define hrPatchFileMismatch ((HRESULT)0xC8000228L)
#define hrRestoreLogTooLow ((HRESULT)0xC8000229L)
#define hrRestoreLogTooHigh ((HRESULT)0xC800022AL)
#define hrGivenLogFileHasBadSignature ((HRESULT)0xC800022BL)
#define hrGivenLogFileIsNotContiguous ((HRESULT)0xC800022CL)
#define hrMissingRestoreLogFiles ((HRESULT)0xC800022DL)
#define hrExistingLogFileHasBadSignature ((HRESULT)0x8800022EL)
#define hrExistingLogFileIsNotContiguous ((HRESULT)0x8800022FL)
#define hrMissingFullBackup ((HRESULT)0xC8000230L)
#define hrBadBackupDatabaseSize ((HRESULT)0xC8000231L)
#define hrTermInProgress ((HRESULT)0xC80003E8L)
#define hrFeatureNotAvailable ((HRESULT)0xC80003E9L)
#define hrInvalidName ((HRESULT)0xC80003EAL)
#define hrInvalidParameter ((HRESULT)0xC80003EBL)
#define hrColumnNull ((HRESULT)0x880003ECL)
#define hrBufferTruncated ((HRESULT)0x880003EEL)
#define hrDatabaseAttached ((HRESULT)0x880003EFL)
#define hrInvalidDatabaseId ((HRESULT)0xC80003F2L)
#define hrOutOfMemory ((HRESULT)0xC80003F3L)
#define hrOutOfDatabaseSpace ((HRESULT)0xC80003F4L)
#define hrOutOfCursors ((HRESULT)0xC80003F5L)
#define hrOutOfBuffers ((HRESULT)0xC80003F6L)
#define hrTooManyIndexes ((HRESULT)0xC80003F7L)
#define hrTooManyKeys ((HRESULT)0xC80003F8L)
#define hrRecordDeleted ((HRESULT)0xC80003F9L)
#define hrReadVerifyFailure ((HRESULT)0xC80003FAL)
#define hrOutOfFileHandles ((HRESULT)0xC80003FCL)
#define hrDiskIO ((HRESULT)0xC80003FEL)
#define hrInvalidPath ((HRESULT)0xC80003FFL)
#define hrRecordTooBig ((HRESULT)0xC8000402L)
#define hrTooManyOpenDatabases ((HRESULT)0xC8000403L)
#define hrInvalidDatabase ((HRESULT)0xC8000404L)
#define hrNotInitialized ((HRESULT)0xC8000405L)
#define hrAlreadyInitialized ((HRESULT)0xC8000406L)
#define hrFileAccessDenied ((HRESULT)0xC8000408L)
#define hrBufferTooSmall ((HRESULT)0xC800040EL)
#define hrSeekNotEqual ((HRESULT)0x8800040FL)
#define hrTooManyColumns ((HRESULT)0xC8000410L)
#define hrContainerNotEmpty ((HRESULT)0xC8000413L)
#define hrInvalidFilename ((HRESULT)0xC8000414L)
#define hrInvalidBookmark ((HRESULT)0xC8000415L)
#define hrColumnInUse ((HRESULT)0xC8000416L)
#define hrInvalidBufferSize ((HRESULT)0xC8000417L)
#define hrColumnNotUpdatable ((HRESULT)0xC8000418L)
#define hrIndexInUse ((HRESULT)0xC800041BL)
#define hrNullKeyDisallowed ((HRESULT)0xC800041DL)
#define hrNotInTransaction ((HRESULT)0xC800041EL)
#define hrNoIdleActivity ((HRESULT)0x88000422L)
#define hrTooManyActiveUsers ((HRESULT)0xC8000423L)
#define hrInvalidCountry ((HRESULT)0xC8000425L)
#define hrInvalidLanguageId ((HRESULT)0xC8000426L)
#define hrInvalidCodePage ((HRESULT)0xC8000427L)
#define hrNoWriteLock ((HRESULT)0x8800042BL)
#define hrColumnSetNull ((HRESULT)0x8800042CL)
#define hrVersionStoreOutOfMemory ((HRESULT)0xC800042DL)
#define hrCurrencyStackOutOfMemory ((HRESULT)0xC800042EL)
#define hrOutOfSessions ((HRESULT)0xC800044DL)
#define hrWriteConflict ((HRESULT)0xC800044EL)
#define hrTransTooDeep ((HRESULT)0xC800044FL)
#define hrInvalidSesid ((HRESULT)0xC8000450L)
#define hrSessionWriteConflict ((HRESULT)0xC8000453L)
#define hrInTransaction ((HRESULT)0xC8000454L)
#define hrDatabaseDuplicate ((HRESULT)0xC80004B1L)
#define hrDatabaseInUse ((HRESULT)0xC80004B2L)
#define hrDatabaseNotFound ((HRESULT)0xC80004B3L)
#define hrDatabaseInvalidName ((HRESULT)0xC80004B4L)
#define hrDatabaseInvalidPages ((HRESULT)0xC80004B5L)
#define hrDatabaseCorrupted ((HRESULT)0xC80004B6L)
#define hrDatabaseLocked ((HRESULT)0xC80004B7L)
#define hrTableEmpty ((HRESULT)0x88000515L)
#define hrTableLocked ((HRESULT)0xC8000516L)
#define hrTableDuplicate ((HRESULT)0xC8000517L)
#define hrTableInUse ((HRESULT)0xC8000518L)
#define hrObjectNotFound ((HRESULT)0xC8000519L)
#define hrCannotRename ((HRESULT)0xC800051AL)
#define hrDensityInvalid ((HRESULT)0xC800051BL)
#define hrTableNotEmpty ((HRESULT)0xC800051CL)
#define hrInvalidTableId ((HRESULT)0xC800051EL)
#define hrTooManyOpenTables ((HRESULT)0xC800051FL)
#define hrIllegalOperation ((HRESULT)0xC8000520L)
#define hrObjectDuplicate ((HRESULT)0xC8000522L)
#define hrInvalidObject ((HRESULT)0xC8000524L)
#define hrIndexCantBuild ((HRESULT)0xC8000579L)
#define hrIndexHasPrimary ((HRESULT)0xC800057AL)
#define hrIndexDuplicate ((HRESULT)0xC800057BL)
#define hrIndexNotFound ((HRESULT)0xC800057CL)
#define hrIndexMustStay ((HRESULT)0xC800057DL)
#define hrIndexInvalidDef ((HRESULT)0xC800057EL)
#define hrIndexHasClustered ((HRESULT)0xC8000580L)
#define hrCreateIndexFailed ((HRESULT)0x88000581L)
#define hrTooManyOpenIndexes ((HRESULT)0xC8000582L)
#define hrColumnLong ((HRESULT)0xC80005DDL)
#define hrColumnDoesNotFit ((HRESULT)0xC80005DFL)
#define hrNullInvalid ((HRESULT)0xC80005E0L)
#define hrColumnIndexed ((HRESULT)0xC80005E1L)
#define hrColumnTooBig ((HRESULT)0xC80005E2L)
#define hrColumnNotFound ((HRESULT)0xC80005E3L)
#define hrColumnDuplicate ((HRESULT)0xC80005E4L)
#define hrColumn2ndSysMaint ((HRESULT)0xC80005E6L)
#define hrInvalidColumnType ((HRESULT)0xC80005E7L)
#define hrColumnMaxTruncated ((HRESULT)0x880005E8L)
#define hrColumnCannotIndex ((HRESULT)0xC80005E9L)
#define hrTaggedNotNULL ((HRESULT)0xC80005EAL)
#define hrNoCurrentIndex ((HRESULT)0xC80005EBL)
#define hrKeyIsMade ((HRESULT)0xC80005ECL)
#define hrBadColumnId ((HRESULT)0xC80005EDL)
#define hrBadItagSequence ((HRESULT)0xC80005EEL)
#define hrCannotBeTagged ((HRESULT)0xC80005F1L)
#define hrRecordNotFound ((HRESULT)0xC8000641L)
#define hrNoCurrentRecord ((HRESULT)0xC8000643L)
#define hrRecordClusteredChanged ((HRESULT)0xC8000644L)
#define hrKeyDuplicate ((HRESULT)0xC8000645L)
#define hrAlreadyPrepared ((HRESULT)0xC8000647L)
#define hrKeyNotMade ((HRESULT)0xC8000648L)
#define hrUpdateNotPrepared ((HRESULT)0xC8000649L)
#define hrwrnDataHasChanged ((HRESULT)0x8800064AL)
#define hrerrDataHasChanged ((HRESULT)0xC800064BL)
#define hrKeyChanged ((HRESULT)0x88000652L)
#define hrTooManySorts ((HRESULT)0xC80006A5L)
#define hrInvalidOnSort ((HRESULT)0xC80006A6L)
#define hrTempFileOpenError ((HRESULT)0xC800070BL)
#define hrTooManyAttachedDatabases ((HRESULT)0xC800070DL)
#define hrDiskFull ((HRESULT)0xC8000710L)
#define hrPermissionDenied ((HRESULT)0xC8000711L)
#define hrFileNotFound ((HRESULT)0xC8000713L)
#define hrFileOpenReadOnly ((HRESULT)0x88000715L)
#define hrAfterInitialization ((HRESULT)0xC800073AL)
#define hrLogCorrupted ((HRESULT)0xC800073CL)
#define hrInvalidOperation ((HRESULT)0xC8000772L)
#define hrAccessDenied ((HRESULT)0xC8000773L)

#endif
