/***************************************************************************
    copyright            : (C) 2002-2005 by Stefano Barbato
    email                : stefano@codesink.org

    $Id: message.h,v 1.8 2005/02/23 10:26:15 tat Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _MIMETIC_RFC822_MESSAGE_H_
#define _MIMETIC_RFC822_MESSAGE_H_
#include <string>
#include <iostream>
#include <mimetic/rfc822/header.h>
#include <mimetic/rfc822/body.h>

namespace mimetic 
{

/// Simple RFC 822 message type
struct Message
{
    Message();
    virtual ~Message(){}
    Rfc822Header& header();
    const Rfc822Header& header() const;
    Rfc822Body& body();
    const Rfc822Body& body() const;

    friend std::ostream& operator<<(std::ostream&, const Message&);
private:
    Rfc822Header m_header;
    Rfc822Body m_body;
};

}

#endif
