/*  MikMod example player
	(c) 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

/*==============================================================================

  $Id: mwindow.h,v 1.1.1.1 2003/09/19 13:16:01 raph Exp $

  Some window functions

==============================================================================*/

#ifndef MWINDOW_H
#define MWINDOW_H

typedef struct MWINDOW{
	int x,y,width,height;		/* Inner pos. and size */
	BOOL border;				/* Has window a border? */
	BOOL resize;				/* Window is automatically resized */
	char *title;
	BOOL (*repaint)(struct MWINDOW *win);
	BOOL (*handle_key)(struct MWINDOW *win,int ch);
	void (*handle_resize)(struct MWINDOW *win,int dx,int dy);
	struct MWINDOW *next;

	void *data;					/* not used by window functions */
} MWINDOW;

/* return: 1: continue repaint with other windows
		   0: cancel repaint (if a new repaint was scheduled in the repaint
              func,e.g. by win_change_panel() */
typedef BOOL (*WinRepaintFunc)(MWINDOW*);
/* return: 1: key was handled */
typedef BOOL (*WinKeyFunc)(MWINDOW*,int);
/* dx,dy: amount of window size change */
typedef void (*WinResizeFunc)(MWINDOW*,int,int);

/* init window functions (e.g. init curses) */
void win_init(BOOL);
/* clean up (e.g. exit curses) */
void win_exit(void);

/* open new window on current panel */
MWINDOW* win_open(int,int,int,int,BOOL,char*);
/* open new window on panel 'panel' */
MWINDOW* win_panel_open(int,int,int,int,int,BOOL,char*);
/* set function which should be called on a repaint request */
void win_set_repaint(WinRepaintFunc);
void win_panel_set_repaint(int,WinRepaintFunc);
/* set function which sould be called on a key press */
void win_set_handle_key(WinKeyFunc);
void win_panel_set_handle_key(int,WinKeyFunc);
/* should window be automatically resized?
   should a function be called on resize? */
void win_set_resize(BOOL,WinResizeFunc);
void win_panel_set_resize(int,BOOL,WinResizeFunc);
/* set private data */
void win_set_data(void*);
void win_panel_set_data(int,void*);

/* close uppermost window */
void win_close(void);
/* close window win */
void win_close_win(MWINDOW*);

/* check if a resize was scheduled and do it */
BOOL win_check_resize(void);

/* repaint the whole panel */
void win_panel_repaint(void);

/* init the status line (height=0,1,2  0: no status line) */
void win_init_status(int);
/* set the status line */
void win_status(char*);

/* clear to end of line on uppermost window */
void win_clrtoeol(int,int);
/* clear to end of line on root window */
void win_clrtoeol_root(int,int);
/* clear uppermost window */
void win_clear(void);
/* clear root window */
void win_clear_root(void);

/* get size of uppermost window */
void win_get_size(int*,int*);
/* get size of whole screen */
void win_get_size_root(int*,int*);
/* get maximal size of a new window without a border and therefore the needed
   minimal y position */
void win_get_size_max(int*,int*,int*);
/* get uppermost window */
MWINDOW *win_get_window(void);

/* print string (?_root: on root window) */
void win_print(int,int,char*);
void win_print_root(int,int,char*);

/* draw horizontal line (rev: in reverse) */
void win_line(int,int,int);

/* set attribute for the following output operations */
void win_attrset(int);
void win_cursor_set(BOOL);

/* update window -> call curses.refresh() */
void win_refresh(void);
/* change current panel */
void win_change_panel(int);
/* handle key press (panel change and call of key handler
   of uppermost window), return: was key handled */
BOOL win_handle_key(int);

#endif /* MWINDOW_H */
