#! /bin/sh

# Installs messagewall's startup script
#
# Written by Gauret <aurelienb@netcourrier.com>

# Try to find an available syslog level
for i in 0 1 2 3 4 5 6 7
do
	syslog_test=$(grep local$i /etc/syslog.conf)
	if [ -z "$syslog_test" ]
	then
		# local$i facility is not yet in use
		echo "" >> /etc/syslog.conf
		echo "# Added by MessageWall" >> /etc/syslog.conf
		echo "local$i.*		/var/log/mail/messagewall.log" >> /etc/syslog.conf
		sed s/local1/local$i/g messagewall > messagewall.temp
		break
	fi
done

# install the startup script
cp -f messagewall.temp /etc/init.d/messagewall
rm -f messagewall.temp

ln -s /etc/init.d/messagewall /etc/rc3.d/S80messagewall
ln -s /etc/init.d/messagewall /etc/rc4.d/S80messagewall
ln -s /etc/init.d/messagewall /etc/rc5.d/S80messagewall

# install the logrorate script
cp -f messagewall.logrotate /etc/logrotate.d/

echo "Messagewall installed !"

# End of install.sh
