/*
 * Memo on Gnome panel - memopanel.c 
 * Copyright (C) 2000-2001 Toshiaki Kanosue <toshika@sutv.zaq.ne.jp>
 * http://kano.technolust.cx/memopanel/
 * (:set ts=4 for vim)
 */
#define VERSION  "7.6"

#define ENABLE_NLS
#define GNOMELOCALEDIR "/usr/share/locale"
#define PACKAGE  "memopanel" 
#define URLFILE  "/." PACKAGE
#define EXTFILE  "/." PACKAGE ".ext" 
#define NUMFILE  "/." PACKAGE ".num" 
#define CMDFILE  "/." PACKAGE ".cmd" 
#include <applet-widget.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <netdb.h>			/* included sys/socket.h */
#include <sys/time.h>		/* included sys/select.h */
#include <netinet/in.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glibtop.h>
#include <glibtop/netload.h>
#include <glibtop/close.h>
#define KERNEL_NAME	"/tmp/" PACKAGE ".kernel"
#define AT_EMAIL    "/tmp/" PACKAGE ".email"
#define AT_SOUND    "/tmp/" PACKAGE ".sound"
#define DB_FILE		"/tmp/" PACKAGE ".db" 
#define PGCMD_FILE	"/tmp/" PACKAGE ".pgcmd" 
#define HHL_SH		"/tmp/" PACKAGE ".hhl_sh" 

#define d_sep_h(f,h) h = gtk_hseparator_new(); \
		gtk_box_pack_start(GTK_BOX(f),h,FALSE,FALSE,0); gtk_widget_show(h)

#define d_vbox1(f,h) h = gtk_vbox_new(FALSE, 1); \
		gtk_box_pack_start(GTK_BOX(f),h,FALSE,FALSE,0); gtk_widget_show(h)

#define d_hbox1(f,h) h = gtk_hbox_new(FALSE, 1); \
		gtk_box_pack_start(GTK_BOX(f),h,FALSE,FALSE,0); gtk_widget_show(h)

#define d_label(s) label1 = gtk_label_new(s); \
		gtk_box_pack_start(GTK_BOX(hbox),label1,FALSE,FALSE,0); gtk_widget_show(label1)

#define	d_frame_name(f,s) label = gtk_label_new(s); gtk_widget_show(label); \
		gnome_property_box_append_page(GNOME_PROPERTY_BOX(propbox),f,label)

#define	d_entry(w,str,width) w = gtk_entry_new(); \
		gtk_entry_set_text(GTK_ENTRY(w), str); \
		gtk_signal_connect_object(GTK_OBJECT(w),"changed", \
			GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox)); \
		gtk_box_pack_start(GTK_BOX(hbox),w,FALSE,FALSE,0); \
		gtk_widget_set_usize(w,width,24); gtk_widget_show(w)

#define	d_select(w,str,func) w = gtk_button_new_with_label(str); \
		gtk_box_pack_start(GTK_BOX(hbox),w,FALSE,FALSE,0); \
		gtk_signal_connect(GTK_OBJECT(w),"clicked",GTK_SIGNAL_FUNC(func),NULL); \
		gtk_widget_show(w)

#define	d_button(w,str,proc) w=gtk_button_new_with_label(str); \
		gtk_signal_connect_object(GTK_OBJECT(w),"clicked",GTK_SIGNAL_FUNC(proc),NULL); \
		gtk_box_pack_start(GTK_BOX(hbox),w,FALSE,FALSE,0); gtk_widget_show(w)

#define	d_chk_button(w,str,event1,vari) \
		w=gtk_check_button_new_with_label(str); \
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),vari); \
		gtk_object_set_data(GTK_OBJECT(propbox),event1,w); \
		gtk_signal_connect_object(GTK_OBJECT(w),"toggled", \
			GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox)); \
		gtk_box_pack_start(GTK_BOX(hbox),w,FALSE,FALSE,0); \
		gtk_widget_show(w)

#define	d_go(w,str,func) w = gtk_button_new_with_label(str); \
		gtk_box_pack_start(GTK_BOX(hbox),w,FALSE,FALSE,0); \
		gtk_signal_connect_object(GTK_OBJECT(w),"clicked",GTK_SIGNAL_FUNC(func),NULL); \
		gtk_widget_show(w)

#define	d_pixmap(data) pixmapw = gnome_pixmap_new_from_xpm_d(data); \
		gtk_box_pack_start(GTK_BOX(hbox),pixmapw,FALSE,FALSE,0); \
		gtk_widget_show(pixmapw)

#define d_url1(s1,s2) \
		d_pixmap(netscape); wk = gnome_href_new(s1,s2); \
		gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0); gtk_widget_show(wk)

#define d_url2(s1,s2) d_label("    "); d_url1(s1,s2)

#define d_get_str(s1,s2,s3) \
		g_snprintf(buf,255,"memopanel%d/%s=%s",num_of_memopanel,s2,s3); \
		s1 = gnome_config_get_string(buf)

#define d_get_int(s1,s2,s3) \
		g_snprintf(buf,255,"memopanel%d/%s=%s",num_of_memopanel,s2,s3); \
		s1 = gnome_config_get_int(buf)

#define d_set_str(s1,s2) \
		g_snprintf(buf,255,"memopanel%d/%s",num_of_memopanel,s1); \
		gnome_config_set_string (buf,s2)

#define d_set_int(s1,s2) \
		g_snprintf(buf,255,"memopanel%d/%s",num_of_memopanel,s1); \
		gnome_config_set_int(buf,s2)
		
#define d_get_text(s1,s2) \
		workname2  = gtk_entry_get_text(GTK_ENTRY(s2)); s1 = g_strdup(workname2)

#define d_tips(w1,s1) w_tips=gtk_tooltips_new(); gtk_tooltips_set_tip(w_tips,w1,s1,NULL)

#define d_combo_pop_body(w,l,t,x) \
	gtk_combo_set_popdown_strings(GTK_COMBO(w),l); \
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w)->entry),t); \
	gtk_signal_connect_object(GTK_OBJECT(GTK_COMBO(w)->entry),"changed", \
			GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox)); \
	gtk_box_pack_start(GTK_BOX(hbox),w,FALSE,FALSE,0); \
	gtk_widget_set_usize(w,x,24); gtk_widget_show(w)

#define d_combo_pop(w,l,t,x) w= gtk_combo_new(); d_combo_pop_body(w,l,t,x)

#define d_p_select(str,w,ok) GtkWidget *s; s=gtk_file_selection_new(str); \
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(s)); \
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(s), \
					gtk_entry_get_text(GTK_ENTRY(w))); \
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(s)->ok_button),"clicked", \
					GTK_SIGNAL_FUNC(ok),s); \
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(s)->ok_button), \
					"clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),(gpointer)s); \
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(s)->cancel_button), \
					"clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),(gpointer)s); \
	gtk_widget_show(s)

#include "xpms/netscape.xpm"
#include "xpms/sound.xpm"
#include "xpms/memo.xpm"
#include "xpms/maru.xpm"
#include "xpms/calc.xpm"
#include "xpms/maru_am.xpm"
#include "xpms/maru_aa.xpm"
#include "xpms/maru_km.xpm"
#include "xpms/maru_ka.xpm"
#include "xpms/hinomaru.xpm"
#include "xpms/world.xpm"
#include "xpms/eyes.xpm"
#include "xpms/mail.xpm"
#include "xpms/nomemo.xpm"
GtkWidget *applet, *label, *labelframe, *labelbox, *labelmemo, *w_label_button;
GtkWidget *w_calc_button;
GtkWidget *propbox, *text, *text2, *w_filename, *w_isfile, *w_label_pixmap, *w_hvbox;
GtkWidget *w_mail_text;
GtkWidget *w_label_pixmap1, *w_label_button1, *w_label_pixmap2, *w_label_button2;
GtkAdjustment *w_memo_delay, *w_mail_delay, *w_hhl_delay, *w_recv_to, *w_netload_delay;
GtkAdjustment *w_max_retrys, *w_cap_delay;
GtkTooltips *w_tips;
GtkWidget *w_kernel, *w_check_mail, *w_mail_command, *w_mail_server, *w_mail_user;
GtkWidget *w_hhl_valid, *w_keyword, *w_hhl_fonly, *w_netload_valid, *w_proxy_only;
GtkWidget *w_display_access, *w_present_only, *w_new_only;
GtkWidget *w_old_file_name, *w_awk_name, *w_tmp_name, *w_back_name, *w_calc_valid;
GtkWidget *w_site_table, *w_html_name, *w_play_music, *w_back_color, *w_device;
GtkWidget *w_other_window, *w_desc_table, *w_big_font, *w_save_output, *w_omit_sitename;
GtkWidget *w_mail_passwd, *w_timestamp, *w_address, *w_subject, *w_program, *w_sounddata;
GtkWidget *w_command, *w_ext, *w_font1, *w_font2, *w_line1, *w_line2, *w_open_prop;
GtkWidget *w_url, *w_url2, *w_url3, *w_url4, *w_url5, *w_usercmd, w_select_usercmd;
GtkWidget *w_type_pop3, *w_type_imap, *w_select_ext, *w_select_filename, *w_atq;
GtkWidget *w_select_program, *w_select_data, *w_select_command, *w_hhl_path;
GtkWidget *w_sep_h1, *w_fixed_length, *w_select_text, *w_select_mail_cmd, *w_bigb;
GtkWidget *w_calc, *w_select_calc, *w_select_text2, *w_select_back_name;
GtkWidget *w_read_cmd, *w_pgscmd, *w_dbcmd, *w_pgcmd, *w_select_hhl, *w_select_site;
GtkWidget *w_select, *w_from, *w_where, *w_group, *w_order, *w_psql, *w_html_flag;
GtkWidget *w_shot, *w_suffix, *w_nomemo;
gchar     *memo;
gchar     *memo2;
gint      memo01 = 0;
gint      f_nomemo = 1;
gint      not_orient = 1;
gint      kernelflag = 0;
gint      check_mail_flag = 0;
gint      hhl_valid = 0;
gint      calc_valid = 0;
gint      netload_valid = 0;
gint      proxy_only = 0;
gint      display_access = 0;
gint      present_only = 0;
gint      new_only = 0;
gint      hhl_fonly = 0;
gint      other_window = 0;
gint      desc_table = 0;
gint      big_font = 0;
gint      save_output = 0;
gint      omit_sitename = 1;
gint      mail_type = 0;
gint      is_line1 = 0;
gint      memoflip = 0;
gint      isfile = 0;
gint      cap_type = 0;
gint      timer_memo = -1;
gint      timer_mail = -1;
gint      timer_cap = -1;
gint      timer_hhl = -1;
gint      timer_netload = -1;
gint      open_prop = 0;
gint      memo_delay = 0;
gint      mail_delay = 0;
gint      cap_delay = 0;
gint      hhl_delay = 30;
gint      netload_delay = 20;
gint      recv_to = 30;
gint      max_retrys = 3;
gint      f_mail = 0;
gint      maxlen = 0;
gint      f_sound = 0;
gint      one_only = 0;
gint      is_bigb = 0;
gint      fixed_length = 0;
gint      html_flag = 0;
gint      num_of_memopanel;
gint      s_label_button;
gchar     *szFontName = NULL;
gchar     *mail_text, *s_calc;
gchar     *filename, *address, *subject, *program, *sounddata, *command, *ext;
char      fontname1[256], fontname2[256], home_dir[256], save_memo[256];
gchar     *mail_command, *mail_server, *mail_user, *mail_passwd, *mail_passwd2;
gchar     *url, *url2, *url3, *url4, *url5, *usercmd, *pgscmd, *dbcmd, *pgcmd;
gchar	  *c_select, *c_from, *c_where, *c_group, *c_order, *c_psql;
gchar     *timestamp, passwd_magic[256], *shotname, lang[256];
gchar     *hhl_path, *keyword, *back_color, *suffix;
gchar     *site_table, *html_name, *play_music, *device;
gchar     *old_file_name, *awk_name, *tmp_name, *back_name;
GList     *g_list_wo1 = NULL;
GList     *g_list_wo2 = NULL;
GList     *g_list_ja1 = NULL;
GList     *g_list_ja2 = NULL;
GList     *g_list_usr = NULL;
GList     *g_list_ucm = NULL;
GList     *g_list_ext = NULL;
GList     *g_list_prg = NULL;
GList     *g_list_txt = NULL;
GList     *g_list_txt2 = NULL;
GList     *g_list_cmd = NULL;
GList     *g_list_pgs = NULL;
GList     *g_list_db  = NULL;
GList     *g_list_pgcmd  = NULL;
GList     *g_list_mcm = NULL;
GList     *g_list_sub = NULL;
GList     *g_list_suf = NULL;
GList     *g_list_isfile = NULL;
GList     *node, *node2;
GSList    *g_mail_type = NULL;
GSList    *g_lines = NULL;
int		  mail_recv_f = 0;
int		  save_nom = 0;
int		  fg_r, fg_g, fg_b, bg_r, bg_g, bg_b;
int		  mfg_r, mfg_g, mfg_b, mbg_r, mbg_g, mbg_b;
int       tmp_fg_r, tmp_fg_g, tmp_fg_b, tmp_bg_r, tmp_bg_g, tmp_bg_b;
int       tmp_mfg_r, tmp_mfg_g, tmp_mfg_b, tmp_mbg_r, tmp_mbg_g, tmp_mbg_b;
PanelOrientType save_orient;
static    GStaticMutex mutex = G_STATIC_MUTEX_INIT;
char      save_mtime[256];
char	  dummy7[]=" ";
glibtop_netload netload;
u_int64_t	netload_in=0;
u_int64_t	netload_out=0;
int	      save_midori, save_aka;	
static void change_maru();

#if 0
void debug(char *s1, char *s2) {
#if 0
	FILE *debug; debug=fopen("/home/ka/debug","a"); fprintf(debug,"%s=[%s]\n",s1,s2); fclose(debug);
#endif
#if 0
	g_message("[%s] [%s]\n",s1,s2);
#endif
}
#endif

void ShowError(char *str) {
	GtkWidget *gnomeapp;

	gnomeapp=gnome_app_new("MemoPanelApp",NULL);
	gnome_app_message((GnomeApp *)gnomeapp,str);
}
static void cut_m(char *s) {
	if(s[strlen(s)-1] == '\n') s[strlen(s)-1]='\0';
}
void strn0cpy(char *dst, char *src, int len) {
	strncpy(dst, src, len); dst[len]='\0';
}
gchar *s_kterm() {
	gchar lang2[4];
	if(lang == NULL || strlen(lang) < 3) return "";
	else {
		strn0cpy(lang2,lang,2); return (strcmp(lang2,"ja")) ? "xterm" : "kterm";
	}
}
void calc_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_calc),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void ext_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_ext),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void filename_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_filename),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void program_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w_program)->entry),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void call_calculator (GtkWidget *widget, GtkWidget *s) {
	if(! strlen(s_calc)) { ShowError(_("Required a filename")); return; }
	gnome_execute_shell(NULL,s_calc);
}
void p_atq (GtkWidget *widget, GtkWidget *s) {
	gchar wk4[256];
	sprintf(wk4,"%s -e sh -c 'atq|less'",s_kterm());
	gnome_execute_shell(NULL,wk4);
}
void text_ok (GtkWidget *widget, GtkWidget *s) {
	gchar *workname2, *workname3, wk4[256], wk5[256];
	FILE *fin3;

	workname2 = gtk_file_selection_get_filename(GTK_FILE_SELECTION(s));
	workname3 = g_strdup(workname2); strcpy(wk4,workname3);
	fin3=fopen(wk4,"r"); if(fin3 == NULL) return;
	if(fgets(wk5,255,fin3) != NULL) {
		cut_m(wk5); if(! strlen(wk5)) strcpy(wk5,_("memo")); strcat(wk5," ");
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(text)->entry),wk5);
	}
	fclose(fin3);
}
void text2_ok (GtkWidget *widget, GtkWidget *s) {
	gchar *workname2, *workname3, wk4[256], wk5[256];
	FILE *fin3;

	workname2 = gtk_file_selection_get_filename(GTK_FILE_SELECTION(s));
	workname3 = g_strdup(workname2); strcpy(wk4,workname3);
	fin3=fopen(wk4,"r"); if(fin3 == NULL) return;
	if(fgets(wk5,255,fin3) != NULL) {
		cut_m(wk5); if(! strlen(wk5)) strcpy(wk5,_("memo")); strcat(wk5," ");
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(text2)->entry),wk5);
	}
	fclose(fin3);
}
void mail_cmd_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w_mail_command)->entry),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void site_table_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_site_table),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void back_name_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_back_name),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void hhl_path_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_hhl_path),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void command_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w_command)->entry),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void data_ok (GtkWidget *widget, GtkWidget *s) {
	gtk_entry_set_text(GTK_ENTRY(w_sounddata),
					gtk_file_selection_get_filename(GTK_FILE_SELECTION(s)));
}
void calc_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("filename for calculator select"),w_calc,calc_ok);
}
void ext_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("filename for ext select"),w_ext,ext_ok);
}
void filename_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("filename select"),w_filename,filename_ok);
}
void text_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("memo file select"),text,text_ok);
}
void text2_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("memo file select"),text2,text2_ok);
}
void program_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("program select"),w_program,program_ok);
}
void mail_cmd_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("mail command select"),w_mail_command,mail_cmd_ok);
}
void site_table_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("SITE.table select"),w_site_table,site_table_ok);
}
void back_name_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("background path select"),w_back_name,back_name_ok);
}
void hhl_path_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("HtmlHeadLine.sh path select"),w_hhl_path,hhl_path_ok);
}
void command_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("command select"),w_command,command_ok);
}
void data_select (GtkWidget *widget, gpointer data) {
	d_p_select(_("sound data select"),w_sounddata,data_ok);
}
static gint timeout_cap() {
	gchar *workname2, workname3[256];
	if(! cap_type) return 1; /* 0=stop timer */
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_shot));
	shotname = g_strdup(workname2);
	sprintf(workname3,"import -window root %s%s",shotname,suffix);
	gnome_execute_shell(NULL,workname3);
	cap_type=0;
	return 1; /* 0=stop timer */
}
static void set_timer_cap(void) {
	if(timer_cap != -1) gtk_timeout_remove(timer_cap);
	if(cap_delay) timer_cap=gtk_timeout_add(cap_delay * (guint32)1000, timeout_cap, applet);
}
void font1_ok_clicked(GtkWidget *widget, GtkWidget *fontsel) {
	char *fontname3;
	GtkFontSelectionDialog *fsd = GTK_FONT_SELECTION_DIALOG(fontsel);
	fontname3 = gtk_font_selection_dialog_get_font_name(fsd);
	if(fontname3 != NULL) { /* No font was selected */
		strcpy(fontname1,fontname3);
		gtk_entry_set_text(GTK_ENTRY(w_font1), fontname1);
	}
	else ShowError(_("Required a font name"));
	gtk_widget_destroy(fontsel);
}
void font2_ok_clicked(GtkWidget *widget, GtkWidget *fontsel) {
	char *fontname3;
	GtkFontSelectionDialog *fsd = GTK_FONT_SELECTION_DIALOG(fontsel);
	fontname3 = gtk_font_selection_dialog_get_font_name(fsd);
	if(fontname3 != NULL) { /* No font was selected */
		strcpy(fontname2,fontname3);
		gtk_entry_set_text(GTK_ENTRY(w_font2), fontname2);
	}
	else ShowError(_("Required a font name"));
	gtk_widget_destroy(fontsel);
}
void font_quit(GtkWidget *widget, gpointer data) {
	gtk_main_quit();
}
void set_style_col_fg(GtkWidget *w, gushort r, gushort g, gushort b){
	char fontname4[256];
	GtkStyle *style;
	sprintf(fontname4,"%s,%s,*",fontname1,fontname2);
	style = gtk_style_copy(gtk_widget_get_default_style());
	style->font = gdk_fontset_load(fontname4);
	style->fg[GTK_STATE_NORMAL].red   = r;
	style->fg[GTK_STATE_NORMAL].green = g;
	style->fg[GTK_STATE_NORMAL].blue  = b;
	gtk_widget_set_style(w, style);
}
void set_style_col_bg(GtkWidget *w, gushort r, gushort g, gushort b){
	GtkStyle *style;
	style = gtk_style_copy(gtk_widget_get_default_style());
	style->bg[GTK_STATE_NORMAL].red   = r;
	style->bg[GTK_STATE_NORMAL].green = g;
	style->bg[GTK_STATE_NORMAL].blue  = b;
	gtk_widget_set_style(w, style);
}
void update_color_font_memo(void) {
	set_style_col_fg(labelmemo, (gushort)fg_r,(gushort)fg_g,(gushort)fg_b); /* text */
	set_style_col_bg(labelbox,  (gushort)bg_r,(gushort)bg_g,(gushort)bg_b); /* box */
	set_style_col_bg(labelframe,(gushort)bg_r,(gushort)bg_g,(gushort)bg_b); /* frame */
	set_style_col_bg(applet,    (gushort)bg_r,(gushort)bg_g,(gushort)bg_b); /* back */
	tmp_fg_r = tmp_fg_g = tmp_fg_b = tmp_bg_r = tmp_bg_g = tmp_bg_b = -1;
}
void font1_clicked(GtkWidget *wid, gpointer gdata) {
	GtkWidget	*widget;
	GtkFontSelectionDialog *fontsel;
	
	widget = gtk_font_selection_dialog_new(_("Font Selector"));
	fontsel = GTK_FONT_SELECTION_DIALOG(widget);
	gtk_signal_connect(GTK_OBJECT(fontsel->ok_button),"clicked",
					GTK_SIGNAL_FUNC(font1_ok_clicked),fontsel);
	gtk_signal_connect_object(GTK_OBJECT(fontsel->cancel_button),"clicked",
					GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(fontsel));
	gtk_signal_connect(GTK_OBJECT(fontsel),"destroy",GTK_SIGNAL_FUNC(font_quit),fontsel);
	gtk_widget_show(widget);
	gtk_main();
	update_color_font_memo();
}
void font2_clicked(GtkWidget *wid, gpointer gdata) {
	GtkWidget	*widget;
	GtkFontSelectionDialog *fontsel;
	
	widget = gtk_font_selection_dialog_new(_("Font Selector"));
	fontsel = GTK_FONT_SELECTION_DIALOG(widget);
	gtk_signal_connect(GTK_OBJECT(fontsel->ok_button),"clicked",
					GTK_SIGNAL_FUNC(font2_ok_clicked),fontsel);
	gtk_signal_connect_object(GTK_OBJECT(fontsel->cancel_button),"clicked",
					GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(fontsel));
	gtk_signal_connect(GTK_OBJECT(fontsel),"destroy",GTK_SIGNAL_FUNC(font_quit),fontsel);
	gtk_widget_show(widget);
	gtk_main();
	update_color_font_memo();
}
void magic1(char *str) {
	int i; if(strlen(str)) for(i=0;i<strlen(str);i++) str[i] ^= 0x19;
}
static void b_command_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_command)->entry));
	command = g_strdup(workname2);
	if(strlen(command)) gnome_execute_shell(NULL,command);
	else ShowError(_("Required a command"));
}
void read_set_pgcmd() {
	gpointer  gp1;
	gchar     wk2[256];
	FILE      *fin2;

	if(g_list_pgcmd) for(node=g_list_pgcmd; node; node=node->next) g_free(node->data);
	g_list_pgcmd = NULL;
	fin2=fopen(PGCMD_FILE,"r");
	if(fin2 != NULL) {
		while(fgets(wk2,255,fin2) != NULL) {
			cut_m(wk2); gp1 = g_malloc(strlen(wk2)+1);
			strcpy(gp1,wk2); g_list_pgcmd = g_list_append(g_list_pgcmd,gp1);
		}
		fclose(fin2);
	}
	if(g_list_pgcmd == NULL) {
		gp1 = g_malloc(strlen(dummy7)+1); strcpy(gp1,dummy7);
		g_list_pgcmd = g_list_append(g_list_pgcmd,gp1);
	}
}
static void b_dbcmd_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[256];
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_dbcmd)->entry));
	dbcmd = g_strdup(workname2);
	if(strlen(dbcmd)) {
		sprintf(workname3,"memopanel.psql.sh pgcmd %s",dbcmd);
		gnome_execute_shell(NULL,workname3);
		read_set_pgcmd();
		gtk_combo_set_popdown_strings(GTK_COMBO(w_pgcmd),g_list_pgcmd);
	}
	else ShowError(_("Required a database name"));
}
static void b_email_clicked(GtkWidget *w, gpointer *data) {
    char buf[256], name[256], *workname2;
	FILE *fil;

	d_get_text(timestamp,w_timestamp);
	d_get_text(address,w_address);
	d_get_text(subject,GTK_COMBO(w_subject)->entry);
	if((! strlen(timestamp))) { ShowError(_("Required a timestamp")); return; }
	if((! strlen(address)) || (! strlen(subject))) {
		ShowError(_("Required an address or subject")); return;
	}
	strcpy(name,AT_EMAIL);
	fil=fopen(name,"w"); if(fil == NULL) return;
    fprintf(fil,"#!/bin/sh\n");
	fprintf(fil,"/usr/sbin/sendmail -ba %s <<@\n",address);
	fprintf(fil,"From: %s\nSubject: %s\n@\n",address,subject);
    fclose(fil);
	sprintf(buf,"chmod +x %s; at -f %s %s",name,name,timestamp);
	gnome_execute_shell(NULL,buf);
}
static void b_sound_clicked(GtkWidget *w, gpointer *data) {
    char buf[256], name[256], *workname2;
	FILE *fil;

	d_get_text(timestamp,w_timestamp);
	d_get_text(program,GTK_COMBO(w_program)->entry);
	d_get_text(sounddata,w_sounddata);
	if((! strlen(timestamp))) { ShowError(_("Required a timestamp")); return; }
	if((! strlen(program)) || (! strlen(sounddata))) {
		ShowError(_("Required a program or sound data name")); return;
	}
	strcpy(name,AT_SOUND);
	fil=fopen(name,"w"); if(fil == NULL) return;
    fprintf(fil,"#!/bin/sh\n");
	fprintf(fil,"%s \"%s\"\n",program,sounddata);
    fclose(fil);
	sprintf(buf,"chmod +x %s; at -f %s %s",name,name,timestamp);
	gnome_execute_shell(NULL,buf);
}
static void b_shot1_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[256];
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_shot));
	shotname = g_strdup(workname2);
	if(strlen(shotname)) {
		d_get_text(suffix,GTK_COMBO(w_suffix)->entry);
		if((! strlen(suffix)) || suffix[0] != '.') {
			ShowError(_("Required a suffix like .jpeg")); return;
		}
		sprintf(workname3,"import %s%s",shotname,suffix);
		gnome_execute_shell(NULL,workname3);
	}
	else ShowError(_("Required a filename"));
}
static void b_shota_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[256];
	cap_delay = w_cap_delay->value;
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_shot));
	shotname = g_strdup(workname2);
	if(strlen(shotname)) {
		d_get_text(suffix,GTK_COMBO(w_suffix)->entry);
		if((! strlen(suffix)) || suffix[0] != '.') {
			ShowError(_("Required a suffix like .jpeg")); return;
		}
		if(! cap_delay) {
			sprintf(workname3,"import -window root %s%s",shotname,suffix);
			gnome_execute_shell(NULL,workname3); cap_type=0;
		}
		else {
			cap_type=2; set_timer_cap();
		}
	}
	else ShowError(_("Required a filename"));
}
static void b_psql_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[2048], workname4[256];
	workname2 = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_dbcmd)->entry));
	dbcmd = g_strdup(workname2);
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_psql)); c_psql = g_strdup(workname2);
	if(strlen(dbcmd) && strlen(c_psql)) {
		if(GTK_TOGGLE_BUTTON(w_html_flag)->active) 
		sprintf(workname3,"%s -e sh -c \"memopanel.psql.sh h_psql %s \\\"%s;\\\"\"",
							s_kterm(),dbcmd,c_psql);
		else
		sprintf(workname3,"%s -e sh -c \"memopanel.psql.sh psql %s \\\"%s;\\\"\"",
							s_kterm(),dbcmd,c_psql);
		gnome_execute_shell(NULL,workname3);
	}
	else ShowError(_("Required a database or psql command"));
}
static void b_select_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[2048], workname4[256];
	workname2 = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_dbcmd)->entry));
	dbcmd = g_strdup(workname2);
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_select)); c_select = g_strdup(workname2);
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_from));   c_from   = g_strdup(workname2);
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_where));  c_where  = g_strdup(workname2);
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_group));  c_group  = g_strdup(workname2);
	workname2 = gtk_entry_get_text(GTK_ENTRY(w_order));  c_order  = g_strdup(workname2);
	if(strlen(dbcmd)) {
		if(GTK_TOGGLE_BUTTON(w_html_flag)->active) 
			sprintf(workname3,"%s -e sh -c \"memopanel.psql.sh h_psql %s \\\"",s_kterm(),dbcmd);
		else
			sprintf(workname3,"%s -e sh -c \"memopanel.psql.sh psql %s \\\"",s_kterm(),dbcmd);
		if(strlen(c_select)) { strcat(workname3," SELECT ");   strcat(workname3,c_select); }	
		else { ShowError(_("Required a select clause")); return; }
		if(strlen(c_from))   { strcat(workname3," FROM ");     strcat(workname3,c_from); }
		if(strlen(c_where))  { strcat(workname3," WHERE ");    strcat(workname3,c_where); }
		if(strlen(c_group))  { strcat(workname3," GROUP BY "); strcat(workname3,c_group); }
		if(strlen(c_order))  { strcat(workname3," ORDER BY "); strcat(workname3,c_order); }
		strcat(workname3,";\\\"\"");
		gnome_execute_shell(NULL,workname3);
	}
	else ShowError(_("Required a database name"));
}
static void b_pgcmd_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[256];
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_dbcmd)->entry));
	dbcmd = g_strdup(workname2);
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_pgcmd)->entry));
	pgcmd = g_strdup(workname2);
	if(strlen(dbcmd) && strlen(pgcmd)) {
		sprintf(workname3,"%s -e sh -c 'memopanel.psql.sh psql %s \"\\h %s\"'",s_kterm(),dbcmd,pgcmd);
		gnome_execute_shell(NULL,workname3);
	}
	else ShowError(_("Required a database name or a command name"));
}
static void b_pgscmd_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2, workname3[256];
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_dbcmd)->entry));
	dbcmd = g_strdup(workname2);
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_pgscmd)->entry));
	pgscmd = g_strdup(workname2);
	if(strlen(pgscmd) && strlen(dbcmd)) {
		if(*pgscmd == '\\')
			sprintf(workname3,"%s -e sh -c 'memopanel.psql.sh psql %s \"%s\"'",
								s_kterm(),dbcmd,pgscmd);
		else
			sprintf(workname3,"%s -e sh -c 'memopanel.psql.sh %s'",s_kterm(),pgscmd);
		gnome_execute_shell(NULL,workname3);
	}
	else ShowError(_("Required a database name or command"));
}
static void b_usercmd_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_usercmd)->entry));
	usercmd = g_strdup(workname2);
	if(strlen(usercmd)) gnome_execute_shell(NULL,usercmd);
	else ShowError(_("Required a user command"));
}
static void b_url_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_url)->entry));
	url   = g_strdup(workname2);
	if(strlen(url)) gnome_url_show(url); else ShowError(_("Required a URL"));
}
static void b_url2_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_url2)->entry));
	url2  = g_strdup(workname2);
	if(strlen(url2)) gnome_url_show(url2); else ShowError(_("Required a URL"));
}
static void b_url3_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_url3)->entry));
	url3  = g_strdup(workname2);
	if(strlen(url3)) gnome_url_show(url3); else ShowError(_("Required a URL"));
}
static void b_url4_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_url4)->entry));
	url4  = g_strdup(workname2);
	if(strlen(url4)) gnome_url_show(url4); else ShowError(_("Required a URL"));
}
static void b_url5_clicked(GtkWidget *w, gpointer *data) {
	gchar *workname2;
	workname2  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w_url5)->entry));
	url5  = g_strdup(workname2);
	if(strlen(url5)) gnome_url_show(url5); else ShowError(_("Required a URL"));
}
static void b_ext_clicked(GtkWidget *w, gpointer *data) {
	char wk4[256], wk5[256], wk6[256], wk7[256], *p, *q;
	gchar *workname2;
	int   found;

	workname2 = gtk_entry_get_text(GTK_ENTRY(w_ext)); ext = g_strdup(workname2);
	if(! strlen(ext)) { ShowError(_("Required a filename")); return; }
	strcpy(wk7,ext); p = strrchr(wk7,'.');
	if(p == NULL) { ShowError(_("Required a file extention name")); return; }
	found=0;
	for(node=g_list_ext; node; node=node->next) {
		strcpy(wk5,node->data); q = strchr(wk5,':'); if(q == NULL) continue;
		strn0cpy(wk6,wk5,q - wk5); if(! strcmp(wk6,p+1)) { found=1; break; }
	}
	if(! found) return;
	sprintf(wk4,"%s \"%s\"",q+1,ext);
	gnome_execute_shell(NULL,wk4);
}
static void mfg_changed_signal(GtkWidget *color_picker_widget, gpointer *data) {
	gushort r, g, b;
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(color_picker_widget), &r, &g, &b, NULL);
	tmp_mfg_r = (int) r; tmp_mfg_g = (int) g; tmp_mfg_b = (int) b; return;
}
static void mbg_changed_signal(GtkWidget *color_picker_widget, gpointer *data) {
	gushort r, g, b;
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(color_picker_widget), &r, &g, &b, NULL);
	tmp_mbg_r = (int) r; tmp_mbg_g = (int) g; tmp_mbg_b = (int) b; return;
}
static void fg_changed_signal(GtkWidget *color_picker_widget, gpointer *data) {
	gushort r, g, b;
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(color_picker_widget), &r, &g, &b, NULL);
	tmp_fg_r = (int) r; tmp_fg_g = (int) g; tmp_fg_b = (int) b; return;
}
static void bg_changed_signal(GtkWidget *color_picker_widget, gpointer *data) {
	gushort r, g, b;
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(color_picker_widget), &r, &g, &b, NULL);
	tmp_bg_r = (int) r; tmp_bg_g = (int) g; tmp_bg_b = (int) b; return;
}
static void about_cb (AppletWidget *widget, gpointer data) {
	GtkWidget *w;
	const gchar *authors[]={"Toshiaki Kanosue <toshika@sutv.zaq.ne.jp>",NULL};

	w = gnome_about_new(_("MemoPanel Applet"),VERSION,
		"Copyright (C) 2000",(const gchar **)authors,
		_("Released under the GNU General Public License.\nA memo on panel."),"memopanel.png");
	gtk_widget_show(w);
}
static gint applet_save_session() {
	gchar buf[256];
	g_snprintf(buf,255,"memopanel%d/",num_of_memopanel);
	gnome_config_push_prefix(buf);
	d_set_str("memo",memo);
	d_set_str("memo2",memo2);
	d_set_int("isfile",isfile);
	d_set_str("filename",filename);
	d_set_str("mail_text",mail_text);
	d_set_str("select",c_select);
	d_set_str("from",c_from);
	d_set_str("where",c_where);
	d_set_str("group",c_group);
	d_set_str("order",c_order);
	d_set_str("psql",c_psql);
	d_set_str("address",address);
	d_set_str("subject",subject);
	d_set_str("suffix",suffix);
	d_set_str("program",program);
	d_set_str("sounddata",sounddata);
	d_set_int("delay",memo_delay);
	d_set_int("kernel",kernelflag);
	d_set_int("open_prop",open_prop);
	d_set_int("fixlen",fixed_length);
	d_set_int("htmlf",html_flag);
	d_set_int("mfg_r",mfg_r);
	d_set_int("mfg_g",mfg_g);
	d_set_int("mfg_b",mfg_b);
	d_set_int("mbg_r",mbg_r);
	d_set_int("mbg_g",mbg_g);
	d_set_int("mbg_b",mbg_b);
	d_set_int("fg_r",fg_r);
	d_set_int("fg_g",fg_g);
	d_set_int("fg_b",fg_b);
	d_set_int("bg_r",bg_r);
	d_set_int("bg_g",bg_g);
	d_set_int("bg_b",bg_b);
	d_set_str("command",command);
	d_set_str("usercmd",usercmd);
	d_set_str("pgscmd",pgscmd);
	d_set_str("pgcmd",pgcmd);
	d_set_str("dbcmd",dbcmd);
	d_set_str("url",url);
	d_set_str("url2",url2);
	d_set_str("url3",url3);
	d_set_str("url4",url4);
	d_set_str("url5",url5);
	d_set_str("shotname",shotname);
	d_set_str("keyword",keyword);
	d_set_str("back_color",back_color);
	d_set_str("site_table",site_table);
	d_set_str("device",device);
	d_set_str("html_name",html_name);
	d_set_str("awk_name",awk_name);
	d_set_str("tmp_name",tmp_name);
	d_set_str("back_name",back_name);
	d_set_str("old_file_name",old_file_name);
	d_set_str("play_music",play_music);
	d_set_str("hhl_path",hhl_path);
	d_set_str("ext",ext);
	d_set_str("calc",s_calc);
	d_set_str("font1",fontname1);
	d_set_str("font2",fontname2);
	d_set_int("check_mail",check_mail_flag);
	d_set_int("hhl_valid",hhl_valid);
	d_set_int("calc_valid",calc_valid);
	d_set_int("netload_valid",netload_valid);
	d_set_int("f_nomemo",f_nomemo);
	d_set_int("proxy_only",proxy_only);
	d_set_int("display_access",display_access);
	d_set_int("present_only",present_only);
	d_set_int("new_only",new_only);
	d_set_int("hhl_fonly",hhl_fonly);
	d_set_int("other_window",other_window);
	d_set_int("desc_table",desc_table);
	d_set_int("big_font",big_font);
	d_set_int("save_output",save_output);
	d_set_int("omit_sitename",omit_sitename);
	d_set_int("mail_delay",mail_delay);
	d_set_int("hhl_delay",hhl_delay);
	d_set_int("netload_delay",netload_delay);
	d_set_int("recv_to",recv_to);
	d_set_int("max_retrys",max_retrys);
	d_set_str("mail_command",mail_command);
	d_set_str("mail_server",mail_server);
	d_set_str("mail_user",mail_user);
	d_set_str("mail_passwd",mail_passwd);
	d_set_int("mail_type",mail_type);
	d_set_int("is_line1",is_line1);
	d_set_int("is_bigb",is_bigb);
	gnome_config_pop_prefix();
	gnome_config_sync();
	gnome_config_drop_all();
	return FALSE;
}
void update_color_mail(void) {
	set_style_col_fg(labelmemo, (gushort)mfg_r,(gushort)mfg_g,(gushort)mfg_b); /* text */
	set_style_col_bg(labelbox,  (gushort)mbg_r,(gushort)mbg_g,(gushort)mbg_b); /* box */
	set_style_col_bg(labelframe,(gushort)mbg_r,(gushort)mbg_g,(gushort)mbg_b); /* frame */
	set_style_col_bg(applet,    (gushort)mbg_r,(gushort)mbg_g,(gushort)mbg_b); /* back */
	tmp_mfg_r = tmp_mfg_g = tmp_mfg_b = tmp_mbg_r = tmp_mbg_g = tmp_mbg_b = -1;
}
void show_memo(char *s) {
	char weeks[][3]={"","","","","","",""}; /* japanese */
	char buf1[256], buf2[256], buf3[256], *p;
	struct tm *tim; long t;

	if(strcmp(save_memo,s))	{
		strcpy(buf1,s); p=strstr(buf1,"%J");
		if(p != NULL) {
			time(&t); tim=localtime(&t);
			while(p != NULL) {
				*p++ = weeks[tim->tm_wday][0]; *p = weeks[tim->tm_wday][1];
				p=strstr(buf1,"%J");
			}
		}
		gtk_label_set_text(GTK_LABEL(labelmemo),buf1); update_color_font_memo();
	}
	strcpy(save_memo,s);
}
static void strftime_memo(char *memo) {
	struct tm *tim; long t; gchar memobuf[256];
	time(&t); tim=localtime(&t); strftime(memobuf,255,memo,tim); show_memo(memobuf);
}
void read_from_file() {
	gpointer  gp1;
	gchar     wk2[256];
	FILE      *fin2;

	if(! strlen(filename)) { ShowError(_("Required a filename")); isfile=0; return; }
	if(g_list_isfile) for(node=g_list_isfile; node; node=node->next) g_free(node->data);
	g_list_isfile = NULL; node2=g_list_isfile;
	fin2=fopen(filename,"r");
	if(fin2 == NULL) return;
	while(fgets(wk2,255,fin2) != NULL) {
		cut_m(wk2); gp1 = g_malloc(strlen(wk2)+1);
		strcpy(gp1,wk2); g_list_isfile = g_list_append(g_list_isfile,gp1);
	}
	fclose(fin2); node2=g_list_isfile;
}
static void isfile_updated() {
	struct stat sbuf;
	char mtime_str[256];

	if(! g_file_exists(filename)) { return; }
	stat(filename,&sbuf); strcpy(mtime_str,ctime(&sbuf.st_mtime));
	if(strcmp(save_mtime,mtime_str)) {
		read_from_file(); strcpy(save_mtime,mtime_str);
	}
}
static void isfile_1line(char *line1) {
	gchar line3[256];
	maxlen=MAX(maxlen,strlen(line1));
	if(fixed_length)
		sprintf(line3,"%-*s",maxlen,line1);
	else
		sprintf(line3,"%s",line1);
	show_memo(line3);
}
static gint timeout_memo() {
	gchar line1[256], line2[256], line3[256];
	gint  i, j;
	FILE  *fin;

	if(not_orient) { show_memo(_("Memo")); return 1; }
	if(mail_recv_f) return 1; /* 0=stop timer */
	if(isfile) { /* display from file */
		isfile_updated();
		if(g_list_isfile == NULL) node2=g_list_isfile; 
		else {
			if(node2 == NULL) node2=g_list_isfile;
			else {
				strcpy(line1,node2->data);	
				j=strlen(line1);
				if(j) {
					strcat(line1," "); /* for italic */
					if(! strlen(line1)) strcpy(line1,"____");
				}
				else strcpy(line1,"____");
				if(is_line1) {
					isfile_1line(line1); node2=node2->next;
				}
				else {
					node2=node2->next;
					if(node2 == NULL) {
						isfile_1line(line1);
						node2=g_list_isfile; isfile_updated();
					}
					else {
						strcpy(line2,node2->data);	
						j=strlen(line2);
						if(j) {
							strcat(line2," "); /* for italic */
							if(! strlen(line2)) strcpy(line2,"____");
						}
						else strcpy(line2,"____");
						maxlen=MAX(maxlen,strlen(line1));
						maxlen=MAX(maxlen,strlen(line2));
						if(fixed_length)
							sprintf(line3,"%-*s\n%-*s",maxlen,line1,maxlen,line2);
						else
							sprintf(line3,"%s\n%s",line1,line2);
						show_memo(line3);
						node2=node2->next;
					}
				}
			}
		}
	}
	else {
		memoflip=(kernelflag) ? ( ( ! memoflip ) & 1 ) : 0;
		if(! memoflip) {
			if(memo01) {
				if(strlen(memo2)) strftime_memo(memo2); else
				if(strlen(memo))  strftime_memo(memo); else show_memo(_("NoMemo"));
			}
			else {
				if(strlen(memo))  strftime_memo(memo); else show_memo(_("NoMemo"));
			}
			memo01 = (memo01) ? 0 : 1;
		}
		else {
			sprintf(line1,"finger @www.kernel.org|awk '{if(index($0,\"stable\"))print\"stable \"$NF;if(index($0,\"beta\"))print\"beta \"$NF}'>%s",KERNEL_NAME);
			gnome_execute_shell(NULL,line1);
			fin=fopen(KERNEL_NAME,"r");
			if(fin != NULL) {
				fgets(line1,255,fin); fgets(line2,255,fin);
				cut_m(line2); sprintf(line3,"%s%s",line1,line2);
				if(strlen(line3)) show_memo(line3);
				fclose(fin);
			}
		}
	}
	return 1; /* 0=stop timer */
}
static char *input1(int s) {
	static char in_buf[256];
	int in_buf_size= sizeof(in_buf);
	char *p;
	
	p = in_buf;
	while(in_buf_size--) {
		fd_set mask;
		struct timeval tval;
		char ch;
		
		FD_ZERO(&mask); FD_SET(s, &mask); tval.tv_sec = 5; tval.tv_usec = 0;
		if(select(FD_SETSIZE, &mask, NULL, NULL, &tval) <= 0) return NULL;
		if(read(s, &ch, sizeof(ch)) != sizeof(ch)) return NULL;
		if(ch == '\n') { *p = '\0'; return in_buf; } 
		*(p++) = ch;
	}
	return NULL; 
}
static int output_ng(int s, char *str) {
	char w_buf[256];
	sprintf(w_buf,"%s\r\n",str); return (write(s,w_buf,strlen(w_buf)) != strlen(w_buf));
}
static int POP3_ok(char *str) {
	return (str && str[0] == '+'); /* +OK or -ERR */
}
static int POP3_in_ng(int s) {
	return (! POP3_ok(input1(s)));
}
static char *IMAP_read_A1(int s) {
	char *p;
	int i=10;
	while(i--) {
		p=input1(s); if(! p) return NULL;
		if(! strncmp(p,"A1",2)) return p;
	}
	return NULL;
}
static int IMAP_ng(char *str) {
	char *p;
	if(! str) return 1;
	p = strchr(str,' '); return strncmp(p+1,"OK",2);
}
static int IMAP_tag(char *str) {
	return ((str) ? (*str != '*') : 1);
}
/* This logic was changed for a information offered by Mr. Jochen Friedrich */
#define STATUS_UNSEEN "* STATUS INBOX (UNSEEN "
static gint get_IMAP(int s) {
	int    nom = -1, wklen;
	char   *in1, buf[256];

	wklen=strlen(STATUS_UNSEEN);
	if(IMAP_tag(in1=input1(s))) return nom;
	if(IMAP_ng(in1)) return nom;
	sprintf(buf,"A1 LOGIN %s %s",mail_user,passwd_magic); if(output_ng(s,buf)) return nom;
	if(IMAP_ng(IMAP_read_A1(s))) return nom;
	if(output_ng(s,"A2 STATUS INBOX (UNSEEN)")) return nom;
	while(1) {
		if(IMAP_tag(in1 = input1(s))) break;
		if(! strncmp(in1,STATUS_UNSEEN,wklen)) nom=atoi(in1+wklen);
	}
	if(! output_ng(s,"A3 LOGOUT")) input1(s);
	return nom;
}
static gint get_POP3(int s) {
	int    nom = -1, noo = -1;
	char   dum1[256], *in1, buf[256];

	if(POP3_in_ng(s)) return nom;
	sprintf(buf,"USER %s",mail_user);    if(output_ng(s,buf) || POP3_in_ng(s)) return nom;
	sprintf(buf,"PASS %s",passwd_magic); if(output_ng(s,buf) || POP3_in_ng(s)) return nom;
	if(output_ng(s,"STAT")) return nom; /* STAT ==> +OK <# of msg> <# of octet> */
	in1 = input1(s); if(! POP3_ok(in1)) return nom;
	sscanf(in1,"%s %d %d",dum1,&nom,&noo);
	if(strcmp(dum1,"+OK") || nom == -1 || noo == -1) return nom;
	if(! output_ng(s,"QUIT")) input1(s);
	return nom;
}
static gint timeout_mail() {
	int    s, m_port;
	char   *ptr, m_host[256], mail_memo2[256], buf2[256], buf3[256], *p;
	struct hostent *server_host;
	struct sockaddr_in server_adr;
	
	if(! check_mail_flag) return 1; /* 0=stop timer */
	ptr = strchr(mail_server,':');
	if(ptr) {
		strn0cpy(m_host,mail_server,ptr - mail_server);
		m_port = atoi(ptr+1);
	}
	else {
		strcpy(m_host,mail_server);
		m_port = (mail_type) ? 143 : 110;
	}
	server_host = gethostbyname(m_host); if(server_host == NULL) return 1;
	bzero((char *)&server_adr, sizeof(server_adr));
	server_adr.sin_family = AF_INET;
	server_adr.sin_port   = htons(m_port);
	bcopy(server_host->h_addr, (char *)&server_adr.sin_addr, server_host->h_length);
	s = socket(AF_INET, SOCK_STREAM, 0); if (s < 0) return 1;
	if(connect(s,&server_adr,sizeof(server_adr)) == -1) { close(s); return 1; }
	save_nom=(mail_type) ? get_IMAP(s) : get_POP3(s);
	close(s);
	if(save_nom > 0) {
		mail_recv_f = 1;
		if(f_nomemo) change_maru();
		if(strlen(mail_text)) {
			strcpy(mail_memo2,mail_text); p=strstr(mail_memo2,"%F");
			if(p != NULL) {
				strcpy(buf2,p+2); *p='\0'; sprintf(buf3,"%d",save_nom);
				strcat(mail_memo2,buf3); strcat(mail_memo2,buf2);
			}	
		}
		else
			sprintf(mail_memo2,"%d%smail%s%srecv%s",save_nom,
				(save_orient == ORIENT_LEFT || save_orient == ORIENT_RIGHT) ? "%n" : " ",
				(save_nom > 1) ? "s" : "",
				(save_orient == ORIENT_LEFT || save_orient == ORIENT_RIGHT) ? "%n" : " ",
				(save_orient == ORIENT_DOWN || save_orient == ORIENT_UP) ? " " : "");
		strftime_memo(mail_memo2);
		update_color_mail();
		if(strlen(mail_command)) gnome_execute_shell(NULL,mail_command);
	}
	else
	if(mail_recv_f) {	
		mail_recv_f = 0; /* before timeout_memo */
		if(f_nomemo) change_maru();
		strcpy(save_memo,"??"); /* need to update */
		timeout_memo();
		update_color_font_memo();
	}
	return 1; /* 0=stop timer */
}
static gint timeout_hhl() {
	char buf[256];
	FILE *fil;

	if(! hhl_valid) return 1; /* 0=stop timer */
	if(! strlen(hhl_path)) { ShowError(_("No HtmlHeadLine.sh path")); return 1; }
	fil=fopen(HHL_SH,"w"); if(fil == NULL) return 1;
    fprintf(fil,"#!/bin/sh\n");
	fprintf(fil,"export DISPLAY_ACCESS=%s\n",(display_access) ? "YES" : "NO");
	fprintf(fil,"export PRESENT_ONLY=%s\n",  (present_only)   ? "YES" : "NO");
	fprintf(fil,"export NEW_ONLY=%s\n",      (new_only)       ? "YES" : "NO");
	fprintf(fil,"export PROXY_ONLY=%s\n",    (proxy_only)     ? "YES" : "NO");
	fprintf(fil,"export OTHER_WINDOW=%s\n",  (other_window)   ? "YES" : "NO");
	fprintf(fil,"export DESC_TABLE=%s\n",    (desc_table)     ? "YES" : "NO");
	fprintf(fil,"export BIG_FONT=%s\n",      (big_font)       ? "YES" : "NO");
	fprintf(fil,"export SAVE_OUTPUT=%s\n",   (save_output)    ? "YES" : "NO");
	fprintf(fil,"export OMIT_SITENAME=%s\n", (omit_sitename)  ? "YES" : "NO");
	fprintf(fil,"export FILE_ONLY=%s\n",     (hhl_fonly)      ? "YES" : "NO");
	if(strlen(keyword))       fprintf(fil,"export KEYWORD=\"%s\"\n",   keyword);
	if(strlen(play_music))    fprintf(fil,"export PLAY_MUSIC=\"%s > /dev/null 2>&1\"\n",play_music);
	if(strlen(site_table))    fprintf(fil,"export SITE_TABLE=\"%s\"\n",site_table);
	if(strlen(html_name))     fprintf(fil,"export HTML_NAME=\"%s\"\n", html_name);
	if(strlen(old_file_name)) fprintf(fil,"export OLD_FILE_NAME=\"%s\"\n",old_file_name);
	if(strlen(awk_name))      fprintf(fil,"export AWK_NAME=\"%s\"\n",  awk_name);
	if(strlen(tmp_name))      fprintf(fil,"export TMP=\"%s\"\n",       tmp_name);
	if(strlen(back_name))     fprintf(fil,"export BACKGROUND=\"%s\"\n",back_name);
	if(strlen(back_color))    fprintf(fil,"export BACK_COLOR=\"%s\"\n",back_color);
	if(recv_to)               fprintf(fil,"export RECV_TIMEOUT=%d\n",  recv_to);
	if(max_retrys)            fprintf(fil,"export MAX_RETRYS=%d\n",    max_retrys);
	if(strlen(filename))      fprintf(fil,"export DATA_NAME=\"%s\"\n", filename);
	fprintf(fil,"%s\n",hhl_path);
    fclose(fil);
	sprintf(buf,"chmod +x %s; %s",HHL_SH,HHL_SH);
	gnome_execute_shell(NULL,buf);
	return 1; /* 0=stop timer */
}
void show_maru_2(int color, int akarui) {
	switch(color) {
	case 0:
		if(w_label_pixmap1 != NULL) gtk_widget_destroy(w_label_pixmap1);
		w_label_pixmap1 = gnome_pixmap_new_from_xpm_d((akarui) ? maru_am : maru_km);
		gtk_container_add(GTK_CONTAINER(w_label_button1),w_label_pixmap1);
		gtk_widget_show(w_label_pixmap1);
		break;
	case 1:
		if(w_label_pixmap2 != NULL) gtk_widget_destroy(w_label_pixmap2);
		w_label_pixmap2 = gnome_pixmap_new_from_xpm_d((akarui) ? maru_aa : maru_ka);
		gtk_container_add(GTK_CONTAINER(w_label_button2),w_label_pixmap2);
		gtk_widget_show(w_label_pixmap2);
		break;
	}
}
static gint timeout_netload() {
	int midori, aka;

	if((! netload_valid) || (! strlen(device)) || (! open_prop)) return 0;
	if(not_orient) return 1;
    glibtop_get_netload ( &netload, device );
 	midori=(netload_in  && netload_in  != netload.packets_in);
	aka   =(netload_out && netload_out != netload.packets_out);
	if(save_midori != midori) show_maru_2(0,midori);
	if(save_aka    != aka)    show_maru_2(1,aka);
	save_midori=midori; save_aka=aka;
	netload_in=netload.packets_in; netload_out=netload.packets_out;
	return 1; /* 0=stop timer */
}
static void call_timeout_mail(AppletWidget *widget, gpointer data) {
	timeout_mail();
}
static void set_timer_memo(void) {
	if(timer_memo != -1) gtk_timeout_remove(timer_memo);
	if(memo_delay) timer_memo=gtk_timeout_add(memo_delay * (guint32)1000, timeout_memo, applet);
}
static void set_timer_mail(void) {
	if(timer_mail != -1) gtk_timeout_remove(timer_mail);
	if(mail_delay) timer_mail=gtk_timeout_add(mail_delay * (guint32)1000, timeout_mail, applet);
}
static void set_timer_hhl(void) {
	if(timer_hhl != -1) gtk_timeout_remove(timer_hhl);
	if(hhl_delay) timer_hhl=gtk_timeout_add(hhl_delay * (guint32)60000, timeout_hhl, applet);
}
static void set_timer_netload(void) {
	if(timer_netload != -1) gtk_timeout_remove(timer_netload);
	if(netload_delay) timer_netload=gtk_timeout_add(netload_delay,timeout_netload,applet);
}
static void prop_apply_cb (GtkWidget *widget, int page_num, gpointer data) {
	gchar *workname2, *workname3;

	if(page_num != -1) return; /* not my page */
	if(tmp_fg_r != -1) { fg_r = tmp_fg_r; fg_g = tmp_fg_g; fg_b = tmp_fg_b; }
	if(tmp_bg_r != -1) { bg_r = tmp_bg_r; bg_g = tmp_bg_g; bg_b = tmp_bg_b; }
	if(tmp_mfg_r != -1) { mfg_r = tmp_mfg_r; mfg_g = tmp_mfg_g; mfg_b = tmp_mfg_b; }
	if(tmp_mbg_r != -1) { mbg_r = tmp_mbg_r; mbg_g = tmp_mbg_g; mbg_b = tmp_mbg_b; }

	d_get_text(memo, GTK_COMBO(text)->entry);
	d_get_text(memo2,GTK_COMBO(text2)->entry);
	fixed_length = (GTK_TOGGLE_BUTTON(w_fixed_length)->active);
	html_flag    = (GTK_TOGGLE_BUTTON(w_html_flag)->active);
	kernelflag   = (GTK_TOGGLE_BUTTON(w_kernel)->active);
	open_prop    = (GTK_TOGGLE_BUTTON(w_open_prop)->active);
	d_get_text(workname3,w_font1); strcpy(fontname1,workname3);
	d_get_text(workname3,w_font2); strcpy(fontname2,workname3);
	d_get_text(filename,w_filename);
	d_get_text(mail_text,w_mail_text);
	d_get_text(c_select,w_select);
	d_get_text(c_from,w_from);
	d_get_text(c_where,w_where);
	d_get_text(c_group,w_group);
	d_get_text(c_order,w_order);
	d_get_text(c_psql,w_psql);
	d_get_text(shotname,w_shot);
	d_get_text(keyword,w_keyword);
	d_get_text(back_color,w_back_color);
	d_get_text(site_table,w_site_table);
	d_get_text(device,w_device);
	d_get_text(html_name,w_html_name);
	d_get_text(old_file_name,w_old_file_name);
	d_get_text(awk_name,w_awk_name);
	d_get_text(tmp_name,w_tmp_name);
	d_get_text(back_name,w_back_name);
	d_get_text(play_music,w_play_music);
	d_get_text(hhl_path,w_hhl_path);
	isfile = (GTK_TOGGLE_BUTTON(w_isfile)->active);
	if(isfile && (! strlen(filename))) {
		ShowError(_("Required a filename"));
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w_isfile),0);
	}
	d_get_text(command,GTK_COMBO(w_command)->entry);
	d_get_text(usercmd,GTK_COMBO(w_usercmd)->entry);
	d_get_text(pgscmd,GTK_COMBO(w_pgscmd)->entry);
	d_get_text(pgcmd,GTK_COMBO(w_pgcmd)->entry);
	d_get_text(dbcmd,GTK_COMBO(w_dbcmd)->entry);
	d_get_text(ext,w_ext);
	d_get_text(s_calc,w_calc);
	d_get_text(url, GTK_COMBO(w_url )->entry);
	d_get_text(url2,GTK_COMBO(w_url2)->entry);
	d_get_text(url3,GTK_COMBO(w_url3)->entry);
	d_get_text(url4,GTK_COMBO(w_url4)->entry);
	d_get_text(url5,GTK_COMBO(w_url5)->entry);
	d_get_text(address,w_address);
	d_get_text(subject,GTK_COMBO(w_subject)->entry);
	d_get_text(suffix,GTK_COMBO(w_suffix)->entry);
	d_get_text(program,GTK_COMBO(w_program)->entry);
	d_get_text(sounddata,w_sounddata);
	d_get_text(timestamp,w_timestamp);
	check_mail_flag = (GTK_TOGGLE_BUTTON(w_check_mail)->active);
	hhl_valid = (GTK_TOGGLE_BUTTON(w_hhl_valid)->active);
	calc_valid = (GTK_TOGGLE_BUTTON(w_calc_valid)->active);
	netload_valid = (GTK_TOGGLE_BUTTON(w_netload_valid)->active);
	f_nomemo = (GTK_TOGGLE_BUTTON(w_nomemo)->active);
	proxy_only = (GTK_TOGGLE_BUTTON(w_proxy_only)->active);
	display_access = (GTK_TOGGLE_BUTTON(w_display_access)->active);
	present_only = (GTK_TOGGLE_BUTTON(w_present_only)->active);
	new_only = (GTK_TOGGLE_BUTTON(w_new_only)->active);
	hhl_fonly = (GTK_TOGGLE_BUTTON(w_hhl_fonly)->active);
	other_window = (GTK_TOGGLE_BUTTON(w_other_window)->active);
	desc_table = (GTK_TOGGLE_BUTTON(w_desc_table)->active);
	big_font = (GTK_TOGGLE_BUTTON(w_big_font)->active);
	save_output = (GTK_TOGGLE_BUTTON(w_save_output)->active);
	omit_sitename = (GTK_TOGGLE_BUTTON(w_omit_sitename)->active);
	mail_delay = w_mail_delay->value;
	cap_delay = w_cap_delay->value;
	hhl_delay = w_hhl_delay->value; if(hhl_delay < 1) hhl_delay=1;
	netload_delay = w_netload_delay->value; if(netload_delay < 1) netload_delay=1;
	recv_to = w_recv_to->value; if(recv_to < 1) recv_to=1;
	max_retrys = w_max_retrys->value; if(max_retrys < 1) max_retrys=1;
	d_get_text(mail_command,GTK_COMBO(w_mail_command)->entry);
	d_get_text(mail_server,w_mail_server);
	d_get_text(mail_user,w_mail_user);
	d_get_text(mail_passwd2,w_mail_passwd); strcpy(passwd_magic,mail_passwd2);
	strcpy(mail_passwd,passwd_magic); magic1(mail_passwd);
	mail_type = (GTK_TOGGLE_BUTTON(w_type_pop3)->active) ? 0 : 1;
	if(check_mail_flag &&
	   ((! strlen(mail_server)) || (! strlen(mail_user)) || (! strlen(mail_passwd2)))) {
		ShowError(_("Required Server, User, Password"));
		check_mail_flag = 0;
		mail_delay      = 0;
	}
	is_bigb = GTK_TOGGLE_BUTTON(w_bigb)->active;
	is_line1 = (GTK_TOGGLE_BUTTON(w_line2)->active) ? 0 : 1;

	memo_delay = w_memo_delay->value;

	set_timer_memo();
	set_timer_mail(); /* remove timer or reset */
	if(isfile) isfile_updated();
	timeout_memo();
	if(mail_recv_f) { if(tmp_mfg_r != -1 || tmp_mbg_r != -1) update_color_mail(); }
	else            { if(tmp_fg_r  != -1 || tmp_bg_r  != -1) update_color_font_memo(); }
	if(check_mail_flag) timeout_mail();

	applet_widget_sync_config(APPLET_WIDGET(applet));
}
static gint prop_destroy_cb(GtkWidget *widget, gpointer data) {
	propbox=NULL; return FALSE;
}
void read_set_db_cmd() {
	gpointer  gp1;
	gchar     wk2[256];
	FILE      *fin2;

	if(g_list_db) for(node=g_list_db; node; node=node->next) g_free(node->data);
	g_list_db = NULL;
	fin2=fopen(DB_FILE,"r");
	if(fin2 != NULL) {
		while(fgets(wk2,255,fin2) != NULL) {
			cut_m(wk2); gp1 = g_malloc(strlen(wk2)+1);
			strcpy(gp1,wk2); g_list_db = g_list_append(g_list_db,gp1);
		}
		fclose(fin2);
	}
	if(g_list_db == NULL) {
		gp1 = g_malloc(strlen(dummy7)+1); strcpy(gp1,dummy7);
		g_list_db = g_list_append(g_list_db,gp1);
	}
}
void read_set_user_cmd() {
	gpointer  gp1;
	gchar     wk2[256], wk3[256];
	FILE      *fin2;

	if(g_list_ucm) for(node=g_list_ucm; node; node=node->next) g_free(node->data);
	g_list_ucm = NULL;
	sprintf(wk3,"%s%s",home_dir,CMDFILE);
	fin2=fopen(wk3,"r");
	if(fin2 != NULL) {
		while(fgets(wk2,255,fin2) != NULL) {
			cut_m(wk2); gp1 = g_malloc(strlen(wk2)+1);
			strcpy(gp1,wk2); g_list_ucm = g_list_append(g_list_ucm,gp1);
		}
		fclose(fin2);
	}
	if(g_list_ucm == NULL) {
		gp1 = g_malloc(strlen(dummy7)+1); strcpy(gp1,dummy7);
		g_list_ucm = g_list_append(g_list_ucm,gp1);
	}
}
void p_read_cmd (GtkWidget *widget, GtkWidget *s) {
	read_set_user_cmd();
	gtk_combo_set_popdown_strings(GTK_COMBO(w_usercmd),g_list_ucm);
}
void read_set_user_URL() {
	gpointer  gp1;
	gchar     wk2[256], wk3[256];
	FILE      *fin2;

	if(g_list_usr) for(node=g_list_usr; node; node=node->next) g_free(node->data);
	g_list_usr = NULL;
	sprintf(wk3,"%s%s",home_dir,URLFILE);
	fin2=fopen(wk3,"r");
	if(fin2 != NULL) {
		while(fgets(wk2,255,fin2) != NULL) {
			cut_m(wk2); gp1 = g_malloc(strlen(wk2)+1);
			strcpy(gp1,wk2); g_list_usr = g_list_append(g_list_usr,gp1);
		}
		fclose(fin2);
	}
	if(g_list_usr == NULL) {
		gp1 = g_malloc(strlen(dummy7)+1); strcpy(gp1,dummy7);
		g_list_usr = g_list_append(g_list_usr,gp1);
	}
}
void read_set_ext() {
	gpointer  gp1;
	FILE      *fin3;
	gchar     wk4[256], wk5[256];

	if(g_list_ext) for(node=g_list_ext; node; node=node->next) g_free(node->data);
	g_list_ext = NULL;
	sprintf(wk4,"%s%s",home_dir,EXTFILE);
	fin3=fopen(wk4,"r");
	if(fin3 != NULL) {
		while(fgets(wk5,255,fin3) != NULL) {
			cut_m(wk5); gp1 = g_malloc(strlen(wk5)+1); strcpy(gp1,wk5);
			g_list_ext = g_list_append(g_list_ext,gp1);
		}
		fclose(fin3);
	}
	if(g_list_ext == NULL) {
		gp1 = g_malloc(strlen(dummy7)+1); strcpy(gp1,dummy7);
		g_list_ext = g_list_append(g_list_ext,gp1);
	}
}
static void set_properties(AppletWidget *applet, gpointer data) {
	GtkWidget *vbox, *hbox, *table, *b_command, *pixmapw;
	GtkWidget *frame1, *frame2, *frame3, *frame4, *frame5, *frame6, *frame7, *frame8;
	GtkWidget *frame9, *frame10, *frame11;
	GtkWidget *button, *wk, *color_picker1, *color_picker2, *label1;
	GtkWidget *color_picker3, *color_picker4;
	GtkWidget *b_url, *b_url2, *b_url3, *b_url4, *b_url5, *b_ext, *b_pgscmd;
	GtkWidget *b_select, *b_psql, *b_dbcmd, *b_pgcmd;
	GtkWidget *b_shot1, *b_shota, *b_shotr;
	GtkWidget *b_email, *b_sound;
	gchar     w_tim[256], wk3[256];
	glong	  t;
	struct tm *tim;

    if(propbox) { gdk_window_raise(propbox->window); return; }
    propbox= gnome_property_box_new();
    gtk_window_set_title(GTK_WINDOW(propbox),"MemoPanel " VERSION);

	read_set_ext();

	frame3 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame3);
	d_frame_name(frame3,_("URL"));
	/* URL */
	d_hbox1(frame3,hbox); d_pixmap(netscape); d_label(_("URL"));
	g_list_wo1 = NULL;
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.slashdot.org");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.gtk.org");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.redhat.com");
	g_list_wo1 = g_list_append(g_list_wo1,"http://sourceforge.net");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.appwatch.com");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.aclug.org");
	g_list_wo1 = g_list_append(g_list_wo1,"http://bebits.bebits.com");
	g_list_wo1 = g_list_append(g_list_wo1,"http://filmink-online.com");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.geeknews.net");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.hotwired.com");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.linux.de");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.linuxtelephony.org");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.gnu.org");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.debian.org");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.turbolinux.com");
	g_list_wo1 = g_list_append(g_list_wo1,"http://www.slackware.com");
	d_combo_pop(w_url,g_list_wo1,url,460);
	d_go(b_url,_("Go"),b_url_clicked); d_label(_("(World 1)"));
	d_label("  "); d_pixmap(world);
	/* URL4 */
	d_hbox1(frame3,hbox); d_pixmap(netscape); d_label(_("URL")); g_list_wo2 = NULL;
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.linuxtoday.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.linuxlinks.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.root.cz");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.pro-linux.de");
	g_list_wo2 = g_list_append(g_list_wo2,"http://linux.davecentral.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://lwn.net");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.softwarecenter.net");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.theregister.co.uk");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.32bitsonline.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.arstechnica.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://benews.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.icewalkers.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.linux-2000.org");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.linuxdev.net");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.penguinapps.com");
	g_list_wo2 = g_list_append(g_list_wo2,"http://www.balsa.net");
	g_list_wo2 = g_list_append(g_list_wo2,"http://gftp.seul.org");
	g_list_wo2 = g_list_append(g_list_wo2,"http://deja.com");
	d_combo_pop(w_url4,g_list_wo2,url4,460);
	d_go(b_url4,_("Go"),b_url4_clicked); d_label(_("(World 2)"));
	d_label("  "); d_pixmap(world);
	/* URL2 */
	d_hbox1(frame3,hbox); d_pixmap(netscape); d_label(_("URL")); g_list_ja1 = NULL;
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.goo.ne.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://gnome.dti.ad.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.mlb.co.jp/linux");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.redhat.com/jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.turbolinux.co.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.changelog.net");
	g_list_ja1 = g_list_append(g_list_ja1,"http://lc.linux.or.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.laser5.com");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.laser5.co.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://doc-cd.linux.or.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.lbi.gr.jp");
	g_list_ja1 = g_list_append(g_list_ja1,"http://www.linuxcons.gr.jp");
	d_combo_pop(w_url2,g_list_ja1,url2,460);
	d_go(b_url2,_("Go"),b_url2_clicked);
	d_label(_("(Japan 1)")); d_label("  "); d_pixmap(hinomaru);
	/* URL5 */
	d_hbox1(frame3,hbox); d_pixmap(netscape); d_label(_("URL")); g_list_ja2 = NULL;
	g_list_ja2 = g_list_append(g_list_ja2,"http://linux.nikkeibp.co.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://queen.heart.ne.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://xjman.dsl.gr.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://www.pje.linux.or.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://www.linet.gr.jp/~kojima/Plamo");
	g_list_ja2 = g_list_append(g_list_ja2,"http://jrpm.linux.or.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://www.kondara.org");
	g_list_ja2 = g_list_append(g_list_ja2,"http://vinelinux.org");
	g_list_ja2 = g_list_append(g_list_ja2,"http://www.v6.linux.or.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://jg.linux.or.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://www.debian.or.jp");
	g_list_ja2 = g_list_append(g_list_ja2,"http://www.linet.gr.jp/lswg");
	g_list_ja2 = g_list_append(g_list_ja2,"http://ash.or.jp/~LJIG");
	d_combo_pop(w_url5,g_list_ja2,url5,460);
	d_go(b_url5,_("Go"),b_url5_clicked);
	d_label(_("(Japan 2)")); d_label("  "); d_pixmap(hinomaru);
	/* URL3 */
	d_hbox1(frame3,hbox); d_pixmap(netscape); d_label(_("URL"));
	w_url3 = gtk_combo_new(); read_set_user_URL();
	d_combo_pop_body(w_url3,g_list_usr,url3,460);
	d_go(b_url3,_("Go"),b_url3_clicked); d_label("(~/.memopanel)");

	d_hbox1(frame3,hbox); d_pixmap(world); d_label("  ");
	d_url1("http://www.yahoo.com","yahoo.com");
	d_url2("http://www.linux.com","linux.com");
	d_url2("http://www.gnome.org","gnome.org");
	d_url2("http://www.enlightenment.org","E");
	d_url2("http://www.freshmeat.net","freshmeat.net");
	d_url2("http://kernelnotes.org","kernelnotes.org");

	d_hbox1(frame3,hbox); d_pixmap(hinomaru); d_label("  ");
	d_url1("http://www.yahoo.co.jp","yahoo.co.jp");
	d_url2("http://www.linux.or.jp","linux.or.jp");
	d_url2("http://www.linux.co.jp","linux.co.jp");
	d_url2("http://www.ascii.co.jp/linux","ascii/linux");

	d_hbox1(frame3,hbox);
	d_url1("http://kano.technolust.cx/memopanel/",_("MemoPanel Homepage"));

	d_hbox1(frame3,hbox);
	d_url1("http://kano.technolust.cx/hhl/",_("HtmlHeadLine.sh Homepage"));

	frame1 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame1);
	d_frame_name(frame1,_("Memo"));
	/* flag of memo or file */
	d_hbox1(frame1,hbox);
	d_chk_button(w_isfile,_(" Show from HtmlHeadLine.sh "),"isfile1",isfile);
	d_label("              ");
	/* lines */
	w_line1 = gtk_radio_button_new_with_label(NULL,_("1 Line Display"));
	gtk_box_pack_start(GTK_BOX(hbox), w_line1, FALSE, FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(w_line1),"toggled",
			GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_widget_show (w_line1);
	gtk_object_set_data(GTK_OBJECT(propbox),"line1",w_line1);
	g_lines = gtk_radio_button_group(GTK_RADIO_BUTTON(w_line1));

	w_line2 = gtk_radio_button_new_with_label(g_lines,_("2 Lines Display"));
	gtk_box_pack_start (GTK_BOX(hbox), w_line2, FALSE, FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(w_line2),"toggled",
			GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_widget_show(w_line2);
	gtk_object_set_data(GTK_OBJECT(propbox),"line2",w_line2);
	g_lines = gtk_radio_button_group(GTK_RADIO_BUTTON(w_line2));
									   
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON((is_line1) ? w_line1 : w_line2),TRUE);
	/* file name */
	d_hbox1(frame1,hbox); d_label(_(" File name: ")); d_entry(w_filename, filename, 380);
	d_tips(w_filename,_("Filename created by HtmlHeadLine.sh"));
	d_select(w_select_filename,_("select"),filename_select);
	/* fixed length */
	d_label("           ");
	d_chk_button(w_fixed_length,_(" Fixed width "),"fixlen1",fixed_length);
	/* separator */
	d_vbox1(frame1,vbox); d_sep_h(vbox,w_sep_h1);
	/* memo */
	d_hbox1(frame1,hbox); d_pixmap(memo_x); d_label(_(" Memo1: "));
	g_list_txt = NULL;
	g_list_txt = g_list_append(g_list_txt,"%Y%n%m/%d%n%a%n%H:%M");
	g_list_txt = g_list_append(g_list_txt,"%y%n%m/%d%n%a%n%I:%M");
	g_list_txt = g_list_append(g_list_txt,"%Y/%m/%d %a %H:%M ");
	g_list_txt = g_list_append(g_list_txt,"%y/%m/%d %a %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%y/%m/%d %a %H:%M ");
	g_list_txt = g_list_append(g_list_txt,"%m/%d/%y %a %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%m/%d/%y %a %H:%M ");
	g_list_txt = g_list_append(g_list_txt,"%d/%m/%y %a %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%d/%m/%y %a %H:%M ");
	g_list_txt = g_list_append(g_list_txt,"%m/%d %a %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%m/%d %a %H:%M ");
	g_list_txt = g_list_append(g_list_txt,"%Y%n%m/%d%n%J%n%I:%M");
	g_list_txt = g_list_append(g_list_txt,"%Y%n%m/%d%n%J%n%H:%M");
	g_list_txt = g_list_append(g_list_txt,"%Y/%m/%d %J %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%y/%m/%d %J %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%Y/%m/%d %J %H:%M ");
	g_list_txt = g_list_append(g_list_txt,"%m/%d %J %I:%M ");
	g_list_txt = g_list_append(g_list_txt,"%m/%d %J %H:%M ");
	g_list_txt = g_list_append(g_list_txt,_("Meeting "));
	g_list_txt = g_list_append(g_list_txt,_("Dentist "));
	g_list_txt = g_list_append(g_list_txt,_("Hospital "));
	g_list_txt = g_list_append(g_list_txt,_("Visitor "));
	d_combo_pop(text,g_list_txt,memo,520);
	d_tips(GTK_COMBO(text)->entry,
	_("%Y=2000, %y=00, %m=04, %b=Apr, %d=16\n%J=YOBI, %a=Sun\n%H=22, %I=10, %M=20, %n=LF"));
	d_select(w_select_text,_("select"),text_select);
	/* memo2 */
	d_hbox1(frame1,hbox); d_pixmap(memo_x); d_label(_(" Memo2: "));
	g_list_txt2 = NULL;
	g_list_txt2 = g_list_append(g_list_txt2,"%Y%n%m/%d%n%a%n%H:%M");
	g_list_txt2 = g_list_append(g_list_txt2,"%y%n%m/%d%n%a%n%I:%M");
	g_list_txt2 = g_list_append(g_list_txt2,"%Y/%m/%d %a %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%y/%m/%d %a %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%y/%m/%d %a %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%m/%d/%y %a %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%m/%d/%y %a %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%d/%m/%y %a %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%d/%m/%y %a %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%m/%d %a %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%m/%d %a %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%Y%n%m/%d%n%J%n%I:%M");
	g_list_txt2 = g_list_append(g_list_txt2,"%Y%n%m/%d%n%J%n%H:%M");
	g_list_txt2 = g_list_append(g_list_txt2,"%Y/%m/%d %J %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%y/%m/%d %J %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%Y/%m/%d %J %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%m/%d %J %I:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,"%m/%d %J %H:%M ");
	g_list_txt2 = g_list_append(g_list_txt2,_("Meeting "));
	g_list_txt2 = g_list_append(g_list_txt2,_("Dentist "));
	g_list_txt2 = g_list_append(g_list_txt2,_("Hospital "));
	g_list_txt2 = g_list_append(g_list_txt2,_("Visitor "));
	d_combo_pop(text2,g_list_txt2,memo2,520);
	d_tips(GTK_COMBO(text2)->entry,
	_("This is displayed alternately after delay when memo2 is present."));
	d_select(w_select_text2,_("select"),text2_select);
	/* file read delay */
	d_hbox1(frame1,hbox); d_label(_(" Delay (sec): "));
	w_memo_delay = (GtkAdjustment *)gtk_adjustment_new(memo_delay,0.0,99999.0,1.0,10.0,0.0);
	wk = gtk_spin_button_new(w_memo_delay,1,0);
	d_tips(wk,_("STD memo:0, clock:1,30 or 60, from file:5~30"));
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"memo_delay",w_memo_delay);
	gtk_signal_connect_object(GTK_OBJECT(w_memo_delay),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk);
	/* open prop */
	d_label("        ");
	d_chk_button(w_open_prop,_("Put open-property button on memo"),"openprop1",open_prop);
	d_pixmap(maru);
	d_tips(w_open_prop,_("Valid after push Apply button and memopanel restart"));
	/* big button */
	d_label("   ");
	d_chk_button(w_bigb,_("Big button"),"bigbutton1",is_bigb);
	d_tips(w_bigb,_("Valid after push Apply button and memopanel restart"));
	/* Color */
	d_hbox1(frame1,hbox); table = gtk_table_new(1, 6, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(table), GNOME_PAD_SMALL);
	gtk_table_set_col_spacings(GTK_TABLE(table), GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(table), GNOME_PAD_SMALL);
	gtk_box_pack_start(GTK_BOX(hbox), table, FALSE, FALSE, 1);
	gtk_widget_show(table);
	/* fg */
	label = gtk_label_new(_(" Text color:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0);
	gtk_widget_show(label);

	color_picker1 = gnome_color_picker_new();
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(color_picker1), fg_r, fg_g, fg_b, 0);
	gtk_signal_connect(GTK_OBJECT(color_picker1),"color_set",
		GTK_SIGNAL_FUNC(fg_changed_signal), (gpointer *) NULL);
	gtk_signal_connect_object(GTK_OBJECT(color_picker1),"color_set",
		GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_table_attach(GTK_TABLE(table), color_picker1, 1, 2, 0, 1, 0, 0, 0, 0);
	gtk_widget_show(color_picker1);
    /* bg */
    label = gtk_label_new(_(" Background color:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 3, 4, 0, 1, GTK_FILL, 0, 0, 0);
	gtk_widget_show(label);

	color_picker2 = gnome_color_picker_new();
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(color_picker2), bg_r, bg_g, bg_b, 0);
	gtk_signal_connect(GTK_OBJECT(color_picker2),"color_set",
		GTK_SIGNAL_FUNC(bg_changed_signal), (gpointer *) NULL);
	gtk_signal_connect_object(GTK_OBJECT(color_picker2),"color_set",
		GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_table_attach(GTK_TABLE(table), color_picker2, 4, 5, 0, 1, 0, 0, 0, 0);
	gtk_widget_show(color_picker2);
	/* kernel.org for memo */
	d_label("     ");
	d_chk_button(w_kernel,_("Show kernel version"),"kernel1",kernelflag);
	/* f_nomemo */
	d_label("     ");
	d_chk_button(w_nomemo,_("No memo"),"nomemo1",f_nomemo);
	d_tips(w_nomemo,_("Show 4x4 no color box without memo."));
	/* font1 */
	d_hbox1(frame1,hbox);
	button = gnome_stock_button (GNOME_STOCK_BUTTON_FONT);
	d_tips(button,_("English font"));
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_signal_connect_object(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(font1_clicked),NULL);
	gtk_widget_show(button); d_entry(w_font1, fontname1, 560);
	/* font2 */
	d_hbox1(frame1,hbox);
	button = gnome_stock_button (GNOME_STOCK_BUTTON_FONT);
	d_tips(button,_("Non-english font"));
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_signal_connect_object(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(font2_clicked),NULL);
	gtk_widget_show(button); d_entry(w_font2, fontname2, 560);
	/* mail color */
	d_hbox1(frame1,hbox);
	d_label(_(" When mail arraived: "));
	table = gtk_table_new(1, 6, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(table), GNOME_PAD_SMALL);
	gtk_table_set_col_spacings(GTK_TABLE(table), GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(table), GNOME_PAD_SMALL);
	gtk_box_pack_start(GTK_BOX(hbox), table, FALSE, FALSE, 1);
	gtk_widget_show(table);
	/* mail fg */
	label = gtk_label_new(_(" Text color:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0);
	gtk_widget_show(label);

	color_picker3 = gnome_color_picker_new();
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(color_picker3), mfg_r, mfg_g, mfg_b, 0);
	gtk_signal_connect(GTK_OBJECT(color_picker3),"color_set",
		GTK_SIGNAL_FUNC(mfg_changed_signal), (gpointer *) NULL);
	gtk_signal_connect_object(GTK_OBJECT(color_picker3),"color_set",
		GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_table_attach(GTK_TABLE(table), color_picker3, 1, 2, 0, 1, 0, 0, 0, 0);
	gtk_widget_show(color_picker3);
    /* mail bg */
    label = gtk_label_new(_(" Background color:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 3, 4, 0, 1, GTK_FILL, 0, 0, 0);
	gtk_widget_show(label);

	color_picker4 = gnome_color_picker_new();
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(color_picker4), mbg_r, mbg_g, mbg_b, 0);
	gtk_signal_connect(GTK_OBJECT(color_picker4),"color_set",
		GTK_SIGNAL_FUNC(mbg_changed_signal), (gpointer *) NULL);
	gtk_signal_connect_object(GTK_OBJECT(color_picker4),"color_set",
		GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_table_attach(GTK_TABLE(table), color_picker4, 4, 5, 0, 1, 0, 0, 0, 0);
	gtk_widget_show(color_picker4);
	
    /* mail text */
	d_hbox1(frame1,hbox); d_label(_(" Text: ")); d_entry(w_mail_text, mail_text, 580);
	d_tips(w_mail_text,_("Text displayed when mail arrived\n%F=mail count\nEx. %F mail recv"));

	frame2 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame2);
	d_frame_name(frame2,_("AT"));
    /* at */
	d_hbox1(frame2,hbox); d_label(_("Timestamp")); time(&t); tim=localtime(&t);
	sprintf(w_tim,"%02d:%02d %02d/%02d/%02d",
			tim->tm_hour,tim->tm_min,tim->tm_mon+1,tim->tm_mday,tim->tm_year % 100);
	d_entry(w_timestamp, w_tim, 340);
	d_tips(w_timestamp, /* These lengthes are same in window */
	"4pm + 3 days          \n"\
	"10am Jul 31           \n"\
	"1am tomorrow        \n"\
	"MMDDYY              \n"\
	"MM/DD/YY            \n"\
	"DD.MM.YY              \n"\
	"month-name day    \n"\
	"HH:MM                 \n"\
	"midnight (=24:00)   \n"\
	"noon (=12:00)         \n"\
	"teatime (=16:00)    \n"\
	"(man at)              \n"\
	"(/usr/doc/at/timespec)");
	/* E-mail button */
	d_hbox1(frame2,hbox);
	d_go(b_email,_(" Reserve to send an email to yourself"),b_email_clicked);
	d_tips(b_email,_("Reserve by this button")); d_pixmap(mail);
	/* atq */
	d_label("                                            ");
	d_button(w_atq," atq | less ",p_atq);
	/* address */
	d_hbox1(frame2,hbox); d_label(_("        Address: ")); d_entry(w_address, address, 340);
	d_tips(w_address,_("yourself mail address"));
	/* subject */
	d_hbox1(frame2,hbox); d_label(_("        Subject  : "));
	g_list_sub = NULL;
	g_list_sub = g_list_append(g_list_sub,_("Meeting "));
	g_list_sub = g_list_append(g_list_sub,_("Dentist "));
	g_list_sub = g_list_append(g_list_sub,_("Hospital "));
	g_list_sub = g_list_append(g_list_sub,_("Visitor "));
	d_combo_pop(w_subject,g_list_sub,subject,540);
	/* sound button */
	d_hbox1(frame2,hbox); d_go(b_sound,_(" Reserve to play a sound "),b_sound_clicked);
	d_tips(b_sound,_("Reserve by this button")); d_pixmap(sound);
	/* program */
	d_hbox1(frame2,hbox); d_label(_("        Program     : "));
	g_list_prg = NULL;
	g_list_prg = g_list_append(g_list_prg,"wavplay");
	g_list_prg = g_list_append(g_list_prg,"mpg123");
	g_list_prg = g_list_append(g_list_prg,"play");
	g_list_prg = g_list_append(g_list_prg,"xmms");
	g_list_prg = g_list_append(g_list_prg,"xmms -p");
	g_list_prg = g_list_append(g_list_prg,"timidity");
	g_list_prg = g_list_append(g_list_prg,"sidplay");
	g_list_prg = g_list_append(g_list_prg,"aktion");
	g_list_prg = g_list_append(g_list_prg,"xanim");
	d_combo_pop(w_program,g_list_prg,program,460);
	d_select(w_select_program,_("select"),program_select);
	/* data */
	d_hbox1(frame2,hbox); d_label(_("        Sound data: "));
	d_entry(w_sounddata, sounddata, 460);
	d_select(w_select_data,_("select"),data_select);
	/* comment */
	d_hbox1(frame2,hbox); d_label(_("(Apply button does not use to reserve no more)"));

	frame4 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame4);
	d_frame_name(frame4,_("Launch"));
	/* Launcher */
	d_hbox1(frame4,hbox); d_label(_("command"));
	d_hbox1(frame4,hbox);
	g_list_cmd = NULL;
	g_list_cmd = g_list_append(g_list_cmd,"HtmlHeadLine.sh");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c '/usr/sbin/chkfontpath --list|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.memopanel.num'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.memopanel'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.memopanel.ext'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.memopanel.cmd'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.memopanel.one'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.gnome/memopanel1'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim ~/.gnome/memopanel2'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim /tmp/memopanel.db'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'vim /tmp/memopanel.pgcmd'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'rpm -qa|grep ^X|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'xset q|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'env|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'xmodmap -pke|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c '/sbin/ifconfig|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'netstat -rn|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'ps ax --sort=pid|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less /var/log/dmesg'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less /proc/cpuinfo'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less /proc/devices'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less /proc/ioports'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less /proc/modules'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less /proc/interrupts'");
	g_list_cmd = g_list_append(g_list_cmd,"xfontsel");
	g_list_cmd = g_list_append(g_list_cmd,"xcolorsel");
	g_list_cmd = g_list_append(g_list_cmd,"pixmap");
	g_list_cmd = g_list_append(g_list_cmd,"gxset");
	g_list_cmd = g_list_append(g_list_cmd,"kcalc");
	g_list_cmd = g_list_append(g_list_cmd,"gcoo");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'ls -lrt|tail|less'");
	g_list_cmd = g_list_append(g_list_cmd,"xterm -e sh -c 'less ~/for.MemoPanel.dat'");
	g_list_cmd = g_list_append(g_list_cmd,"export FILE_ONLY=YES;HtmlHeadLine.sh");
	g_list_cmd = g_list_append(g_list_cmd,"kterm -e sh -c 'cannacheck -v|less'");
	d_combo_pop(w_command,g_list_cmd,command,560);
	d_select(w_select_command,_("select"),command_select);
	d_go(b_command,_("Go"),b_command_clicked);
	d_hbox1(frame4,hbox); d_label("\n");
	/* separator */
	d_vbox1(frame4,vbox); d_sep_h(vbox,w_sep_h1);
	/* user command */
	d_hbox1(frame4,hbox); d_label(_("user-defined command")); d_label("          ");
	d_button(w_read_cmd,_(" Re-read user-defined command "),p_read_cmd);
	d_hbox1(frame4,hbox); w_usercmd = gtk_combo_new(); read_set_user_cmd();
	d_combo_pop_body(w_usercmd,g_list_ucm,usercmd,600);
	d_go(b_url3,_("Go"),b_usercmd_clicked);
	label1 = gtk_label_new(_("(from ~/.memopanel.cmd)"));
	gtk_box_pack_start(GTK_BOX(frame4),label1,FALSE,TRUE,0); /* TRUE */
	gtk_widget_show(label1);

	frame5 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame5);
	d_frame_name(frame5,_("Ext"));
	/* ext Launcher */
	d_hbox1(frame5,hbox); d_label(_("filename")); d_entry(w_ext, ext, 480);
	d_select(w_select_ext,_("select"),ext_select);
	d_go(b_ext,_("Go"),b_ext_clicked);
	label1 = gtk_label_new(_("(from ~/.memopanel.ext)"));
	gtk_box_pack_start(GTK_BOX(frame5),label1,FALSE,TRUE,0); /* TRUE */
	gtk_widget_show(label1);

	frame6 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame6);
	d_frame_name(frame6,_("Mail"));
	/* mail check */
	d_hbox1(frame6,hbox);
	d_chk_button(w_check_mail,_("Check mail"),"checkmail1",check_mail_flag);
	d_pixmap(mail); d_pixmap(eyes);
	/* mail check delay */
	d_label("                           "); d_label(_(" Delay (sec): "));
	w_mail_delay = (GtkAdjustment *)gtk_adjustment_new(mail_delay,0.0,99999.0,1.0,10.0,0.0);
	wk = gtk_spin_button_new(w_mail_delay,1,0);
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"maildelay",w_mail_delay);
	gtk_signal_connect_object(GTK_OBJECT(w_mail_delay),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk);
	/* mail command */
	d_hbox1(frame6,hbox); d_label(_(" Command to execute when new mail arrives: "));
	d_hbox1(frame6,hbox);
	g_list_mcm = NULL;
	g_list_mcm = g_list_append(g_list_mcm,"sylpheed");
	g_list_mcm = g_list_append(g_list_mcm,"nmail4");
	g_list_mcm = g_list_append(g_list_mcm,"balsa --checkmail");
	g_list_mcm = g_list_append(g_list_mcm,"balsa");
	d_combo_pop(w_mail_command,g_list_mcm,mail_command,480);
	d_select(w_select_mail_cmd,_("select"),mail_cmd_select);
	/* mail server */
	d_hbox1(frame6,hbox); d_label(_("      Server: ")); d_entry(w_mail_server, mail_server, 380);
	d_tips(w_mail_server,_("Format is <URL>[:<PORT>]"));
	/* mail user */
	d_hbox1(frame6,hbox); d_label(_("         User: ")); d_entry(w_mail_user, mail_user, 280);
	/* mail passwd */
	d_hbox1(frame6,hbox); d_label(_(" Password: "));
	w_mail_passwd = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(w_mail_passwd), passwd_magic);
	gtk_entry_set_visibility(GTK_ENTRY(w_mail_passwd), FALSE); /* special */
	gtk_signal_connect_object(GTK_OBJECT(w_mail_passwd),"changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_box_pack_start(GTK_BOX(hbox),w_mail_passwd,FALSE,FALSE,0);
	gtk_widget_set_usize(w_mail_passwd,280,24); gtk_widget_show(w_mail_passwd);
	/* mail_type */
	d_hbox1(frame6,hbox);
	w_type_pop3 = gtk_radio_button_new_with_label(NULL,_("POP3"));
	gtk_box_pack_start(GTK_BOX(hbox), w_type_pop3, FALSE, FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(w_type_pop3),"toggled",
			GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_widget_show (w_type_pop3);
	gtk_object_set_data(GTK_OBJECT(propbox),"typepop3",w_type_pop3);
	g_mail_type = gtk_radio_button_group(GTK_RADIO_BUTTON(w_type_pop3));

	w_type_imap = gtk_radio_button_new_with_label(g_mail_type,_("IMAP"));
	gtk_box_pack_start (GTK_BOX(hbox), w_type_imap, FALSE, FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(w_type_imap),"toggled",
			GTK_SIGNAL_FUNC(gnome_property_box_changed), GTK_OBJECT(propbox));
	gtk_widget_show(w_type_imap);
	gtk_object_set_data(GTK_OBJECT(propbox),"typeimap",w_type_imap);
	g_mail_type = gtk_radio_button_group(GTK_RADIO_BUTTON(w_type_imap));
									   
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON((mail_type) ? w_type_imap : w_type_pop3),TRUE);

	frame7 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame7);
	d_frame_name(frame7,_("pgSQL"));
	/* postgresSQL help */
	d_hbox1(frame7,hbox); d_label(_("DATABASE: ")); read_set_db_cmd();
	w_dbcmd = gtk_combo_new(); d_combo_pop_body(w_dbcmd,g_list_db,dbcmd,200);
	d_tips(GTK_COMBO(w_dbcmd)->entry,_("At first, need to select a database"));
	d_go(b_dbcmd,_(" Get psql cmd "),b_dbcmd_clicked);
	d_tips(b_dbcmd,_("For help cmd. Valid after next property opened"));
	/* html falg */
	d_label("              ");
	d_chk_button(w_html_flag,_(" HTML flag "),"htmlfalg1",html_flag);
	d_tips(w_html_flag,_("Display an output of psql or select by netscape"));

	d_hbox1(frame7,hbox); d_label(_("HELP: ")); read_set_pgcmd();
	w_pgcmd = gtk_combo_new(); d_combo_pop_body(w_pgcmd,g_list_pgcmd,pgcmd,220);
	d_tips(GTK_COMBO(w_pgcmd)->entry,_("Display a help by vim"));
	d_go(b_pgcmd,_("Go"),b_pgcmd_clicked);

	d_label("        "); d_label(_("Misc: ")); read_set_pgcmd();
	g_list_pgs = NULL;
	g_list_pgs = g_list_append(g_list_pgs,"\\?");
	g_list_pgs = g_list_append(g_list_pgs,"\\df");
	g_list_pgs = g_list_append(g_list_pgs,"\\do");
	g_list_pgs = g_list_append(g_list_pgs,"\\dS");
	g_list_pgs = g_list_append(g_list_pgs,"\\dt");
	g_list_pgs = g_list_append(g_list_pgs,"\\dT");
	g_list_pgs = g_list_append(g_list_pgs,"\\l");
	g_list_pgs = g_list_append(g_list_pgs,"\\z");
	g_list_pgs = g_list_append(g_list_pgs,"\\h");
	g_list_pgs = g_list_append(g_list_pgs,"\\h *");
	g_list_pgs = g_list_append(g_list_pgs,"option -l");
	g_list_pgs = g_list_append(g_list_pgs,"postmast");
	g_list_pgs = g_list_append(g_list_pgs,"rpm-postgresql");
	w_pgscmd = gtk_combo_new(); d_combo_pop_body(w_pgscmd,g_list_pgs,pgscmd,220);
	d_tips(GTK_COMBO(w_pgscmd)->entry,_("Escape cmd or postmaster status"));
	d_go(b_pgscmd,_("Go"),b_pgscmd_clicked);
	/* separator */
	d_vbox1(frame7,vbox); d_sep_h(vbox,w_sep_h1);
	/* postgreSQL select */
	d_hbox1(frame7,hbox); d_label("SELECT ");   d_entry(w_select, c_select, 580);
	d_tips(w_select,
	"SELECT [DISTINCT [ON attrN]] expr1 [AS attr1], ...exprN [INTO [TEMP] [TABLE] class_name]");
	d_hbox1(frame7,hbox); d_label("FROM ");     d_entry(w_from,   c_from,   580);
	d_tips(w_from,"[FROM from_list]");
	d_hbox1(frame7,hbox); d_label("WHERE ");    d_entry(w_where,  c_where,  580);
	d_tips(w_where,"[WHERE qual]");
	d_hbox1(frame7,hbox); d_label("GROUP BY "); d_entry(w_group,  c_group,  540);
	d_tips(w_group,"[GROUP BY group_list] "
				   "[HAVING having_clause] "
				   "[ { UNION [ALL] | INTERSECT | EXCEPT } SELECT ...]");
	d_hbox1(frame7,hbox); d_label("ORDER BY "); d_entry(w_order,  c_order,  520);
	d_tips(w_order,"[ORDER BY attr1 [ASC|DESC] [USING op1], ...attrN ] "
				   "[FOR UPDATE [OF class_name...]] "
				   "[LIMIT count [OFFSET|, count]]");
	d_label(" "); d_go(b_select,_("Go"),b_select_clicked);
	/* separator */
	d_vbox1(frame7,vbox); d_sep_h(vbox,w_sep_h1);
	/* psql cmd */
	d_hbox1(frame7,hbox); d_label("psql: ");    d_entry(w_psql,   c_psql,   560);
	d_tips(w_psql,_("any command by psql"));
	d_label(" "); d_go(b_psql,_("Go"),b_psql_clicked);

	frame8 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame8);
	d_frame_name(frame8,_("Capture"));
	/* screen shot */
	d_hbox1(frame8,hbox);
	d_label("\n"); d_label(_("At first, please enter filename.")); d_label("\n");
	d_hbox1(frame8,hbox); d_label(_("Output filename: "));

	d_entry(w_shot,shotname,360);
	g_list_suf = NULL;
	g_list_suf = g_list_append(g_list_suf,".jpg");
	g_list_suf = g_list_append(g_list_suf,".png");
	g_list_suf = g_list_append(g_list_suf,".miff");
	g_list_suf = g_list_append(g_list_suf,".eps");
	g_list_suf = g_list_append(g_list_suf,".tiff");
	g_list_suf = g_list_append(g_list_suf,".jpeg");
	d_combo_pop(w_suffix,g_list_suf,suffix,80);
	
	d_hbox1(frame8,hbox); d_label(" ");
	/* separator */
	d_vbox1(frame8,vbox); d_sep_h(vbox,w_sep_h1);
	d_hbox1(frame8,hbox); d_label(" ");

	d_hbox1(frame8,hbox);
	d_label("      "); d_go(b_shot1,_(" Capture single window "),b_shot1_clicked);
	d_tips(b_shot1,_("After push this button, please specify a window"));
	d_label("      "); d_go(b_shotr,_(" Capture rectangular portion "),b_shot1_clicked);
	d_tips(b_shotr,_("After push this button, please drag a rectangle"));

	d_hbox1(frame8,hbox); d_label(" ");
	/* separator */
	d_vbox1(frame8,vbox); d_sep_h(vbox,w_sep_h1);
	/* capture delay */
	d_hbox1(frame8,hbox); d_label(" ");

	d_hbox1(frame8,hbox); d_label(_("Delay until capture entire screen (sec): "));
	w_cap_delay = (GtkAdjustment *)gtk_adjustment_new(cap_delay,0.0,60.0,1.0,5.0,0.0);
	wk = gtk_spin_button_new(w_cap_delay,1,0);
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"capdelay",w_cap_delay);
	gtk_signal_connect_object(GTK_OBJECT(w_cap_delay),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk);
	d_label("      "); d_go(b_shota,_(" Capture entire screen "),b_shota_clicked);

	d_hbox1(frame8,hbox); d_label(" ");
	/* separator */
	d_vbox1(frame8,vbox); d_sep_h(vbox,w_sep_h1);
	d_hbox1(frame8,hbox); d_label("\n\n"); d_label(_("(This function requires ImageMagick)"));

	frame9 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame9);
	d_frame_name(frame9,_("HHL"));
	/* HtmlHeadLine */
	
	d_hbox1(frame9,hbox);
	
	d_chk_button(w_hhl_valid,_("Valid"),"validhhl1",hhl_valid);
	d_tips(w_hhl_valid,_("This button controls to execute HtmlHeadLine.sh"));
	d_label(" ");

	d_chk_button(w_proxy_only,"PROXY_ONLY","proxyonly1",proxy_only);
	d_tips(w_proxy_only,_("This button controls to access from proxy"));
	d_label(" ");

	d_chk_button(w_other_window,"OTHER_WINDOW","otherwindow1",other_window);
	d_tips(w_other_window,_("All of the links open up in a new netscape window"));
	d_label(" ");

	d_chk_button(w_desc_table,"DESC_TABLE","desctable1",desc_table);
	d_tips(w_desc_table,_("Description is displayed under a title"));
	d_label(" ");

	d_chk_button(w_omit_sitename,"OMIT_SITENAME","omitsitename1",omit_sitename);
	d_tips(w_omit_sitename,_("Omit a site name for FILE_ONLY"));
	d_label(" ");

	d_hbox1(frame9,hbox);

	d_chk_button(w_save_output,"SAVE_OUTPUT","saveoutput1",save_output);
	d_tips(w_save_output,_("Save an output html file"));
	d_label(" ");

	d_chk_button(w_big_font,"BIG_FONT","bigfont1",big_font);
	d_tips(w_big_font,_("This bumped the program titles up one font size"));
	d_label(" ");

	d_chk_button(w_hhl_fonly,"FILE_ONLY","fileonly1",hhl_fonly);
	d_tips(w_hhl_fonly,_("Filename is same in memo frame"));
	d_label("   ");
	/* RECV_TIMEOUT */
	d_label(_("RECV_TIMEOUT (seconds): "));
	w_recv_to = (GtkAdjustment *)gtk_adjustment_new(recv_to,1.0,99999.0,1.0,10.0,0.0);
	wk = gtk_spin_button_new(w_recv_to,1,0);
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"recvtimeout1",w_recv_to);
	gtk_signal_connect_object(GTK_OBJECT(w_recv_to),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk);

	d_hbox1(frame9,hbox);
	
	d_chk_button(w_display_access,"DISPLAY_ACCESS","displayaccess1",display_access);
	d_tips(w_display_access,_("This button controls to display site name and number"));
	d_label(" ");

	d_chk_button(w_present_only,"PRESENT_ONLY","presentonly1",present_only);
	d_tips(w_present_only,_("This button controls to display site name when data is new and present"));
	d_label(" ");

	d_chk_button(w_new_only,"NEW_ONLY","newonly1",new_only);
	d_tips(w_new_only,_("This button controls to display only new headlines"));

	d_hbox1(frame9,hbox);

	/* back color */
	d_label("BACK_COLOR: "); d_entry(w_back_color,back_color,140);
	d_tips(w_back_color,_("background color in html")); d_label("         ");
	/* keyword */
	d_label("KEYWORD: "); d_entry(w_keyword,keyword,240);
	d_tips(w_keyword,_("Play a sound when this keyword was included in headlines"));
	/* play music */
	d_hbox1(frame9,hbox);
	d_label("PLAY_MUSIC: "); d_entry(w_play_music,play_music,380);
	d_label(" > /dev/null 2>&1");
	d_tips(w_play_music,_("Play a sound when this keyword was included in headlines"));
	/* old file name */
	d_hbox1(frame9,hbox);
	d_label("OLD_FILE_NAME: "); d_entry(w_old_file_name,old_file_name,480);
	d_tips(w_old_file_name,_("This is a name of a saved file"));
	/* html name */
	d_hbox1(frame9,hbox);
	d_label("HTML_NAME: "); d_entry(w_html_name,html_name,480);
	d_tips(w_html_name,_("This is a name of an output html file"));
	/* site table */
	d_hbox1(frame9,hbox);
	d_label("SITE_TABLE: "); d_entry(w_site_table,site_table,400);
	d_select(w_select_site,_("select"),site_table_select);
	d_tips(w_site_table,_("Can change a directory of site table"));
	/* path */
	d_hbox1(frame9,hbox);
	d_label(_("HtmlHeadLine.sh path: ")); d_entry(w_hhl_path,hhl_path,400);
	d_select(w_select_hhl,_("select"),hhl_path_select);
	d_tips(w_hhl_path,_("Required"));

	d_hbox1(frame9,hbox);

	/* MAX_RETRYS */
	d_label("MAX_RETRYS: ");
	w_max_retrys = (GtkAdjustment *)gtk_adjustment_new(max_retrys,1.0,99999.0,1.0,10.0,0.0);
	wk = gtk_spin_button_new(w_max_retrys,1,0);
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"maxretrys1",w_max_retrys);
	gtk_signal_connect_object(GTK_OBJECT(w_max_retrys),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk); d_label("  ");
	/* HHL delay */
	d_label(_("Delay (minutes): "));
	w_hhl_delay = (GtkAdjustment *)gtk_adjustment_new(hhl_delay,1.0,99999.0,1.0,10.0,0.0);
	wk = gtk_spin_button_new(w_hhl_delay,1,0);
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"hhldelay1",w_hhl_delay);
	gtk_signal_connect_object(GTK_OBJECT(w_hhl_delay),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk); d_label("  ");
	d_tips(wk,_("Periodical run"));

	d_label("AWK_NAME: "); d_entry(w_awk_name,awk_name,140);
	d_tips(w_awk_name,_("This is a name of an awk"));

	/* temporary dir name */
	d_hbox1(frame9,hbox);
	d_label("TMP: "); d_entry(w_tmp_name,tmp_name,480);
	d_tips(w_tmp_name,_("This is a name of a temporary directory"));

	/* background file name */
	d_hbox1(frame9,hbox);
	d_label("BACKGROUND: "); d_entry(w_back_name,back_name,480);
	d_select(w_select_back_name,_("select"),back_name_select);
	d_tips(w_back_name,_("This is a name of a background file"));

	/* comment */	
	d_hbox1(frame9,hbox);
	d_label(_("(Valid after push Apply button and memopanel restart)"));

	frame10 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame10);
	d_frame_name(frame10,_("NetLoad"));
	d_hbox1(frame10,hbox);
	d_chk_button(w_netload_valid,_("Valid"),"validnetload1",netload_valid);
	d_tips(w_netload_valid,_("This button controls to show Network load"));
	/* device */
	d_hbox1(frame10,hbox);
	d_label(_("Device: ")); d_entry(w_device,device,150);
	d_tips(w_device,_("Network device like 'eth0' "));
	/* netload delay */
	d_hbox1(frame10,hbox);
	d_label(_("Delay (miliseconds): "));
	w_netload_delay = (GtkAdjustment *)gtk_adjustment_new(netload_delay,5.0,99999.0,1.0,10.0,0.0);
	wk = gtk_spin_button_new(w_netload_delay,1,0);
	gtk_widget_set_usize(wk,70,0);
	gtk_box_pack_start(GTK_BOX(hbox),wk,FALSE,FALSE,0);
	gtk_object_set_data(GTK_OBJECT(propbox),"netloaddelay1",w_netload_delay);
	gtk_signal_connect_object(GTK_OBJECT(w_netload_delay),"value_changed",
		GTK_SIGNAL_FUNC(gnome_property_box_changed),GTK_OBJECT(propbox));
	gtk_widget_show(wk);
	d_tips(wk,_("Small value is not recommended"));
	d_hbox1(frame10,hbox); d_label(" ");
	/* comment */	
	d_hbox1(frame10,hbox);
	d_label("( ");		 d_pixmap(maru_km); d_pixmap(maru_am);
	d_label(_(" and ")); d_pixmap(maru_ka); d_pixmap(maru_aa);
	d_label(_(" are used to display )"));
	d_hbox1(frame10,hbox);
	d_label(_("(This function is required to put open-property button on memo)"));
	d_hbox1(frame10,hbox);
	d_label(_("(Valid after push Apply button and memopanel restart)"));

	frame11 = gtk_vbox_new(FALSE, 1); gtk_widget_show(frame11);
	d_frame_name(frame11,_("Calc"));
	/* valid */
	d_hbox1(frame11,hbox);
	d_chk_button(w_calc_valid,_("Valid"),"validcalc1",calc_valid);
	d_tips(w_calc_valid,_("This button controls to call calculator"));
	/* calculator */
	d_hbox1(frame11,hbox); d_label(_("filename")); d_entry(w_calc, s_calc, 480);
	d_select(w_select_calc,_("select"),calc_select);
	gtk_widget_show(label1);
	/* comment */	
	d_hbox1(frame11,hbox);
	d_label("( "); d_pixmap(calc); d_label(_(" is used to run on memo )"));
	d_hbox1(frame11,hbox);
	d_label(_("(Valid after push Apply button and memopanel restart)"));

	/* Apply */
    gtk_signal_connect(GTK_OBJECT(propbox),"apply",  GTK_SIGNAL_FUNC(prop_apply_cb),NULL);
    gtk_signal_connect(GTK_OBJECT(propbox),"destroy",GTK_SIGNAL_FUNC(prop_destroy_cb),NULL);

    gtk_widget_show(propbox);
}
void show_memo_widget() {
	gtk_container_add(GTK_CONTAINER(labelframe),labelbox);
	gtk_widget_show(labelbox);

	if(f_nomemo && (! mail_recv_f))
		labelmemo = gnome_pixmap_new_from_xpm_d(nomemo);
	else
		labelmemo = gtk_label_new((not_orient) ? _("Memo") : memo);

	gtk_box_pack_start_defaults(GTK_BOX(labelbox),labelmemo);
	gtk_widget_show(labelmemo);

	if(open_prop && w_hvbox != NULL) {
		gtk_box_pack_start_defaults(GTK_BOX(labelbox),w_hvbox);
		gtk_widget_show(w_hvbox);

		w_label_button = gtk_button_new();
		if(is_bigb)
			gtk_box_pack_end(GTK_BOX(w_hvbox),w_label_button,TRUE,TRUE,0);
		else {
			gtk_widget_set_usize(GTK_WIDGET(w_label_button),8,8);
			gtk_box_pack_end(GTK_BOX(w_hvbox),w_label_button,FALSE,FALSE,0);
		}
		d_tips(w_label_button,_("open property"));
		s_label_button = gtk_signal_connect(GTK_OBJECT(w_label_button),
					"clicked",GTK_SIGNAL_FUNC(set_properties),0);
		gtk_widget_show(w_label_button);

		w_label_pixmap = gnome_pixmap_new_from_xpm_d(maru);
		gtk_container_add(GTK_CONTAINER(w_label_button),w_label_pixmap);
		gtk_widget_show(w_label_pixmap);

		if(calc_valid) {
			w_calc_button = gtk_button_new();
			if(is_bigb)
				gtk_box_pack_end(GTK_BOX(w_hvbox),w_calc_button,TRUE,TRUE,0);
			else {
				gtk_widget_set_usize(GTK_WIDGET(w_calc_button),8,8);
				gtk_box_pack_end(GTK_BOX(w_hvbox),w_calc_button,FALSE,FALSE,0);
			}
			d_tips(w_calc_button,_("call calculator"));
			s_label_button = gtk_signal_connect(GTK_OBJECT(w_calc_button),
						"clicked",GTK_SIGNAL_FUNC(call_calculator),0);
			gtk_widget_show(w_calc_button);

			w_label_pixmap = gnome_pixmap_new_from_xpm_d(calc);
			gtk_container_add(GTK_CONTAINER(w_calc_button),w_label_pixmap);
			gtk_widget_show(w_label_pixmap);
		}

		if(netload_valid) {
			/* midori */
			w_label_button1 = gtk_button_new();
			gtk_widget_set_usize(GTK_WIDGET(w_label_button1),8,8);
			gtk_box_pack_start(GTK_BOX(w_hvbox),w_label_button1,FALSE,FALSE,0);
			gtk_widget_show(w_label_button1);
			w_label_pixmap1 = gnome_pixmap_new_from_xpm_d(maru_km);
			gtk_container_add(GTK_CONTAINER(w_label_button1),w_label_pixmap1);
			gtk_widget_show(w_label_pixmap1);
			d_tips(w_label_button1,_("libgtop network load packets in"));
			/* aka */
			w_label_button2 = gtk_button_new();
			gtk_widget_set_usize(GTK_WIDGET(w_label_button2),8,8);
			gtk_box_pack_start(GTK_BOX(w_hvbox),w_label_button2,FALSE,FALSE,0);
			gtk_widget_show(w_label_button2);
			w_label_pixmap2 = gnome_pixmap_new_from_xpm_d(maru_ka);
			gtk_container_add(GTK_CONTAINER(w_label_button2),w_label_pixmap2);
			gtk_widget_show(w_label_pixmap2);
			d_tips(w_label_button2,_("libgtop network load packets out"));
		}
	}
}
static void change_maru() {
	gchar s_mail[256], buf2[256], buf3[256], *p;
	if(s_label_button !=    0) gtk_signal_disconnect(GTK_OBJECT(w_label_button),s_label_button);
	if(w_label_pixmap != NULL) gtk_widget_destroy(w_label_pixmap);
	if(w_hvbox        != NULL) gtk_widget_destroy(w_hvbox);
	if(w_label_button != NULL) gtk_widget_destroy(w_label_button);
	if(labelmemo      != NULL) gtk_widget_destroy(labelmemo);
	if(labelbox       != NULL) gtk_widget_destroy(labelbox);
	if(save_orient == ORIENT_LEFT || save_orient == ORIENT_RIGHT) {
		labelbox = gtk_vbox_new(FALSE, FALSE);
		w_hvbox  = gtk_hbox_new(FALSE, FALSE);
	}
	else {
		labelbox = gtk_hbox_new(FALSE, FALSE);
		w_hvbox  = gtk_vbox_new(FALSE, FALSE);
	}
	strcpy(save_memo,"???");
	show_memo_widget();
	if(mail_recv_f) {
		if(strlen(mail_text)) 
			strcpy(s_mail,mail_text); p=strstr(s_mail,"%F");
			if(p != NULL) {
				strcpy(buf2,p+2); *p='\0'; sprintf(buf3,"%d",save_nom);
				strcat(s_mail,buf3); strcat(s_mail,buf2);
			}	
		else
			sprintf(s_mail,"%d%smail%s%srecv%s",save_nom,
				(save_orient == ORIENT_LEFT || save_orient == ORIENT_RIGHT) ? "%n" : " ",
				(save_nom > 1) ? "s" : "",
				(save_orient == ORIENT_LEFT || save_orient == ORIENT_RIGHT) ? "%n" : " ",
				(save_orient == ORIENT_DOWN || save_orient == ORIENT_UP) ? " " : "");
		strftime_memo(s_mail); update_color_mail();
	}
	else {
		timeout_memo(); update_color_font_memo();
	}
}
static void applet_change_orient(GtkWidget *w, PanelOrientType o, gpointer data) {
	save_orient = o; not_orient=0;
	if(open_prop) change_maru();
	else { strcpy(save_memo,"???"); timeout_memo(); update_color_font_memo(); }
}
static void clear_m_count (AppletWidget *widget, gpointer data) {
	FILE      *fin3;
	gchar     wk4[256];

	g_static_mutex_lock (&mutex);
	sprintf(wk4,"%s%s",home_dir,NUMFILE);
	fin3=fopen(wk4,"w");
	if(fin3 != NULL) { fprintf(fin3,"0"); fclose(fin3); }
	g_static_mutex_unlock (&mutex);
}
void get_num_of_me(int plus1) {
	FILE      *fin3;
	gchar     wk4[256], wk5[256];

	g_static_mutex_lock (&mutex);
	sprintf(wk4,"%s%s",home_dir,NUMFILE);
	fin3=fopen(wk4,"r+");
	if(fin3 != NULL) {
		if(fgets(wk5,255,fin3) != NULL) {
			num_of_memopanel = MAX(atoi(wk5) + ((plus1) ? 1 : -1), 0);
			rewind(fin3); fprintf(fin3,"%d",num_of_memopanel);
		}
		else {
			num_of_memopanel = (plus1) ? 1 : 0;
			rewind(fin3); fprintf(fin3,"%d",num_of_memopanel);
		}
		fclose(fin3);
	}
	else {
		fin3=fopen(wk4,"w");
		if(fin3 != NULL) {
			num_of_memopanel = (plus1) ? 1 : 0;
			fprintf(fin3,"%d",num_of_memopanel);
			fclose(fin3);
		}
	}
	g_static_mutex_unlock (&mutex);
}
void dusting() {
	if(timer_cap     != -1) gtk_timeout_remove(timer_cap);
	if(timer_memo    != -1) gtk_timeout_remove(timer_memo);
	if(timer_mail    != -1) gtk_timeout_remove(timer_mail);
	if(timer_hhl     != -1) gtk_timeout_remove(timer_hhl);
	if(timer_netload != -1) gtk_timeout_remove(timer_netload);
	if(g_list_ext) {
		for(node=g_list_ext; node; node=node->next) g_free(node->data); g_list_ext = NULL;
	}
	if(g_list_usr) {
		for(node=g_list_usr; node; node=node->next) g_free(node->data); g_list_usr = NULL;
	}
	if(g_list_ucm) {
		for(node=g_list_ucm; node; node=node->next) g_free(node->data); g_list_ucm = NULL;
	}
	if(g_list_isfile) {
		for(node=g_list_isfile; node; node=node->next) g_free(node->data); g_list_isfile = NULL;
	}
	if(g_list_db) {
		for(node=g_list_db; node; node=node->next) g_free(node->data); g_list_db = NULL;
	}
	if(g_list_pgcmd) {
		for(node=g_list_pgcmd; node; node=node->next) g_free(node->data); g_list_pgcmd = NULL;
	}
	if(! one_only) get_num_of_me(FALSE);
}
int main(int argc, char **argv) {
	GtkWidget *vbox;
	gchar     buf[256], *work7, work8[256], *p_lang;

	/* i18n */
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	glibtop_init();
	applet_widget_init("memopanel", NULL, argc, argv, NULL,0,NULL);
	tmp_fg_r = tmp_fg_g = tmp_fg_b = tmp_bg_r = tmp_bg_g = tmp_bg_b = -1;
	tmp_mfg_r = tmp_mfg_g = tmp_mfg_b = tmp_mbg_r = tmp_mbg_g = tmp_mbg_b = -1;
	strcpy(home_dir,g_get_home_dir());
	applet = applet_widget_new("memopanel");
	if (!applet) g_error(_("Can't create memopanel applet!\n"));
	sprintf(work8,"%s/.memopanel.one",home_dir);
	one_only = g_file_exists(work8);
	if(one_only) num_of_memopanel=1; else get_num_of_me(TRUE);
	strcpy(save_mtime,""); strcpy(save_memo,"");
	gnome_execute_shell(NULL,"memopanel.psql.sh database");
	strcpy(lang,""); if((p_lang=getenv("LANG")) != NULL) strcpy(lang,p_lang);

	g_snprintf(buf,255,"memopanel%d/",num_of_memopanel);
	gnome_config_push_prefix(buf);
	d_get_str(memo,        "memo",     "%Y%n%m/%d%n%a%n%I:%M");
	d_get_str(memo2,       "memo2",    "%Y%n%m/%d%n%a%n%I:%M");
	d_get_int(isfile,      "isfile",   "0");
	d_get_str(filename,    "filename", "/tmp/for.MemoPanel.dat");
	d_get_str(mail_text,   "mail_text","%F mails recv");
	d_get_str(address,     "address",  "yourself mail address");
	d_get_str(subject,     "subject",  "important reservation");
	d_get_str(suffix,      "suffix",   ".jpg");
	d_get_str(program,     "program",  "/usr/bin/mpg123");
	d_get_str(sounddata,   "sounddata","/root/sample.mp3");
	d_get_int(memo_delay,  "delay", "0");
	d_get_int(kernelflag,  "kernel","0");
	d_get_int(open_prop,   "open_prop","0");
	d_get_int(fixed_length,"fixlen","0");
	d_get_int(html_flag,   "htmlf", "0");
	d_get_int(mfg_r,       "mfg_r", "65535");
	d_get_int(mfg_g,       "mfg_g", "65535");
	d_get_int(mfg_b,       "mfg_b", "0");
	d_get_int(mbg_r,       "mbg_r", "65535");
	d_get_int(mbg_g,       "mbg_g", "0");
	d_get_int(mbg_b,       "mbg_b", "0");
	d_get_int(fg_r,        "fg_r",  "65535");
	d_get_int(fg_g,        "fg_g",  "65535");
	d_get_int(fg_b,        "fg_b",  "0");
	d_get_int(bg_r,        "bg_r",  "9175");
	d_get_int(bg_g,        "bg_g",  "9175");
	d_get_int(bg_b,        "bg_b",  "45874");
	d_get_str(c_select,    "select","*");
	d_get_str(c_from,      "from",  "");
	d_get_str(c_where,     "where", "");
	d_get_str(c_group,     "group", "");
	d_get_str(c_order,     "order", "pid");
	d_get_str(c_psql,      "psql",  "");
	d_get_str(dbcmd,       "dbcmd", "");
	d_get_str(pgcmd,       "pgcmd", "");
	d_get_str(pgscmd,      "pgscmd","");
	d_get_str(command,     "command","gcoo");
	d_get_str(usercmd,     "usercmd","");
	d_get_str(url,         "url",  "www.slashdot.org");
	d_get_str(url2,        "url2", "www.goo.ne.jp");
	d_get_str(url3,        "url3", "");
	d_get_str(url4,        "url4", "www.linuxtoday.com");
	d_get_str(url5,        "url5", "linux.nikkeibp.co.jp");
	d_get_str(shotname,    "shotname", "sample");
	d_get_str(keyword,     "keyword",  "keyword sample");
	d_get_str(back_color,  "back_color","#e6e6fa");
	d_get_str(site_table,  "site_table","/usr/local/bin/SITES.table");
	d_get_str(device,      "device","eth0");
	d_get_str(html_name,   "html_name","");
	d_get_str(old_file_name,"old_file_name","");
	d_get_str(awk_name,    "awk_name","");
	d_get_str(tmp_name,    "tmp_name","");
	d_get_str(back_name,   "back_name","");
	d_get_str(play_music,  "play_music","/usr/local/bin/wavplay /tmp/Bweep.wav");
	d_get_str(hhl_path,    "hhl_path", "/usr/local/bin/HtmlHeadLine.sh");
	d_get_str(ext,         "ext",  "/root/sample.mp3");
	d_get_str(s_calc,      "calc", "gxcalc");
	d_get_str(work7,       "font1","-adobe-utopia-bold-r-normal-*-*-180-*-*-p-*-iso8859-1");
	strcpy(fontname1,work7);
	d_get_str(work7,       "font2","*"); strcpy(fontname2,work7);
	d_get_int(check_mail_flag,"check_mail",  "0");
	d_get_int(hhl_valid,   "hhl_valid",   "0");
	d_get_int(calc_valid,  "calc_valid",  "0");
	d_get_int(netload_valid,"netload_valid","0");
	d_get_int(f_nomemo,    "f_nomemo",    "0");
	d_get_int(proxy_only,  "proxy_only",  "0");
	d_get_int(display_access,"display_access",  "0");
	d_get_int(present_only,"present_only",  "0");
	d_get_int(new_only,    "new_only",    "0");
	d_get_int(hhl_fonly,   "hhl_fonly",   "0");
	d_get_int(other_window,"other_window","0");
	d_get_int(desc_table,  "desc_table",  "0");
	d_get_int(big_font,    "big_font",    "0");
	d_get_int(save_output, "save_output", "0");
	d_get_int(omit_sitename,"omit_sitename","1");
	d_get_int(mail_delay,  "mail_delay",  "180");
	d_get_int(hhl_delay,   "hhl_delay",   "30");
	d_get_int(netload_delay,"netload_delay","20");
	d_get_int(recv_to,     "recv_to",     "30");
	d_get_int(max_retrys,  "max_retrys",  "3");
	d_get_str(mail_command,"mail_command","balsa --checkmail");
	d_get_str(mail_server, "mail_server", "a.b.ne.jp:110");
	d_get_str(mail_user,   "mail_user",   "");
	d_get_str(mail_passwd, "mail_passwd", "");
	strcpy(passwd_magic,mail_passwd); magic1(passwd_magic);
	d_get_int(mail_type,   "mail_type","0");
	d_get_int(is_line1,    "is_line1", "0");
	d_get_int(is_bigb,     "is_bigb",  "0");
	gnome_config_pop_prefix();

	labelframe = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(labelframe), GTK_SHADOW_NONE);
	gtk_widget_show(labelframe);

	labelbox = gtk_vbox_new(FALSE, FALSE);
	show_memo_widget();

	gtk_signal_connect(GTK_OBJECT(applet),"save_session",
					GTK_SIGNAL_FUNC(applet_save_session), NULL);

	gtk_signal_connect(GTK_OBJECT(applet),"change_orient",
					GTK_SIGNAL_FUNC(applet_change_orient), NULL);

	applet_widget_add (APPLET_WIDGET (applet), labelframe);
	gtk_widget_show (applet);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),"properties",
				GNOME_STOCK_MENU_PROP, _("Properties"), set_properties, NULL);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),"about",
				GNOME_STOCK_MENU_ABOUT, "MemoPanel " VERSION, about_cb, NULL);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),"mail",
				GNOME_STOCK_MENU_MAIL,_("Check mail now"),call_timeout_mail, NULL);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),"refresh",
				GNOME_STOCK_MENU_REFRESH,
				_("Clear memopanel count\n(Need to restart memopanel)"),
				clear_m_count,NULL);

	set_timer_memo();
	if(check_mail_flag) set_timer_mail();
	if(hhl_valid)       set_timer_hhl();
	if(isfile)          isfile_updated();
	if(check_mail_flag) timeout_mail(); else timeout_memo();
	if(hhl_valid)       timeout_hhl();
	if(netload_valid)   set_timer_netload();

	applet_widget_gtk_main ();
	dusting();
	glibtop_close();
	return 0;
}
