/* mbox_selection.c -- mailbox menu
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "melon.h"

static void mbox_selector ( GtkWidget *widget, gpointer user_data );
static void add_mbox (GtkWidget *selector, gpointer user_data);
static void select_all_mbox (GtkWidget *widget, gpointer mbox_data);
static void setup_new_mbox (char *mbox_path, int mbox_index);
static void remove_mbox (GtkWidget *widget, gpointer sel_data);
static void setup_removed_mbox (char *mbox_path);
static int mbox_exists(char *mbox);
static void set_mbox_type( GtkWidget *widget, gpointer g_pix);
static void set_file_type( GtkWidget *widget, gpointer g_pix);
static void setup_file_type(char *mbox_path, int f_type, int row, gpointer g_pix);
static void quit_mbox_menu (GtkWidget *widget, gpointer g_pix);
static void display_type_pix( GtkWidget *window, gpointer g_pix, int rows );

gint select_mbox (GtkWidget *widget, gpointer data);

GtkWidget *m_list;


int mbox_exists(char *mbox)
{
	int c;

	for(c = 0; c < MAX_MBOX; c++)
		if ((strcmp(cfg_data.mbox[c], mbox)) == 0)
			return 1;

	return 0;
}


gint select_mbox (GtkWidget *widget, gpointer data)
{
	GtkWidget *sel_window;
	GtkWidget *vbox, *hbox;
	GtkWidget *scroll_win;
	GtkWidget *button, *mbox_button, *file_button, *pixmap;
	GtkTooltips *bbar_tips;
	gchar *titles[2] = { "Type", "Path" };
	gchar *m_data[2];
	char mbox_pix[MAX_PLEN], file_pix[MAX_PLEN];
	GdkPixmap *gdk_pix1, *gdk_pix2;
	GdkBitmap *mask1, *mask2;
	GtkStyle *style;
	static void *g_pix[5];
	int c;

	/* file_type pixmaps */
	snprintf(mbox_pix, MAX_PLEN, "%s/%s", PIXMAPS_DIR, ".mbox.xpm");
	snprintf(file_pix, MAX_PLEN, "%s/%s", PIXMAPS_DIR, ".file.xpm");

	/* window */
	sel_window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (sel_window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (sel_window), 400, 250);
	gtk_window_set_title(GTK_WINDOW (sel_window), "Mailboxes");
	gtk_widget_show(sel_window);

	/* pixmaps */
	style = gtk_widget_get_default_style();
	gdk_pix1 = gdk_pixmap_create_from_xpm( sel_window->window, &mask1,
		&style->bg[GTK_STATE_NORMAL],
		mbox_pix);
	gdk_pix2 = gdk_pixmap_create_from_xpm( sel_window->window, &mask2,
		&style->bg[GTK_STATE_NORMAL],
		file_pix);

	g_pix[0] = gdk_pix1;
	g_pix[1] = mask1;
	g_pix[2] = gdk_pix2;
	g_pix[3] = mask2;
	g_pix[4] = sel_window;

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( sel_window ), vbox );
	gtk_widget_show( vbox );

	/* scrolled window */
	scroll_win = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW( scroll_win ), 
		GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
	gtk_box_pack_start( GTK_BOX( vbox ), scroll_win, TRUE, TRUE, 0 );
	gtk_widget_show(scroll_win);

	/* clist */
	m_list = gtk_clist_new_with_titles( 2, titles );

	gtk_widget_set_usize( GTK_WIDGET (m_list), 200, 200);
	gtk_clist_set_row_height( GTK_CLIST (m_list), 20);
	gtk_clist_column_titles_passive( GTK_CLIST( m_list ));
	gtk_clist_set_shadow_type (GTK_CLIST(m_list), GTK_SHADOW_OUT);
        gtk_clist_set_selection_mode( GTK_CLIST(m_list), GTK_SELECTION_MULTIPLE );
	GTK_CLIST_SET_FLAG( m_list, CLIST_AUTO_SORT );

	gtk_clist_set_column_width(GTK_CLIST( m_list ), 0, 30);
	gtk_clist_set_column_width(GTK_CLIST( m_list ), 1, 150);

	gtk_clist_set_column_justification (GTK_CLIST(m_list), 0, GTK_JUSTIFY_CENTER);

	gtk_container_add( GTK_CONTAINER( scroll_win ), m_list );

	for (c = 0; c < MAX_MBOX; c++)
	{
		/* display all mailbox list into clist */
		if(cfg_data.mbox[c][0] == '\0')
			continue;
		m_data[0] = NULL;
		m_data[1] = cfg_data.mbox[c];

		gtk_clist_append(GTK_CLIST (m_list), m_data);
	}

	display_type_pix(sel_window, g_pix, c );

        gtk_widget_show(m_list);

	/* tooltips */
	bbar_tips = gtk_tooltips_new();

	/* hbox */
	hbox = gtk_hbox_new( FALSE, 0 );
	//gtk_box_pack_start( GTK_BOX( vbox ), scroll_win, FALSE, FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox);
	gtk_widget_show( hbox );

	/* Select All button */
	button = gtk_button_new_with_label("Select All");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                GTK_SIGNAL_FUNC(select_all_mbox), (gpointer)(m_list));

        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show(button);


        /* REMOVE button */
        button = gtk_button_new_with_label ("Remove");
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                GTK_SIGNAL_FUNC(remove_mbox),
                GTK_OBJECT (m_list));
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
        gtk_widget_show (button);

        /* ADD NEW button */
        button = gtk_button_new_with_label ("Add New");
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                GTK_SIGNAL_FUNC(mbox_selector),
                GTK_OBJECT (m_list));
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
        gtk_widget_show (button);

	/* MBOX button */
	mbox_button = gtk_button_new();
        gtk_signal_connect (GTK_OBJECT (mbox_button), "clicked",
                GTK_SIGNAL_FUNC(set_mbox_type), g_pix);

	pixmap = gtk_pixmap_new( gdk_pix1, mask1 );
	gtk_container_add(GTK_CONTAINER(mbox_button), pixmap);
	gtk_widget_show(pixmap);

        gtk_box_pack_start (GTK_BOX (hbox), mbox_button, TRUE, TRUE, 0);
	gtk_widget_show(mbox_button);

	/* FILE button */
	file_button = gtk_button_new();
        gtk_signal_connect (GTK_OBJECT (file_button), "clicked",
                GTK_SIGNAL_FUNC(set_file_type), g_pix);


	pixmap = gtk_pixmap_new( gdk_pix2, mask2 );
	gtk_container_add(GTK_CONTAINER(file_button), pixmap);
	gtk_widget_show(pixmap);

        gtk_box_pack_start (GTK_BOX (hbox), file_button, TRUE, TRUE, 0);
	gtk_widget_show(file_button);


        /* CLOSE button */
        button = gtk_button_new_with_label ("Close");
        gtk_signal_connect (GTK_OBJECT (button), "clicked",
                GTK_SIGNAL_FUNC(quit_mbox_menu), g_pix);
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
        gtk_widget_show (button);

	/* add tooltips to mbox_button and file_button */
	gtk_tooltips_set_tip(GTK_TOOLTIPS (bbar_tips), mbox_button,
		"Set type to Mailbox",
		"If set to mbox type, the check will be performed
		by looking for the STATUS flag");
	gtk_tooltips_set_tip(GTK_TOOLTIPS (bbar_tips), file_button,
		"Set type to File",
		"If set to file type, the check will be performed
		upon the change time");

        return 1;
}

void quit_mbox_menu (GtkWidget *widget, gpointer g_pix)
{
	void **p_args = g_pix;

	/* free pixmaps */
	gdk_pixmap_unref(p_args[0]);
	gdk_pixmap_unref(p_args[3]);

	gtk_widget_destroy(p_args[4]);
}

void display_type_pix( GtkWidget *window, gpointer g_pix, int rows )
{
	void **p_args = g_pix;
	char *mbox_path;
	int c, i;

	for (c = 0; c < rows; c++)
	{
		gtk_clist_get_text(GTK_CLIST(m_list), c, 1, &mbox_path);

		for (i = 0; i < rows; i++)
			if((strcmp(cfg_data.mbox[i], mbox_path)) == 0)
				break;

		if(cfg_data.is_a_mbox[i])
			gtk_clist_set_pixmap(GTK_CLIST( m_list ), c, 0, p_args[0], p_args[1]);
		else
			gtk_clist_set_pixmap(GTK_CLIST( m_list ), c, 0, p_args[2], p_args[3]);
	}

	return;
}
/*
void register_row ( GtkWidget *widget, gint row, GdkEventButton *event )
{
	sel_row[row] = row;
	return;
}

void unregister_row ( GtkWidget *widget, gint row, GdkEventButton *event )
{
	sel_row[row] = -1;
	return;
}
*/

void set_mbox_type( GtkWidget *widget, gpointer g_pix )
{
	char *mbox_path;

	gtk_clist_freeze(GTK_CLIST(m_list));

        while (GTK_CLIST(m_list)->selection)
        {
                gtk_clist_get_text(GTK_CLIST(m_list),
		                        GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), 
					1, &mbox_path);

		setup_file_type(mbox_path, 1, 
			GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), g_pix); 
		gtk_clist_unselect_row(GTK_CLIST(m_list), 
			GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), 1);
        }

        gtk_clist_thaw(GTK_CLIST(m_list));

	config_update();
	return;
}


void set_file_type( GtkWidget *widget, gpointer g_pix )
{
	char *mbox_path;

	gtk_clist_freeze(GTK_CLIST(m_list));

        while (GTK_CLIST(m_list)->selection)
        {
                gtk_clist_get_text(GTK_CLIST(m_list),
		                        GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), 
					1, &mbox_path);

		setup_file_type(mbox_path, 0, 
			GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), g_pix); 
		gtk_clist_unselect_row(GTK_CLIST(m_list), 
			GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), 1);
        }

        gtk_clist_thaw(GTK_CLIST(m_list));

	config_update();
	return;
}

void setup_file_type(char *mbox_path, int f_type, int row, gpointer g_pix)
{
	int c;
	void **p_args = g_pix;

	for (c = 0; c < MAX_MBOX; c++)
	{
		if (!strcmp(cfg_data.mbox[c], mbox_path)) {
			cfg_data.is_a_mbox[c] = f_type;
			break;
		}
	}

	if(cfg_data.is_a_mbox[c])
		gtk_clist_set_pixmap(GTK_CLIST( m_list ), row, 0, p_args[0], p_args[1]);
	else
		gtk_clist_set_pixmap(GTK_CLIST( m_list ), row, 0, p_args[2], p_args[3]);

	return;
}



void remove_mbox ( GtkWidget *widget, gpointer sel_data )
{
	char *mbox_path;

	gtk_clist_freeze(GTK_CLIST(m_list));

        while (GTK_CLIST(m_list)->selection)
        {

                gtk_clist_get_text(GTK_CLIST(m_list),
		                        GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data), 
					1, &mbox_path);

		setup_removed_mbox(mbox_path); 

                gtk_clist_remove (GTK_CLIST(m_list),
                        GPOINTER_TO_INT(GTK_CLIST(m_list)->selection->data));
        }

        gtk_clist_thaw(GTK_CLIST(m_list));

	//gtk_clist_unselect_all (GTK_CLIST(m_list));

	config_update();
	return;
}

void setup_removed_mbox (char *mbox_path)
{
	int c, i;

	for (c = 0; c < MAX_MBOX; c++)
	{
		if (!strcmp(cfg_data.mbox[c], mbox_path)) {
			cfg_data.mbox[c][0] = '\0';
			cfg_data.is_a_mbox[c] = 0;
			break;
		}
	}

	/* reorder cfg_data.mbox array */
	for (i = MAX_MBOX -1; i > c; i--)
	{
		if (cfg_data.mbox[i] != '\0') {
			strncpy(cfg_data.mbox[c], cfg_data.mbox[i], MAX_PLEN);
			cfg_data.mbox[i][0] = '\0';
			cfg_data.is_a_mbox[c] = cfg_data.is_a_mbox[i];
			cfg_data.is_a_mbox[i] = 0;
			break;
		}
	}
	return;
}

void select_all_mbox( GtkWidget *widget, gpointer mbox_data )
{
        if (GTK_CLIST(mbox_data)->rows > 0)
                gtk_clist_select_all(GTK_CLIST(mbox_data));

	return;
}

void mbox_selector ( GtkWidget *widget, gpointer user_data )
{
	GtkWidget *filesel, *button_sel;

	filesel = gtk_file_selection_new ("Add or Remove Mailbox");
	gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (filesel));

        gtk_clist_set_selection_mode(
	                GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list),
			GTK_SELECTION_MULTIPLE);

	button_sel = gtk_button_new_with_label("Select All");
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(filesel)->ok_button->parent), 
		button_sel);
	GTK_WIDGET_SET_FLAGS (button_sel, GTK_CAN_DEFAULT);
	gtk_widget_show(button_sel);

	gtk_signal_connect(GTK_OBJECT(button_sel), "clicked",
		GTK_SIGNAL_FUNC(select_all_mbox),
		(gpointer)(GTK_FILE_SELECTION(filesel)->file_list));

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC (add_mbox), filesel);
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
		(gpointer) filesel);
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
		(gpointer) filesel);

	gtk_widget_show (filesel);

        return;
}

void add_mbox (GtkWidget *selector, gpointer sel_data)
{
	/* part of this code is based on chbg of
	 * Ondrejicka Stefan (ondrej@idata.sk)
	 */
	char *d_path;
	char mbox_dir[MAX_PLEN];
	char mbox_path[MAX_PLEN];
	GList *data_list;
	int mark = 0;

	while (mark < MAX_MBOX) {
		if(cfg_data.mbox[mark][0] == '\0')
			break;
		mark++;
	}

	data_list = GTK_CLIST(GTK_FILE_SELECTION(sel_data)->file_list)->selection;
	d_path = gtk_file_selection_get_filename (GTK_FILE_SELECTION(sel_data));

	if(!data_list) {
		setup_new_mbox(d_path, mark);
		config_update();
		return;
	}

        strcpy(mbox_dir, d_path);
        d_path = strrchr(mbox_dir, '/');
        if (d_path) *d_path = '\0';

	while (data_list)
	{
		gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(sel_data)->file_list),
			GPOINTER_TO_INT(data_list->data), 0, &d_path);
		sprintf(mbox_path, "%s/%s", mbox_dir, d_path);
		d_path = mbox_path;

		if (mark == MAX_MBOX) {
			dialog_message (" Max mboxes number reached ");
			return;
		}
		setup_new_mbox(d_path, mark);

		data_list = data_list->next;
		mark++;
	}

	/* update melon.cfg file for next startup */
	config_update();

	return;
}

void setup_new_mbox (char *mbox_path, int mbox_index) 
{
	gchar *m_data[2];
	struct stat buf;
	int retval;

	if(mbox_exists(mbox_path)) {
		melon_error("Mailbox %s already configured... skipped.\n", mbox_path);
		return;
	}

	strncpy(cfg_data.mbox[mbox_index], mbox_path, MAX_PLEN);
	/* default: added file is NOT a mailbox */
	cfg_data.is_a_mbox[mbox_index] = 0;

	m_data[0] = NULL;
	m_data[1] = mbox_path;

	gtk_clist_append(GTK_CLIST (m_list), m_data);

	/* initialize mbox status */
	if((retval=stat(cfg_data.mbox[mbox_index], &buf)) == -1)
		melon_error("Stat error for mailbox %s: %s\n", 
			cfg_data.mbox[mbox_index], strerror(errno));

	w_data.m_time[mbox_index] = buf.st_mtime;
	w_data.beep[mbox_index] = 0;
}


