/* $Id: python-interface.c,v 1.3 2002/01/03 12:44:37 davidw Exp $ */
/* MegHAL Python interface, by David N. Welton <davidw@dedasys.com> */

#include <python1.5/Python.h>
#include "megahal.h"

static PyObject *mhinitbrain(PyObject *self, PyObject *args)
{
    megahal_initialize();
    return Py_None;
}

static PyObject *mhdoreply(PyObject *self, PyObject *args)
{
    char *input;
    char *output = NULL;

    if (!PyArg_ParseTuple(args, "s", &input))
	return NULL;

    output = megahal_do_reply(input, 1);

    return PyString_FromString(output);
}

static PyObject *mhcleanup(PyObject *self, PyObject *args)
{
    megahal_cleanup();
    return Py_None;
}

static struct PyMethodDef mh_methods[] = {
    {"initbrain", mhinitbrain, METH_VARARGS},
    {"doreply", mhdoreply, METH_VARARGS},
    {"cleanup", mhcleanup, METH_VARARGS},
    {NULL, NULL}
};

void initmh_python()
{
    PyObject *m, *d;
    Py_InitModule("mh_python", mh_methods);

    if(PyErr_Occurred())
	Py_FatalError("can't initialize module my_python");
}
