/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <string.h>
#include <stdlib.h>

void _MEDmeshGridIndexCoordinateRd30(int dummy, ...) {

  va_list params;
  va_start(params,dummy);

  const med_idt               fid       = va_arg(params,const med_idt     );
  const char*  const          meshname  = va_arg(params,const char*  const);
  const med_int               numdt     = va_arg(params,const med_int     );
  const med_int               numit     = va_arg(params,const med_int     );
  const med_int               axis      = va_arg(params,const med_int     );
  med_float * const           gridindex = va_arg(params,med_float * const );
  med_err *                   fret      = va_arg(params,med_err *);

  med_idt         _meshid=0;
  med_err         _ret         = -1;
  med_data_type   _datatype    = MED_UNDEF_DATATYPE;
  med_grid_type   _gridtype    = MED_UNDEF_GRID_TYPE;
  med_int         _intgridtype = 0;
  med_int         _meshdim     = 0;
  char            _meshpath[MED_TAILLE_MAA+MED_NAME_SIZE+1]=MED_MAA;
  med_int  _intaxistype=0;

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  strcat(_meshpath,meshname);
  if ((_meshid = _MEDdatagroupOuvrir(fid,_meshpath)) < 0) {
    MED_ERR_(_ret,MED_ERR_OPEN,MED_ERR_DATAGROUP,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);SSCRUTE(_meshpath); goto ERROR;
  }

  /*
   * Lecture du type de grille (attribut MED_NOM_GTY)
   */
  if (_MEDattrEntierLire(_meshid,MED_NOM_GTY,&_intgridtype) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);SSCRUTE(MED_NOM_GTY);ISCRUTE(_intgridtype);goto ERROR;
  }
  _gridtype=(med_grid_type) _intgridtype;

  if ((_gridtype != MED_CARTESIAN_GRID) && (_gridtype != MED_POLAR_GRID)) {
    MED_ERR_(_ret,MED_ERR_RANGE,MED_ERR_GRIDTYPE,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);ISCRUTE_int(_gridtype);goto ERROR;
  }


 /* Lecture de l'attribut MED_NOM_REP */
  if ( _MEDattrEntierLire(_meshid,MED_NOM_REP,&_intaxistype) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);SSCRUTE(MED_NOM_REP);
    ISCRUTE(_intaxistype);goto ERROR;
  }

  if ((med_mesh_type)( _intaxistype) != MED_CARTESIAN ) {
    MED_ERR_(_ret,MED_ERR_RANGE,MED_ERR_AXISTYPE,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);ISCRUTE(_intaxistype);goto ERROR;
  }

  /* Lecture de l'attribut MED_NOM_DIM  */
  if (_MEDattrEntierLire(_meshid,MED_NOM_DIM,&_meshdim) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);SSCRUTE(MED_NOM_DIM);ISCRUTE(_meshdim);goto ERROR;
  }

  if (axis > _meshdim ) {
    MED_ERR_(_ret,MED_ERR_RANGE,MED_ERR_ATTRIBUTE,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);ISCRUTE(_meshdim);ISCRUTE(axis);goto ERROR;
  }

  /*
   * On ecrit le tableau d'indice dans un dataset HDF
   */
  switch(axis)
    {
    case 1 :
      _datatype = MED_COORDINATE_AXIS1;
      break;
    case 2 :
      _datatype = MED_COORDINATE_AXIS2;
      break;
    case 3 :
      _datatype = MED_COORDINATE_AXIS3;
      break;
    default :
      MED_ERR_(_ret,MED_ERR_RANGE,MED_ERR_GRIDTYPE,MED_ERR_MESH_MSG);
      SSCRUTE(meshname);ISCRUTE_int(_gridtype);goto ERROR;
    }

  if (_MEDmeshAdvancedRd(fid,
			 meshname,
			 _datatype,
			 MED_NO_NAME,
			 MED_INTERNAL_UNDEF,
			 numdt,
			 numit,
			 MED_NODE,
			 MED_NONE,
			 MED_NO_CMODE,
			 MED_UNDEF_PFLMODE,
			 MED_NO_PROFILE,
			 MED_FULL_INTERLACE,
			 MED_ALL_CONSTITUENT,
			 NULL,
			 (unsigned char *) gridindex) < 0 ) {
    MED_ERR_(_ret,MED_ERR_CALL,MED_ERR_API,"_MEDmeshAdvancedRd");
    goto ERROR;
  }

  _ret = 0;

 ERROR:

  if (_meshid>0)            if (_MEDdatagroupFermer(_meshid) < 0) {
    MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_DATAGROUP,_meshpath);
    ISCRUTE_id(_meshid);
  }


  va_end(params);
  *fret = _ret;
  return;
}
