/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

#include <2.3.6/med23v30.h>
#include <2.3.6/med23v30_proto.h>
#include "2.3.6/med23v30_misc.h"

void
_MEDfamily23Info236(int dummy,...)
{
  va_list params;
  va_start(params,dummy);

  const med_idt       fid             = va_arg(params, const  med_idt       );
  const char*   const meshname        = va_arg(params, const  char*    const);
  const int           famit           = va_arg(params, const  int           );
  char*         const familyname      = va_arg(params,        char*    const);
  med_int*      const attributenumber = va_arg(params,        med_int* const);
  med_int*      const attributevalue  = va_arg(params,        med_int* const);
  char*         const attributedes    = va_arg(params,        char*    const);
  med_int*      const familynumber    = va_arg(params,        med_int* const);
  char*         const groupname       = va_arg(params,        char*    const);
  med_err*            fret            = va_arg(params,        med_err*      );

  med_int             _nattributes=0;
  med_int             _ngroups=0;

/*   ISCRUTE(                   fid); */
/*   SSCRUTE(		     meshname); */
/*   ISCRUTE_int(		     famit); */
/*   SSCRUTE(		     familyname); */

  *fret = MEDfamInfo(fid,
		     (char * ) meshname,
		     famit,
		     familyname,
		     familynumber,
		     attributenumber,
		     attributevalue,
		     attributedes,
		     &_nattributes,
		     groupname,
		     &_ngroups);

/*   ISCRUTE(		     *familynumber); */
/*   ISCRUTE(		     *attributenumber); */
/*   XSCRUTE(		     attributevalue); */
/*   SSCRUTE(		     attributedes); */
/*   ISCRUTE(		     _nattributes); */
/*   SSCRUTE(		     groupname); */
/*   ISCRUTE(		     _ngroups); */
/*   ISCRUTE(		     *fret); */

  va_end(params);

  return;
}
