/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */



#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <string.h>
#include <stdlib.h>


#include <2.3.6/med23v30.h>
#include <2.3.6/med23v30_proto.h>
#include "2.3.6/med23v30_misc.h"

void _MEDequivalenceCorrespondenceSizeInfo236( int dummy, ...) {

  va_list params;
  va_start(params,dummy);

  const med_idt              fid      = va_arg(params,const med_idt               );
  const char * const         meshname = va_arg(params,const char * const          );
  const char * const         equivname= va_arg(params,const char * const          );
  const med_int              numdt    = va_arg(params,const med_int               );
  const med_int              numit    = va_arg(params,const med_int               );
  const int                  corit    = va_arg(params,const int                   );
  med_entity_type * const    entitype = va_arg(params,med_entity_type * const     );
  med_geometry_type* const   geotype  = va_arg(params,med_geometry_type* const    );
  med_int * const            nentity  = va_arg(params,med_int * const             );
  med_err *                  fret     = va_arg(params,med_err *                   );

  med_err   _ret=-1,_err=-1;
  char      _path[MED_TAILLE_MAA+MED_TAILLE_EQS+2*MED_TAILLE_NOM+1+
		 2*MED_TAILLE_NOM_ENTITE+1+1]=MED_MAA;
  char      _entgeoname[2*MED_TAILLE_NOM_ENTITE+2]="";
  med_size  _nocstpncorrespondence=0;
  med_int   _intentitytype;
  med_int   _intgeotype;
  int       _num = corit -1;

  if ( (numdt != MED_NO_DT) || (numit != MED_NO_IT) ) {
    MED_ERR_(_ret,MED_ERR_INVALID,MED_ERR_PARAMETER,"");
    ISCRUTE(numdt);ISCRUTE(numit); goto ERROR;
  }

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  strcat(_path,meshname);
  strcat(_path,MED_EQS);
  strcat(_path,equivname);
  strcat(_path,"/");


  /*
   * On recupere le nom de <entitype>[.<geotype>]
   */
  if ( _MEDobjectGetName(fid, _path ,_num, &_path[strlen(_path)]) < 0 ) {
    MED_ERR_(_ret,MED_ERR_ACCESS,MED_ERR_DATAGROUP,_path);ISCRUTE_int(corit);
    goto ERROR;
  }

  if ( _MEDattributeNumRdByName(fid, _path, MED_NOM_ENT,MED_INTERNAL_INT,(unsigned char *)&_intentitytype) < 0 ) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_NOM_ENT);
    SSCRUTE(_path);ISCRUTE(_intentitytype);goto ERROR;
  }
  *entitype = (med_entity_type) _intentitytype;

  if ( _MEDattributeNumRdByName(fid, _path,MED_NOM_GEO,MED_INTERNAL_INT,(unsigned char *)&_intgeotype) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_NOM_GEO);
    SSCRUTE(_path);ISCRUTE(_intgeotype);goto ERROR;
  }
  *geotype = (med_geometry_type) _intgeotype;


  if (  _MEDattributeNumRdByName(fid, _path, MED_NOM_NBR,MED_INTERNAL_INT, (unsigned char *) nentity) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_EQUIVALENCE_MSG);
    SSCRUTE(_path);SSCRUTE(MED_NOM_NBR);ISCRUTE(*nentity);
    goto ERROR;
  }

  _ret = 0;
 ERROR:

  va_end(params);
  *fret = _ret;

  return;
}
