AC_DEFUN([MED_CHECK_TYPEOF_MEDINT], [

## Guess where as med_int type is provided by --with-med_int option
## or auto-detection must be used

AC_ARG_WITH([med_int],
            AC_HELP_STRING([--with-med_int=<C type>],
	                   [Use <C type> for med_int]),
	    [],
	    [withval=no])

if test "x$withval" = "xno"
then

  ## Guess the fortran int size
  AC_CHECK_SIZEOF_FORTRAN(integer)
  if test "x$ac_cv_sizeof_fortran_integer" = "x8" ; then
     AC_DEFINE(HAVE_F77INT64,[],
                       [The size of a Fortran integer, as computed by sizeof.])
     AC_CHECK_SIZEOF(long)
     test "x$ac_cv_sizeof_long" = "x8" || AC_MSG_ERROR([Size of C type long expected to be eight bytes])
     LONG_OR_INT="long"
  elif test "x$ac_cv_sizeof_fortran_integer" = "x4" ; then
     AC_CHECK_SIZEOF(int)
     test "x$ac_cv_sizeof_int" = "x4" || AC_MSG_ERROR([Size of C type int expected to be four bytes])
     LONG_OR_INT="int"
  else
     AC_MSG_ERROR([Size of Fortran type integer is neither four nor eigth bytes])
  fi

else
  LONG_OR_INT="$withval" 
  AC_MSG_NOTICE([Using type $withval for med_int])
fi

AC_SUBST(LONG_OR_INT)

])