/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h>
#include <stdlib.h>
#include <string.h>


#ifdef MAJUSCULES
#define nedfnpro NOMF(EDFNPRO)
#define nedfproi NOMF(EDFPROI)
#define nedfpfle NOMF(EDFPFLE)
#define nedfnpfl NOMF(EDFNPFL)
#define nedfpfll NOMF(EDFPFLL)
#else
#define nedfnpro NOMF(edfnpro)
#define nedfproi NOMF(edfproi)
#define nedfpfle NOMF(edfpfle)
#define nedfnpfl NOMF(edfnpfl)
#define nedfpfll NOMF(edfpfll)
#endif

#ifdef PPRO_NT
med_int 
__stdcall EDFPROI(med_int *fid, med_int *indice, char *pro, 
                  unsigned int bidon, med_int *n)
#else
med_int
nedfproi(med_int *fid,med_int *indice, char *pro,med_int *n)
#endif
{
  med_int ret;
  char fs1[MED_TAILLE_NOM+1];

  ret = (med_int) MEDprofilInfo((med_idt)*fid,(med_int) *indice, (char *) fs1, 
			     (med_int *) n); 
  
  strncpy(pro,fs1,MED_TAILLE_NOM);
  _MEDfstring(pro,MED_TAILLE_NOM);

  return(ret); 
}


#ifdef PPRO_NT
med_int 
__stdcall EDFNPRO(med_int *fid)
#else
med_int 
nedfnpro(med_int *fid)
#endif
{
  med_int ret; 
  
  ret = (med_int) MEDnProfil((med_idt) *fid); 

  return(ret); 
}


#ifdef PPRO_NT
med_int
__stdcall EDFPFLE(med_int *fid, med_int *pflval, med_int *n, char *nom, 
		  unsigned int bidon1, med_int *lon1)
#else
med_int 
nedfpfle(med_int *fid, med_int *pflval, med_int *n, 
	 char *nom, med_int *lon1)
#endif
{
  med_int ret;
  char *fn1;

  fn1 = _MED2cstring(nom, (int) * lon1);

  if (!fn1)
    return(-1); 
  
  ret = (med_int) MEDprofilEcr((med_idt) *fid,(med_int *) pflval,
			       (med_int) *n,(char *)fn1);

  _MEDcstringFree(fn1);

  return (ret);
}




#ifdef PPRO_NT
med_int
__stdcall EDFNPFL(med_int *fid,char *nom, unsigned int bidon1, med_int *lon1)
#else
med_int 
nedfnpfl(med_int *fid,char *nom, med_int *lon1)
#endif
{
  med_int ret;
  char *fn1;
  
  fn1 = _MED2cstring(nom, (int) * lon1);

  if (!fn1)
    return(-1); 
  
  ret = (med_int) MEDnValProfil((med_idt) *fid,(char *)fn1);

  _MEDcstringFree(fn1);

  return (ret);
}


#ifdef PPRO_NT
med_int
__stdcall EDFPFLL(med_int *fid, med_int *pflval,char *nom, 
		  unsigned int bidon1, med_int *lon1)
#else
med_int 
nedfpfll(med_int *fid, med_int *pflval,
	 char *nom, med_int *lon1)
#endif
{
  med_int ret;
  char *fn1;

  fn1 = _MED2cstring(nom, (int) * lon1);

  if (!fn1)
    return(-1); 
  
  ret = (med_int) MEDprofilLire((med_idt) *fid,(med_int *) pflval,
				(char *)fn1);

  _MEDcstringFree(fn1);

  return (ret);
}

