/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#ifndef MED_H
#define MED_H

#include <med/med_config.h>
#include <hdf5.h>

#define MED_NULL       (void *) NULL
#define MED_MAX_PARA        20

#define MED_TAILLE_DESC 200
#define MED_TAILLE_IDENT  8
#define MED_TAILLE_NOM   32
#define MED_TAILLE_LNOM  80    
#define MED_TAILLE_PNOM  16

#define MED_PNOM_BLANC "                "
#define MED_NOM_BLANC  "                                "

/*
  MED_FULL_INTERLACE : exemple avec 3 composantes X,Y,Z : X1Y1Z1X2Y2Z2X3Y3Z3...
  MED_NO_INTERLACE   : exemple avec 3 composantes X,Y,Z : X1X2X3Y1Y2Y3Z1Z2Z3...
*/
typedef enum {MED_FULL_INTERLACE,
	      MED_NO_INTERLACE}  med_mode_switch; 

typedef enum {MED_NO_PFLMOD,
              MED_GLOBAL,
	      MED_COMPACT }  med_mode_profil; 

/* 
   MED_LECTURE          : Ouverture en lecture seule
   MED_LECTURE_ECRITURE : Ouverture en lecture/ecriture, si un lment existe il est cras
   MED_LECTURE_AJOUT    : Ouverture en lecture/ecriture, si un lment existe une erreur est gnre
   MED_CREATION         : Crer le fichier s'il n'existe pas, l'crase sinon
   MED_MODE_ACCESS      : Variable globale interne le mode d'ouverture
*/
typedef enum {MED_LECTURE, MED_LECTURE_ECRITURE, MED_LECTURE_AJOUT, MED_CREATION} med_mode_acces; 
extern med_mode_acces MED_MODE_ACCES; 

typedef enum {MED_NON_STRUCTURE, MED_STRUCTURE} med_maillage;

typedef enum {MED_GRILLE_CARTESIENNE, MED_GRILLE_POLAIRE, MED_GRILLE_STANDARD} med_type_grille;

typedef enum {MED_MAILLE, MED_FACE, MED_ARETE, MED_NOEUD} med_entite_maillage; 

extern char *  MED_ENTITE_MAILLAGE_AFF[4];

typedef enum {MED_COOR, MED_CONN, MED_NOM, MED_NUM, MED_FAM,MED_COOR_IND1,MED_COOR_IND2,MED_COOR_IND3} med_table;

typedef enum {MED_FLOAT64=6, MED_INT32=24,MED_INT64=26, MED_INT=28} med_type_champ;

typedef enum {MED_MAILLAGE,MED_CHAMP} med_type_donnee;

#define MED_NBR_GEOMETRIE_MAILLE 15
#define MED_NBR_GEOMETRIE_FACE 4
#define MED_NBR_GEOMETRIE_ARETE 2
typedef enum {MED_POINT1=1, MED_SEG2=102, MED_SEG3=103, MED_TRIA3=203,
	      MED_QUAD4=204, MED_TRIA6=206,MED_QUAD8=208, MED_TETRA4=304,
	      MED_PYRA5=305, MED_PENTA6=306, MED_HEXA8=308, MED_TETRA10=310, 
	      MED_PYRA13=313, MED_PENTA15=315, MED_HEXA20=320, 
	      MED_POLYGONE=400, MED_POLYEDRE=500, MED_NONE=0} med_geometrie_element;

extern char * MED_GEOMETRIE_MAILLE_AFF[MED_NBR_GEOMETRIE_MAILLE+2];
extern char * MED_GEOMETRIE_FACE_AFF[MED_NBR_GEOMETRIE_FACE+1];
extern char * MED_GEOMETRIE_ARETE_AFF[MED_NBR_GEOMETRIE_ARETE];
extern char * MED_GEOMETRIE_NOEUD_AFF[1];  

typedef enum {MED_NOD, MED_DESC} med_connectivite ; 

typedef enum {MED_CART, MED_CYL,MED_SPHER} med_repere; 

typedef enum {MED_FAUX, MED_VRAI} med_booleen ; 

typedef enum {MED_GROUPE, MED_ATTR, MED_FAMILLE} med_dim_famille; 

typedef enum {MED_COMP, MED_DTYPE} med_dim_champ; 

typedef enum {MED_HDF_VERSION, MED_VERSION, MED_FICH_DES} med_fich_info; 

#define MED_NOPG    1                   /* Variable Interne                            */
#define MED_NOGAUSS  ""                 /* -> pas de point de Gauss                    */
#define MED_NOGAUSSi  MED_NOM_BLANC     /* Variable Interne                            */
#define MED_NOPFL   ""                  /* -> pas de profils utilisateur               */
#define MED_NOPFLi  MED_NOM_BLANC       /* Variable Interne                            */
#define MED_NOLIEN  ""
#define MED_NOLIENi MED_NOM_BLANC      /* Variable Interne                            */
#define MED_NOPF   0                   /* -> pas de profils pour _MEDdataseNnumEcrire */
#define MED_NOPDT -1                   /* rem: pas de pas de temps negatifs           */
#define MED_NONOR -1                   /* rem: pas de nordre negatif                 */
#define MED_DIM1   1                   /* PAS */
#define MED_ALL    0
#define MED_NOREF  ""
#define MED_DEFAUT ""                  /* Toutes les donnees champs ou maillage pour le montage */

#if defined(SUN4SOL2) || defined(PCLINUX) || defined(PCLINUX64_32) ||defined(OSF1_32) || defined(IRIX64_32) || defined(RS6000)  || defined(F77INT32)
/* interface C/FORTRAN */
/* SEPARER LA GESTION des _ de la taille du int f77, laisser la gestion des _  l'utilisateur */
#define NOMF_POST_UNDERSCORE 

/* correspondance des types avec HDF 5 */
typedef hsize_t        med_size;
typedef hssize_t       med_ssize;
typedef hid_t          med_idt;
typedef herr_t         med_err;

/* types elementaires */
typedef int            med_int;
typedef double         med_float;
#endif

#if defined(HP9000)
/* correspondance des types avec HDF 5 */
typedef hsize_t        med_size;
typedef hssize_t       med_ssize;
typedef hid_t          med_idt;
typedef herr_t         med_err;

/* types elementaires */
typedef int            med_int;
typedef double         med_float;
#endif

#if defined(IRIX64) || defined(OSF1) || defined(VPP5000) || defined(PCLINUX64) || defined(F77INT64)
#define NOMF_POST_UNDERSCORE

/* correspondance des types avec HDF 5 */
typedef hsize_t        med_size;
typedef hssize_t       med_ssize;
typedef hid_t          med_idt;
typedef herr_t         med_err;

/* types elementaires */
typedef long           med_int;
typedef double         med_float;
#endif


#if defined(PPRO_NT) 
/* correspondance des types avec HDF 5 */
typedef hsize_t        med_size;
typedef hssize_t       med_ssize;
typedef hid_t          med_idt;
typedef herr_t         med_err;

/* types elementaires */
typedef int	       med_int;
typedef double         med_float;
#endif


#if defined(NOMF_PRE_UNDERSCORE) && defined(NOMF_POST_UNDERSCORE)
#   define NOMF(x)     _##x##_
#endif
#if defined(NOMF_PRE_UNDERSCORE) && !defined(NOMF_POST_UNDERSCORE)
#   define NOMF(x)     _##x
#endif
#if !defined(NOMF_PRE_UNDERSCORE) && defined(NOMF_POST_UNDERSCORE)
#   define NOMF(x)     x##_
#endif
#if !defined(NOMF_PRE_UNDERSCORE) && !defined(NOMF_POST_UNDERSCORE)
#   define NOMF(x)     x
#endif

#include "med_proto.h"

#endif  /* MED_H */
