C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************

C       ******************************************************************************
C       * - Nom du fichier : test27.f
C       *
C       * - Description : creation de maillages structures (grille cartesienne |
C       *                 grille standard ) dans le fichier test27.med
C       *
C       *****************************************************************************
	program test27
C       
	implicit none
	include 'med.hf'
C       
C       
	integer       cret, fid
C       ** la dimension du maillage                         **
	integer       mdim
C       ** nom du maillage de longueur maxi MED_TAILLE_NOM  **
	character*32  maa
C       ** le nombre de noeuds                              **
	integer       nnoe 
C       ** table des coordonnees                            **
        real*8        coo(8)
	character*16  comp, comp2(2)
	character*16  unit, unit2(2)
	character*200 desc
        integer       strgri(2)
C       ** grille cartesienne                               **
	integer       axe,nind
        real*8        indice(4)
        
C
C	
	data  coo    /0.0,0.0,1.0,0.0,0.0,1.0,1.0,1.0/
	data  comp2  /"x","y"/, unit2 /"cm","cm"/
C
C       Creation du fichier test27.med
	call efouvr(fid,'test27.med',MED_CREATION, cret)
	print *,cret
	print *,'Creation du fichier test27.med'
C	
C       Creation d'un maillage MED_NON_STRUCTURE
	if (cret .eq. 0) then
	   mdim = 3
	   maa = 'maillage vide'
	   desc = 'un maillage vide'
	   call efmaac(fid,maa,mdim,MED_NON_STRUCTURE,desc,cret)
	   print *,cret
	endif
C
C       Creation d'une grille cartesienne
	if (cret .eq. 0) then
	   mdim = 2
	   maa = 'grille cartesienne'
	   desc = 'un exemple de grille cartesienne'
	   call efmaac(fid,maa,mdim,MED_STRUCTURE,desc,cret)
	   print *,cret
	   print *,'Creation d un maillage MED_STRUCTURE'
	endif
C
C       On specifie la nature du maillage structure
	if (cret .eq. 0) then
	   call efnage(fid,maa,MED_GRILLE_CARTESIENNE,cret)
	   print *,cret
	   print *,'On definit la nature de la grille : MED_GRILLE_CARTESIENNE'
	endif
C
C       On definit les indices de la grille selon chaque dimension
	if (cret .eq. 0) then
	   indice(1) = 1.1
	   indice(2) = 1.2
	   indice(3) = 1.3
	   indice(4) = 1.4
	   nind = 4
	   axe = 1
	   comp = 'X'
	   unit = 'cm'
	   call eficoe(fid,maa,mdim,indice,nind,axe,comp,unit,cret)
	   print *,cret
	   print *,'Ecriture des indices des coordonnees selon axe X'
	endif
C
	if (cret .eq. 0) then
	   indice(1) = 2.1
	   indice(2) = 2.2
	   indice(3) = 2.3
	   indice(4) = 2.4
	   nind = 4
	   axe = 2
	   comp = 'Y'
	   unit = 'cm'
	   call eficoe(fid,maa,mdim,indice,nind,axe,comp,unit,cret)
	   print *,cret
	   print *,'Ecriture des indices des coordonnees selon axe Y'
	endif
C
C       Creation d'une grille MED_GRILLE_STANDARD de dimension 2
	if (cret .eq. 0) then
	   maa = 'grille standard'
	   mdim = 2
	   desc = 'un exemple de grille standard'
	   call efmaac(fid,maa,mdim,MED_STRUCTURE,desc,cret)
	   print *,cret
	   print *,'Nouveau maillage MED_STRUCTURE'
	endif
C
	if (cret .eq. 0) then
	   call efnage(fid,maa,MED_GRILLE_STANDARD,cret)
	   print *,cret
	   print *,'On definit la nature du maillage structure : MED_GRILLE_STANDARD'
	endif
C
C       On ecrit les coordonnes de la grille
	if (cret .eq. 0) then
	   nnoe = 4
	   call efcooe(fid,maa,mdim,coo,MED_FULL_INTERLACE,nnoe,MED_CART,
     &                 comp2,unit2,cret)
	   print *,cret
	   print *,'Ecriture des coordonnees de la grille'
	endif
C
C       On definit la structure des coordonnees de la grille
	if (cret .eq. 0) then
	   strgri(1) = 2
	   strgri(2) = 2
	   call efscoe(fid,maa,mdim,strgri,cret)
	   print *,cret
	   print *,'Ecriture de la structure de la grille : / 2,2 /'
	endif
C
C       On ferme le fichier
	call efferm (fid,cret)
	print *,cret
	print *,'Fermeture du fichier'
C	
	 end






