!*************************************************************************
! COPYRIGHT (C) 1999 - 2003  EDF R&D
! THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
! AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
! EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
! ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
! INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
!
!**************************************************************************


! ******************************************************************************
! * - Nom du fichier : test11.f90
! *
! * - Description : lecture de champs de resultats MED 
! *
! ***************************************************************************** 

program test11
  
  implicit none
  include 'med.hf'
!
!
  integer      ret,cret, fid
  character*32 maa
  character*255 argc
  integer      mdim
  character*16, allocatable, dimension(:) :: comp,unit
  character*16  dtunit
  character*32 nomcha
  character*32 profil
  integer      ncomp
  real*8,      allocatable, dimension(:) :: valr
  real*8       dt
  integer,     allocatable, dimension(:) :: vale
  integer      typcha,typgeo
  integer      i,j,k,l
  integer      ncha, nval, npdt, ngauss, numdt, numo, pflsize
  integer,      allocatable, dimension(:) :: pflval
  integer,parameter  :: typmai(MED_NBR_GEOMETRIE_MAILLE) =  (/ MED_POINT1,MED_SEG2,   &
						 &  MED_SEG3,MED_TRIA3,    &
						 &  MED_TRIA6,MED_QUAD4,   &
						 &  MED_QUAD8,MED_TETRA4,  &
						 &  MED_TETRA10,MED_HEXA8, &
						 &  MED_HEXA20,MED_PENTA6, &
						 &  MED_PENTA15,MED_PYRA5, &
						 &  MED_PYRA13/)

   integer,parameter :: typfac(MED_NBR_GEOMETRIE_FACE) = (/MED_TRIA3,MED_TRIA6,       &
					&	 MED_QUAD4,MED_QUAD8/)
   integer,parameter ::typare(MED_NBR_GEOMETRIE_ARETE) = (/MED_SEG2,MED_SEG3/)
   character*200 :: desc
   integer type

   
   print *,"Indiquez le fichier med a decrire : "
   read(*,'(A)') argc

   !  ** ouverture du fichier **
   call efouvr(fid,argc,MED_LECTURE, cret)
   if (cret .ne. 0) write(*,'(I1)') cret
   
   !  ** info sur le premier maillage **
   if (cret.eq.0) then
      call efmaai(fid,1,maa,mdim,type,desc,cret)
      write (*,'(/A,A,A,I1)') "Maillage de nom : ",TRIM(maa)," et de dimension : ", mdim
   endif
   if (cret .ne. 0) write(*,'(I1)') cret
   
   
   !  ** combien de champs dans le fichier **
   if (cret.eq.0) then
      call efncha(fid,0,ncha,cret)
   endif
   if (cret.eq.0) then
      write (*,'(A,I1/)') "Nombre de champs : ",ncha
   endif
   if (cret .ne. 0) write(*,'(I1)') cret
   
   ! ** lecture de tous les champs associes a <maa> **
   if (cret.eq.0) then
      do i=1,ncha
         write(*,'(A,I5)') "- Champ numero : ",i
         ! ** combien de composantes **
          if (cret.eq.0) then
            call efncha(fid,i,ncomp,cret)
         endif
         if (cret .ne. 0) write(*,'(I1)') cret

         ! ** allocation memoire de comp et unit **
         if (cret.eq.0) then
            allocate(comp(ncomp),unit(ncomp),STAT=ret)
         endif
         if (ret .ne. 0) write(*,'(I1)') ret

         ! ** Info sur les champs
         if (cret.eq.0) then
            call efchai(fid,i,nomcha,typcha,comp,unit,ncomp,cret)
         endif
         if (ret .ne. 0) write(*,'(I1)') ret
         write(*,'(/5X,A,A)') 'Nom du champ  : ', TRIM(nomcha)
         write(*,'(5X,A,I5)') 'Type du champ : ', typcha
         do j=1,ncomp
            write(*,'(5X,A,I1,A,A,A,A)') 'Composante ',j,'  : ',TRIM(comp(j)),' ',TRIM(unit(j))
         enddo

         deallocate(comp,unit)

         ! ** Valeurs sur les noeuds

         ! ** Combien de pas de temps et de numeros d'ordre a lire 
         ! ** sur les noeuds
         if (cret.eq.0) then
            call efnpdt(fid,nomcha,MED_NOEUD,0,npdt,cret)
         endif         
         if (cret .ne. 0) write(*,'(I1)') cret
         write(*,'(/5X,A,I5)') 'Nombre de (pas de temps,nitration) sur les noeuds : ',npdt

         ! ** Parcours des pas de temps
         if (cret .eq. 0) then
            do j=1,npdt
               
            if (cret .eq. 0) then
               call efpdti(fid,nomcha,MED_NOEUD,0,j,maa,ngauss,numdt,dtunit,dt,numo,cret)
            endif
            if (cret .ne. 0) write(*,'(I1)') cret
            if (numdt .eq. MED_NOPDT) then
               write(*,'(5X,A)') 'Pas de pas de temps'
            else
               write(*,'(5X,A,I5,A,E20.8,A,A,A)') 'Pas de temps n ' &
                    &  ,numdt,' (', dt ,') ', 'et d''unite ',TRIM(dtunit)
            endif
            if (numo .eq. MED_NONOR) then
               write(*,'(5X,A)')     'Pas de numero d''ordre'
            else
               write(*,'(5X,A,I5)')  'Numero d ordre            : ', numo
            endif
            write(*,'(5X,A,I5)') 'Nombre de points de gauss : ',ngauss
            write(*,'(5X,A,A)')    'Maillage associe          : ', TRIM(maa)

            ! ** Combien de valeurs
            if (cret .eq. 0) then
               call efnval(fid,nomcha,MED_NOEUD,0,numdt,numo,nval,cret)
            endif
            if (cret .ne. 0) write(*,'(I1)') cret
            write(*,'(5X,A,I5,A)') 'Ce champ est constitu de : ',nval,' valeurs'

            if (nval .gt. 0) then
               if (typcha .eq. MED_INT32) then
                  != print *,'Lecture des valeurs entieres : '
                  ! ** allocation memoire de vale **
                  if (cret.eq.0) then
                     allocate(vale(ncomp*nval),STAT=ret)
                  endif
                  if (ret .ne. 0) write(*,'(I1)') ret

                  if (cret .eq. 0) then
                     call efchal(fid,maa,nomcha,vale,MED_FULL_INTERLACE,MED_ALL,profil,MED_NOEUD,0,numdt,numo,cret)
                  endif
                  if (cret .ne. 0) write(*,'(I1)') cret

                  !* Profils
                  if (cret .eq. 0) then
                     if (profil .eq. MED_NOPFL) then
                        write(*,'(5X,A)') 'Pas de profil'
                     else
                        write(*,'(5X,A,A)') 'Profil :',profil
                        if (cret .eq. 0) then
                           call efnpfl(fid,profil,pflsize,cret)
                        endif
                        if (cret .ne. 0) write(*,'(I1)') cret
                        write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize
                        
                        ! ** allocation memoire de pflval **
                        if (cret.eq.0) then
                           allocate(pflval(pflsize),STAT=ret)
                        endif
                        if (ret .ne. 0) write(*,'(I1)') ret
                        
                        if (ret .eq. 0 .and. cret .eq. 0) then
                           call efpfll(fid,pflval,profil,cret)
                        endif
                        if (cret .ne. 0) write(*,'(I1)') cret
                        write(*,'(5X,A)') 'Valeurs du profil : '
                        do l=1,pflsize
                           write (*,'(5X,I6)') pflval(l)          
                        enddo
                        
                        deallocate(pflval)

                     endif
                  endif

                  write (*,'(5X,A)') 'Valeurs du champ : '                  
                  do l=1,nval*ncomp
                     write (*,'(15X,I6)') vale(l)             
                  enddo

                  deallocate(vale)

               else
                  != print *,'Lecture des valeurs reelles : '

                  ! ** allocation memoire de valr **
                  if (cret.eq.0) then
                     allocate(valr(ncomp*nval),STAT=ret)
                  endif
                  if (ret .ne. 0) write(*,'(I1)') ret

                  if (cret .eq. 0) then
                     call efchal(fid,maa,nomcha,valr,MED_FULL_INTERLACE,MED_ALL,profil,MED_NOEUD,0,numdt,numo,cret)
                  endif

                  if (cret .ne. 0) write(*,'(I1)') cret

                  !* Profils
                  if (cret .eq. 0) then
                     if (profil .eq. MED_NOPFL) then
                        write(*,'(5X,A)') 'Pas de profil'
                     else
                        write(*,'(5X,A,A)') 'Profil :',profil
                        if (cret .eq. 0) then
                           call efnpfl(fid,profil,pflsize,cret)
                        endif
                        if (cret .ne. 0) write(*,'(I1)') cret
                        write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize

                        ! ** allocation memoire de pflval **
                        if (cret.eq.0) then
                           allocate(pflval(pflsize),STAT=ret)
                        endif
                        if (ret .ne. 0) write(*,'(I1)') ret
                        
                        if (ret .eq. 0 .and. cret .eq. 0) then
                           call efpfll(fid,pflval,profil,cret)
                        endif
                        if (cret .ne. 0) write(*,'(I1)') cret
                        write(*,'(5X,A)') 'Valeurs du profil : '
                        do l=1,pflsize
                           write (*,'(5X,I6)') pflval(l)          
                        enddo
                        
                        deallocate(pflval)

                     endif
                  endif

                  write (*,'(5X,A)') 'Valeurs du champ : '                  
                  do l=1,nval*ncomp
                     write (*,'(15X,E20.8)') valr(l)             
                  enddo

                  deallocate(valr)

               endif
            endif
            
            enddo
         endif

         ! **  Valeurs sur les mailles
         if (cret .eq. 0) then
           
            do j = 1,MED_NBR_GEOMETRIE_MAILLE

               typgeo = typmai(j)

               ! ** Nombre de pas de temps
               if (cret .eq. 0) then
                  call efnpdt(fid,nomcha,MED_MAILLE,typgeo,npdt,cret)
               endif
               if (cret .ne. 0) write(*,'(I1)') cret
               write(*,'(/5X,A,I5,A,I5)') 'Nombre de pas de temps sur les mailles de type  : ',typgeo,' : ',npdt

               ! ** Parcours des pas de temps
               if (cret .eq. 0) then
                  do k=1,npdt
                     
                     if (cret .eq. 0) then
                        call efpdti(fid,nomcha,MED_MAILLE,typgeo,k,maa,ngauss,numdt,dtunit,dt,numo,cret)
                     endif
                     if (cret .ne. 0) write(*,'(I1)') cret
                     if (numdt .eq. MED_NOPDT) then
                        write(*,'(5X,A)') 'Pas de pas de temps'
                     else
                        write(*,'(5X,A,I5,A,E20.8,A,A,A)') 'Pas de temps n ' &
                             &  ,numdt,' (', dt ,') ', 'et d''unite ',TRIM(dtunit)
                     endif
                     if (numo .eq. MED_NONOR) then
                        write(*,'(5X,A)')     'Pas de numero d''ordre'
                     else
                        write(*,'(5X,A,I5)')  'Numero d ordre            : ', numo
                     endif
                     write(*,'(5X,A,I5)') 'Nombre de points de gauss : ',ngauss
                     write(*,'(5X,A,A)')    'Maillage associe          : ', TRIM(maa)
                     
                     ! ** Combien de valeurs
                     if (cret .eq. 0) then
                        call efnval(fid,nomcha,MED_MAILLE,typgeo,numdt,numo,nval,cret)
                     endif
                     if (cret .ne. 0) write(*,'(I1)') cret
                     write(*,'(5X,A,I5,A)') 'Ce champ est constitu de : ',nval,' valeurs'
                     
                     if (nval .gt. 0) then
                        if (typcha .eq. MED_INT32) then
                           ! ** allocation memoire de vale **
                           if (cret.eq.0) then
                              allocate(vale(ncomp*nval),STAT=ret)
                           endif
                           if (ret .ne. 0) write(*,'(I1)') ret
                           
                           if (cret .eq. 0) then
                              call efchal(fid,maa,nomcha,vale,MED_FULL_INTERLACE,MED_ALL,profil,MED_MAILLE,typgeo,numdt,numo,cret)
                           endif
                           if (cret .ne. 0) write(*,'(I1)') cret

                           !* Profils
                           if (cret .eq. 0) then
                              if (profil .eq. MED_NOPFL) then
                                 write(*,'(5X,A)') 'Pas de profil'
                              else
                                 write(*,'(5X,A,A)') 'Profil :',profil
                                 if (cret .eq. 0) then
                                    call efnpfl(fid,profil,pflsize,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize

                                 ! ** allocation memoire de pflval **
                                 if (cret.eq.0) then
                                    allocate(pflval(pflsize),STAT=ret)
                                 endif
                                 if (ret .ne. 0) write(*,'(I1)') ret
                                 
                                 if (ret .eq. 0 .and. cret .eq. 0) then
                                    call efpfll(fid,pflval,profil,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A)') 'Valeurs du profil : '
                                 do l=1,pflsize
                                    write (*,'(5X,I6)') pflval(l)          
                                 enddo
                                 
                                 deallocate(pflval)
                                 
                              endif
                           endif
                           
                           write (*,'(5X,A)') 'Valeurs du champ : '                  
                           do l=1,nval*ncomp
                              write (*,'(15X,I6)') vale(l)             
                           enddo
                           
                           deallocate(vale)
                           
                        else
                           != print *,'Lecture des valeurs reelles : '
                           ! ** allocation memoire de valr **
                           if (cret.eq.0) then
                              allocate(valr(ncomp*nval),STAT=ret)
                           endif
                           if (ret .ne. 0) write(*,'(I1)') ret
                           
                           if (cret .eq. 0) then
                              call efchal(fid,maa,nomcha,valr,MED_FULL_INTERLACE,MED_ALL,profil,MED_MAILLE,typgeo,numdt,numo,cret)
                           endif
                           
                           if (cret .ne. 0) write(*,'(I1)') cret

                           !* Profils
                           if (cret .eq. 0) then
                              if (profil .eq. MED_NOPFL) then
                                 write(*,'(5X,A)') 'Pas de profil'
                              else
                                 write(*,'(5X,A,A)') 'Profil : ',profil
                                 if (cret .eq. 0) then
                                    call efnpfl(fid,profil,pflsize,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize
                        
                                 ! ** allocation memoire de pflval **
                                 if (cret.eq.0) then
                                    allocate(pflval(pflsize),STAT=ret)
                                 endif
                                 if (ret .ne. 0) write(*,'(I1)') ret

                                 if (ret .eq. 0 .and. cret .eq. 0) then
                                    call efpfll(fid,pflval,profil,cret)
                                 endif
                                 write(*,'(5X,A)') 'Valeurs du profil : '
                                 do l=1,pflsize
                                    write (*,'(5X,I6)') pflval(l)          
                                 enddo
                                 
                                 deallocate(pflval)

                              endif
                           endif
                           
                           write (*,'(5X,A)') 'Valeurs du champ : '                  
                           do l=1,nval*ncomp
                              write (*,'(15X,E20.8)') valr(l)             
                           enddo
                           
                           deallocate(valr)                           
                           
                        endif
                     endif
                     
                  enddo
               endif
               
            enddo
         endif

         ! **  Valeurs sur les faces
         if (cret .eq. 0) then
           
            do j = 1,MED_NBR_GEOMETRIE_FACE

               typgeo = typfac(j)

               ! ** Nombre de pas de temps
               if (cret .eq. 0) then
                  call efnpdt(fid,nomcha,MED_FACE,typgeo,npdt,cret)
               endif
               if (cret .ne. 0) write(*,'(I1)') cret
               write(*,'(/5X,A,I5,A,I5)') 'Nombre de pas de temps sur les faces de type  : ',typgeo, ' : ',npdt

               ! ** Parcours des pas de temps
               if (cret .eq. 0) then
                  do k=1,npdt
                     
                     if (cret .eq. 0) then
                        call efpdti(fid,nomcha,MED_FACE,typgeo,k,maa,ngauss,numdt,dtunit,dt,numo,cret)
                     endif
                     if (cret .ne. 0) write(*,'(I1)') cret
                     if (numdt .eq. MED_NOPDT) then
                        write(*,'(5X,A)') 'Pas de pas de temps'
                     else
                        write(*,'(5X,A,I5,A,E20.8,A,A,A)') 'Pas de temps n ' &
                             &  ,numdt,' (', dt ,') ', 'et d''unite ',TRIM(dtunit)
                     endif
                     if (numo .eq. MED_NONOR) then
                        write(*,'(5X,A)')     'Pas de numero d''ordre'
                     else
                        write(*,'(5X,A,I5)')  'Numero d ordre            : ', numo
                     endif
                     write(*,'(5X,A,I5)') 'Nombre de points de gauss : ',ngauss
                     write(*,'(5X,A,A)')    'Maillage associe          : ', TRIM(maa)
                     
                     ! ** Combien de valeurs
                     if (cret .eq. 0) then
                        call efnval(fid,nomcha,MED_FACE,typgeo,numdt,numo,nval,cret)
                     endif
                     if (cret .ne. 0) write(*,'(I1)') cret
                     write(*,'(5X,A,I5,A)') 'Ce champ est constitu de : ',nval,' valeurs'
                     
                     if (nval .gt. 0) then
                        if (typcha .eq. MED_INT32) then
                           != print *,'Lecture des valeurs entieres : '
                           ! ** allocation memoire de vale **
                           if (cret.eq.0) then
                              allocate(vale(ncomp*nval),STAT=ret)
                           endif
                           if (ret .ne. 0) write(*,'(I1)') ret
                           
                           if (cret .eq. 0) then
                              call efchal(fid,maa,nomcha,vale,MED_FULL_INTERLACE,MED_ALL,profil,MED_FACE,typgeo,numdt,numo,cret)
                           endif
                           if (cret .ne. 0) write(*,'(I1)') cret

                           !* Profils
                           if (cret .eq. 0) then
                              if (profil .eq. MED_NOPFL) then
                                 write(*,'(5X,A)') 'Pas de profil'
                              else
                                 write(*,'(5X,A,A)') 'Profil :',profil
                                 if (cret .eq. 0) then
                                    call efnpfl(fid,profil,pflsize,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize

                                 ! ** allocation memoire de pflval **
                                 if (cret.eq.0) then
                                    allocate(pflval(pflsize),STAT=ret)
                                 endif
                                 if (ret .ne. 0) write(*,'(I1)') ret
                                 
                                 if (ret .eq. 0 .and. cret .eq. 0) then
                                    call efpfll(fid,pflval,profil,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 do l=1,pflsize
                                    write (*,'(5X,I6)') pflval(l)          
                                 enddo

                                 deallocate(pflval)
                                 
                              endif
                           endif
                                 
                           write (*,'(5X,A)') 'Valeurs du champ : '                  
                           do l=1,nval*ncomp
                              write (*,'(15X,I6)') vale(l)             
                           enddo
                   
                           deallocate(vale)
                           
                        else
                           print *,'Lecture des valeurs reelles : '
                           ! ** allocation memoire de valr **
                           if (cret.eq.0) then
                              allocate(valr(ncomp*nval),STAT=ret)
                           endif
                           if (ret .ne. 0) write(*,'(I1)') ret
                           
                           if (cret .eq. 0) then
                              call efchal(fid,maa,nomcha,valr,MED_FULL_INTERLACE,MED_ALL,profil,MED_FACE,typgeo,numdt,numo,cret)
                           endif
                           
                           if (cret .ne. 0) write(*,'(I1)') cret

                           !* Profils
                           if (cret .eq. 0) then
                              if (profil .eq. MED_NOPFL) then
                                 write(*,'(5X,A)') 'Pas de profil'
                              else
                                 print *,'Profil : ',profil
                                 if (cret .eq. 0) then
                                    call efnpfl(fid,profil,pflsize,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize

                                 ! ** allocation memoire de pflval **
                                 if (cret.eq.0) then
                                    allocate(pflval(pflsize),STAT=ret)
                                 endif
                                 if (ret .ne. 0) write(*,'(I1)') ret

                                 if (ret .eq. 0 .and. cret .eq. 0) then
                                    call efpfll(fid,pflval,profil,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A)') 'Valeurs du profil : '
                                 do l=1,pflsize
                                    write (*,'(5X,I6)') pflval(l)          
                                 enddo

                                 deallocate(pflval)

                              endif
                           endif
                           
                           write (*,'(5X,A)') 'Valeurs du champ : '                  
                           do l=1,nval*ncomp
                              write (*,'(15X,E20.8)') valr(l)             
                           enddo
                           
                           deallocate(valr)                           
                           
                        endif
                     endif
                     
                  enddo
               endif
               
            enddo
         endif

         ! **  Valeurs sur les aretes
         if (cret .eq. 0) then
           
            do j = 1,MED_NBR_GEOMETRIE_ARETE

               typgeo = typare(j)

               ! ** Nombre de pas de temps
               if (cret .eq. 0) then
                  call efnpdt(fid,nomcha,MED_ARETE,typgeo,npdt,cret)
               endif
               if (cret .ne. 0) write(*,'(I1)') cret
               write(*,'(/5X,A,I5,A,I5)') 'Nombre de pas de temps sur les aretes de type  : ',typgeo,' : ',npdt

               ! ** Parcours des pas de temps
               if (cret .eq. 0) then
                  do k=1,npdt
                     
                     if (cret .eq. 0) then
                        call efpdti(fid,nomcha,MED_ARETE,typgeo,k,maa,ngauss,numdt,dtunit,dt,numo,cret)
                     endif
                     if (cret .ne. 0) write(*,'(I1)') cret
                     if (numdt .eq. MED_NOPDT) then
                        write(*,'(5X,A)') 'Pas de pas de temps'
                     else
                        write(*,'(5X,A,I5,A,E20.8,A,A,A)') 'Pas de temps n ' &
                             &  ,numdt,' (', dt ,') ', 'et d''unite ',TRIM(dtunit)
                     endif
                     if (numo .eq. MED_NONOR) then
                        write(*,'(5X,A)')     'Pas de numero d''ordre'
                     else
                        write(*,'(5X,A,I5)')  'Numero d ordre            : ', numo
                     endif
                     write(*,'(5X,A,I5)') 'Nombre de points de gauss : ',ngauss
                     write(*,'(5X,A,A)')    'Maillage associe          : ', TRIM(maa)
              
                     ! ** Combien de valeurs
                     if (cret .eq. 0) then
                        call efnval(fid,nomcha,MED_ARETE,typgeo,numdt,numo,nval,cret)
                     endif
                     if (cret .ne. 0) write(*,'(I1)') cret
                     write(*,'(5X,A,I5,A)') 'Ce champ est constitu de : ',nval,' valeurs'
                     
                     if (nval .gt. 0) then
                        if (typcha .eq. MED_INT32) then
                           != print *,'Lecture des valeurs entieres : '
                           ! ** allocation memoire de vale **
                           if (cret.eq.0) then
                              allocate(vale(ncomp*nval),STAT=ret)
                           endif
                           if (ret .ne. 0) write(*,'(I1)') ret
                           
                           if (cret .eq. 0) then
                              call efchal(fid,maa,nomcha,vale,MED_FULL_INTERLACE,MED_ALL,profil,MED_ARETE,typgeo,numdt,numo,cret)
                           endif
                           if (cret .ne. 0) write(*,'(I1)') cret

                           !* Profils
                           if (cret .eq. 0) then
                              if (profil .eq. MED_NOPFL) then
                                 write(*,'(5X,A)') 'Pas de profil'
                              else
                                 write(*,'(5X,A,A)') 'Profil :',profil
                                 if (cret .eq. 0) then
                                    call efnpfl(fid,profil,pflsize,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize

                                 ! ** allocation memoire de pflval **
                                 if (cret.eq.0) then
                                    allocate(pflval(pflsize),STAT=ret)
                                 endif
                                 if (ret .ne. 0) write(*,'(I1)') ret
                                 
                                 if (ret .eq. 0 .and. cret .eq. 0) then
                                    call efpfll(fid,pflval,profil,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A)') 'Valeurs du profil : '
                                 do l=1,pflsize
                                    write (*,'(5X,I6)') pflval(l)          
                                 enddo
                        
   
                                 deallocate(pflval)
                                 
                              endif
                           endif
                                 
                           write (*,'(5X,A)') 'Valeurs du champ : '                  
                           do l=1,nval*ncomp
                              write (*,'(15X,I6)') vale(l)             
                           enddo
                           
                           deallocate(vale)
                           
                        else
                           print *,'Lecture des valeurs reelles : '
                           ! ** allocation memoire de valr **
                           if (cret.eq.0) then
                              allocate(valr(ncomp*nval),STAT=ret)
                           endif
                           if (ret .ne. 0) write(*,'(I1)') ret
                           
                           if (cret .eq. 0) then
                              call efchal(fid,maa,nomcha,valr,MED_FULL_INTERLACE,MED_ALL,profil,MED_ARETE,typgeo,numdt,numo,cret)
                           endif
                           
                           if (cret .ne. 0) write(*,'(I1)') cret

                           !* Profils
                           if (cret .eq. 0) then
                              if (profil .eq. MED_NOPFL) then
                                 write(*,'(5X,A)') 'Pas de profil'
                              else
                                 write(*,'(5X,A,A)') 'Profil :',profil
                                 if (cret .eq. 0) then
                                    call efnpfl(fid,profil,pflsize,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A,I5)') 'Taille du profil : ',pflsize

                                 ! ** allocation memoire de pflval **
                                 if (cret.eq.0) then
                                    allocate(pflval(pflsize),STAT=ret)
                                 endif
                                 if (ret .ne. 0) write(*,'(I1)') ret

                                 if (ret .eq. 0 .and. cret .eq. 0) then
                                    call efpfll(fid,pflval,profil,cret)
                                 endif
                                 if (cret .ne. 0) write(*,'(I1)') cret
                                 write(*,'(5X,A)') 'Valeurs du profil : '
                                 do l=1,pflsize
                                    write (*,'(5X,I6)') pflval(l)          
                                 enddo
                                 
                                 deallocate(pflval)

                              endif
                           endif
                           
                           write (*,'(5X,A)') 'Valeurs du champ : '                  
                           do l=1,nval*ncomp
                              write (*,'(15X,E20.8)') valr(l)             
                           enddo

                           
                           deallocate(valr)                           
                           
                        endif
                     endif
                     
                  enddo
               endif
               
            enddo
         endif
         
      enddo
   endif

   call efnpro(fid,nval,cret)
   write (*,'(5X,A,I2)') 'Nombre de profils stocks : ', nval

   if (nval .gt. 0 ) then
     do i=1,nval
       call efproi(fid,i,profil,nval,cret)
       write (*,'(5X,A,I2,A,A,A,I2)') 'Profil n ',i,' : ',profil, ' et de taille',nval
     enddo 
   endif
   
   call efferm (fid,cret)
   if (cret .ne. 0) write(*,'(I1)') cret
   
 end program test11
	
