/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __XINE_ENGINE_H__
#define __XINE_ENGINE_H__

#include <xine.h>
#include "configuration.hh"
#include "engine.hh"

class XineEngine : public Engine
{
private:
	xine_t*						xine;
	xine_stream_t*				stream;
	xine_video_port_t*			video_port;
	xine_audio_port_t*			audio_port;
	gint						width, height;
	double						pixel_aspect;
	gboolean					mute_state;
	IO::Channel*				fifo_output_stream;
	String						fifo_path;
	GThread*					video_thread;
	GtkWidget*					widget;
	GStaticRecMutex				size_mutex;
	Display*					display;
	Window						window_id;
	gint						dual_language_state;
	
	static void dest_size_cb ( void *data,
		int video_width, int video_height, double video_pixel_aspect,
		int *dest_width, int *dest_height, double *dest_pixel_aspect );
	static void frame_output_cb ( void *data,
		int video_width, int video_height, double video_pixel_aspect, int *dest_x, int *dest_y,
		int *dest_width, int *dest_height, double *dest_pixel_aspect, int *win_x, int *win_y );
	static GdkFilterReturn xevent_filter (XEvent* xev, GdkEvent* ev, XineEngine* engine);
	static gpointer video_thread_function(XineEngine* engine);	
	static gboolean on_expose(GtkWidget* widget, GdkEventExpose* event, XineEngine* engine);
	static void on_size(GtkWidget* widget, GdkEventConfigure *requisition, XineEngine* engine);
	
	void write(const gchar* buffer, gsize length);
	void open();
	void create();
	void destroy();
	void close();
	void on_timer();
	void expose(gint x, gint y, gint width, gint height);
	void mute(gboolean state);
	void set_audio_channel(gint channel);	
	void set_subtitle_channel(gint channel);
	void set_dual_language_state(gint state);
	
public:
	XineEngine ();
	~XineEngine();

	static void initialise()
	{
		if (!XInitThreads())
		{
			throw Exception("XInitThreads() failed");
		}
	}
};

#endif
