/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#include "glade.hh"
#include "application.hh"
#include <glib/gstdio.h>

Glade::Glade()
{
	glade_xml = NULL;
}

void Glade::load()
{
	glade_init();

	gchar* dirname = g_path_get_dirname(Application::get_current().get_exe_path().c_str());
	g_chdir(dirname);
	g_free(dirname);
	
	String path = "me-tv.glade";
	if (!IO::File::exists(path))
	{
		path = DATADIR;
		path += "/me-tv/glade/me-tv.glade";
	}
	
	Log::write(_("Loading glade file '%s'"), path.c_str());
	glade_xml = glade_xml_new(path.c_str(), NULL, NULL);
	if (glade_xml == NULL)
	{
		throw SystemException(_("Failed to load glade file"));
	}
}

GtkWidget* Glade::get_widget(const char* name)
{
	if (glade_xml == NULL)
	{
		throw Exception(_("Glade has not been initialised"));
	}
	
	GtkWidget* widget = glade_xml_get_widget(glade_xml, name);
	if (widget == NULL)
	{
		String message = String::format(_("Failed to get widget named '%s' from glade file"), name);
		throw Exception(message);
	}
	return widget;
}
