/*      Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#include    <string.h>

#include    "parse.h"
#include    "ilist.h"

#include    "util/types.h"
#include    "util/ting.h"
#include    "util/array.h"



mcxIL*   ilParseIntSet
(  const char*    string
,  long           max
,  mcxOnFail      ON_FAIL
)
   {  mcxBuf   ibuf
   ;  mcxTing   *itxt
   ;  char     *token
   ;  const char   *msg
   ;  int      left, right, i
   ;  int      *ip
   ;  mcxIL    *il
   ;  char*  op

   ;  il             =  ilInit(NULL)
   ;  mcxBufInit(&ibuf, &il->L, sizeof(int), 20)

   ;  itxt           =  mcxTingNew(string)
   ;  token          =  strtok(itxt->str, ",")

   ;  while(token)
      {  int   tokenlen       =  strlen(token)

      ;  if ((op = strchr(token+1, '-')) || (op = strchr(token+1, '%')))
         {  mcxTing  *fmt  =  mcxTingNew(op[0] == '-' ? "%d-%d" : "%d%%%d")
         ;  if (sscanf(token, fmt->str, &left, &right) == 2)
            {  if (op[0] == '-')
               for (i=left;i<=right;i++)
               {  if (!(ip = (int *)  mcxBufExtend(&ibuf, 1, ON_FAIL)))
                  {  mcxFree(il->L)
                  ;  return NULL
               ;  }
                  *ip         =  i
            ;  }
               else if (op[0] == '%')
               for (i=left;i<=max;i+=right)
               {  if (!(ip = (int *)  mcxBufExtend(&ibuf, 1, ON_FAIL)))
                  {  mcxFree(il->L)
                  ;  return NULL
               ;  }
                  *ip         =  i
            ;  }
            }
            else
            {  msg   =  "invalid binop specification in string"
            ;  goto parseError
         ;  }
            mcxTingFree(&fmt)
      ;  }

         else if (tokenlen)
         {  int   n  =  0  
         ;  if (!(ip = (int *)  mcxBufExtend(&ibuf, 1, ON_FAIL))) {
         mcxFree(il->L)
            ;  return NULL
         ;  }

            if ((sscanf(token, "%d%n", ip, &n) != 1) || n != tokenlen)
            {  msg   =  "invalid int specification in string"
            ;  goto parseError
         ;  }
         }

         else if (0)
         {  parseError:
            fprintf
            (  stderr
            ,  "[parseIntSet] %s [%s]\n"
            ,  msg
            ,  token
            )
         ;  if (ON_FAIL == RETURN_ON_FAIL)
            return NULL
         ;  else
            exit(1)
      ;  }

         else
         {  msg   =  "empty string with comma-boundary not allowed"
         ;  goto parseError

        /*  we actually never reach this place because strtok
         *  skips the empty records for us. It has no consistent way of giving
         *  us a correct offset.
         */
      ;  }

      ;  token          =  strtok(NULL, ",")
   ;  }

   ;  mcxTingFree(&itxt)
   ;  il->n       =  mcxBufFinalize(&ibuf)

   ;  return(il)
;  }


