/*
 * mibtree.c
 *
 * $Revision: 1.18 $
 *
 * Routines pertaining to manipulation of the mibtree
 *
 * Last Modified:
 *   $Author: ahodgen $
 *   $Date: 2002/08/11 15:39:56 $
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"
#include "details.h"
#include "icons.h"
#include "snmpstuff.h"

GtkWidget *mib_tree_view;
  GtkWidget *menu;
GtkWidget *mib_scrolledwin;
extern GtkWidget *oid_entry;
GtkCTreeNode *firstnode;

static GdkPixmap *table_xpm;
static GdkBitmap *table_mask;
GdkPixmap *child_xpm;
GdkBitmap *child_mask;
GdkPixmap *end_xpm;
GdkBitmap *end_mask;
static GdkBitmap *trap_xpm;
static GdkBitmap *trap_mask;

static GtkCTreeNode *selection=NULL;
int dont_select_damnit = 0;
extern GtkWidget *main_window;

static gint context_menu(GtkWidget *widget,GdkEvent *event);

void load_xpm(void) {

  table_xpm = gdk_pixmap_create_from_xpm_d(main_window->window,
      &table_mask,NULL,snmp_table_xpm);
  child_xpm = gdk_pixmap_create_from_xpm_d(main_window->window,
      &child_mask,NULL,folder_xpm);
  end_xpm = gdk_pixmap_create_from_xpm_d(main_window->window,
      &end_mask,NULL,leaf_xpm);
  trap_xpm = gdk_pixmap_create_from_xpm_d(main_window->window,
      &trap_mask,NULL,trap);
}

/* Step through the CTree until we arrive at the
 * last node associated with the oid.
 */

GtkCTreeNode *locate_treenode_by_oid(oid poid[],size_t size) {

  GtkCTreeNode *children;
  GtkCTreeNode *last_selected = NULL;
  int i;

  children=firstnode;
  for(i=0;i<size;i++) {
    for(;children;children=GTK_CTREE_ROW(children)->sibling) {
      if (((struct tree *)gtk_ctree_node_get_row_data(GTK_CTREE(mib_tree_view),children))->subid == poid[i]) {
        last_selected = children;
        gtk_ctree_expand(GTK_CTREE(mib_tree_view),children);
        children =GTK_CTREE_ROW(GTK_CTREE_NODE(children))->children;
        break;
      }
    }
   if (children == NULL)
     break;
  }
  dont_select_damnit = 1;
  gtk_ctree_node_moveto(GTK_CTREE(mib_tree_view),last_selected,0,0.5,0);
  gtk_ctree_select(GTK_CTREE(mib_tree_view),last_selected);
  return(last_selected);
}

int cmp_nodes(const void *a,const void *b) {

  return(((*(struct tree **)a)->subid - (*(struct tree **)b)->subid));
}

/* Recursively populate the mib ctree with
 * parsed mibs
 */

void populate_mib_tree(struct tree *child,GtkCTreeNode *tree) {

  struct tree *next;
  GtkCTreeNode *subtree;
  struct tree *items[1024];
  int i=0,j;
  GdkPixmap *map;
  GdkBitmap *mask;

  next = (tree == NULL) ? child : child->child_list;
  for(; next; next = next->next_peer){
    items[i] = next;
    i++;
  }
  qsort(items,i,sizeof(struct tree *),cmp_nodes);

  for(j=0;j<i;j++) {
    next = items[j];
    if (next->type == TYPE_TRAPTYPE || next->type == TYPE_NOTIFTYPE) {
      map = trap_xpm;
      mask = trap_mask;
    } else if (next->access == MIB_ACCESS_NOACCESS) {
      map = table_xpm;
      mask = table_mask;
    } else if (next->child_list) {
      map = child_xpm;
      mask = child_mask;
    } else {
      map = end_xpm;
      mask = end_mask;
    }
    subtree = gtk_ctree_insert_node(GTK_CTREE(mib_tree_view),tree,NULL,
                                    &next->label,5,map,mask,map,mask,
                                    (next->child_list)?FALSE:TRUE,FALSE);
    if (tree == NULL && firstnode==NULL) /* If this is the root of the tree */
      firstnode=subtree;                 /* make it the searchnode */ 
    gtk_ctree_node_set_row_data(GTK_CTREE(mib_tree_view),subtree,next);
    if (next->child_list) {
      populate_mib_tree(next,subtree);
    }
  }
}


void on_tree_select(GtkCTree *item,GList *node, gint column, gpointer junk) {

  struct tree *signame;
  struct tree *next;
  char *tmp,*start,*end;
  char real[1024];
  unsigned long val;
  GtkCTreeNode *pnode;

  selection = pnode = GTK_CLIST(item)->selection->data;
  signame = gtk_ctree_node_get_row_data(item,GTK_CTREE_NODE(pnode));
  if (!signame)
    return;
  populate_detail_tab(signame);
  /* Don't let us get called recursively */
  if ((dont_select_damnit = 1-dont_select_damnit) == 0)
    return;
  /* Put everything into a buffer backwards, then reverse it */
  start = tmp = real;
  for(next = signame;next && (tmp-real < 1023);next = next->parent) {
    val = next->subid;
    while(val > 0) {
      *tmp++ = val%10+'0';
      val /= 10;
    }
    *tmp++='.';
  }
  *tmp = 0x00;
  end = tmp-1;
  while(start < end) {
    char c;
    c = *start;
    *start = *end;
    *end = c;
    end--;
    start++;
  }
  gtk_entry_set_text(GTK_ENTRY(get_main_widgets()->oid_entry),real);
}

void expand_all(void) {

  GtkCTreeNode *p;

  for(p=firstnode;p;p=GTK_CTREE_ROW(p)->sibling)
    gtk_ctree_expand_recursive(GTK_CTREE(mib_tree_view),p);
}

void expand_below(void) {

  if (selection == NULL)
    expand_all();
  else
    gtk_ctree_expand_recursive(GTK_CTREE(mib_tree_view),selection);
}

void collapse_all(void) {

  GtkCTreeNode *p;

  for(p=firstnode;p;p=GTK_CTREE_ROW(p)->sibling)
    gtk_ctree_collapse_recursive(GTK_CTREE(mib_tree_view),p);
}

void collapse_below(void) {

  if (selection == NULL)
    collapse_all();
  else
    gtk_ctree_collapse_recursive(GTK_CTREE(mib_tree_view),selection);
}

void retree(struct tree *mibtree) {

    gtk_widget_destroy(mib_tree_view);
    mib_tree_view = gtk_ctree_new(1,0);
    gtk_container_add(GTK_CONTAINER(mib_scrolledwin),mib_tree_view);
    gtk_clist_set_column_auto_resize(GTK_CLIST(mib_tree_view),0,TRUE);
    gtk_signal_connect_object(GTK_OBJECT(mib_tree_view),"event",
                    GTK_SIGNAL_FUNC(context_menu),GTK_OBJECT(menu));
    gtk_signal_connect(GTK_OBJECT(mib_tree_view),"tree-select-row",
                    GTK_SIGNAL_FUNC(on_tree_select),NULL);
    populate_mib_tree(mibtree,NULL);
    gtk_widget_show(mib_tree_view);
}

void set_mibtree_style(int exp_style,int line_style) {

  gtk_ctree_set_expander_style(GTK_CTREE(mib_tree_view),exp_style);
  gtk_ctree_set_line_style(GTK_CTREE(mib_tree_view),line_style);
}

static struct menu_items context_items[] = {
  { "Collapse All",collapse_all,NULL,NULL },
  { "Collaps All Below",collapse_below,NULL,NULL },
  { "-",NULL,NULL,NULL },
  { "Expand All",expand_all,NULL,NULL },
  { "Expand All Below",expand_below,NULL,NULL },
  { NULL,NULL,NULL,NULL },
};

static gint context_menu(GtkWidget *widget,GdkEvent *event) {

  GdkEventButton *event_button;

  if (event->type == GDK_BUTTON_PRESS) {
    event_button = (GdkEventButton *) event;
    if (event_button->button == 3) {  /* Right mouse button clicked */
      gtk_menu_popup(GTK_MENU(widget), NULL, NULL, NULL, NULL, event_button->button, event_button->time);
    }
  }
  return(FALSE);
}

void create_mibtree_tab(void) {

  GtkWidget *mibtree_tab;
  GtkWidget *menu_item;
  GtkWidget *notebook;
  struct menu_items *m;

  load_xpm();
  notebook = get_main_widgets()->notebook;
  mib_scrolledwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(mib_scrolledwin),
      GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_placement(GTK_SCROLLED_WINDOW(mib_scrolledwin),
      GTK_CORNER_TOP_RIGHT);
  gtk_widget_show(mib_scrolledwin);
  gtk_container_add(GTK_CONTAINER(notebook),mib_scrolledwin);
  mibtree_tab = gtk_label_new("Mib Tree");
  gtk_widget_show(mibtree_tab);
  gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
      gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),0),mibtree_tab);

  menu = gtk_menu_new();
  for(m=context_items;m->item;m++) {
    if (*m->item == '-')
      menu_item = gtk_menu_item_new();
    else
      menu_item = gtk_menu_item_new_with_label(m->item);
    gtk_menu_append(GTK_MENU(menu),menu_item);
    if (m->func) {
      gtk_signal_connect_object(GTK_OBJECT(menu_item),"activate",
                       		GTK_SIGNAL_FUNC(m->func),m->data);
    }
    gtk_widget_show(menu_item);
  } 

  mib_tree_view = gtk_ctree_new(1,0);
  gtk_widget_show(mib_tree_view);
  gtk_container_add(GTK_CONTAINER(mib_scrolledwin),mib_tree_view);
  gtk_clist_set_column_auto_resize(GTK_CLIST(mib_tree_view),0,TRUE);
  gtk_signal_connect_object(GTK_OBJECT(mib_tree_view),"event",
      GTK_SIGNAL_FUNC(context_menu),GTK_OBJECT(menu));
  gtk_signal_connect(GTK_OBJECT(mib_tree_view),"tree-select-row",
      GTK_SIGNAL_FUNC(on_tree_select),NULL);
}
