#ifndef CREATURE_H
#define CREATURE_H
#include "allegro.h"
#include "config.h"

class linkedlist
{
 public:
  linkedlist *nextn, *previousn;

  linkedlist(linkedlist *parent=NULL) {
    if (parent) {
      nextn=parent->nextn;
      if (nextn) nextn->previousn=this;
      previousn=parent;
      parent->nextn=this;
    }
    else {
      previousn=NULL;
      nextn=NULL;
    }
  }
  
  virtual ~linkedlist() {
    if (previousn) previousn->nextn=nextn;
    if (nextn) nextn->previousn=previousn;
  }
  virtual linkedlist* next() {return nextn;}
  virtual linkedlist* previous() {return previousn;}

};
  
class creature: public linkedlist
{
 public:
  int hitpoints,power,health,speed,life,xcoor,ycoor,weight;
  unsigned int terrain,diet;
  float food;
  unsigned char load,status,dir,job,species;
  creature *creatureload;

  creature(creature* parent=NULL): linkedlist (parent) {}
  virtual ~creature() {
    if (load==MEAT)
     if (!creatureload) error ("Meat, no pointer,aargh");
      else delete creatureload;
  }
  virtual creature* newcreature()=0;

  virtual creature* next() {return (creature*) nextn;}
  virtual creature* previous() {return (creature*) previousn;}
  
  void preparecreature(creature* parent);
  virtual char* name();
  virtual int color() {return ((species+1)*16)%256+(species+1)/16;}
  virtual int lookslike();
  virtual void drawinfo(BITMAP *cr_info, bool firsttime);
  virtual void choosejob();
  virtual bool usekey() {return false;}
  virtual char shortkey() {return '$';}
  virtual int init_n_of() {return 100;}
};

extern creature **r[MAPWIDTH];
extern creature *firstcreature[N_OF_SPECIES];

#endif
