(**************************************************************************)
(*       ___                                                              *)
(*      ||M||                                                             *)
(*      ||A||       A project by Andrea Asperti                           *)
(*      ||T||                                                             *)
(*      ||I||       Developers:                                           *)
(*      ||T||         The HELM team.                                      *)
(*      ||A||         http://helm.cs.unibo.it                             *)
(*      \   /                                                             *)
(*       \ /        This file is distributed under the terms of the       *)
(*        v         GNU General Public License Version 2                  *)
(*                                                                        *)
(**************************************************************************)

(******************* SETS OVER TYPES *****************)

include "logic/connectives.ma".

nrecord powerclass (A: Type[0]) : Type[1] ≝ { mem: A → CProp[0] }.

interpretation "mem" 'mem a S = (mem ? S a).
interpretation "powerclass" 'powerset A = (powerclass A).
interpretation "subset construction" 'subset \eta.x = (mk_powerclass ? x).

ndefinition subseteq ≝ λA.λU,V.∀a:A. a ∈ U → a ∈ V.
interpretation "subseteq" 'subseteq U V = (subseteq ? U V).

ndefinition overlaps ≝ λA.λU,V.∃x:A.x ∈ U ∧ x ∈ V.
interpretation "overlaps" 'overlaps U V = (overlaps ? U V).

ndefinition intersect ≝ λA.λU,V:Ω^A.{ x | x ∈ U ∧ x ∈ V }.
interpretation "intersect" 'intersects U V = (intersect ? U V).

ndefinition union ≝ λA.λU,V:Ω^A.{ x | x ∈ U ∨ x ∈ V }.
interpretation "union" 'union U V = (union ? U V).

ndefinition big_union ≝ λA,B.λT:Ω^A.λf:A → Ω^B.{ x | ∃i. i ∈ T ∧ x ∈ f i }.

ndefinition big_intersection ≝ λA,B.λT:Ω^A.λf:A → Ω^B.{ x | ∀i. i ∈ T → x ∈ f i }.

ndefinition full_set: ∀A. Ω^A ≝ λA.{ x | True }.

nlemma subseteq_refl: ∀A.∀S: Ω^A. S ⊆ S.
 #A; #S; #x; #H; nassumption.
nqed.

nlemma subseteq_trans: ∀A.∀S,T,U: Ω^A. S ⊆ T → T ⊆ U → S ⊆ U.
 #A; #S; #T; #U; #H1; #H2; #x; #P; napply H2; napply H1; nassumption.
nqed.

include "properties/relations1.ma".

ndefinition seteq: ∀A. equivalence_relation1 (Ω^A).
 #A; @
  [ napply (λS,S'. S ⊆ S' ∧ S' ⊆ S)
  | #S; @; napply subseteq_refl
  | #S; #S'; *; #H1; #H2; @; nassumption
  | #S; #T; #U; *; #H1; #H2; *; #H3; #H4; @; napply subseteq_trans;
     ##[##2,5: nassumption |##1,4: ##skip |##*: nassumption]##]
nqed.

include "sets/setoids1.ma".

(* this has to be declared here, so that it is combined with carr *)
ncoercion full_set : ∀A:Type[0]. Ω^A ≝ full_set on A: Type[0] to (Ω^?).

ndefinition powerclass_setoid: Type[0] → setoid1.
 #A; @[ napply (Ω^A)| napply seteq ]
nqed.

include "hints_declaration.ma". 

alias symbol "hint_decl" = "hint_decl_Type2".
unification hint 0 ≔ A ⊢ carr1 (mk_setoid1 (Ω^A) (eq1 (powerclass_setoid A))) ≡ Ω^A.

(************ SETS OVER SETOIDS ********************)

include "logic/cprop.ma".

nrecord ext_powerclass (A: setoid) : Type[1] ≝
 { ext_carr:> Ω^A; (* qui pc viene dichiarato con un target preciso... 
                forse lo si vorrebbe dichiarato con un target più lasco 
                ma la sintassi :> non lo supporta *)
   ext_prop: ∀x,x':A. x=x' → (x ∈ ext_carr) = (x' ∈ ext_carr) 
 }.
 
notation > "𝛀 ^ term 90 A" non associative with precedence 70 
for @{ 'ext_powerclass $A }.

notation "Ω term 90 A \atop ≈" non associative with precedence 70 
for @{ 'ext_powerclass $A }.

interpretation "extensional powerclass" 'ext_powerclass a = (ext_powerclass a).

ndefinition Full_set: ∀A. 𝛀^A.
 #A; @[ napply A | #x; #x'; #H; napply refl1]
nqed.
ncoercion Full_set: ∀A. ext_powerclass A ≝ Full_set on A: setoid to ext_powerclass ?.

ndefinition ext_seteq: ∀A. equivalence_relation1 (𝛀^A).
 #A; @
  [ napply (λS,S'. S = S')
  | #S; napply (refl1 ? (seteq A))
  | #S; #S'; napply (sym1 ? (seteq A))
  | #S; #T; #U; napply (trans1 ? (seteq A))]
nqed.

ndefinition ext_powerclass_setoid: setoid → setoid1.
 #A; @
  [ napply (ext_powerclass A)
  | napply (ext_seteq A) ]
nqed.
              
unification hint 0 ≔ A;
      R ≟ (mk_setoid1 (𝛀^A) (eq1 (ext_powerclass_setoid A)))
  (* ----------------------------------------------------- *) ⊢  
                 carr1 R ≡ ext_powerclass A.

interpretation "prop21 mem" 'prop2 l r = (prop21 (setoid1_of_setoid ?) (ext_powerclass_setoid ?) ? ? ???? l r).
      
(*
ncoercion ext_carr' : ∀A.∀x:ext_powerclass_setoid A. Ω^A ≝ ext_carr 
on _x : (carr1 (ext_powerclass_setoid ?)) to (Ω^?). 
*)

nlemma mem_ext_powerclass_setoid_is_morph: 
 ∀A. binary_morphism1 (setoid1_of_setoid A) (ext_powerclass_setoid A) CPROP.
 #A; @
  [ napply (λx,S. x ∈ S) 
  | #a; #a'; #b; #b'; #Ha; *; #Hb1; #Hb2; @; #H;
     ##[ napply Hb1; napply (. (ext_prop … Ha^-1)); nassumption;
     ##| napply Hb2; napply (. (ext_prop … Ha)); nassumption;
     ##]
  ##]
nqed.

unification hint 0 ≔  A:setoid, x, S;  
     SS ≟ (ext_carr ? S),
     TT ≟ (mk_binary_morphism1 ??? 
             (λx:setoid1_of_setoid ?.λS:ext_powerclass_setoid ?. x ∈ S) 
             (prop21 ??? (mem_ext_powerclass_setoid_is_morph A))),
     XX ≟ (ext_powerclass_setoid A)
  (*-------------------------------------*) ⊢ 
      fun21 (setoid1_of_setoid A) XX CPROP TT x S 
    ≡ mem A SS x.

nlemma subseteq_is_morph: ∀A. binary_morphism1 (ext_powerclass_setoid A) (ext_powerclass_setoid A) CPROP.
 #A; @
  [ napply (λS,S'. S ⊆ S')
  | #a; #a'; #b; #b'; *; #Ha1; #Ha2; *; #Hb1; #Hb2; @; #H
     [ napply (subseteq_trans … a)
        [ nassumption | napply (subseteq_trans … b); nassumption ]
   ##| napply (subseteq_trans … a')
        [ nassumption | napply (subseteq_trans … b'); nassumption ] ##]
nqed.

unification hint 0 ≔ A,a,a'
 (*-----------------------------------------------------------------*) ⊢
  eq_rel ? (eq A) a a' ≡ eq_rel1 ? (eq1 (setoid1_of_setoid A)) a a'.

nlemma intersect_is_ext: ∀A. 𝛀^A → 𝛀^A → 𝛀^A.
 #A; #S; #S'; @ (S ∩ S');
 #a; #a'; #Ha; @; *; #H1; #H2; @ 
  [##1,2: napply (. Ha^-1‡#); nassumption;
##|##3,4: napply (. Ha‡#); nassumption]
nqed.

alias symbol "hint_decl" = "hint_decl_Type1".
unification hint 0 ≔ 
  A : setoid, B,C : ext_powerclass A;
  R ≟ (mk_ext_powerclass ? (B ∩ C) (ext_prop ? (intersect_is_ext ? B C)))
  
  (* ------------------------------------------*)  ⊢ 
    ext_carr A R ≡ intersect ? (ext_carr ? B) (ext_carr ? C).

nlemma intersect_is_morph: 
 ∀A. binary_morphism1 (powerclass_setoid A) (powerclass_setoid A) (powerclass_setoid A).
 #A; @ (λS,S'. S ∩ S');
 #a; #a'; #b; #b'; *; #Ha1; #Ha2; *; #Hb1; #Hb2; @; #x; nnormalize; *; #Ka; #Kb; @
  [ napply Ha1; nassumption
  | napply Hb1; nassumption
  | napply Ha2; nassumption
  | napply Hb2; nassumption]
nqed.

alias symbol "hint_decl" = "hint_decl_Type1".
unification hint 0 ≔ 
  A : Type[0], B,C : Ω^A;
  R ≟ (mk_binary_morphism1 …
       (λS,S'.S ∩ S') 
       (prop21 … (intersect_is_morph A)))
   ⊢ 
    fun21 (powerclass_setoid A) (powerclass_setoid A) (powerclass_setoid A) R B C 
  ≡ intersect ? B C.

interpretation "prop21 ext" 'prop2 l r = (prop21 (ext_powerclass_setoid ?) (ext_powerclass_setoid ?) ? ? ???? l r).

nlemma intersect_is_ext_morph: 
 ∀A. binary_morphism1 (ext_powerclass_setoid A) (ext_powerclass_setoid A) (ext_powerclass_setoid A).
 #A; @ (intersect_is_ext …); nlapply (prop21 … (intersect_is_morph A));
#H; #a; #a'; #b; #b'; #H1; #H2; napply H; nassumption; 
nqed.

unification hint 1 ≔ 
      A:setoid, B,C : 𝛀^A;
      R ≟ (mk_binary_morphism1 (ext_powerclass_setoid A) (ext_powerclass_setoid A) (ext_powerclass_setoid A)
              (λS,S':carr1 (ext_powerclass_setoid A).
                mk_ext_powerclass A (S∩S') (ext_prop A (intersect_is_ext ? S S'))) 
              (prop21 … (intersect_is_ext_morph A))) ,
       BB ≟ (ext_carr ? B),
       CC ≟ (ext_carr ? C)
   (* ------------------------------------------------------*) ⊢ 
            ext_carr A
             (fun21 
              (ext_powerclass_setoid A) 
              (ext_powerclass_setoid A) 
              (ext_powerclass_setoid A) R B C) ≡ 
            intersect (carr A) BB CC.

(*
alias symbol "hint_decl" = "hint_decl_Type2".
unification hint 0 ≔
  A : setoid, B,C : 𝛀^A ;
  CC ≟ (ext_carr ? C),
  BB ≟ (ext_carr ? B),
  C1 ≟ (carr1 (powerclass_setoid (carr A))),
  C2 ≟ (carr1 (ext_powerclass_setoid A))
  ⊢ 
     eq_rel1 C1 (eq1 (powerclass_setoid (carr A))) BB CC ≡ 
          eq_rel1 C2 (eq1 (ext_powerclass_setoid A)) B C.
          
unification hint 0 ≔
  A, B : CPROP ⊢ iff A B ≡ eq_rel1 ? (eq1 CPROP) A B.    
    
nlemma test: ∀U.∀A,B:𝛀^U. A ∩ B = A →
 ∀x,y. x=y → x ∈ A → y ∈ A ∩ B.
 #U; #A; #B; #H; #x; #y; #K; #K2;
  alias symbol "prop2" = "prop21 mem".
  alias symbol "invert" = "setoid1 symmetry".
  napply (. K^-1‡H);
  nassumption;
nqed. 


nlemma intersect_ok: ∀A. binary_morphism1 (ext_powerclass_setoid A) (ext_powerclass_setoid A) (ext_powerclass_setoid A).
 #A; @
  [ #S; #S'; @
     [ napply (S ∩ S')
     | #a; #a'; #Ha;
        nwhd in ⊢ (? ? ? % %); @; *; #H1; #H2; @
        [##1,2: napply (. Ha^-1‡#); nassumption;
      ##|##3,4: napply (. Ha‡#); nassumption]##]
 ##| #a; #a'; #b; #b'; #Ha; #Hb; nwhd; @; #x; nwhd in ⊢ (% → %); #H
      [ alias symbol "invert" = "setoid1 symmetry".
        alias symbol "refl" = "refl".
alias symbol "prop2" = "prop21".
napply (. ((#‡Ha^-1)‡(#‡Hb^-1))); nassumption
      | napply (. ((#‡Ha)‡(#‡Hb))); nassumption ]##]
nqed.

(* unfold if intersect, exposing fun21 *)
alias symbol "hint_decl" = "hint_decl_Type1".
unification hint 0 ≔ 
  A : setoid, B,C : ext_powerclass A ⊢ 
    pc A (fun21 …
            (mk_binary_morphism1 …
              (λS,S':qpowerclass_setoid A.mk_qpowerclass ? (S ∩ S') (mem_ok' ? (intersect_ok ? S S'))) 
              (prop21 … (intersect_ok A))) 
            B
            C) 
    ≡ intersect ? (pc ? B) (pc ? C).

nlemma test: ∀A:setoid. ∀U,V:qpowerclass A. ∀x,x':setoid1_of_setoid A. x=x' → x ∈ U ∩ V → x' ∈ U ∩ V.
 #A; #U; #V; #x; #x'; #H; #p; napply (. (H^-1‡#)); nassumption.
nqed.
*)

ndefinition image: ∀A,B. (carr A → carr B) → Ω^A → Ω^B ≝
 λA,B:setoid.λf:carr A → carr B.λSa:Ω^A.
  {y | ∃x. x ∈ Sa ∧ eq_rel (carr B) (eq B) (f x) y}.

ndefinition counter_image: ∀A,B. (carr A → carr B) → Ω^B → Ω^A ≝
 λA,B,f,Sb. {x | ∃y. y ∈ Sb ∧ f x = y}.

(******************* compatible equivalence relations **********************)

nrecord compatible_equivalence_relation (A: setoid) : Type[1] ≝
 { rel:> equivalence_relation A;
   compatibility: ∀x,x':A. x=x' → rel x x'
 }.

ndefinition quotient: ∀A. compatible_equivalence_relation A → setoid.
 #A; #R; @ A R; 
nqed.

(******************* first omomorphism theorem for sets **********************)

ndefinition eqrel_of_morphism:
 ∀A,B. unary_morphism A B → compatible_equivalence_relation A.
 #A; #B; #f; @
  [ @
     [ napply (λx,y. f x = f y)
     | #x; napply refl | #x; #y; napply sym | #x; #y; #z; napply trans]
##| #x; #x'; #H; nwhd; alias symbol "prop1" = "prop1".
napply (.= (†H)); napply refl ]
nqed.

ndefinition canonical_proj: ∀A,R. unary_morphism A (quotient A R).
 #A; #R; @
  [ napply (λx.x) | #a; #a'; #H; napply (compatibility … R … H) ]
nqed.

ndefinition quotiented_mor:
 ∀A,B.∀f:unary_morphism A B.
  unary_morphism (quotient … (eqrel_of_morphism … f)) B.
 #A; #B; #f; @
  [ napply f | #a; #a'; #H; nassumption]
nqed.

nlemma first_omomorphism_theorem_functions1:
 ∀A,B.∀f: unary_morphism A B.
  ∀x. f x = quotiented_mor … (canonical_proj … (eqrel_of_morphism … f) x).
 #A; #B; #f; #x; napply refl;
nqed.

alias symbol "eq" = "setoid eq".
ndefinition surjective ≝
 λA,B.λS: ext_powerclass A.λT: ext_powerclass B.λf:unary_morphism A B.
  ∀y. y ∈ T → ∃x. x ∈ S ∧ f x = y.

ndefinition injective ≝
 λA,B.λS: ext_powerclass A.λf:unary_morphism A B.
  ∀x,x'. x ∈ S → x' ∈ S → f x = f x' → x = x'.

nlemma first_omomorphism_theorem_functions2:
 ∀A,B.∀f: unary_morphism A B. 
   surjective … (Full_set ?) (Full_set ?) (canonical_proj ? (eqrel_of_morphism … f)).
 #A; #B; #f; nwhd; #y; #Hy; @ y; @ I ; napply refl; 
 (* bug, prova @ I refl *)
nqed.

nlemma first_omomorphism_theorem_functions3:
 ∀A,B.∀f: unary_morphism A B. 
   injective … (Full_set ?) (quotiented_mor … f).
 #A; #B; #f; nwhd; #x; #x'; #Hx; #Hx'; #K; nassumption.
nqed.

nrecord isomorphism (A, B : setoid) (S: ext_powerclass A) (T: ext_powerclass B) : Type[0] ≝
 { iso_f:> unary_morphism A B;
   f_closed: ∀x. x ∈ S → iso_f x ∈ T;
   f_sur: surjective … S T iso_f;
   f_inj: injective … S iso_f
 }.

nlemma subseteq_intersection_l: ∀A.∀U,V,W:Ω^A.U ⊆ W ∨ V ⊆ W → U ∩ V ⊆ W.
#A; #U; #V; #W; *; #H; #x; *; #xU; #xV; napply H; nassumption;
nqed.

nlemma subseteq_union_l: ∀A.∀U,V,W:Ω^A.U ⊆ W → V ⊆ W → U ∪ V ⊆ W.
#A; #U; #V; #W; #H; #H1; #x; *; #Hx; ##[ napply H; ##| napply H1; ##] nassumption;
nqed. 

nlemma subseteq_intersection_r: ∀A.∀U,V,W:Ω^A.W ⊆ U → W ⊆ V → W ⊆ U ∩ V.
#A; #U; #V; #W; #H1; #H2; #x; #Hx; @; ##[ napply H1; ##| napply H2; ##] nassumption;
nqed. 

(*
nrecord isomorphism (A, B : setoid) (S: qpowerclass A) (T: qpowerclass B) : CProp[0] ≝
 { iso_f:> unary_morphism A B;
   f_closed: ∀x. x ∈ pc A S → fun1 ?? iso_f x ∈ pc B T}.
   
   
ncheck (λA:?.
   λB:?.
    λS:?.
     λT:?.
      λxxx:isomorphism A B S T.
       match xxx
       return λxxx:isomorphism A B S T.
               ∀x: carr A.
                ∀x_72: mem (carr A) (pc A S) x.
                 mem (carr B) (pc B T) (fun1 A B ((λ_.?) A B S T xxx) x)
        with [ mk_isomorphism _ yyy ⇒ yyy ] ).   
   
   ;
 }.
*)
