(**************************************************************************)
(*       ___                                                              *)
(*      ||M||                                                             *)
(*      ||A||       A project by Andrea Asperti                           *)
(*      ||T||                                                             *)
(*      ||I||       Developers:                                           *)
(*      ||T||         The HELM team.                                      *)
(*      ||A||         http://helm.cs.unibo.it                             *)
(*      \   /                                                             *)
(*       \ /        This file is distributed under the terms of the       *)
(*        v         GNU General Public License Version 2                  *)
(*                                                                        *)
(**************************************************************************)

(*DOCBEGIN

Scopo della lezione
===================

Lo scopo della lezione è di usare Matita come strumento per la correzione 
automatica degli esercizi di deduzione naturale, che
saranno parte dell'esame scritto. 

Per risolvere gli esericizi dovrete

 1. Risolvere su carta gli esercizi qui proposti.
 
 2. Ricopiare gli esercizi su Matita secondo le istruzioni che seguono.
 

Gli esercizi
============

1. (A ⇒ (B ⇒ C)) ⇒ (A ∧ B) ⇒ C
2. ¬(A∨B) ⇒ (¬A ∧ ¬B)
3. ¬A ∧ ¬B ⇒ ¬(A∨B)
4. ¬((A ∧ B) → C) -> ¬(A → (B → C)) 
5. ¬(A ∧ (¬A ∨ B ∨ C) ∧ (¬B ∨ D) ∧ ¬C ∧ ¬D)
6. (F ⇒ G∨E) ⇒ (G ⇒ ¬L∨E) ⇒ (L⇒F) ⇒ L ⇒ E 
7. (C∧G ⇒ E) ⇒ (¬L ⇒ E∨C) ⇒ G ∨ L ⇒ ¬L ⇒ E
 

La tabella vista a lezione
==========================
* `c` : `intr`  `elim`
* `∧` : `ok` `ok`
* `∨` : `check` `ok`
* `¬` : `ok` `check`
* `⇒` : `ok` `bloccata + check`
* `⊥` : `ok` ` `
* `⊤` : ` ` `ok`

Le istruzioni per Matita
========================

1. Con il comando F2 aprire la palette con le shortcut per le regole di 
deduzione naturale

2. Con il comando F3 aprire un nuovo CIC browser e cliccare sul simbolo Home 
   (una casa). In questa finestra verrà disegnato l'albero man mano che lo 
   costruite.
   
3. Cominciate a ricopiare l'albero di deduzione naturale che avete scritto su 
   carta. La copiatura procede dal basso verso l'alto.
   
I connettivi logici
===================

Per digitare i connettivi logici:

* `∧` : `\land`
* `∨` : `\lor`
* `¬` : `\lnot`
* `⇒` : `=>`, `\Rightarrow` (!! Attenzione non usare →)
* `⊥` : `\bot`
* `⊤` : `\top`


Le regole di deduzione naturale
===============================

Per digitare le regole di deduzione naturale utilizzate la palette 
che è comparsa sulla sinistra.

In questa palette troverete i template per tutte le regole  di introduzione 
ed eliminazione dei connettivi viste a lezione TRANNE il template della regola 
di eliminazione dell'AND.

Ogni regola si occupa di riscrivere una riga/sottoalbero della vostra 
dimostrazione: immaginate che ogni comando apply_rule si occupi di 
riscrivere la premessa e la regola sotto utilizzata in questo modo

premessa

---------------- regola

Regola generica con una sola premessa  
  
  apply rule (nome_regola [eventuali ipotesi] (premessa) )
  
Esempio: se nell'ultimo passo di una deduzione naturale avessi utilizzato la
regola di eliminazione dell'implica per concludere A → B scriverei:

    apply rule (⇒_i [h1] (B));

dove ho chiamato h1 l'ipotesi A.  
  
Regola generica con diverse premesse: queste regole sono seguite da   
`[`, `|` e `]` in questo modo

    apply rule (nome_regola (premessa_1) ...  (premessa_n));
    [ dimostrazione per premessa 1
    | dimostrazione per premessa 2
    ...
    | dimostrazione per premessa n
    ]
 
Ad esempio: 

    apply rule (∧_i (F) (G));
    [ …continua qui il sottoalbero per (F)
    | …continua qui il sottoalbero per (G)
    ] 


Se nelle varie premesse vengono introdotte delle ipotesi queste vanno 
aggiunte tra parentesi quadre. Ad esempio nella regola di eliminazione 
dell'∨

    apply rule (∨_e (A∨B) [h1] C [h2] C);
    [ dimostrazione di (A∨B)
    | dimostrazione di C sotto l'ipotesi A (di nome h1)  
    | dimostrazione di C sotto l'ipotesi B (di nome h2)
    ]


In sintesi le regole vengono applicate alle loro premesse, ovvero
gli argomenti delle regole sono le formule che normalmente 
scrivete sopra la linea che rappresenta l'applicazione della
regola stessa.        

Le regole che hanno una sola premessa non vengono seguite 
da parentesi quadre.

Quando arrivate ad una foglia del vostro albero utilizzerete la regola
Discharge (Si trova tra Misc Rules)

    apply rule (discharge [nome ipotesi]);




Template per la regola di eliminazione dell'`∧`
==============================================

    apply rule (∧_e (A ∧ B) [h1] [h2] (C));
	  [ dimostrazione di (A ∧ B)
	  | dimostrazione di (C) utilizzando le ipotesi A (chiamata h1) e B (chiamata h2)
	  ]



Notazione: I termini, le formule e i nomi delle ipotesi
=======================================================

* Le formule, se argomenti di
  una regola, vengono scritte tra `(` e `)`.

* I nomi delle ipotesi, se argomenti di
  una regola, vengono scritti tra `[` e `]`.


L'albero di deduzione
=====================

Nella finestra che avete aperto con il comando F3 man mano che lo costruite 
comparirà l'albero di deduzione.

Applicazioni di regole errate vengono contrassegnate con
il colore rosso.

Suggerimenti
============

* Nelle regole con più premesse ricordatevi di indentare il codice.
In questo modo sarà più facile trovare gli errori e correggerli.

* Nella regola di eliminazione del ¬ la premessa di sinistra è quella 
negata.  Esempio:

        apply rule (¬_e (¬ F) (F));
        [ dimostrazione di ¬ F
        | dimostrazione di F
        ]

Buon lavoro

DOCEND*)

(* Esercizio 0
   ===========

   Compilare i seguenti campi:

   Nome1: ...
   Cognome1: ...
   Matricola1: ...
   Account1: ...

   Nome2: ...
   Cognome2: ...
   Matricola2: ...
   Account2: ...

*)

(* ATTENZIONE
   ==========
   
   Non modificare quanto segue 
*)

include "didactic/support/natural_deduction.ma".

definition And_elim: ∀A,B,C: CProp. A ∧ B → (A → B → C) → C.
 intros; cases H; apply H1; assumption.
qed.

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp abc \emsp) c (mstyle color #ff0000 (∧\sub\e \emsp) ident Ha \emsp ident Hb)" with precedence 19
for @{ 'And_elim_ko_1 $ab $c (λ${ident Ha}:$ta.λ${ident Hb}:$tb.$abc) }.
interpretation "And_elim_ko_1" 'And_elim_ko_1 ab c \eta.\eta.abc =
  (show c (cast _ _ (And_elim _ _ _ (cast _ _ ab) (cast _ _ abc)))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp abc \emsp) mstyle color #ff0000 (c) (mstyle color #ff0000 (∧\sub\e) \emsp ident Ha \emsp ident Hb)" with precedence 19
for @{ 'And_elim_ko_2 $ab (λ${ident Ha}:$ta.λ${ident Hb}:$tb.$abc) $c }.
interpretation "And_elim_ko_2" 'And_elim_ko_2 ab \eta.\eta.abc c =
  (cast _ _ (show c (cast _ _ (And_elim _ _ _ (cast _ _ ab) (cast _ _ abc))))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp abc \emsp) c (∧\sub\e \emsp ident Ha \emsp ident Hb)" with precedence 19
for @{ 'And_elim_ok_1 $ab (λ${ident Ha}:$ta.λ${ident Hb}:$tb.$abc) $c }.
interpretation "And_elim_ok_1" 'And_elim_ok_1 ab \eta.\eta.abc c =
  (show c (And_elim _ _ _ ab abc)).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp abc \emsp) mstyle color #ff0000 (c) (∧\sub\e \emsp ident Ha \emsp ident Hb)" with precedence 19
for @{ 'And_elim_ok_2 $ab (λ${ident Ha}:$ta.λ${ident Hb}:$tb.$abc) $c }.
interpretation "And_elim_ok_2" 'And_elim_ok_2 ab \eta.\eta.abc c =
  (cast _ _ (show c (And_elim _ _ _ ab abc))).

notation > "∧_'e' term 90 ab [ident Ha] [ident Hb] term 90 c" with precedence 19
for @{ 'And_elim (show $ab ?) (λ${ident Ha}.λ${ident Hb}.show $c ?) }.
interpretation "And_elim KO" 'And_elim ab abc =
  (cast _ _ (And_elim _ _ _
    (cast (And unit unit) _ ab)
    (cast (unit_to (unit_to unit)) (unit_to _) abc))).
interpretation "And_elim OK" 'And_elim ab abc = (And_elim _ _ _ ab abc).


(* Esercizio risolto di esempio *)

theorem ex0 : (B ⇒ ¬A) ⇒ (A ⇒ ¬B).
(* Questo comando disegna l'ultima riga dell'albero *)
apply rule (prove ((B ⇒ ¬A) ⇒ (A ⇒ ¬B)));
(* Applico una regola di introduzione dell'implica*)
apply rule (⇒_i [h3] (A ⇒ ¬B));
(* Applico una regola di introduzione dell'implica*)
apply rule (⇒_i [h2] (¬ B));
(* Applico una regola di introduzione del not*)
apply rule (¬_i [h1] (⊥));
(* Applico una regola di eliminazione del not*)
apply rule (¬_e (A) (¬A));
	[(*Applico una regola di eliminazione dell'implica*)
	  apply rule (⇒_e (B ⇒ ¬A) (B));
	  [ apply rule (discharge [h3]); (*Scarico B ⇒ ¬A con l'ipotesi h3*)
	  | apply rule (discharge [h1]); (*Scarico B con l'ipotesi h1*)
	  ]
	| apply rule (discharge [h2]); (*Scarico A con l'ipotesi h2*)
	]
qed.





(*
TEMPLATE PER L'ELIMINAZIONE DI ∧

apply rule (∧_e (…) […] […] (…));
	[ 
	| 
	]

*)


theorem ex1 : (A ⇒ (B ⇒ C)) ⇒ (A ∧ B) ⇒ C.

apply rule (prove ((A ⇒ (B ⇒ C)) ⇒ (A ∧ B) ⇒ C));
(*BEGIN*)
apply rule (⇒_i [h3] ((A ∧ B) ⇒ C));
apply rule (⇒_i [h2] (C));
apply rule (∧_e (A ∧ B) [h1l] [h1r] (C));
	[ apply rule (discharge [h2]);
	| apply rule (⇒_e (B ⇒ C) (B));
	  [ apply rule (⇒_e (A ⇒ (B ⇒ C)) (A));
	   [ apply rule (discharge [h3]);
	   |apply rule (discharge [h1r]);
	   ]
	  | apply rule (discharge [h1l]);
	  ]
	]
(*END*)
qed.

theorem ex2 :  ¬(A∨B) ⇒ (¬A ∧ ¬B).
apply rule (prove (¬(A∨B) ⇒ (¬A ∧ ¬B)));
(*BEGIN*)
apply rule (⇒_i [h3] (¬A ∧ ¬B));
apply rule (∧_i (¬A) (¬B));
	[ apply rule (¬_i [h1] (⊥));
	  apply rule (¬_e (¬(A∨B)) (A∨B));
	  [ apply rule (discharge [h3]);
	  | apply rule (∨_i_l (A));
	    apply rule (discharge [h1]);
	  ]
	| apply rule (¬_i [h2] (⊥));
	  apply rule (¬_e (¬(A∨B)) (A∨B));
	  [ apply rule (discharge [h3]);
	  | apply rule (∨_i_r (B));
	    apply rule (discharge [h2]);
	  ]
	]
(*END*)
qed.

theorem ex3 :  ¬A ∧ ¬B ⇒ ¬(A∨B).
apply rule (prove (¬A ∧ ¬B ⇒ ¬(A∨B)));
(*BEGIN*)
apply rule (⇒_i [h4] (¬(A∨B)));
apply rule (¬_i [h3] (⊥));
apply rule (∧_e (¬A ∧ ¬B) [h2l] [h2r] (⊥));
	[ apply rule (discharge [h4]);
	| apply rule (∨_e (A ∨ B) [h1l] (⊥) [h1r] (⊥));
	  [ apply rule (discharge [h3]);
	  | apply rule (¬_e (¬A) (A));
	    [ apply rule (discharge [h2l]);
	    |apply rule (discharge [h1l]);
	    ]
	  | apply rule (¬_e (¬B) (B));
	    [ apply rule (discharge [h2r]);
	    |apply rule (discharge [h1r]);
	    ]
	  ]
	]
(*END*)
qed.

theorem ex4 :  ¬((A ∧ B) → C) -> ¬(A → (B → C)).
apply rule (prove (¬((A ∧ B) → C) -> ¬(A → (B → C))));
(*BEGIN*)
apply rule (⇒_i [h1] (¬((A ∧ B) → C)));
 
(*END*)
qed. 

theorem ex5 :  ¬(A ∧ (¬A ∨ B ∨ C) ∧ (¬B ∨ D) ∧ ¬C ∧ ¬D).
apply rule (prove (¬(A ∧ (¬A ∨ B ∨ C) ∧ (¬B ∨ D) ∧ ¬C ∧ ¬D)));
(*BEGIN*)
(*END*)
qed. 

theorem ex6 :  (F ⇒ G∨E) ⇒ (G ⇒ ¬L∨E) ⇒ (L⇒F) ⇒ L ⇒ E .
apply rule (prove ((F ⇒ G∨E) ⇒ (G ⇒ ¬L∨E) ⇒ (L⇒F) ⇒ L ⇒ E));
(*BEGIN*)
(*END*)
qed. 

theorem ex7 :  (C∧G ⇒ E) ⇒ (¬L ⇒ E∨C) ⇒ G ∨ L ⇒ ¬L ⇒ E.
apply rule (prove ((C∧G ⇒ E) ⇒ (¬L ⇒ E∨C) ⇒ G ∨ L ⇒ ¬L ⇒ E));
(*BEGIN*)
(*END*)
qed. 

