(* Copyright (C) 2006, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

(* $Id: saturation.mli 7438 2007-06-13 13:01:32Z tassi $ *)

type passive_table
type active_table = Equality.equality list * Indexing.Index.t

val reset_refs : unit -> unit

val make_active: Equality.equality list -> active_table
val make_passive: Equality.equality list -> passive_table
val add_to_passive: Equality.equality list -> passive_table -> passive_table
val list_of_passive: passive_table -> Equality.equality list

val simplify_equalities : 
  Equality.equality_bag ->
  UriManager.uri ->
  Utils.environment -> 
  Equality.equality list -> 
  Equality.equality list
val pump_actives :
  Cic.context ->
  Equality.equality_bag ->
  int ->
  active_table ->
  passive_table -> 
  int -> 
  float -> 
  active_table * passive_table * int
val all_subsumed :
  Equality.equality_bag ->
  int ->
  ProofEngineTypes.status ->
  active_table ->
  passive_table -> 
  (Cic.substitution * 
     ProofEngineTypes.proof * 
     ProofEngineTypes.goal list) list * int
val given_clause: 
  Equality.equality_bag ->
  int -> (* maxmeta *)
  ProofEngineTypes.status ->
  active_table ->
  passive_table -> 
  int -> int -> float -> 
    (Cic.substitution * 
     ProofEngineTypes.proof * 
     ProofEngineTypes.goal list) option * 
    active_table * passive_table * int

