(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCicSubstitution.mli 8545 2008-05-15 10:08:00Z asperti $ *)

(* lift n t                                                              *)
(*  lifts [t] of [n]                                                     *)
(*  [from] default 1, lifts only indexes >= [from]                       *)
(*  NOTE: the opposite function (delift_rels) is defined in CicMetaSubst *)
(*  since it needs to restrict the metavariables in case of failure      *)
val lift : ?from:int -> int -> NCic.term -> NCic.term

(* subst t1 t2                                                          *)
(*  substitutes [t1] for [Rel 1] in [t2]                                *)
(*  if avoid_beta_redexes is true (default: false) no new beta redexes  *)
(*  are generated. WARNING: the substitution can diverge when t2 is not *)
(*  well typed and avoid_beta_redexes is true.                          *)
val subst : ?avoid_beta_redexes:bool -> NCic.term -> NCic.term -> NCic.term

(* psubst [avoid] [delift] [lift_args] [t] [map_arg] [args]              
 *  [avoid] : do not leave newly created beta-redexes, default false
 *  [delift] : perform delifting
 *  [t] : term to fill in
 *  [lift_args] : lift argument after map_arg is applied
 *  [args] : stuff to substitute
 *  [map_arg] : map the argument to obtain a term
 *    the function is ReductionStrategy.from_env_for_unwind when psubst is
 *    used to implement nCicReduction.unwind'                              *)
val psubst : 
  ?avoid_beta_redexes:bool ->  
  ('a -> NCic.term) -> 'a list -> NCic.term -> 
    NCic.term

(* subst_meta (n, Ctx [t_1 ; ... ; t_n]) t                                  *)
(*  returns the term [t] where [Rel i] is substituted with [t_i] lifted by n *)
(*  [t_i] is lifted as usual when it crosses an abstraction                  *)
(* subst_meta (n, Irl _) t -> lift n t                                        *)
val subst_meta : NCic.local_context -> NCic.term -> NCic.term

