(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCicReduction.mli 8698 2008-06-09 16:02:24Z ricciott $ *)

val whd : 
  ?delta:int -> ?subst:NCic.substitution -> 
  NCic.context -> NCic.term -> 
    NCic.term

val are_convertible :
  ?subst:NCic.substitution ->
  (subst:NCic.substitution ->
   NCic.context -> NCic.term -> NCic.term list -> bool list) ->
  NCic.context -> NCic.term -> NCic.term -> bool


(* performs head beta/(delta)/cast reduction; the default is to not perform
   delta reduction; if provided, ~upto is the maximum number of beta redexes
   reduced *)
val head_beta_reduce: ?delta:int -> ?upto:int -> NCic.term -> NCic.term
