(* Copyright (C) 2004-2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

(* $Id: grafiteTypes.mli 8052 2008-01-10 22:32:03Z tassi $ *)

exception Option_error of string * string
exception Statement_error of string
exception Command_error of string

val command_error: string -> 'a   (** @raise Command_error *)

type incomplete_proof = {
  proof: ProofEngineTypes.proof;
  stack: Continuationals.Stack.t;
}

type proof_status =
    No_proof
  | Incomplete_proof of incomplete_proof
  | Proof of ProofEngineTypes.proof
  | Intermediate of Cic.metasenv

(*
type option_value =
  | String of string
  | Int of int
type options
val no_options: options
*)

type status = {
  moo_content_rev: GrafiteMarshal.moo;
  proof_status: proof_status;                             (** logical status *)
(*   options: options; *)
  objects: UriManager.uri list;  (** in-scope objects *)
  coercions: UriManager.uri list; (** defined coercions *)
  universe:Universe.universe;  (** universe of terms used by auto *)
  baseuri: string;
}

val dump_status : status -> unit

  (** list is not reversed, head command will be the first emitted *)
val add_moo_content: GrafiteMarshal.ast_command list -> status -> status

(* REOMVE ME
val get_option : status -> string -> option_value
val get_string_option : status -> string -> string
val set_option : status -> string -> string -> status
*)
val get_baseuri: status -> string 

val get_current_proof: status -> ProofEngineTypes.proof
val get_proof_metasenv: status ->  Cic.metasenv
val get_stack: status -> Continuationals.Stack.t
val get_proof_context : status -> int -> Cic.context
val get_proof_conclusion : status -> int -> Cic.term

val set_stack: Continuationals.Stack.t -> status -> status
val set_metasenv: Cic.metasenv -> status -> status

