/* {{{ License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */ //}}}
// :indentSize=4:lineSeparator=\n:noTabs=false:tabSize=4:folding=explicit:collapseFolds=0:
package org.mathpiper.test;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 *
 * @author tkosan
 */
public class Build {

    private java.io.File scriptsDir;
    private java.io.FileWriter packagesFile;
    private String sourceScriptsDirectory = null;
    private String outputScriptsDirectory = null;
    private String outputDocsDirectory = null;
    private String sourceDirectory = null;
    private java.io.DataOutputStream documentationFile;
    private java.io.FileWriter documentationIndexFile;
    private long documentationOffset = 0;
    private java.io.FileWriter functionCategoriesFile;
    private List<CategoryEntry> functionCategoriesList = new ArrayList<CategoryEntry>();


    public Build() {
    }//end constructor.


    public Build(String sourceScriptsDirectory, String outputScriptsDirectory) {
        this.sourceScriptsDirectory = sourceScriptsDirectory;
        this.outputScriptsDirectory = outputScriptsDirectory;
    }//end constructor.


    public Build(String sourceScriptsDirectory, String outputScriptsDirectory, String outputDocsDirectory) throws Exception {
        this(sourceScriptsDirectory, outputScriptsDirectory);

        this.outputDocsDirectory = outputDocsDirectory;

        documentationFile = new DataOutputStream(new java.io.FileOutputStream(outputDocsDirectory + "documentation.txt"));
        documentationIndexFile = new java.io.FileWriter(outputDocsDirectory + "documentation_index.txt");
        functionCategoriesFile = new java.io.FileWriter(outputDocsDirectory + "function_categories.txt");



    }


    public void setSourceScriptsDirectory(String scriptsDirectory) {
        this.sourceScriptsDirectory = scriptsDirectory;
    }//end method.


    public void setOutputScriptsDirectory(String outputDirectory) {
        this.outputScriptsDirectory = outputDirectory;
    }//end method.


    public void setOutputDocsDirectory(String outputDocsDirectory) throws Exception {
        this.outputDocsDirectory = outputDocsDirectory;


        documentationFile = new DataOutputStream(new java.io.FileOutputStream(outputDocsDirectory + "documentation.txt"));
        documentationIndexFile = new java.io.FileWriter(outputDocsDirectory + "documentation_index.txt");
        functionCategoriesFile = new java.io.FileWriter(outputDocsDirectory + "function_categories.txt");


    }//end method.


    public void setBaseDirectory(String baseDirectory) {
        this.sourceDirectory = baseDirectory + "src/";
    }//end method.


    public void compileScripts() throws Exception {

        StringBuilder mainScriptsClassBuffer = new StringBuilder();


        mainScriptsClassBuffer.append("static{\n");



        //System.out.println("XXXXX " + outputDirectory);
        packagesFile = new java.io.FileWriter(outputScriptsDirectory + "initialization.rep/packages.mpi");
        packagesFile.write("//// This file is generated by a script.\n/// It lists all {.def} files in the library.\nDefun(DefFileList,{}) {\n");


        scriptsDir = new java.io.File(sourceScriptsDirectory);

        if (scriptsDir.exists()) {
            java.io.File[] packagesDirectory = scriptsDir.listFiles(new java.io.FilenameFilter() {

                public boolean accept(java.io.File file, String name) {
                    if (name.endsWith(".rep") || name.startsWith(".")) {
                        return (false);
                    } else {
                        return (true);
                    }
                }


            });

            Arrays.sort(packagesDirectory);



            String output;
            for (int x = 0; x < packagesDirectory.length; x++) {
                //Process each package directory.************************************************************************
                File packageDirectoryFile = packagesDirectory[x];
                String packageDirectoryFileName = packageDirectoryFile.getName();
                System.out.println(packageDirectoryFileName);

                //Create package directory
                String dirNameRep = packageDirectoryFileName;
                String newPackageName = dirNameRep + ".rep";
                String newPackagePath = outputScriptsDirectory + newPackageName;
                File newPackageFile = new File(newPackagePath);
                Boolean directoryCreated = newPackageFile.mkdir();

                //mpi file.
                BufferedWriter mpiFileOut = null;
                File newMPIFile = new File(newPackagePath + "/" + "code.mpi");
                newMPIFile.createNewFile();
                mpiFileOut = new BufferedWriter(new FileWriter(newMPIFile));

                packagesFile.write("\"org/mathpiper/assembledscripts/" + newPackageName + "/code.mpi\",\n");

                //mpi.def file
                BufferedWriter mpiDefFileOut = null;
                File newMPIDefFile = new File(newPackagePath + "/" + "code.mpi.def");
                newMPIDefFile.createNewFile();
                mpiDefFileOut = new BufferedWriter(new FileWriter(newMPIDefFile));


                //Place files in package dir
                if (packageDirectoryFile.exists()) {
                    java.io.File[] packageDirectoryContentsArray = packageDirectoryFile.listFiles(new java.io.FilenameFilter() {

                        public boolean accept(java.io.File file, String name) {
                            if (name.startsWith(".")) {
                                return (false);
                            } else {
                                return (true);
                            }
                        }


                    });

                    Arrays.sort(packageDirectoryContentsArray);


                    // }//note:tk:remove.
                    String classNameUpper = null;

                    for (int x2 = 0; x2 < packageDirectoryContentsArray.length; x2++) {
                        //Process each script or subdirectory in a .rep directory.***********************************************************************************
                        File scriptFileOrSubdirectoy = packageDirectoryContentsArray[x2];
                        System.out.println("    " + scriptFileOrSubdirectoy.getName());

                        if (scriptFileOrSubdirectoy.getName().endsWith(".mrw")) {
                            //Process a .mrw files that is in a top-level package. ************************************************************************

                            processMRWFile(scriptFileOrSubdirectoy, mpiDefFileOut, mpiFileOut);

                        } else {
                            //Process a subdirectory.***********************************************************************************************
                            java.io.File[] packageSubDirectoryContentsArray = scriptFileOrSubdirectoy.listFiles(new java.io.FilenameFilter() {

                                public boolean accept(java.io.File file, String name) {
                                    if (name.startsWith(".")) {
                                        return (false);
                                    } else {
                                        return (true);
                                    }
                                }


                            });

                            Arrays.sort(packageSubDirectoryContentsArray);

                            BufferedWriter mpiSubDirectoyFileOut = null;
                            File newMPISubDirectoyFile = new File(newPackagePath + "/" + scriptFileOrSubdirectoy.getName() + ".mpi");
                            newMPISubDirectoyFile.createNewFile();
                            mpiSubDirectoyFileOut = new BufferedWriter(new FileWriter(newMPISubDirectoyFile));

                            packagesFile.write("\"org/mathpiper/assembledscripts/" + newPackageName + "/" + scriptFileOrSubdirectoy.getName() + ".mpi" + "\",\n");

                            //mpi.def file
                            BufferedWriter mpiSubDirectoyDefFileOut = null;
                            File newMPISubDirectoyDefFile = new File(newPackagePath + "/" + scriptFileOrSubdirectoy.getName() + ".mpi.def");
                            newMPISubDirectoyDefFile.createNewFile();
                            mpiSubDirectoyDefFileOut = new BufferedWriter(new FileWriter(newMPISubDirectoyDefFile));

                            for (int x3 = 0; x3 < packageSubDirectoryContentsArray.length; x3++) {
                                //Process each script in a package subdirectlry directory.
                                File scriptFile2 = packageSubDirectoryContentsArray[x3];
                                System.out.println("        " + scriptFile2.getName());

                                processMRWFile(scriptFile2, mpiSubDirectoyDefFileOut, mpiSubDirectoyFileOut);

                                //mpi file.


                            }//end subpackage for.

                            if (mpiSubDirectoyFileOut != null) {
                                mpiSubDirectoyFileOut.close();
                                mpiSubDirectoyDefFileOut.write("}\n\n");
                                mpiSubDirectoyDefFileOut.close();
                            }

                        }//end else.

                    }//end package for.




                }//end if.

                if (mpiFileOut != null) {
                    mpiFileOut.close();
                    mpiDefFileOut.write("}\n");
                    mpiDefFileOut.close();
                }

            }//end for.

            if (documentationFile != null) {
                processBuiltinDocs();
            }

            Collections.sort(functionCategoriesList);
            for (CategoryEntry entry : functionCategoriesList) {
                functionCategoriesFile.write(entry.toString() + "\n");
            }


        } else {
            System.out.println("\nDirectory " + sourceScriptsDirectory + "does not exist.\n");
        }

        packagesFile.write("\n};\n");
        packagesFile.close();

        if (documentationFile != null) {

            documentationFile.close();
            documentationIndexFile.close();
            functionCategoriesFile.close();
        }




    }//end method.


    List scanSourceFile(File sourceFile) throws Exception {


        String fileName = sourceFile.getName();

        //Uncomment for debugging.
        /*
        if (fileName.equals("Factors.mrw")) {
            int xxx = 1;
        }//end if.*/

        List<Fold> folds = new ArrayList();
        StringBuilder foldContents = new StringBuilder();
        String foldHeader = "";
        boolean inFold = false;


        FileInputStream fstream = new FileInputStream(sourceFile);
        // Get the object of DataInputStream
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line;
        //Read File Line By Line
        while ((line = br.readLine()) != null) {
            //line = line.trim();
            //System.out.println(line);

            if (line.startsWith("%/")) {

                if (inFold == false) {
                    throw new Exception("Opening fold tag missing in " + fileName + ".");
                }

                Fold fold = new Fold(foldHeader, foldContents.toString());
                foldContents.delete(0, foldContents.length());
                folds.add(fold);
                inFold = false;

            } else if (line.startsWith("%")) {

                if (inFold == true) {
                    throw new Exception("Closing fold tag missing in " + fileName + ".");
                }

                foldHeader = line;
                inFold = true;
            } else if (inFold == true) {
                foldContents.append(line);
                foldContents.append("\n");

            }
        }//end while.

        if (inFold == true) {
            throw new Exception("Opening or closing fold tag missing in " + fileName + ".");
        }

        //Close the input stream
        in.close();


        return folds;

    }//end.


    class Fold {

        private String type;
        private String contents;
        private Map<String, String> attributes = new HashMap();


        public Fold(String header, String contents) {
            scanHeader(header);

            this.contents = contents;
        }//end inner class.


        private void scanHeader(String header) {
            String[] headerParts = header.trim().split(",");

            type = headerParts[0];

            for (int x = 1; x < headerParts.length; x++) {
                headerParts[x] = headerParts[x].replaceFirst("=", ",");
                String[] headerPart = headerParts[x].split(",");
                String attributeName = headerPart[0];
                String attributeValue = headerPart[1].replace("\"", "");
                attributes.put(attributeName, attributeValue);
            }

        }//end method.


        public Map getAttributes() {
            return attributes;
        }


        public String getContents() {
            return contents;
        }


        public String getType() {
            return type;
        }


    }//end inner class.


    private void processMRWFile(File mrwFile, Writer mpiDefFileOut, Writer mpiFileOut) throws Exception {

        List<Fold> folds = scanSourceFile(mrwFile);

        boolean hasDocs = false;

        String scopeAttribute = "public";
        String scope = "public";

        for (Fold fold : folds) {

            String foldType = fold.getType();

            if (foldType.equalsIgnoreCase("%mathpiper")) {


                if (fold.getAttributes().containsKey("scope")) {
                    scopeAttribute = (String) fold.getAttributes().get("scope");
                }

                if (!scopeAttribute.equalsIgnoreCase("nobuild")) {

                    mpiFileOut.write(fold.getContents());

                    if (fold.getAttributes().containsKey("def")) {
                        String defAttribute = (String) fold.getAttributes().get("def");
                        if (!defAttribute.equalsIgnoreCase("")) {

                            String[] defFunctionNames = defAttribute.split(";");

                            for (int x = 0; x < defFunctionNames.length; x++) {
                                mpiDefFileOut.write(defFunctionNames[x]);
                                mpiDefFileOut.write("\n");
                            }//end if.
                        }//end if.
                    }//end if.

                    scope = scopeAttribute;
                }//end if.


            } else if (foldType.equalsIgnoreCase("%mathpiper_docs")) {
                //System.out.println("        **** Contains docs *****");
                hasDocs = true;
                processMathPiperDocsFold(fold, scope);

            }//end if.


        }//end subpackage for.

        if (!hasDocs) {
            System.out.println("        ^^^^ Does not contain docs ^^^^");
        }
    }//end method.


    private void processMathPiperDocsFold(Fold fold, String scope) throws IOException {
        if (documentationFile != null) {

            String functionNamesString = "";
            if (fold.getAttributes().containsKey("name")) {
                functionNamesString = (String) fold.getAttributes().get("name");

                //Uncomment to debug the documentation for a given function..
                /*if(functionNamesString.equals("Factors"))
                {
                int xxx = 1;
                }*/


                String[] functionNames = functionNamesString.split(";");

                for (String functionName : functionNames) {
                    //DataOutputStream individualDocumentationFile = null;
                    /*
                    try{
                    individualDocumentationFile =  new DataOutputStream(new java.io.FileOutputStream(outputDocsDirectory + functionName));
                    }catch(Exception ex)
                    {
                    ex.printStackTrace();
                    }*/

                    documentationIndexFile.write(functionName + ",");
                    documentationIndexFile.write(documentationOffset + ",");

                    String contents = fold.getContents();
                    byte[] contentsBytes = contents.getBytes();
                    documentationFile.write(contentsBytes, 0, contentsBytes.length);
                    //individualDocumentationFile.write(contentsBytes, 0, contentsBytes.length);
                    //individualDocumentationFile.close();

                    documentationOffset = documentationOffset + contents.length();
                    documentationIndexFile.write(documentationOffset + "\n");

                    byte[] separator = "\n==========\n".getBytes();
                    documentationFile.write(separator, 0, separator.length);

                    documentationOffset = documentationOffset + separator.length;

                    if (fold.getAttributes().containsKey("categories")) {


                        int commandIndex = contents.indexOf("*CMD");
                        String descriptionLine = contents.substring(commandIndex, contents.indexOf("\n", commandIndex));
                        String description = descriptionLine.substring(descriptionLine.lastIndexOf("--") + 2);
                        description = description.trim();

                        String functionCategories = (String) fold.getAttributes().get("categories");
                        String[] categoryNames = functionCategories.split(";");
                        String categories = "";

                        int categoryIndex = 0;
                        String functionCategoryName = "";

                        for (String categoryName : categoryNames) {
                            if (categoryIndex == 0) {
                                //functionCategoriesFile.write(categoryName + ",");
                                functionCategoryName = categoryName;

                            } else {
                                categories = categories + categoryName + ",";
                            }
                            categoryIndex++;
                        }//end for.

                        //functionCategoriesFile.write(functionName + ",");


                        //functionCategoriesFile.write(description);


                        if (!categories.equalsIgnoreCase("")) {
                            categories = categories.substring(0, categories.length() - 1);
                            //functionCategoriesFile.write("," + categories);

                        }
                        //functionCategoriesFile.write("\n");
                        if (functionCategoryName.equalsIgnoreCase("")) {
                            functionCategoryName = "Uncategorized";
                        }
                        CategoryEntry categoryEntry = new CategoryEntry(functionCategoryName, functionName, scope, description, categories);

                        functionCategoriesList.add(categoryEntry);

                    }//end if.
                }//end for.
            }//end if.




        }//end if.
    }//end method


    public void execute() throws Exception {
        //execute() method is needed by ant to run this class.
        System.out.println("****************** Compiling scripts *******");
        System.out.println("Source directory: " + this.sourceScriptsDirectory);
        System.out.println("Destination directory: " + this.outputScriptsDirectory);
        compileScripts();
    }//end method.


    private class CategoryEntry implements Comparable {

        private String categoryName;
        private String functionName;
        private String scope;
        private String description;
        private String categories;


        public CategoryEntry(String categoryName, String functionName, String scope, String description, String categories) {
            this.categoryName = categoryName;
            this.functionName = functionName;
            this.scope = scope;
            this.description = description;
            this.categories = categories;
        }


        public int compareTo(Object o) {
            CategoryEntry categoryEntry = (CategoryEntry) o;
            return this.functionName.compareToIgnoreCase(categoryEntry.getFunctionName());
        }//end method.


        public String getFunctionName() {
            return this.functionName;
        }//end method.


        public String toString() {
            return categoryName + "," + functionName + "," + scope + "," + description + "," + categories;
        }//end method.


    }//end class.


    private void processBuiltinDocs() throws Exception {
        // try {
        System.out.println("***** Processing built in docs...");

        File builtinFunctionsSourceDir = new java.io.File(sourceDirectory + "org/mathpiper/builtin/functions/core");

        if (builtinFunctionsSourceDir.exists()) {
            java.io.File[] javaFilesDirectory = builtinFunctionsSourceDir.listFiles(new java.io.FilenameFilter() {

                public boolean accept(java.io.File file, String name) {
                    if (name.endsWith(".java")) {
                        return true;
                    } else {
                        return false;
                    }
                }


            });

            Arrays.sort(javaFilesDirectory);

            for (int x = 0; x < javaFilesDirectory.length; x++) {
                File javaFile = javaFilesDirectory[x];
                String javaFileName = javaFile.getName();


                System.out.println(javaFileName);

                List<Fold> folds = scanSourceFile(javaFile);

                boolean hasDocs = false;

                for (Fold fold : folds) {

                    String foldType = fold.getType();
                    if (foldType.equalsIgnoreCase("%mathpiper_docs")) {
                        // System.out.println("        **** Contains docs *****  " + javaFileName);
                        hasDocs = true;


                        processMathPiperDocsFold(fold, "public");

                    }//end if.

                }//end for

                if (!hasDocs) {
                    System.out.println("    ^^^^ Does not contain docs ^^^^  ");// + javaFileName);
                }




            }//end for

        }//end if.

        /*               } catch (java.io.IOException e) {
        e.printStackTrace();
        }*/


    }//end method.


    public static void main(String[] args) {

        String sourceScriptsDirectory;

        if (args.length > 0) {
            sourceScriptsDirectory = args[0];
        } else {
            sourceScriptsDirectory = "/home/tkosan/NetBeansProjects/mathpiper/src/org/mathpiper/scripts3/";
        }

        String outputScriptsDirectory = "/home/tkosan/NetBeansProjects/scripts/";
        File newScriptsDirectory = new File(outputScriptsDirectory);
        Boolean directoryCreated = newScriptsDirectory.mkdir();


        File newInitializationDirectory = new File(outputScriptsDirectory + "initialization.rep/");
        newInitializationDirectory.mkdir();

        File outputDocsDirectory = new File(outputScriptsDirectory + "documentation/");
        outputDocsDirectory.mkdir();


        //String outputDirectory = "/home/tkosan/temp/mathpiper/org/mathpiper/assembledscripts/";

        try {

            Build scripts = new Build(sourceScriptsDirectory, outputScriptsDirectory, outputDocsDirectory.getPath() + "/");

            scripts.setBaseDirectory("/home/tkosan/NetBeansProjects/mathpiper/");


            scripts.compileScripts();

            Map functionDocs = new HashMap();

            BufferedReader documentationIndex = new BufferedReader(new FileReader(outputDocsDirectory.getPath() + "/documentation_index.txt"));

            String line;
            while ((line = documentationIndex.readLine()) != null) {

                String[] values = line.split(",");

                if (values[0].indexOf(";") != -1) {
                    String[] functionNames = values[0].split(";");
                    for (String name : functionNames) {
                        functionDocs.put(name, values[1] + "," + values[2]);
                    }//end for.
                } else {
                    functionDocs.put(values[0], values[1] + "," + values[2]);
                }//end else.
            }//end while.

            documentationIndex.close();

        } catch (Exception e) {
            e.printStackTrace();
        }


    }//end main
}//end class.

