\name{summary.neyman}

\alias{summary.neyman}
\alias{print.summary.neyman}

\title{Summarizing the estimated treatment effects}

\description{Calculates basic estimate of treatment effect, using simple difference in means and
Neyman's estimate of the variance. Also provides test of significance and subclass estimates if
applicable.}

\details{Calculates overall treatment effect estimate using matched samples generated by
\code{matchit}.  Also gives test of significance of the estimated treatment effect, and subclass
estimates, if applicable.  If subclasses were generated in the matching procedure, an overall
estimate is also provided, which is a weighted average over the subclasses, with subclass
weights defined by the \code{sub.by} option in the \code{matchit} call.  The standard deviation
can also be estimated using the bootstrap procedure, which is often used when matching done with
replacement.  For more details on the calculations, see the complete documentation (link below).  
}

\usage{
\method{summary}{neyman}(object, ...)
}

\arguments{
\item{object}{(required).  Stored output from \code{neyman}. }
\item{...}{Further arguments passed to or from other methods.}
}

\value{ \item{Returns estimate of the effect of the treatment, as well as the standard deviation
of that estimate, a test of significance of the estimate, and subclass estimates if applicable.  
Also shows the sample sizes of the matched treated and control groups used to estimate the
treatment effect.} }

\seealso{Please use \code{help.matchit} to access the matchit reference
  manual.  The complete document is available online at
  \url{http://gking.harvard.edu/matchit}.}

\author{
  Daniel Ho <\email{deho@fas.harvard.edu}>;  Kosuke Imai <\email{kimai@princeton.edu}>; Gary King
  <\email{king@harvard.edu}>; Elizabeth Stuart<\email{stuart@stat.harvard.edu}>
}

\keyword{methods}
