/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _WM_H_
#define _WM_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/Xmd.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "theme.h"
#include "base_client.h"
#include "main_client.h"
#include "docked_client.h"
#include "toolbar_client.h"
#include "dockbar_client.h"
#include "dialog_client.h"
#include "client_common.h"
#include "misc.h"

#define WINDOW_TYPE_TOOLBAR 0
#define WINDOW_TYPE_DOCK    1
#define WINDOW_TYPE_DIALOG  2
#define REC_PROTOCOLS       3
#define REC_KEY             4

#define WITHDRAW 1

#define FRAME  1
#define WINDOW 2

#define ChildMask (SubstructureRedirectMask|SubstructureNotifyMask)
#define ButtonMask (ButtonPressMask|ButtonReleaseMask)
#define MouseMask (ButtonMask|PointerMotionMask)
#define KeyMask (KeyPressMask|KeyReleaseMask)

wm *wm_new(int argc, char **argv);
void wm_usage(char *progname);
void wm_load_config(wm *w, int *argc, char *argv[]);
client *wm_find_client(wm *w, Window win, int mode);

/* events */
void wm_event_loop(Wm* w);
void wm_handle_button_event(Wm *w, XButtonEvent *e);
void wm_handle_keypress(Wm *w, XKeyEvent *e);
void wm_handle_map_request(Wm *w, XMapRequestEvent *e);
void wm_handle_unmap_event(Wm *w, XUnmapEvent *e);
void wm_handle_expose_event(Wm *w, XExposeEvent *e);
void wm_handle_configure_request(Wm *w, XConfigureRequestEvent *e);
void wm_handle_configure_notify(Wm *w, XConfigureEvent *e);
void wm_handle_destroy_event(Wm *w, XDestroyWindowEvent *e);
void wm_handle_client_message(Wm *w, XClientMessageEvent *e);
void wm_handle_property_change(Wm *w, XPropertyEvent *e);

Client *wm_make_new_client(Wm *w, Window win);
void wm_restack(Wm *w, Client *c, signed int amount);
void wm_remove_client(Wm *w, Client *c);
int  wm_total_toolbar_height(Client *c);
void wm_gravitate(Client *c, int multiplier); /* to be moved */
void wm_init_existing(Wm *w);

#endif _WM_H_
