/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include "hash.h"

static struct nlist *hashtab[HASHSIZE];

unsigned int hash(char *s)
{
   unsigned int hashval;

   for(hashval = 0; *s != '\0'; s++)
      hashval = *s + 21 * hashval;
   return hashval % HASHSIZE;
}

struct nlist *hash_lookup(char *s)
{
   struct nlist *np;

   for (np = hashtab[hash(s)]; np != NULL; np = np->next)
      if (strcmp(s, np->key) == 0)
	 return np;
   return NULL;
}

struct nlist *hash_add(char *key, char *val)
{
   struct nlist *np;
   unsigned int hashval;

   if ((np = hash_lookup(key)) == NULL)
   {
      np = (struct nlist * ) malloc(sizeof(*np));
      if ( np == NULL || (np->key = strdup(key)) == NULL)
	 return NULL;
      hashval = hash(key);
      np->next = hashtab[hashval];
      hashtab[hashval] = np;
   } else {
      free((void *) np->value);
   }
   if ((np->value = strdup(val)) == NULL)
      return NULL;
   return np;
}

void hash_empty()
{
   memset(hashtab, 0, sizeof(hashtab));
}
