/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _DOCKED_CLIENT_H_
#define _DOCKED_CLIENT_H_

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "base_client.h"
#include "client_common.h"

Client* docked_client_new(wm *w, Window win);
void docked_client_configure(Client *c);
void docked_client_move_resize(Client *c);
void docked_client_reparent(Client *c);
void docked_client_redraw(Client *c, Bool use_cache);
void docked_client_button_press(Client *c, XButtonEvent *e);
void docked_client_show(Client *c);
void docked_client_hide(Client *c);
int docked_client_get_offset(Client *c);
int docked_client_get_y_offset(Client *c);
void docked_client_destroy(Client *c);
int dockbar_client_init_offset(Client *c);

#endif _DOCKED_CLIENT_H_
