/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/** THIS IS THE CLIENT-SIDE INCLUDE **/

#ifndef _mas_cdrom_h_
#define _mas_cdrom_h_


#include "mas/mas_api_internal.h"
#include "mas/mas_cdrom_common.h"

/* Plays a given track number. */
int mas_cdrom_play_track(mas_device_t device, int track);

/* Starts playing the track at the minute, seconds, frame location */
int mas_cdrom_play_msf(mas_device_t device, int minute, int second, int frame);

/* Sets the state of the cd player. */
int mas_cdrom_set_status(mas_device_t device, int cd_status);

/* Sets the state of the cd player. */
CD_Status *mas_cdrom_get_status(mas_device_t device);

/* This fetches the cd's info from the freedb.org database along with other info */
CD_Information *mas_cdrom_get_info(mas_device_t device, char *cddb_server, char *username);

/* Exits the program */
int mas_cdrom_exit_instance(mas_device_t device);

/* Frees a CDDB_Query returned from mas_cdrom_get_cddb_info */
void destroy_cd_info(CD_Information *cddb);

/* Frees a CDDB_Status returned from mas_cdrom_get_cddb_info */
void destroy_cd_status(CD_Status *cd_status);

#endif /* _mas_cdrom_h_ */
