/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas/mas_api_internal.h"

#define DEFAULT_PACKAGE_SIZE 1024

int32
mas_source_set_file( mas_device_t device, char* filename )
{
    struct mas_package  p;
    char buf[DEFAULT_PACKAGE_SIZE];
    int32 err;

    masc_setup_package( &p, buf, sizeof buf, MASC_PACKAGE_STATIC );
    masc_pushk_int16( &p, "pos", 0 );
    masc_push_string( &p, filename );
    masc_finalize_package( &p );

    err = mas_set( device, "playlist", &p );
    masc_strike_package( &p );
    
    return err;
}

int32
mas_source_play( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_play";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}

int32
mas_source_play_on_mark( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_play_on_mark";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}


int32
mas_source_stop( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_stop";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}

int32
mas_source_pause( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_pause";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}

int32
mas_source_next_track( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_next_track";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}

int32
mas_source_prev_track( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_prev_track";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}

int32
mas_source_flush( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_flush";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}


int32
mas_source_rebuffer( mas_device_t device )
{
    struct mas_event    event;
    
    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_source_rebuffer";
    event.device_instance = device->device_instance;

    return mas_send_event( &event, device->control_channel );
}

