/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_CMATRIX_H
#define _MAS_CMATRIX_H

#include "mas/mas_types.h"

/************************************************************************
 * TABLE OF CONTENTS
 ************************************************************************/
#define MAS_CMATRIX_ANYTHING           "mas_cmatrix_anything"
#define MAS_CMATRIX_MCP                "mas_cmatrix_mcp"
#define MAS_CMATRIX_AUDIO_BASIC        "mas_cmatrix_audio_basic"

/************************************************************************
 * CHARACTERISTIC MATRIX DEFINITIONS
 * 
 ************************************************************************/
const char* mas_cmatrix_anything[][2] =
{
    { "*", ""},  /* any key */
    { "*", ""},  /* any value */
    { "",  ""},
};

const char* mas_cmatrix_mcp[][2] =
{
    { "protocol", ""},  /* any key */
    { "mcp", ""},  /* any value */
    { "",  ""},
};

/* This is a catch-all cmatrix with the basic audio types in it.
   You'll probably want to use some subset of these in your
   application. */
const char* mas_cmatrix_audio_basic[][6] = 
{
    { "format", "resolution", "channels", "sampling rate", "endian",  "" },
    { "linear", "double",     "2",        "48000",        "host",    "" },
    { "linear", "double",     "2",        "44100",        "host",     "" },
    { "linear", "double",     "2",        "32000",        "host",     "" },
    { "linear", "double",     "2",        "22050",        "host",     "" },
    { "linear", "double",     "2",        "16000",        "host",     "" },
    { "linear", "double",     "2",        "11025",        "host",     "" },
    { "linear", "double",     "2",        "8000",         "host",     "" },
    { "linear", "double",     "1",        "48000",        "host",     "" },
    { "linear", "double",     "1",        "44100",        "host",    "" },
    { "linear", "double",     "1",        "32000",        "host",     "" },
    { "linear", "double",     "1",        "22050",        "host",     "" },
    { "linear", "double",     "1",        "16000",        "host",     "" },
    { "linear", "double",     "1",        "11025",        "host",     "" },
    { "linear", "double",     "1",        "8000",         "host",     "" },
    { "linear", "16",         "2",        "48000",        "host",     "" },
    { "linear", "16",         "2",        "44100",        "host",     "" },
    { "linear", "16",         "2",        "32000",        "host",     "" },
    { "linear", "16",         "2",        "22050",        "host",     "" },
    { "linear", "16",         "2",        "16000",        "host",     "" },
    { "linear", "16",         "2",        "11025",        "host",     "" },
    { "linear", "16",         "2",        "8000",         "host",     "" },
    { "linear", "16",         "1",        "48000",        "host",     "" },
    { "linear", "16",         "1",        "44100",        "host",     "" },
    { "linear", "16",         "1",        "32000",        "host",     "" },
    { "linear", "16",         "1",        "22050",        "host",     "" },
    { "linear", "16",         "1",        "16000",        "host",     "" },
    { "linear", "16",         "1",        "11025",        "host",     "" },
    { "linear", "16",         "1",        "8000",         "host",     "" },
    { "linear", "20",         "2",        "48000",        "host",     "" },
    { "linear", "20",         "2",        "44100",        "host",     "" },
    { "linear", "20",         "2",        "32000",        "host",     "" },
    { "linear", "20",         "2",        "22050",        "host",     "" },
    { "linear", "20",         "2",        "16000",        "host",     "" },
    { "linear", "20",         "2",        "11025",        "host",     "" },
    { "linear", "20",         "2",        "8000",         "host",     "" },
    { "linear", "20",         "1",        "48000",        "host",     "" },
    { "linear", "20",         "1",        "44100",        "host",     "" },
    { "linear", "20",         "1",        "32000",        "host",     "" },
    { "linear", "20",         "1",        "22050",        "host",     "" },
    { "linear", "20",         "1",        "16000",        "host",     "" },
    { "linear", "20",         "1",        "11025",        "host",     "" },
    { "linear", "20",         "1",        "8000",         "host",     "" },
    { "linear", "24",         "2",        "48000",        "host",     "" },
    { "linear", "24",         "2",        "44100",        "host",     "" },
    { "linear", "24",         "2",        "32000",        "host",     "" },
    { "linear", "24",         "2",        "22050",        "host",     "" },
    { "linear", "24",         "2",        "16000",        "host",     "" },
    { "linear", "24",         "2",        "11025",        "host",     "" },
    { "linear", "24",         "2",        "8000",         "host",     "" },
    { "linear", "24",         "1",        "48000",        "host",     "" },
    { "linear", "24",         "1",        "44100",        "host",     "" },
    { "linear", "24",         "1",        "32000",        "host",     "" },
    { "linear", "24",         "1",        "22050",        "host",     "" },
    { "linear", "24",         "1",        "16000",        "host",     "" },
    { "linear", "24",         "1",        "11025",        "host",     "" },
    { "linear", "24",         "1",        "8000",         "host",     "" },
    { "linear", "8",          "2",        "48000",        "*",     "" },
    { "linear", "8",          "2",        "44100",        "*",     "" },
    { "linear", "8",          "2",        "32000",        "*",     "" },
    { "linear", "8",          "2",        "22050",        "*",     "" },
    { "linear", "8",          "2",        "16000",        "*",     "" },
    { "linear", "8",          "2",        "11025",        "*",     "" },
    { "linear", "8",          "2",        "8000",         "*",     "" },
    { "linear", "8",          "1",        "48000",        "*",     "" },
    { "linear", "8",          "1",        "44100",        "*",     "" },
    { "linear", "8",          "1",        "32000",        "*",     "" },
    { "linear", "8",          "1",        "22050",        "*",     "" },
    { "linear", "8",          "1",        "16000",        "*",     "" },
    { "linear", "8",          "1",        "11025",        "*",     "" },
    { "linear", "8",          "1",        "8000",         "*",     "" },
    { "ulinear", "16",         "2",        "48000",        "host",     "" },
    { "ulinear", "16",         "2",        "44100",        "host",     "" },
    { "ulinear", "16",         "2",        "32000",        "host",     "" },
    { "ulinear", "16",         "2",        "22050",        "host",     "" },
    { "ulinear", "16",         "2",        "16000",        "host",     "" },
    { "ulinear", "16",         "2",        "11025",        "host",     "" },
    { "ulinear", "16",         "2",        "8000",         "host",     "" },
    { "ulinear", "16",         "1",        "48000",        "host",     "" },
    { "ulinear", "16",         "1",        "44100",        "host",      "" },
    { "ulinear", "16",         "1",        "32000",        "host",      "" },
    { "ulinear", "16",         "1",        "22050",        "host",      "" },
    { "ulinear", "16",         "1",        "16000",        "host",      "" },
    { "ulinear", "16",         "1",        "11025",        "host",      "" },
    { "ulinear", "16",         "1",        "8000",         "host",      "" },
    { "ulinear", "8",          "2",        "48000",        "*",      "" },
    { "ulinear", "8",          "2",        "44100",        "*",      "" },
    { "ulinear", "8",          "2",        "32000",        "*",      "" },
    { "ulinear", "8",          "2",        "22050",        "*",      "" },
    { "ulinear", "8",          "2",        "16000",        "*",      "" },
    { "ulinear", "8",          "2",        "11025",        "*",      "" },
    { "ulinear", "8",          "2",        "8000",         "*",      "" },
    { "ulinear", "8",          "1",        "48000",        "*",      "" },
    { "ulinear", "8",          "1",        "44100",        "*",      "" },
    { "ulinear", "8",          "1",        "32000",        "*",      "" },
    { "ulinear", "8",          "1",        "22050",        "*",      "" },
    { "ulinear", "8",          "1",        "16000",        "*",      "" },
    { "ulinear", "8",          "1",        "11025",        "*",      "" },
    { "ulinear", "8",          "1",        "8000",         "*",      "" },
    { "ulaw",   "8",          "2",        "48000",         "*",     "" },
    { "ulaw",   "8",          "2",        "44100",         "*",     "" },
    { "ulaw",   "8",          "2",        "32000",         "*",     "" },
    { "ulaw",   "8",          "2",        "22050",         "*",      "" },
    { "ulaw",   "8",          "2",        "16000",         "*",     "" },
    { "ulaw",   "8",          "2",        "11025",         "*",     "" },
    { "ulaw",   "8",          "2",        "8000",          "*",     "" },
    { "ulaw",   "8",          "1",        "48000",         "*",     "" },
    { "ulaw",   "8",          "1",        "44100",         "*",     "" },
    { "ulaw",   "8",          "1",        "32000",         "*",    "" },
    { "ulaw",   "8",          "1",        "22050",         "*",     "" },
    { "ulaw",   "8",          "1",        "16000",         "*",    "" },
    { "ulaw",   "8",          "1",        "11025",         "*",     "" },
    { "ulaw",   "8",          "1",        "8000",          "*",    "" },
    { "alaw",   "8",          "2",        "48000",         "*",    "" },
    { "alaw",   "8",          "2",        "44100",         "*",    "" },
    { "alaw",   "8",          "2",        "32000",         "*",    "" },
    { "alaw",   "8",          "2",        "22050",         "*",    "" },
    { "alaw",   "8",          "2",        "16000",         "*",    "" },
    { "alaw",   "8",          "2",        "11025",         "*",    "" },
    { "alaw",   "8",          "2",        "8000",          "*",    "" },
    { "alaw",   "8",          "1",        "48000",         "*",    "" },
    { "alaw",   "8",          "1",        "44100",         "*",     "" },
    { "alaw",   "8",          "1",        "32000",         "*",     "" },
    { "alaw",   "8",          "1",        "22050",         "*",    "" },
    { "alaw",   "8",          "1",        "16000",         "*",    "" },
    { "alaw",   "8",          "1",        "11025",         "*",    "" },
    { "alaw",   "8",          "1",        "8000",          "*",    "" },
    { "",       "",           "",         ""    ,          "",        "" },
};

#endif /* _MAS_CMATRIX_H */



