#!/bin/bash
#
# mas           This shell script starts and stops the Media Application Server (MAS)
#
# chkconfig: 345 96 96
# description:  MAS (the Media Application Server) provides desktop sound support for the X Window System.
#
# source function library
. /etc/rc.d/init.d/functions

RETVAL=0
prog="mas"

LOGLEVEL=50
MAS=MASBINDIR/mas
OPTIONS="-d -l $LOGLEVEL"
MAS_WD=MASBINDIR/maswatchdog
PID_FILE=/var/run/mas.pid
LOCK_FILE=/var/lock/subsys/mas

start()
{
    echo -n $"Starting $prog: " 
    daemon $MAS $OPTIONS
    RETVAL=$?
    $MAS_WD
    [ $RETVAL -eq 0 ] && touch $LOCK_FILE
    echo
    return $RETVAL
}

stop()
{
    if test "x`pidof mas`" != x; then
        echo -n $"Stopping $prog: "
        killproc maswatchdog
        killproc mas
        RETVAL=$?
        echo
    fi
    [ $RETVAL -eq 0 ] && rm -f $LOCK_FILE $PID_FILE

    return $RETVAL
}

case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    restart)
        stop
        start
        ;;
    condrestart)
        if test "x`pidof mas`" != x; then
            stop
            start
        fi
        ;;
    status)
        status mas
        RETVAL=$?
        ;;
    *)
        echo $"Usage: $0 {start|stop|restart|condrestart|status}"
        RETVAL=1
esac
exit $RETVAL
